/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.processselect;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.mid.dbmanager.interceptor.stage.visitor.BaseExpressionVisitor;
import com.bokesoft.yes.mid.mysqls.dbstruct.DBStruct;
import com.bokesoft.yes.mid.mysqls.group.Group;
import com.bokesoft.yes.mid.mysqls.group.GroupConfig;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.mid.mysqls.processselect.InTableGroups;
import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yes.mid.mysqls.processselect.SubQuerys;
import com.bokesoft.yes.mid.mysqls.processselect.SubSelectTableReplace;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfos;
import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.expression.BinaryExpression;
import net.boke.jsqlparser.expression.CaseExpression;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.Function;
import net.boke.jsqlparser.expression.InverseExpression;
import net.boke.jsqlparser.expression.Parenthesis;
import net.boke.jsqlparser.expression.WhenClause;
import net.boke.jsqlparser.expression.operators.relational.Between;
import net.boke.jsqlparser.expression.operators.relational.InExpression;
import net.boke.jsqlparser.expression.operators.relational.IsNullExpression;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.AllColumns;
import net.boke.jsqlparser.statement.select.AllTableColumns;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.Join;
import net.boke.jsqlparser.statement.select.OrderByElement;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.SelectBody;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;
import net.boke.jsqlparser.statement.select.SelectItem;
import net.boke.jsqlparser.statement.select.SubSelect;

public class SubQuery {
    PlainSelect plainSelect;
    protected List<FromItem> fromItems = new ArrayList<FromItem>();
    private HashMapIgnoreCase<String> fieldsChangeAlias = null;
    private SubQuery leftJoinPerSubQuery = null;
    private Join firstJoin = null;
    private final SubQuerys parent;
    public final SubQuery inValuesForSubQuery;
    private Expression leftJoinCondition = null;
    private boolean isMainSelect;
    private Join relationJoin = null;

    public SubQuery(SubQuerys parent) {
        this(parent, null);
    }

    public SubQuery(SubQuerys parent, SubQuery inValuesForSubQuery) {
        this.parent = parent;
        this.inValuesForSubQuery = inValuesForSubQuery;
        if (inValuesForSubQuery != null) {
            int pos = parent.datas.indexOf(inValuesForSubQuery);
            parent.datas.add(pos + 1, this);
        } else {
            parent.datas.add(this);
        }
    }

    public PlainSelect getPlainSelect() {
        return this.plainSelect;
    }

    public boolean isDefaultGroup() {
        if (this.fromItems.get(0) instanceof Table) {
            String tableName = ((Table)this.fromItems.get(0)).getName();
            Group group = TableGroupProps.getInstance().getFixedGroup(tableName);
            return group == GroupConfig.instance.getGroups().getDefaultGroup();
        }
        return false;
    }

    public boolean isSingleGroup() {
        if (this.fromItems.get(0) instanceof Table) {
            String tableName = ((Table)this.fromItems.get(0)).getName();
            Group group = TableGroupProps.getInstance().getFixedGroup(tableName);
            return group != null && group.isOnlyDSN();
        }
        return false;
    }

    public String getOnlyTableName() {
        if (this.fromItems.size() == 1) {
            FromItem from;
            SelectBody selectBody;
            if (this.fromItems.get(0) instanceof Table) {
                return ((Table)this.fromItems.get(0)).getName();
            }
            if (this.fromItems.get(0) instanceof SubSelect && (selectBody = ((SubSelect)this.fromItems.get(0)).getSelectBody()) instanceof PlainSelect && ((PlainSelect)selectBody).getJoins() == null && !((PlainSelect)selectBody).isNoSplit() && (from = ((PlainSelect)selectBody).getFromItem()) instanceof Table) {
                return ((Table)from).getName();
            }
        }
        return null;
    }

    public void addFromItem(FromItem fromItem, Join join) {
        if (this.firstJoin == null && (this.plainSelect == null || this.plainSelect.getFromItem() == null)) {
            this.firstJoin = join;
        }
        if (this.plainSelect == null) {
            this.plainSelect = new PlainSelect();
            this.plainSelect.setFromItem(fromItem);
        } else {
            ArrayList<Join> joins = this.plainSelect.getJoins();
            if (joins == null) {
                joins = new ArrayList<Join>();
                this.plainSelect.setJoins(joins);
            }
            Join newJoin = new Join();
            if (join != null) {
                newJoin.setFull(join.isFull());
                newJoin.setInner(join.isInner());
                newJoin.setLeft(join.isLeft());
                newJoin.setNatural(join.isNatural());
                newJoin.setOuter(join.isOuter());
                newJoin.setRight(join.isRight());
                newJoin.setSimple(join.isSimple());
                fromItem.setJoin(newJoin);
            }
            newJoin.setRightItem(fromItem);
            joins.add(newJoin);
        }
        this.fromItems.add(fromItem);
    }

    public void appendGroupByField(Expression exp) {
        ParsedSqlUtil.addGroupByField(this.plainSelect, exp);
    }

    public void appendOrderByItem(OrderByElement orderByElement) {
        ParsedSqlUtil.addOrderByItem(this.plainSelect, orderByElement);
    }

    public boolean appendExpression(Expression exp, boolean addWhere) {
        int tableIndex = this.getTableIndex(exp);
        if (tableIndex != -1) {
            this.addExpression(exp, tableIndex, addWhere);
            if (addWhere) {
                this.setFirstJoinInner();
            }
            return true;
        }
        return false;
    }

    public void setFirstJoinInner() {
        if (this.getLeftJoinPerSubQuery() != null) {
            this.setLeftJoinPerSubQuery(null);
        }
        if (this.firstJoin != null && this.firstJoin.isLeft()) {
            this.firstJoin.setLeft(false);
            this.firstJoin.setInner(true);
        }
    }

    public boolean getFirstJoinIsLeft() {
        return this.firstJoin != null && this.firstJoin.isLeft();
    }

    private void addExpression(Expression exp, int tableIndex, boolean addWhere) {
        SubSelectTableReplace subVisitor = new SubSelectTableReplace(this.plainSelect);
        exp.accept(subVisitor);
        if (tableIndex == 0 || addWhere) {
            ParsedSqlUtil.addWhereExpression(this.plainSelect, exp);
        } else {
            Join join = (Join)this.plainSelect.getJoins().get(tableIndex - 1);
            ParsedSqlUtil.addJoinOnExpression(join, exp);
        }
    }

    public int getTableIndex(Expression exp) {
        if (exp == null) {
            return 0;
        }
        if (ParsedSqlUtil.isConstant(exp)) {
            return 0;
        }
        if (exp instanceof Column) {
            int i = 0;
            int size = this.fromItems.size();
            while (i < size) {
                FromItem fromItem = this.fromItems.get(i);
                if (((Column)exp).getExtendFromItem() == fromItem) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        if (exp instanceof BinaryExpression) {
            int left = this.getTableIndex(((BinaryExpression)exp).getLeftExpression());
            int right = this.getTableIndex(((BinaryExpression)exp).getRightExpression());
            if (left == -1 || right == -1) {
                return -1;
            }
            return Math.max(left, right);
        }
        if (exp instanceof CaseExpression) {
            int index = this.getTableIndex(((CaseExpression)exp).getSwitchExpression());
            if (index == -1) {
                return -1;
            }
            List whenClauses = ((CaseExpression)exp).getWhenClauses();
            for (Object tmp : whenClauses) {
                int indexTmp = this.getTableIndex((Expression)tmp);
                if (indexTmp == -1) {
                    return -1;
                }
                index = Math.max(index, indexTmp);
            }
            int indexTmp = this.getTableIndex(((CaseExpression)exp).getElseExpression());
            if (indexTmp == -1) {
                return -1;
            }
            return Math.max(index, indexTmp);
        }
        if (exp instanceof WhenClause) {
            int whenIndex = this.getTableIndex(((WhenClause)exp).getWhenExpression());
            int thenIndex = this.getTableIndex(((WhenClause)exp).getThenExpression());
            if (whenIndex == -1 || thenIndex == -1) {
                return -1;
            }
            return Math.max(whenIndex, thenIndex);
        }
        if (exp instanceof Between) {
            int left = this.getTableIndex(((Between)exp).getLeftExpression());
            int start = this.getTableIndex(((Between)exp).getBetweenExpressionStart());
            int end = this.getTableIndex(((Between)exp).getBetweenExpressionEnd());
            if (left == -1 || start == -1 || end == -1) {
                return -1;
            }
            return Math.max(left, Math.max(start, end));
        }
        if (exp instanceof InExpression) {
            int left = this.getTableIndex(((InExpression)exp).getLeftExpression());
            return left;
        }
        if (exp instanceof Function) {
            Function function = (Function)exp;
            if (function.isAllColumns()) {
                return 0;
            }
            List columns = ((Function)exp).getParameters().getExpressions();
            if (columns instanceof Column) {
                Column column = (Column)columns.get(0);
                return this.getTableIndex(column);
            }
            return this.getTableIndex((Expression)columns.get(0));
        }
        if (exp instanceof Parenthesis) {
            return this.getTableIndex(((Parenthesis)exp).getExpression());
        }
        if (exp instanceof IsNullExpression) {
            return this.getTableIndex(((IsNullExpression)exp).getLeftExpression());
        }
        if (exp instanceof InverseExpression) {
            return this.getTableIndex(((InverseExpression)exp).getExpression());
        }
        if (exp instanceof SubSelect) {
            return 0;
        }
        throw new RuntimeException("\u5206\u5e93\u5206\u8868\uff0c\u672a\u652f\u6301\u7684\u8868\u8fbe\u5f0f\uff0c" + exp + "\u3002");
    }

    public boolean isMyColumn(Column column) {
        int i = 0;
        int size = this.fromItems.size();
        while (i < size) {
            FromItem fromItem = this.fromItems.get(i);
            if (column.getExtendFromItem() == fromItem) {
                return true;
            }
            if (column.getExtendSelectItemInGroupByOrderByHaving() != null && this.isMyExpression(column.getExtendSelectItemInGroupByOrderByHaving().getExpression())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isMyFunctionOrColumn(Expression exp) {
        if (exp instanceof Function) {
            List<Column> columns = ((Function)exp).getColumns();
            if (columns.size() == 0) {
                return false;
            }
            if (columns.size() > 1) {
                throw new RuntimeException("\u5206\u5e93\u5206\u8868\uff0c\u672a\u652f\u6301\u7684\u8868\u8fbe\u5f0f\uff0c" + exp + "\u3002");
            }
            return this.isMyColumn(columns.get(0));
        }
        if (exp instanceof Column) {
            return this.isMyColumn((Column)exp);
        }
        return false;
    }

    public boolean isMyTable(Table table) {
        int i = 0;
        int size = this.fromItems.size();
        while (i < size) {
            FromItem fromItem = this.fromItems.get(i);
            if (ParsedSqlUtil.isFitFromItem(fromItem, table.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean addSelectItem(SelectItem selectExpressionItem) {
        boolean isMySelectItem = false;
        if (selectExpressionItem instanceof SelectExpressionItem) {
            Expression exp = ((SelectExpressionItem)selectExpressionItem).getExpression();
            isMySelectItem = this.isMyExpression(exp);
            if (isMySelectItem && this.getLeftJoinPerSubQuery() != null) {
                final RefObject hasIsNull = new RefObject((Object)false);
                exp.accept(new BaseExpressionVisitor(){

                    @Override
                    public void visit(IsNullExpression isNullExpression) {
                        hasIsNull.setValue((Object)true);
                    }

                    @Override
                    public void visit(Function function) {
                        String functionName = function.getName();
                        if (functionName.equalsIgnoreCase("IfNull") || functionName.equalsIgnoreCase("COALESCE")) {
                            hasIsNull.setValue((Object)true);
                        }
                        super.visit(function);
                    }
                });
                if (((Boolean)hasIsNull.getValue()).booleanValue()) {
                    isMySelectItem = false;
                }
            }
        } else if (selectExpressionItem instanceof AllTableColumns) {
            isMySelectItem = this.isMyTable(((AllTableColumns)selectExpressionItem).getTable());
        } else if (selectExpressionItem instanceof AllColumns) {
            isMySelectItem = true;
        }
        if (isMySelectItem) {
            ParsedSqlUtil.addSelectItem(this.plainSelect, selectExpressionItem);
        }
        return isMySelectItem;
    }

    public SelectExpressionItem addCalcExpression(Expression exp, boolean isAssistCol, RefObject<Boolean> isAddSelectItem, List<SelectExpressionItem> calcItemsBeforeGroup, List<SelectExpressionItem> calcItems) {
        if (exp instanceof Column) {
            return this.addColumn((Column)exp, isAssistCol, isAddSelectItem, true);
        }
        SelectItem selectItem = ParsedSqlUtil.findSelectItemByColumnOrExpression(this.plainSelect, exp, false, false, null);
        String realColumnName = null;
        if (selectItem == null) {
            realColumnName = ParsedSqlUtil.getNoRepeatColumnAlias(this.parent.getSelectSqlInfo(), this.plainSelect, exp, calcItemsBeforeGroup, calcItems);
            SelectExpressionItem newSelectItem = new SelectExpressionItem(exp);
            newSelectItem.setAlias(realColumnName);
            ParsedSqlUtil.addSelectItem(this.plainSelect, newSelectItem);
            isAddSelectItem.setValue((Object)true);
            return newSelectItem;
        }
        return (SelectExpressionItem)selectItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectExpressionItem addColumn(Column column, boolean isAssistCol, RefObject<Boolean> isAddSelectItem, boolean isCalcItem) {
        ArrayList<SelectExpressionItem> selectItems = this.plainSelect.getSelectItems();
        if (selectItems == null) {
            selectItems = new ArrayList<SelectExpressionItem>();
            this.plainSelect.setSelectItems(selectItems);
        }
        boolean groupBy = false;
        Table table = column.getTable();
        String tableName = table == null ? null : table.getName();
        String columnName = column.getColumnName();
        for (Object e : selectItems) {
            if (!(e instanceof SelectExpressionItem)) continue;
            SelectExpressionItem selectItem = (SelectExpressionItem)e;
            Expression exp = selectItem.getExpression();
            String alias = selectItem.getAlias();
            if (exp instanceof Column) {
                Column selectColumn = (Column)exp;
                if (selectColumn.isSameColumn(column)) {
                    if (alias != null && !alias.equalsIgnoreCase(columnName)) {
                        if (this.fieldsChangeAlias == null) {
                            this.fieldsChangeAlias = new HashMapIgnoreCase();
                        }
                        this.fieldsChangeAlias.put(column.getWholeColumnName(), (Object)alias);
                        if (isAddSelectItem != null) {
                            isAddSelectItem.setValue((Object)true);
                        }
                    }
                    return selectItem;
                }
                if (alias == null) continue;
                alias.equalsIgnoreCase(columnName);
                continue;
            }
            if (exp instanceof Function) {
                Function function = (Function)exp;
                groupBy = groupBy || this.needGroupBy(function);
                continue;
            }
            if (exp instanceof BinaryExpression || exp instanceof CaseExpression || exp instanceof Parenthesis || exp instanceof IsNullExpression) {
                groupBy = groupBy || this.needGroupBy(exp);
                continue;
            }
            if (alias == null) continue;
            alias.equalsIgnoreCase(columnName);
        }
        SelectExpressionItem selectExpressionItem = new SelectExpressionItem();
        selectExpressionItem.setExpression(column);
        selectExpressionItem.setAssistCol(groupBy);
        if (!this.hasColumn(selectItems, selectExpressionItem, column.getTable(), isAssistCol)) {
            PlainSelect plainSelect = this.plainSelect;
            synchronized (plainSelect) {
                if (!this.hasColumn(selectItems, selectExpressionItem, column.getTable(), isAssistCol)) {
                    if (this.hasColumnBySelectItems(columnName, isCalcItem)) {
                        String aliasName = this.getNoRepeatName(columnName, isCalcItem);
                        selectExpressionItem.setAlias(aliasName);
                        if (this.fieldsChangeAlias == null) {
                            this.fieldsChangeAlias = new HashMapIgnoreCase();
                        }
                        this.fieldsChangeAlias.put(column.getWholeColumnName(), (Object)aliasName);
                    }
                    selectItems.add(selectExpressionItem);
                    if (groupBy || this.plainSelect.getGroupByColumnReferences() != null) {
                        ParsedSqlUtil.addGroupByField(this.plainSelect, selectExpressionItem.getExpression());
                    }
                    if (isAddSelectItem != null) {
                        isAddSelectItem.setValue((Object)true);
                    }
                }
            }
        }
        return selectExpressionItem;
    }

    private String getNoRepeatName(String columnName, boolean isCalcItem) {
        int i = 2;
        String newColumnName = String.valueOf(columnName) + i;
        while (this.hasColumnBySelectItems(newColumnName, isCalcItem)) {
            newColumnName = String.valueOf(columnName) + ++i;
        }
        return newColumnName;
    }

    private boolean hasColumn(List<?> selectItems, SelectExpressionItem selectExpressionItem, Table table, boolean isAssistCol) {
        if (selectItems == null || selectItems.size() == 0) {
            return false;
        }
        if (selectItems.contains(selectExpressionItem)) {
            return true;
        }
        for (Object item : selectItems) {
            AllTableColumns tableColumns;
            if (item instanceof SelectExpressionItem) {
                String table2;
                if (isAssistCol) {
                    if (((SelectExpressionItem)item).getExpression().equals(selectExpressionItem.getExpression())) {
                        if (this.fieldsChangeAlias == null) {
                            this.fieldsChangeAlias = new HashMapIgnoreCase();
                        }
                        this.fieldsChangeAlias.put(selectExpressionItem.getExpression().toString(), (Object)((SelectExpressionItem)item).getAlias());
                        return true;
                    }
                } else if (((SelectExpressionItem)item).getExpression() == selectExpressionItem.getExpression()) {
                    return true;
                }
                if (!(((SelectExpressionItem)item).getExpression() instanceof Column) || !(selectExpressionItem.getExpression() instanceof Column)) continue;
                Column column1 = (Column)((SelectExpressionItem)item).getExpression();
                Column column2 = (Column)selectExpressionItem.getExpression();
                String table1 = column1.getTable() != null ? column1.getTable().getName() : null;
                String string = table2 = column2.getTable() != null ? column2.getTable().getName() : null;
                if (((SelectExpressionItem)item).getAlias() != null && !((SelectExpressionItem)item).getAlias().equalsIgnoreCase(column1.getColumnName()) || selectExpressionItem.getAlias() != null && !selectExpressionItem.getAlias().equalsIgnoreCase(column2.getColumnName()) || !column1.getColumnName().equalsIgnoreCase(column2.getColumnName()) || table1 != null && table2 != null && !table1.equalsIgnoreCase(table2)) continue;
                return true;
            }
            if (!(item instanceof AllTableColumns ? (tableColumns = (AllTableColumns)item).getTable().equals(table) : item instanceof AllColumns)) continue;
            return true;
        }
        return false;
    }

    private boolean needGroupBy(Function function) {
        return function.needGroupBy(this.plainSelect);
    }

    private boolean needGroupBy(Expression expression) {
        if (expression == null) {
            return false;
        }
        if (expression instanceof BinaryExpression) {
            return this.needGroupBy(((BinaryExpression)expression).getLeftExpression()) || this.needGroupBy(((BinaryExpression)expression).getLeftExpression());
        }
        if (expression instanceof Parenthesis) {
            return this.needGroupBy(((Parenthesis)expression).getExpression());
        }
        if (expression instanceof CaseExpression) {
            List whenClauses = ((CaseExpression)expression).getWhenClauses();
            for (WhenClause whenExp : whenClauses) {
                if (!this.needGroupBy(whenExp)) continue;
                return true;
            }
            return this.needGroupBy(((CaseExpression)expression).getElseExpression());
        }
        if (expression instanceof WhenClause) {
            return this.needGroupBy(((WhenClause)expression).getThenExpression()) || this.needGroupBy(((WhenClause)expression).getWhenExpression());
        }
        if (expression instanceof Function) {
            return this.needGroupBy((Function)expression);
        }
        if (expression instanceof Column || ParsedSqlUtil.isConstant(expression)) {
            return false;
        }
        if (expression instanceof IsNullExpression) {
            return this.needGroupBy(((IsNullExpression)expression).getLeftExpression());
        }
        if (expression instanceof InExpression) {
            return this.needGroupBy(((InExpression)expression).getLeftExpression());
        }
        throw new RuntimeException();
    }

    public boolean isMyExpression(Expression exp) {
        if (exp == null) {
            return true;
        }
        if (ParsedSqlUtil.isConstant(exp)) {
            return true;
        }
        if (exp instanceof Column) {
            return this.isMyColumn((Column)exp);
        }
        if (exp instanceof Parenthesis) {
            return this.isMyExpression(((Parenthesis)exp).getExpression());
        }
        if (exp instanceof BinaryExpression) {
            if (!this.isMyExpression(((BinaryExpression)exp).getLeftExpression())) {
                return false;
            }
            return this.isMyExpression(((BinaryExpression)exp).getRightExpression());
        }
        if (exp instanceof CaseExpression) {
            if (!this.isMyExpression(((CaseExpression)exp).getSwitchExpression())) {
                return false;
            }
            List whenClauses = ((CaseExpression)exp).getWhenClauses();
            for (Object tmp : whenClauses) {
                if (this.isMyExpression((Expression)tmp)) continue;
                return false;
            }
            return this.isMyExpression(((CaseExpression)exp).getElseExpression());
        }
        if (exp instanceof WhenClause) {
            if (!this.isMyExpression(((WhenClause)exp).getWhenExpression())) {
                return false;
            }
            return this.isMyExpression(((WhenClause)exp).getThenExpression());
        }
        if (exp instanceof Function) {
            if (((Function)exp).getParameters() == null) {
                return true;
            }
            List expList = ((Function)exp).getParameters().getExpressions();
            int i = 0;
            while (i < expList.size()) {
                boolean result = this.isMyExpression((Expression)expList.get(i));
                if (!result) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (exp instanceof InverseExpression) {
            return this.isMyExpression(((InverseExpression)exp).getExpression());
        }
        if (exp instanceof InExpression) {
            return this.isMyExpression(((InExpression)exp).getLeftExpression());
        }
        if (exp instanceof IsNullExpression) {
            return this.isMyExpression(((IsNullExpression)exp).getLeftExpression());
        }
        throw new RuntimeException("\u5206\u5e93\u5206\u8868\uff0c\u672a\u652f\u6301\u7684\u8868\u8fbe\u5f0f\uff0c" + exp + "\u3002");
    }

    public void merge(SubQuery subSelect, Join orgJoin) {
        this.addFromItem(subSelect.plainSelect.getFromItem(), orgJoin);
        List joins = subSelect.plainSelect.getJoins();
        int i = 0;
        int size = joins != null ? joins.size() : 0;
        while (i < size) {
            Join join = (Join)joins.get(i);
            this.addFromItem(join.getRightItem(), join);
            if (join.getOnExpression() != null) {
                this.appendExpression(join.getOnExpression(), false);
            }
            ++i;
        }
        Expression where = subSelect.plainSelect.getWhere();
        if (where != null) {
            this.appendExpression(where, true);
        }
    }

    public boolean hasTableNameDeep(final String tableName) {
        final RefObject result = new RefObject((Object)false);
        this.plainSelect.accept(new BaseExpressionVisitor(){

            @Override
            public void visit(Table table) {
                if (tableName.equalsIgnoreCase(table.getName()) || tableName.equalsIgnoreCase(table.getAlias())) {
                    result.setValue((Object)true);
                }
            }
        });
        return (Boolean)result.getValue();
    }

    public boolean hasFromItem(FromItem fromItem) {
        return this.hasFromItemInPlainSelect(this.plainSelect, fromItem);
    }

    private boolean hasFromItemInPlainSelect(PlainSelect plainSelect, FromItem fromItem) {
        if (plainSelect.getFromItem() == fromItem) {
            return true;
        }
        if (plainSelect.getFromItem() instanceof SubSelect) {
            assert (((SubSelect)plainSelect.getFromItem()).getSelectBody() instanceof PlainSelect);
            if (this.hasFromItemInPlainSelect((PlainSelect)((SubSelect)plainSelect.getFromItem()).getSelectBody(), fromItem)) {
                return true;
            }
        }
        if (plainSelect.getJoins() != null) {
            for (Object tmp : plainSelect.getJoins()) {
                Join join = (Join)tmp;
                if (join.getRightItem() == fromItem) {
                    return true;
                }
                if (!(join.getRightItem() instanceof SubSelect)) continue;
                assert (((SubSelect)join.getRightItem()).getSelectBody() instanceof PlainSelect);
                if (!this.hasFromItemInPlainSelect((PlainSelect)((SubSelect)join.getRightItem()).getSelectBody(), fromItem)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasColumnName(String columnName) {
        return SubQuery.hasColumnBySelectItems(columnName, this.plainSelect);
    }

    private boolean hasColumnBySelectItems(String columnName, boolean isCalcItem) {
        List<SelectExpressionItem> calcItemsBeforeGroup = this.parent.getCalcItemsBeforeGroup();
        int i = 0;
        int size = calcItemsBeforeGroup != null ? calcItemsBeforeGroup.size() : 0;
        while (i < size) {
            SelectExpressionItem selectExpItem = calcItemsBeforeGroup.get(i);
            if (columnName.equalsIgnoreCase(selectExpItem.getAlias())) {
                return true;
            }
            ++i;
        }
        List<SelectExpressionItem> calcItems = this.parent.getCalcItems();
        int i2 = 0;
        int size2 = calcItems != null ? calcItems.size() : 0;
        while (i2 < size2) {
            SelectExpressionItem selectExpItem = calcItems.get(i2);
            if (columnName.equalsIgnoreCase(selectExpItem.getAlias())) {
                return true;
            }
            ++i2;
        }
        if (isCalcItem) {
            List<SubQuery> subQueryList = this.parent.getSubQuerys();
            int i3 = 0;
            int size3 = subQueryList.size();
            while (i3 < size3) {
                if (SubQuery.hasColumnBySelectItems(columnName, subQueryList.get(i3).getPlainSelect())) {
                    return true;
                }
                ++i3;
            }
            return false;
        }
        return SubQuery.hasColumnBySelectItems(columnName, this.plainSelect);
    }

    private static boolean hasColumnBySelectItems(String columnName, PlainSelect plainSelect) {
        List selectItems = plainSelect.getSelectItems();
        int i = 0;
        int size = selectItems != null ? selectItems.size() : 0;
        while (i < size) {
            Object item = selectItems.get(i);
            if (item instanceof SelectExpressionItem) {
                Column column;
                String curColName;
                String itemAlias = ((SelectExpressionItem)item).getAlias();
                if (itemAlias != null ? itemAlias.equalsIgnoreCase(columnName) : ((SelectExpressionItem)item).getExpression() instanceof Column && (curColName = (column = (Column)((SelectExpressionItem)item).getExpression()).getColumnName()).equalsIgnoreCase(columnName)) {
                    return true;
                }
            } else {
                if (item instanceof AllColumns) {
                    if (plainSelect.getFromItem() instanceof Table) {
                        return DBStruct.isExistColumnInTable(columnName, ((Table)plainSelect.getFromItem()).getName());
                    }
                    PlainSelect subPlainSelect = ParsedSqlUtil.getPlainSelect(((SubSelect)plainSelect.getFromItem()).getSelectBody());
                    return SubQuery.hasColumnBySelectItems(columnName, subPlainSelect);
                }
                if (item instanceof AllTableColumns) {
                    String tableName = ((AllTableColumns)item).getTable().getName();
                    SelectSqlInfo sqlinfo = (SelectSqlInfo)SqlInfos.instance.getSqlInfo(plainSelect.toString());
                    String realName = sqlinfo.getTableName(tableName);
                    if (DBStruct.isExistColumnInTable(columnName, realName)) {
                        return true;
                    }
                } else {
                    throw new RuntimeException("hasColumnBySelectItems\u4e2d" + item + "\u672a\u5904\u7406");
                }
            }
            ++i;
        }
        return false;
    }

    public boolean hasJoin() {
        return this.plainSelect.getJoins() != null;
    }

    public String toString() {
        return this.plainSelect == null ? "null" : this.plainSelect.toString();
    }

    public boolean hasAliasName(String aliasName) {
        return this.hasAliasName(this.plainSelect, aliasName);
    }

    private boolean hasAliasName(FromItem fromItem, String aliasName) {
        if (fromItem instanceof SubSelect) {
            PlainSelect subPlainSelect = ParsedSqlUtil.getPlainSelect(((SubSelect)this.plainSelect.getFromItem()).getSelectBody());
            return this.hasAliasName(subPlainSelect, aliasName);
        }
        return false;
    }

    private boolean hasAliasName(PlainSelect plainSelect, String aliasName) {
        boolean result = false;
        for (Object o : plainSelect.getSelectItems()) {
            AllTableColumns all;
            if (o instanceof AllColumns ? this.hasAliasName(plainSelect.getFromItem(), aliasName) : o instanceof AllTableColumns && this.hasAliasName((all = (AllTableColumns)o).getExtendFromItem(), aliasName)) {
                return true;
            }
            String itemAlias = "";
            if (o instanceof SelectExpressionItem) {
                SelectExpressionItem selectExpressionItem = (SelectExpressionItem)o;
                itemAlias = ParsedSqlUtil.getSelectItemShortName(selectExpressionItem);
            } else if (o instanceof AllColumns) continue;
            if (!ParsedSqlUtil.isSameNameMaybeWithKeyWordEscape(aliasName, itemAlias)) continue;
            result = true;
            break;
        }
        return result;
    }

    public String getAliasNameByTableName(String tableName) {
        String result = null;
        int i = 0;
        int size = this.fromItems.size();
        while (i < size) {
            Table table;
            FromItem fromItem = this.fromItems.get(i);
            if (fromItem instanceof Table && (table = (Table)fromItem).getName().equalsIgnoreCase(tableName)) {
                result = table.getAlias();
                break;
            }
            ++i;
        }
        return result;
    }

    public boolean isMainSelect() {
        return this.isMainSelect;
    }

    public void setMainSelect(boolean isMainSelect) {
        this.isMainSelect = isMainSelect;
    }

    public boolean isInSelect() {
        boolean result = true;
        InTableGroups inTableGroups = this.parent.getSelectSqlInfo().getInTableGroups();
        for (FromItem fromItem : this.fromItems) {
            boolean bl = result = result && inTableGroups.containsObject(fromItem);
        }
        return result;
    }

    public HashMapIgnoreCase<String> getFieldsChangeAlias() {
        return this.fieldsChangeAlias;
    }

    public SubQuery getLeftJoinPerSubQuery() {
        return this.leftJoinPerSubQuery;
    }

    public void setLeftJoinPerSubQuery(SubQuery leftJoinPerSubQuery) {
        this.leftJoinPerSubQuery = leftJoinPerSubQuery;
    }

    public boolean isSelect0() {
        SelectBody body;
        if (this.fromItems.size() == 1 && this.fromItems.get(0) instanceof SubSelect && (body = ((SubSelect)this.fromItems.get(0)).getSelectBody()) instanceof PlainSelect) {
            return ((PlainSelect)body).getFromItem() == null;
        }
        return false;
    }

    public void setLeftJoinCondition(Expression expression) {
        this.leftJoinCondition = ParsedSqlUtil.newAndExpression(this.leftJoinCondition, expression);
    }

    public Expression getLeftJoinCondition() {
        return this.leftJoinCondition;
    }

    public void setRelationJoin(Join relationJoin) {
        this.relationJoin = relationJoin;
    }

    public Join getRelationJoin() {
        return this.relationJoin;
    }
}

