/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.processselect;

import com.bokesoft.erp.sql.check.CheckSplitSql;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.mysqls.execute.QueryPlan;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProp;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupType;
import com.bokesoft.yes.mid.mysqls.processselect.ColumnAndInExpression;
import com.bokesoft.yes.mid.mysqls.processselect.ExpressionConstantValueEqual;
import com.bokesoft.yes.mid.mysqls.processselect.IComplexSQL;
import com.bokesoft.yes.mid.mysqls.processselect.InTableGroups;
import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yes.mid.mysqls.processselect.RegularSelectSQL;
import com.bokesoft.yes.mid.mysqls.processselect.RelationBetweenSubQuery;
import com.bokesoft.yes.mid.mysqls.processselect.SubQuery;
import com.bokesoft.yes.mid.mysqls.processselect.SubQuerys;
import com.bokesoft.yes.mid.mysqls.processselect.TwiceQueryInValue;
import com.bokesoft.yes.mid.mysqls.processselect.Unions;
import com.bokesoft.yes.mid.mysqls.processselect.split.GroupConfigRelationUtil;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.boke.jsqlparser.expression.BinaryExpression;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.Parenthesis;
import net.boke.jsqlparser.expression.operators.conditional.AndExpression;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.expression.operators.relational.InExpression;
import net.boke.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.boke.jsqlparser.query.extend.ParseHelper;
import net.boke.jsqlparser.query.source.AbstractQuerySource;
import net.boke.jsqlparser.query.source.TableSource;
import net.boke.jsqlparser.query.source.part.QueryJoinOn;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.AllColumns;
import net.boke.jsqlparser.statement.select.AllTableColumns;
import net.boke.jsqlparser.statement.select.Distinct;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.Join;
import net.boke.jsqlparser.statement.select.Limit;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.SelectBody;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;
import net.boke.jsqlparser.statement.select.SelectItem;
import net.boke.jsqlparser.statement.select.SubSelect;
import net.boke.jsqlparser.statement.select.Union;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitSelectIntoGroup {
    public static Logger splitLimitLogger = LoggerFactory.getLogger(SplitSelectIntoGroup.class);

    public static IComplexSQL splitSelectIntoGroup(SelectSqlInfo selectSqlInfo) throws SQLException {
        FromItem fromItem;
        ParseHelper.rebindRootSource(selectSqlInfo.getSelect());
        SelectBody selectBody = selectSqlInfo.getSelect().getSelectBody();
        if (selectBody instanceof Union) {
            RegularSelectSQL.instance.regularSelectSQL(selectSqlInfo.getSelect());
            return SplitSelectIntoGroup.getUnionsResult(selectSqlInfo, (Union)selectBody);
        }
        PlainSelect plainSelect = (PlainSelect)selectBody;
        if (plainSelect.getSelectItems().size() == 1 && plainSelect.getSelectItems().get(0) instanceof AllColumns && (fromItem = plainSelect.getFromItem()) instanceof SubSelect && ((SubSelect)fromItem).getSelectBody() instanceof Union) {
            return SplitSelectIntoGroup.getUnionsResult(selectSqlInfo, (Union)((SubSelect)fromItem).getSelectBody());
        }
        SubQuerys subQuerys = SplitSelectIntoGroup.splitSelectIntoGroup(selectSqlInfo, plainSelect);
        if (subQuerys != null) {
            QueryPlan.preProcessSubQuery(subQuerys);
        }
        return subQuerys;
    }

    public static Unions getUnionsResult(SelectSqlInfo selectSqlInfo, Union selectBody) throws SQLException {
        SelectBody plainSelect = selectSqlInfo.getSelect().getSelectBody();
        Expression whereExp = null;
        if (!(plainSelect instanceof Union)) {
            whereExp = ((PlainSelect)plainSelect).getWhere();
        }
        Unions result = new Unions(selectBody.isAll());
        List plainSelects = selectBody.getPlainSelects();
        int i = 0;
        int len = plainSelects.size();
        while (i < len) {
            PlainSelect subPlainSelect = (PlainSelect)plainSelects.get(i);
            ParsedSqlUtil.addWhereExpression(subPlainSelect, whereExp);
            SubQuerys subSelects = SplitSelectIntoGroup.splitSelectIntoGroup(selectSqlInfo, subPlainSelect, true);
            if (subSelects != null) {
                QueryPlan.preProcessSubQuery(subSelects);
            }
            result.addSubSelects(subSelects);
            ++i;
        }
        return result;
    }

    private static SubQuerys splitSelectIntoGroup(SelectSqlInfo selectSqlInfo, PlainSelect plainSelect) throws SQLException {
        return SplitSelectIntoGroup.splitSelectIntoGroup(selectSqlInfo, plainSelect, false);
    }

    private static SubQuerys splitSelectIntoGroup(SelectSqlInfo parentSelectSqlInfo, PlainSelect plainSelect, boolean bIsUnion) throws SQLException {
        Join join;
        SelectSqlInfo selectSqlInfo;
        SubQuerys result = new SubQuerys(parentSelectSqlInfo, plainSelect, bIsUnion);
        SelectSqlInfo selectSqlInfo2 = selectSqlInfo = bIsUnion ? result.getSelectSqlInfo() : parentSelectSqlInfo;
        if (selectSqlInfo.isNoGroup()) {
            return result;
        }
        if (!bIsUnion) {
            int newGroupCount;
            int oldGroupCount = plainSelect.getGroupByColumnReferences() != null ? plainSelect.getGroupByColumnReferences().size() : 0;
            RegularSelectSQL.instance.regularSelectSQL(selectSqlInfo.getSelect());
            int n = newGroupCount = plainSelect.getGroupByColumnReferences() != null ? plainSelect.getGroupByColumnReferences().size() : 0;
            if (oldGroupCount != newGroupCount) {
                selectSqlInfo.reProcessFunctionGroupByOrderBy();
            }
        }
        ExpressionConstantValueEqual.ReplanceConstantValue(selectSqlInfo.getSelect());
        FromItem fromItem = plainSelect.getFromItem();
        SplitSelectIntoGroup.processFromItem(result, fromItem, plainSelect, null, plainSelect.getWhere(), null);
        List joins = plainSelect.getJoins();
        if (joins != null) {
            for (Object joinTmp : joins) {
                join = (Join)joinTmp;
                FromItem joinFromItem = join.getRightItem();
                if (GroupConfigRelationUtil.isRelationJoin(join, plainSelect.getWhere())) continue;
                SubQuery subQuery = SplitSelectIntoGroup.processFromItem(result, joinFromItem, plainSelect, join.getOnExpression(), plainSelect.getWhere(), join);
                List<Join> relatonJoins = GroupConfigRelationUtil.getRelationJoins(fromItem, joins, plainSelect.getWhere());
                for (Join relationJoin : relatonJoins) {
                    subQuery.addFromItem(relationJoin.getRightItem(), relationJoin);
                    subQuery.setRelationJoin(relationJoin);
                }
            }
        }
        if (result.datas.size() == 1 && !bIsUnion) {
            return null;
        }
        ParseHelper.rebindRootSource(plainSelect);
        result.processExpression(plainSelect.getWhere(), null, true);
        if (joins != null) {
            for (Object joinTmp : joins) {
                join = (Join)joinTmp;
                result.processExpression(join.getOnExpression(), join, false);
                if (!GroupConfigRelationUtil.isRelationJoin(join, plainSelect.getWhere())) continue;
                result.addRelationBetweenSubQuery(join);
            }
        }
        result.mergeSubSelectSameDataObjectByRelation();
        if (result.datas.size() == 1 && !bIsUnion) {
            return null;
        }
        ParseHelper.rebindRootSource(plainSelect);
        SplitSelectIntoGroup.processSelectItems(result, plainSelect.getSelectItems());
        result.processGroupByExpression(plainSelect.getGroupByColumnReferences());
        result.processOrderByExpression(plainSelect.getOrderByElements());
        SplitSelectIntoGroup.processDistinct(result, plainSelect.getDistinct());
        SplitSelectIntoGroup.processLimit(result, plainSelect.getLimit());
        result.processGroupbyExt();
        SplitSelectIntoGroup.processInTables(result, parentSelectSqlInfo.getInTableGroups());
        if (bIsUnion) {
            selectSqlInfo.setComplexSQL(result);
        }
        for (SubQuery tmp : result.datas) {
            List<FromItem> fromItems = tmp.fromItems;
            boolean isAllRelationTable = true;
            for (FromItem tmpFromItem : fromItems) {
                if (tmpFromItem instanceof Table) {
                    TableGroupProp tableGroupProp = TableGroupProps.getInstance().getTableGroupProp(((Table)tmpFromItem).getName());
                    if (tableGroupProp != null && tableGroupProp.getFixedType() == TableGroupType.DataObjectRelationTable) continue;
                    isAllRelationTable = false;
                    continue;
                }
                isAllRelationTable = false;
            }
            if (!isAllRelationTable || tmp.getPlainSelect().getDistinct() != null) continue;
            tmp.getPlainSelect().setDistinct(new Distinct());
        }
        return result;
    }

    private static void processLimit(SubQuerys result, Limit limit) {
        if (limit != null) {
            for (SubQuery subQuery : result.getSubQuerys()) {
                if (subQuery.isMainSelect()) {
                    SplitSelectIntoGroup.checkSubMainTable4Limit(subQuery.getPlainSelect(), result.getPlainSelect());
                    subQuery.getPlainSelect().setLimit(limit);
                    break;
                }
                SplitSelectIntoGroup.checkLeftJoin4Limit(subQuery.getPlainSelect(), result.getPlainSelect());
            }
        }
    }

    private static void checkLeftJoin4Limit(PlainSelect subPlainSelect, PlainSelect orgPlainSelect) {
        if (!CheckSplitSql.isNeedCheckLimit()) {
            return;
        }
        AbstractQuerySource<?> subSource = subPlainSelect.getQuerySource();
        for (QueryJoinOn joinOn : subSource.getJoinOnList()) {
            if (joinOn.isLeftJoinOn()) continue;
            SplitSelectIntoGroup.logAndRaiseLimitCheck(subPlainSelect, orgPlainSelect, "\u5206\u5e93Limt,\u975e\u4e3bSQL\u8bed\u53e5\u4e2d\u53ea\u80fd\u4f7f\u7528Left Join\u7684\u65b9\u5f0f\u8fdb\u884c\u8868\u5173\u8054\uff01");
        }
    }

    private static void checkSubMainTable4Limit(PlainSelect subMainSelect, PlainSelect orgPlainSelect) {
        if (!CheckSplitSql.isNeedCheckLimit()) {
            return;
        }
        TableSource mainTableSourceOrg = orgPlainSelect.getQuerySource().getFirstTableSource();
        if (subMainSelect.getQuerySource() == null) {
            ParseHelper.rebindRootSource(subMainSelect);
        }
        TableSource mainTableSource = subMainSelect.getQuerySource().getFirstTableSource();
        if (mainTableSourceOrg == null || mainTableSource == null) {
            SplitSelectIntoGroup.logAndRaiseLimitCheck(subMainSelect, orgPlainSelect, "\u5206\u5e93Limit,\u65e0\u6cd5\u5b9a\u4f4d\u7b2c\u4e00\u4e2a\u5173\u8054\u8868\uff01");
        }
        if (!TypeConvertor.toString((Object)mainTableSource.getTableName()).equalsIgnoreCase(mainTableSourceOrg.getTableName())) {
            SplitSelectIntoGroup.logAndRaiseLimitCheck(subMainSelect, orgPlainSelect, "\u5206\u5e93Limit,\u539f\u59cbSQL\u4e0e\u4e3bSQL\u7684\u7b2c\u4e00\u4e2a\u5173\u8054\u8868\u4e0d\u4e00\u81f4\uff01");
        }
    }

    private static void logAndRaiseLimitCheck(PlainSelect subSelect, PlainSelect orgPlainSelect, String errorMessage) {
        splitLimitLogger.info("\u3010\u68c0\u67e5\u7ed3\u679c\u3011: " + errorMessage);
        String message1 = null;
        String message2 = null;
        if (orgPlainSelect != null) {
            message1 = "\u3010\u539f\u59cbSQL\u3011: " + orgPlainSelect.toString();
            splitLimitLogger.info(message1);
        }
        if (subSelect != null) {
            message2 = "\u3010\u5206\u5e93SQL\u3011:  " + subSelect.toString();
            splitLimitLogger.info(message2);
        }
        splitLimitLogger.info("******************************************************************************************");
        throw new RuntimeException(String.valueOf(errorMessage) + (StringUtil.isBlankOrNull((String)message1) ? "" : "\n" + message1) + (StringUtil.isBlankOrNull((String)message2) ? "" : "\n" + message2));
    }

    private static void processDistinct(SubQuerys result, Distinct distinct) {
        for (SubQuery subSelect : result.datas) {
            subSelect.getPlainSelect().setDistinct(distinct);
        }
    }

    private static SubQuery processFromItem(SubQuerys subSelects, FromItem fromItem, PlainSelect plainSelect, Expression joinOnExpression, Expression whereExpression, Join join) {
        FromItem firstJoinFromItem = null;
        if (!(join == null || join.isLeft() && SplitSelectIntoGroup.hasLeftJoin(subSelects.datas))) {
            boolean isDefaultGroup = false;
            if (fromItem instanceof Table || SplitSelectIntoGroup.isSameDataObject((SubSelect)fromItem)) {
                boolean checkRst;
                if (joinOnExpression != null && (firstJoinFromItem = SplitSelectIntoGroup.getJoinTableSameDataObject(fromItem, joinOnExpression)) != null && !(checkRst = SplitSelectIntoGroup.checkJoinTableDiffDeforeCurrJoin(plainSelect, firstJoinFromItem, fromItem, joinOnExpression))) {
                    firstJoinFromItem = null;
                }
                if (firstJoinFromItem == null && whereExpression != null) {
                    firstJoinFromItem = SplitSelectIntoGroup.getJoinTableSameDataObject(fromItem, whereExpression);
                }
                if (firstJoinFromItem == null) {
                    firstJoinFromItem = SplitSelectIntoGroup.getJoinTableDefaultGroup(fromItem, joinOnExpression);
                    if (firstJoinFromItem == null && whereExpression != null) {
                        firstJoinFromItem = SplitSelectIntoGroup.getJoinTableDefaultGroup(fromItem, whereExpression);
                    }
                    boolean bl = isDefaultGroup = firstJoinFromItem != null;
                }
            }
            if (firstJoinFromItem != null) {
                if (isDefaultGroup && !ParsedSqlUtil.isDefaultGroup(firstJoinFromItem)) {
                    firstJoinFromItem = null;
                } else {
                    subSelects.addTableRelation(fromItem, firstJoinFromItem);
                }
            }
        }
        SubQuery subQuery = subSelects.getSubSelectEnsure(firstJoinFromItem);
        if (join != null && join.isLeft() && firstJoinFromItem != null && subQuery != subSelects.datas.get(subSelects.datas.size() - 1)) {
            firstJoinFromItem = null;
            subQuery = subSelects.getSubSelectEnsure(null);
        }
        if (join != null && join.isLeft() && firstJoinFromItem == null) {
            subQuery.setLeftJoinPerSubQuery(subSelects.datas.get(subSelects.datas.size() - 2));
        }
        if (subSelects.datas.size() == 1) {
            subQuery.setMainSelect(true);
        }
        subQuery.addFromItem(fromItem, join);
        return subQuery;
    }

    private static boolean hasLeftJoin(List<SubQuery> list) {
        for (SubQuery subQuery : list) {
            if (subQuery.getLeftJoinPerSubQuery() == null) continue;
            return true;
        }
        return false;
    }

    private static boolean checkJoinTableDiffDeforeCurrJoin(PlainSelect plainSelect, FromItem firstJoinTable, FromItem fromItem, Expression expression) {
        if (expression == null) {
            return true;
        }
        if (expression instanceof AndExpression) {
            boolean result = SplitSelectIntoGroup.checkJoinTableDiffDeforeCurrJoin(plainSelect, firstJoinTable, fromItem, ((AndExpression)expression).getLeftExpression());
            if (result) {
                result = SplitSelectIntoGroup.checkJoinTableDiffDeforeCurrJoin(plainSelect, firstJoinTable, fromItem, ((AndExpression)expression).getRightExpression());
            }
            return result;
        }
        if (expression instanceof EqualsTo || expression instanceof NotEqualsTo) {
            Expression leftExpression = ((BinaryExpression)expression).getLeftExpression();
            Expression rightExpression = ((BinaryExpression)expression).getRightExpression();
            if (leftExpression instanceof Column && rightExpression instanceof Column) {
                FromItem rightItem;
                Join currJoin;
                String leftColumName = ((Column)leftExpression).getColumnName();
                if (SplitSelectIntoGroup.isJoinFieldSameDataObject(leftColumName)) {
                    return true;
                }
                String rightColumnName = ((Column)rightExpression).getColumnName();
                if (SplitSelectIntoGroup.isJoinFieldSameDataObject(rightColumnName)) {
                    return true;
                }
                int mergeIndex = 0;
                List joins = plainSelect.getJoins();
                for (Object join : joins) {
                    Table joinTable;
                    Join currJoin2 = (Join)join;
                    FromItem rightItem2 = currJoin2.getRightItem();
                    if (!(rightItem2 instanceof Table) || (joinTable = (Table)rightItem2) != firstJoinTable) continue;
                    mergeIndex = joins.indexOf(join) + 1;
                }
                int currIndex = 0;
                if (firstJoinTable != ((Column)leftExpression).getExtendFromItem() && fromItem != ((Column)leftExpression).getExtendFromItem()) {
                    for (Object join : joins) {
                        currJoin = (Join)join;
                        rightItem = currJoin.getRightItem();
                        if (rightItem != ((Column)leftExpression).getExtendFromItem()) continue;
                        currIndex = joins.indexOf(join) + 1;
                    }
                } else if (firstJoinTable != ((Column)rightExpression).getExtendFromItem() && fromItem != ((Column)rightExpression).getExtendFromItem()) {
                    for (Object join : joins) {
                        currJoin = (Join)join;
                        rightItem = currJoin.getRightItem();
                        if (rightItem != ((Column)rightExpression).getExtendFromItem()) continue;
                        currIndex = joins.indexOf(join) + 1;
                    }
                }
                if (currIndex > mergeIndex) {
                    return false;
                }
            }
        }
        return true;
    }

    private static FromItem getJoinTableSameDataObject(FromItem fromItem, Expression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof Parenthesis) {
            return SplitSelectIntoGroup.getJoinTableSameDataObject(fromItem, ((Parenthesis)expression).getExpression());
        }
        if (expression instanceof AndExpression) {
            FromItem result = SplitSelectIntoGroup.getJoinTableSameDataObject(fromItem, ((AndExpression)expression).getLeftExpression());
            if (result == null) {
                result = SplitSelectIntoGroup.getJoinTableSameDataObject(fromItem, ((AndExpression)expression).getRightExpression());
            }
            return result;
        }
        if (expression instanceof EqualsTo || expression instanceof NotEqualsTo) {
            Expression leftExpression = ((BinaryExpression)expression).getLeftExpression();
            Expression rightExpression = ((BinaryExpression)expression).getRightExpression();
            if (leftExpression instanceof Column && rightExpression instanceof Column) {
                String leftColumName = ((Column)leftExpression).getColumnName();
                if (!SplitSelectIntoGroup.isJoinFieldSameDataObject(leftColumName)) {
                    return null;
                }
                String rightColumnName = ((Column)rightExpression).getColumnName();
                if (!SplitSelectIntoGroup.isJoinFieldSameDataObject(rightColumnName)) {
                    return null;
                }
                if (fromItem == ((Column)leftExpression).getExtendFromItem()) {
                    return ((Column)rightExpression).getExtendFromItem();
                }
                if (fromItem == ((Column)rightExpression).getExtendFromItem()) {
                    return ((Column)leftExpression).getExtendFromItem();
                }
            }
        }
        return null;
    }

    private static FromItem getJoinTableDefaultGroup(FromItem fromItem, Expression expression) {
        if (!SplitSelectIntoGroup.isInDefaultGroup(fromItem)) {
            return null;
        }
        if (expression == null) {
            return null;
        }
        if (expression instanceof Parenthesis) {
            return SplitSelectIntoGroup.getJoinTableDefaultGroup(fromItem, ((Parenthesis)expression).getExpression());
        }
        if (expression instanceof AndExpression) {
            FromItem result = SplitSelectIntoGroup.getJoinTableDefaultGroup(fromItem, ((AndExpression)expression).getLeftExpression());
            if (result == null) {
                result = SplitSelectIntoGroup.getJoinTableDefaultGroup(fromItem, ((AndExpression)expression).getRightExpression());
            }
            return result;
        }
        if (expression instanceof BinaryExpression) {
            Expression leftExpression = ((BinaryExpression)expression).getLeftExpression();
            Expression rightExpression = ((BinaryExpression)expression).getRightExpression();
            if (leftExpression instanceof Column && rightExpression instanceof Column) {
                Table leftTable = ((Column)leftExpression).getTable();
                Table rightTable = ((Column)rightExpression).getTable();
                if (((Column)leftExpression).getExtendFromItem() == fromItem) {
                    return ((Column)rightExpression).getExtendFromItem();
                }
                if (((Column)rightExpression).getExtendFromItem() == fromItem) {
                    return ((Column)leftExpression).getExtendFromItem();
                }
            }
        }
        return null;
    }

    private static boolean isInDefaultGroup(FromItem fromItem) {
        if (fromItem instanceof Table) {
            Table table = (Table)fromItem;
            return TableGroupProps.getInstance().getTableGroupProp(table.getName()) == null;
        }
        if (fromItem instanceof SubSelect) {
            List<Table> tables = ParsedSqlUtil.getAllTableBySelectBody(((SubSelect)fromItem).getSelectBody(), null);
            for (Table table : tables) {
                if (TableGroupProps.getInstance().getTableGroupProp(table.getName()) == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isJoinFieldSameDataObject(String columnName) {
        return columnName.equalsIgnoreCase("OID") || columnName.equalsIgnoreCase("SOID") || columnName.equalsIgnoreCase("POID") || columnName.equalsIgnoreCase("SrcLangOID");
    }

    private static boolean isSameDataObject(SubSelect subSelect) {
        if (subSelect.getSelectBody() instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)subSelect.getSelectBody();
            FromItem firstFromItem = plainSelect.getFromItem();
            if (firstFromItem instanceof SubSelect && !SplitSelectIntoGroup.isSameDataObject((SubSelect)firstFromItem)) {
                return false;
            }
            List joins = plainSelect.getJoins();
            int i = 0;
            int size = joins != null ? joins.size() : 0;
            while (i < size) {
                Join join = (Join)joins.get(i);
                if (join.getRightItem() instanceof SubSelect && !SplitSelectIntoGroup.isSameDataObject((SubSelect)join.getRightItem())) {
                    return false;
                }
                if (SplitSelectIntoGroup.getJoinTableSameDataObject(join.getRightItem(), join.getOnExpression()) == null) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static void processSelectItems(SubQuerys subSelects, List<?> selectItems) throws SQLException {
        ArrayList<SelectExpressionItem> calcItems = null;
        for (Object tmp : selectItems) {
            if (tmp instanceof SelectExpressionItem) {
                SelectExpressionItem selectExpressionItem = (SelectExpressionItem)tmp;
                if (subSelects.addSelectItem(selectExpressionItem)) continue;
                if (calcItems == null) {
                    calcItems = new ArrayList<SelectExpressionItem>();
                }
                calcItems.add(selectExpressionItem);
                continue;
            }
            if (!(tmp instanceof AllTableColumns) && !(tmp instanceof AllColumns)) continue;
            subSelects.addSelectItem((SelectItem)tmp);
        }
        if (calcItems != null) {
            for (SelectExpressionItem calcItem : calcItems) {
                subSelects.addCalcItem(calcItem);
            }
            for (SelectExpressionItem calcItem : calcItems) {
                subSelects.addColumnInCalcItem(calcItem.getExpression());
            }
        }
        for (SubQuery subQuery : subSelects.datas) {
            if (subQuery.getLeftJoinCondition() == null) continue;
            subSelects.addColumnInCalcItem(subQuery.getLeftJoinCondition());
        }
        if (subSelects.getExtendHavingExpression() != null) {
            subSelects.addColumnInCalcItem(subSelects.getExtendHavingExpression());
        }
    }

    private static void processInTables(SubQuerys subSelects, InTableGroups inTableGroups) {
        HashMap twiceQueryInValueMap = null;
        for (SubQuery subQuery : subSelects.datas) {
            List<FromItem> tables = subQuery.fromItems;
            if (subQuery.getPlainSelect().getDistinct() != null && !inTableGroups.hasNotInOrExist(tables)) continue;
            ArrayList<ColumnAndInExpression> plainSelectIns = new ArrayList<ColumnAndInExpression>();
            boolean isAllInTable = true;
            for (FromItem table : tables) {
                if (inTableGroups.contains(table)) continue;
                isAllInTable = false;
                break;
            }
            if (isAllInTable) {
                subQuery.plainSelect.setDistinct(new Distinct());
                continue;
            }
            InTableGroups subInTableGroups = inTableGroups.getSubGroups(tables);
            ArrayList<TwiceQueryInValue> twiceQueryInValues = null;
            int i = 0;
            int size = subInTableGroups != null ? subInTableGroups.size() : 0;
            while (i < size) {
                List<FromItem> subInTableGroup = subInTableGroups.get(i);
                int inTableSize = subInTableGroup.size();
                ArrayList<Join> subJoinGroup = new ArrayList<Join>(inTableSize);
                BinaryExpression firstEqualsTo = null;
                int j = 0;
                while (j < inTableSize) {
                    Expression firstEqualsToTmp;
                    Join join = ParsedSqlUtil.getJoinByFromItem(subQuery.plainSelect, subInTableGroup.get(j));
                    if (join == null) {
                        throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u6ca1\u6709\u627e\u5230In\u5b50\u53e5\u4e2d\u7684\u8868" + subInTableGroup.get(j) + "\u5bf9\u5e94\u7684From\u9879\u3002\n" + subQuery.plainSelect.toString());
                    }
                    subJoinGroup.add(join);
                    Expression onExpression = join.getOnExpression();
                    Expression expression = firstEqualsToTmp = onExpression instanceof AndExpression ? ParsedSqlUtil.getFirstExpressionFromAnds((AndExpression)onExpression) : onExpression;
                    if (firstEqualsToTmp == null || !(firstEqualsToTmp instanceof EqualsTo) && !(firstEqualsToTmp instanceof NotEqualsTo)) {
                        firstEqualsToTmp = null;
                    }
                    if (firstEqualsToTmp != null) {
                        BinaryExpression firstEqualsToTmp2 = (BinaryExpression)firstEqualsToTmp;
                        if (!(firstEqualsToTmp2.getRightExpression() instanceof Column) || !(firstEqualsToTmp2.getLeftExpression() instanceof Column)) {
                            firstEqualsToTmp2 = null;
                        }
                        if (firstEqualsToTmp2 != null) {
                            Column leftColumn = (Column)firstEqualsToTmp2.getLeftExpression();
                            Column rightColumn = (Column)firstEqualsToTmp2.getRightExpression();
                            if (subInTableGroup.get(j) == rightColumn.getExtendFromItem() && !subInTableGroup.contains(leftColumn.getExtendFromItem())) {
                                if (firstEqualsTo != null) {
                                    throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u627e\u5230Join\u7684\u4e24\u4e2a\u6761\u4ef6\u8868\u8fbe\uff0c\u540e\u4e00\u4e2a\u662f" + firstEqualsToTmp2 + "\u3002\n" + subQuery.plainSelect.toString());
                                }
                                firstEqualsTo = firstEqualsToTmp2;
                            }
                        }
                    }
                    ++j;
                }
                if (firstEqualsTo == null) {
                    throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u627e\u4e0d\u5230Join\u7684\u6761\u4ef6\u8868\u8fbe\uff0c\u76f8\u5173\u8868\u662f" + subInTableGroup + "\u3002\n" + subQuery.plainSelect.toString());
                }
                boolean useInRelation = false;
                if (subSelects.relations != null) {
                    int j2 = 0;
                    int relationSize = subSelects.relations.size();
                    while (j2 < relationSize) {
                        if (ParsedSqlUtil.isUseTable((Expression)subSelects.relations.get(j2).getLeftColumn(), subInTableGroup) || ParsedSqlUtil.isUseTable((Expression)subSelects.relations.get(j2).getRightColumn(), subInTableGroup)) {
                            useInRelation = true;
                            break;
                        }
                        ++j2;
                    }
                }
                if (useInRelation) {
                    twiceQueryInValues = twiceQueryInValues == null ? new ArrayList<TwiceQueryInValue>() : twiceQueryInValues;
                    twiceQueryInValues.add(new TwiceQueryInValue(firstEqualsTo, subInTableGroup, subJoinGroup));
                    twiceQueryInValueMap = twiceQueryInValueMap == null ? new HashMap() : twiceQueryInValueMap;
                    twiceQueryInValueMap.put(subQuery, twiceQueryInValues);
                } else {
                    PlainSelect plainSelectIn = new PlainSelect();
                    ParsedSqlUtil.addSelectItem(plainSelectIn, new SelectExpressionItem(firstEqualsTo.getRightExpression()));
                    FromItem firstTable = subInTableGroup.get(0);
                    plainSelectIn.setFromItem(firstTable);
                    Expression onExpression = ((Join)subJoinGroup.get(0)).getOnExpression();
                    plainSelectIn.setWhere(ParsedSqlUtil.removeFirstExpressionFromAnds(onExpression, firstEqualsTo));
                    Expression whereExpressionEx = ParsedSqlUtil.removeAndReturnWhereOfTable(subQuery.plainSelect, firstTable);
                    ParsedSqlUtil.addWhereExpression(plainSelectIn, whereExpressionEx);
                    subQuery.plainSelect.getJoins().remove(subJoinGroup.get(0));
                    if (inTableSize > 1) {
                        ArrayList<Join> joins = new ArrayList<Join>(inTableSize - 1);
                        int m = 1;
                        while (m < inTableSize) {
                            Join join = (Join)subJoinGroup.get(m);
                            joins.add(join);
                            onExpression = join.getOnExpression();
                            join.setOnExpression(ParsedSqlUtil.removeFirstExpressionFromAnds(onExpression, firstEqualsTo));
                            whereExpressionEx = ParsedSqlUtil.removeAndReturnWhereOfTable(subQuery.plainSelect, subInTableGroup.get(m));
                            ParsedSqlUtil.addWhereExpression(plainSelectIn, whereExpressionEx);
                            subQuery.plainSelect.getJoins().remove(join);
                            ++m;
                        }
                        plainSelectIn.setJoins(joins);
                    }
                    SubSelect subSelectIn = new SubSelect();
                    subSelectIn.setSelectBody(plainSelectIn);
                    InExpression in = new InExpression(firstEqualsTo.getLeftExpression(), subSelectIn);
                    if (firstEqualsTo instanceof NotEqualsTo) {
                        in.setNot(true);
                    }
                    plainSelectIns.add(new ColumnAndInExpression((Column)firstEqualsTo.getLeftExpression(), in));
                }
                ++i;
            }
            int checkEndlessLoop = 0;
            while (plainSelectIns.size() > 0) {
                ArrayList<ColumnAndInExpression> nextLoop = new ArrayList<ColumnAndInExpression>();
                for (ColumnAndInExpression entry : plainSelectIns) {
                    PlainSelect plainSelect = ParsedSqlUtil.getPlainSelectByTable(subQuery.plainSelect, entry.leftColumn.getTable());
                    if (plainSelect != null) {
                        ParsedSqlUtil.addWhereExpression(plainSelect, entry.inExp);
                        continue;
                    }
                    nextLoop.add(entry);
                }
                plainSelectIns = nextLoop;
                if (++checkEndlessLoop > subQuery.fromItems.size()) {
                    throw new AssertionError((Object)"\u5206\u5e93SQL\u89e3\u6790\u6b7b\u5faa\u73af\u3002");
                }
            }
        }
        SplitSelectIntoGroup.processTwiceQueryInValues(subSelects, twiceQueryInValueMap);
    }

    private static void processTwiceQueryInValues(SubQuerys subSelects, Map<SubQuery, List<TwiceQueryInValue>> twiceQueryInValueMap) {
        if (twiceQueryInValueMap == null) {
            return;
        }
        for (Map.Entry<SubQuery, List<TwiceQueryInValue>> entry : twiceQueryInValueMap.entrySet()) {
            TwiceQueryInValue twiceQueryInValue;
            SubQuery subQuery = entry.getKey();
            List<TwiceQueryInValue> twiceQueryInValues = entry.getValue();
            int i = 0;
            int size = twiceQueryInValues.size();
            while (i < size) {
                twiceQueryInValue = twiceQueryInValues.get(i);
                SubQuery inValueSubQuery = new SubQuery(subSelects, subQuery);
                PlainSelect plainSelect = subQuery.plainSelect;
                inValueSubQuery.addFromItem(plainSelect.getFromItem(), null);
                int joinIndex = 0;
                int joinSize = plainSelect.getJoins().size();
                while (joinIndex < joinSize) {
                    Join join = (Join)plainSelect.getJoins().get(joinIndex);
                    inValueSubQuery.addFromItem(join.getRightItem(), join);
                    if (join.getOnExpression() != null) {
                        Join newJoin = ParsedSqlUtil.getJoinByFromItem(inValueSubQuery.plainSelect, join.getRightItem());
                        newJoin.setOnExpression(ParsedSqlUtil.cloneExpression(join.getOnExpression()));
                    }
                    ++joinIndex;
                }
                for (RelationBetweenSubQuery relation : subSelects.getRelations()) {
                    if (relation.getLeftSubQuery() == subQuery) {
                        if (!ParsedSqlUtil.isUseTable((Expression)relation.getLeftColumn(), twiceQueryInValue.subInTableGroup)) continue;
                        relation.setLeftSubQuery(inValueSubQuery);
                        continue;
                    }
                    if (relation.getRightSubQuery() != subQuery || !ParsedSqlUtil.isUseTable((Expression)relation.getRightColumn(), twiceQueryInValue.subInTableGroup)) continue;
                    relation.setRightSubQuery(inValueSubQuery);
                }
                inValueSubQuery.plainSelect.setDistinct(new Distinct());
                ParsedSqlUtil.addWhereExpression(inValueSubQuery.plainSelect, ParsedSqlUtil.cloneExpression(plainSelect.getWhere()));
                if (plainSelect.getHaving() != null) {
                    throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0cIn\u503c\u4e8c\u6b21\u67e5\u8be2\u4e0d\u652f\u6301Having\u3002" + plainSelect.toString());
                }
                twiceQueryInValue.subQuery = inValueSubQuery;
                ++i;
            }
            i = 0;
            size = twiceQueryInValues.size();
            while (i < size) {
                twiceQueryInValue = twiceQueryInValues.get(i);
                PlainSelect plainSelect = subQuery.plainSelect;
                for (Join join : twiceQueryInValue.subJoinGroup) {
                    ParsedSqlUtil.removeJoin(plainSelect, join);
                    Expression onExpression = join.getOnExpression();
                    if (onExpression == null) continue;
                    ParsedSqlUtil.removeFirstExpressionFromAnds(onExpression, twiceQueryInValue.keyExpression);
                }
                plainSelect.setWhere(ParsedSqlUtil.removeExpressionFromAnds(plainSelect.getWhere(), twiceQueryInValue.subInTableGroup));
                RelationBetweenSubQuery relation = new RelationBetweenSubQuery();
                relation.setEqual(twiceQueryInValue.keyExpression instanceof EqualsTo);
                relation.setLeftExpression(twiceQueryInValue.keyExpression.getLeftExpression());
                relation.setLeftSubQuery(subQuery);
                relation.setRightColumn((Column)twiceQueryInValue.keyExpression.getRightExpression());
                relation.setRightSubQuery(twiceQueryInValue.subQuery);
                subSelects.addRelation(relation);
                ++i;
            }
        }
    }
}

