/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.oidpool;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.mid.mysqls.group.OneOrMultiValue;
import com.bokesoft.yes.mid.mysqls.oidpool.DSNTableName;
import com.bokesoft.yigo.cache.CacheFactory;
import com.bokesoft.yigo.cache.ICache;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class UnreliableOIDPool {
    private ICache<DSNTableName> cache = CacheFactory.getInstance().createCache("ERP_UnreliableOIDPoolCaches");
    public static final UnreliableOIDPool instance = new UnreliableOIDPool();

    private UnreliableOIDPool() {
    }

    public DSNTableName getDSNTableName(Long oid) {
        try {
            return (DSNTableName)this.cache.get(oid.toString());
        }
        catch (JedisConnectionException e) {
            throw new RuntimeException("Redis\u670d\u52a1\u6ca1\u6709\u542f\u52a8\uff0c\u4e0d\u80fd\u8fde\u63a5", e);
        }
        catch (Throwable t) {
            LogSvr.getInstance().error(t.getMessage(), t);
            return null;
        }
    }

    public void setOIDDSNName(Long oid, DSNTableName dsnTableName) {
        OneOrMultiValue<String> newDSNNames = dsnTableName.getNewDSNNames();
        if (newDSNNames != null) {
            dsnTableName = new DSNTableName(newDSNNames, dsnTableName.tableNamePostFix);
        }
        this.cache.put(oid.toString(), (Object)dsnTableName);
    }

    public void removeOIDDSNName(Long oid) {
        this.cache.remove(oid.toString());
    }
}

