/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.oidpool;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.mid.mysqls.oidpool.ERPRedisCache;
import com.bokesoft.yes.mid.mysqls.oidpool.ERPRedisHelper;
import com.bokesoft.yes.mid.util.PropertyUtil;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.cache.ICacheFactory;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.nosql.Connection;
import java.io.InputStream;
import java.util.PropertyResourceBundle;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class OIDPoolRedisFactory
implements ICacheFactory {
    private String host = "127.0.0.1";
    private int port = 6379;
    private String pwd = "";
    private int max_active = 100;
    private int max_idle = 20;
    private int max_wait = -1;
    private int timeout = 10000;
    private boolean testOnBorrow = false;
    private boolean testOnReturn = false;
    private int expireTime = 0;
    private String prefix = "";
    private ERPRedisHelper helper;
    public static final String UNRELIABLE_OIDPOOL_CACHE = "ERP_UnreliableOIDPoolCaches";

    public OIDPoolRedisFactory(int dbIndex) {
        try {
            this.init();
        }
        catch (Throwable e) {
            LogSvr.getInstance().error("init redis cacheFactory error", e);
            LogSvr.getInstance().error(e.getMessage(), e);
        }
    }

    public <V> ICache<V> createCache(String key) {
        ERPRedisCache cache = new ERPRedisCache(key, (Connection)this.helper);
        return cache;
    }

    private void init() throws Throwable {
        String expire;
        String testReturn;
        String testBorrow;
        String wait;
        String idle;
        String max;
        String timeout;
        String pwd;
        String port;
        String host;
        InputStream redisIS = PropertyUtil.readProperties((String)"redis.properties");
        if (redisIS == null) {
            throw new MidCoreException(36, MidCoreException.formatMessage(null, (int)36, (Object[])new Object[0]));
        }
        PropertyResourceBundle redisBundle = new PropertyResourceBundle(redisIS);
        if (redisBundle.containsKey("Host") && (host = redisBundle.getString("Host")) != null && !host.isEmpty()) {
            this.host = host;
        }
        if (redisBundle.containsKey("Port") && (port = redisBundle.getString("Port")) != null && !port.isEmpty()) {
            this.port = Integer.parseInt(port);
        }
        if (redisBundle.containsKey("PassWord") && (pwd = redisBundle.getString("PassWord")) != null && !pwd.isEmpty()) {
            this.pwd = pwd;
        }
        if (redisBundle.containsKey("TimeOut") && (timeout = redisBundle.getString("TimeOut")) != null && !timeout.isEmpty()) {
            this.timeout = Integer.parseInt(timeout);
        }
        if (redisBundle.containsKey("MaxActive") && (max = redisBundle.getString("MaxActive")) != null && !max.isEmpty()) {
            this.max_active = Integer.parseInt(max);
        }
        if (redisBundle.containsKey("MaxIdle") && (idle = redisBundle.getString("MaxIdle")) != null && !idle.isEmpty()) {
            this.max_idle = Integer.parseInt(idle);
        }
        if (redisBundle.containsKey("MaxWait") && (wait = redisBundle.getString("MaxWait")) != null && !wait.isEmpty()) {
            this.max_wait = Integer.parseInt(wait);
        }
        if (redisBundle.containsKey("TestOnBorrow") && (testBorrow = redisBundle.getString("TestOnBorrow")) != null && !testBorrow.isEmpty()) {
            this.testOnBorrow = TypeConvertor.toBoolean((Object)testBorrow);
        }
        if (redisBundle.containsKey("TestOnReturn") && (testReturn = redisBundle.getString("TestOnReturn")) != null && !testReturn.isEmpty()) {
            this.testOnBorrow = TypeConvertor.toBoolean((Object)testReturn);
        }
        if (redisBundle.containsKey("Expire_time") && (expire = redisBundle.getString("Expire_time")) != null && !expire.isEmpty()) {
            this.expireTime = TypeConvertor.toInteger((Object)expire);
        }
        if (redisBundle.containsKey("Prefix")) {
            this.prefix = redisBundle.getString("Prefix");
        }
        this.initPool();
        redisIS.close();
    }

    private void initPool() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(this.max_active);
        config.setMaxIdle(this.max_idle);
        config.setMaxWaitMillis((long)this.max_wait);
        config.setTestOnBorrow(this.testOnBorrow);
        config.setTestOnReturn(this.testOnReturn);
        JedisPool pool = null;
        pool = this.pwd != null && !this.pwd.isEmpty() ? new JedisPool((GenericObjectPoolConfig)config, this.host, this.port, this.timeout, this.pwd) : new JedisPool((GenericObjectPoolConfig)config, this.host, this.port, this.timeout);
        this.helper = new ERPRedisHelper(pool, 0, this.prefix);
        this.helper.setExpireTime(this.expireTime);
    }
}

