/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.group.meta;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.mid.connection.MdbDSNItems;
import com.bokesoft.yes.mid.mysqls.group.Group;
import com.bokesoft.yes.mid.mysqls.group.HeadDetailTable;
import com.bokesoft.yes.mid.mysqls.group.OneOrMultiValue;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class TableGroupProp {
    private final String tableName;
    private Group group;
    private TableGroupType fixedType;
    private Map<String, TableGroupType> variableTypes;
    private HeadDetailTable headTableForDetailTableExtra;
    private TableGroupProp groupDetailTable;
    private String headTableName;
    private List<HeadDetailTable> detailTables;
    private OneOrMultiValue<TableGroupProp> parentTables = new OneOrMultiValue();
    private String[] preCommitHeadTableNames;
    private boolean bHasExtraChild = false;

    public TableGroupProp(String tableName) {
        this.tableName = tableName;
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        if (this.group != null && this.group != group) {
            throw new RuntimeException("\u8868" + this.tableName + "\u5b58\u5728\u4e24\u4e2a\u5206\u7ec4" + this.group.getKey() + "," + group.getKey() + "\uff0c\u8bf7\u4fee\u6b63\u3002");
        }
        this.group = group;
    }

    public TableGroupType getFixedType() {
        return this.fixedType;
    }

    public TableGroupType getType(String mainTableKey) {
        return this.fixedType != null ? this.fixedType : this.variableTypes.get(mainTableKey);
    }

    public void setType(String headTableName, TableGroupType type) {
        if (type.isFixedType()) {
            if (this.variableTypes != null) {
                throw new RuntimeException("\u8868" + this.tableName + "\u5b58\u5728\u53ef\u53d8\u7c7b\u578b" + this.variableTypes.values() + "\u548c\u56fa\u5b9a\u7c7b\u578b" + type + "\uff0c\u8bf7\u4fee\u6b63\u3002");
            }
            if (this.fixedType != null && this.fixedType != type) {
                throw new RuntimeException("\u8868" + this.tableName + "\u5b58\u5728\u4e24\u79cd\u7c7b\u578b" + this.fixedType + "\u548c" + type + "\uff0c\u8bf7\u4fee\u6b63\u3002");
            }
            this.fixedType = type;
        } else {
            TableGroupType tmp;
            if (this.fixedType != null) {
                throw new RuntimeException("\u8868" + this.tableName + "\u5b58\u5728\u56fa\u5b9a\u7c7b\u578b" + this.fixedType + "\u548c\u53ef\u53d8\u7c7b\u578b" + type + "\uff0c\u8bf7\u4fee\u6b63\u3002");
            }
            if (this.variableTypes == null) {
                this.variableTypes = new HashMapIgnoreCase();
            }
            if ((tmp = this.variableTypes.get(headTableName)) != null && tmp != type) {
                throw new RuntimeException("\u8868" + this.tableName + "\u9488\u5bf9\u4e3b\u8868" + headTableName + "\u5b58\u5728\u4e24\u79cd\u53ef\u53d8\u7c7b\u578b" + tmp + "\u548c\u53ef\u53d8\u7c7b\u578b" + type + "\uff0c\u8bf7\u4fee\u6b63\u3002");
            }
            this.variableTypes.put(headTableName, type);
        }
    }

    public Map<String, TableGroupType> getVariableTypes() {
        return this.variableTypes;
    }

    public TableGroupType getVariableType(String headTableName) {
        return this.variableTypes.get(headTableName);
    }

    public void setFixedType(TableGroupType type) {
        if (!type.isFixedType()) {
            throw new RuntimeException(type + "\u4e0d\u662f\u56fa\u5b9a\u7c7b\u578b\uff0c\u8bf7\u4fee\u6b63\u3002");
        }
        this.setType(null, type);
    }

    public void setHeadTableForDetailTableExtra(HeadDetailTable headTable) {
        if (this.fixedType != TableGroupType.DetailTableExtra) {
            throw new RuntimeException("ERROR");
        }
        if (this.headTableForDetailTableExtra != null) {
            throw new RuntimeException("\u5206\u5e93\u5206\u8868\uff0c\u6269\u5c55\u660e\u7ec6\u8868\u53ea\u652f\u6301\u6302\u5728\u4e00\u5f20\u4e3b\u8868\u4e0a\uff0c\u800c" + headTable + "\u5b9a\u4e49\u9519\u8bef\u3002");
        }
        this.headTableForDetailTableExtra = headTable;
    }

    public HeadDetailTable getHeadTableForDetailTableExtra() {
        return this.headTableForDetailTableExtra;
    }

    public List<HeadDetailTable> getDetailTables() {
        return this.detailTables;
    }

    public void addDetailTable(HeadDetailTable headDetailTable) {
        if (this.detailTables == null) {
            this.detailTables = new ArrayList<HeadDetailTable>();
        }
        if (!this.detailTables.contains(headDetailTable)) {
            this.detailTables.add(headDetailTable);
        }
        if (this.getFixedType() == TableGroupType.DetailTableExtra) {
            this.bHasExtraChild = true;
        }
    }

    public void setGroupDetailTable(TableGroupProp tableGroupProp) {
        if (this.fixedType != TableGroupType.HeadTableInGroupByDetailTable) {
            throw new RuntimeException("ERROR");
        }
        this.groupDetailTable = tableGroupProp;
    }

    public TableGroupProp getGroupDetailTable() {
        return this.groupDetailTable;
    }

    public void addParentTable(TableGroupProp parentTable) {
        this.parentTables.addValue(parentTable);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getOneDSNName(String tableName) throws Throwable {
        if (this.group != null) {
            return this.group.getOneDSNName(tableName);
        }
        throw new RuntimeException("\u5206\u5e93\u5206\u8868\uff0c\u8868" + tableName + "\u672a\u53d6\u5230\u6570\u636e\u5e93\u3002");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append(this.tableName).append(":");
        if (this.group != null) {
            sb.append("Group:").append(this.group.getKey()).append(";");
        }
        if (this.fixedType != null) {
            sb.append("FixedType:").append(this.fixedType);
        }
        if (this.variableTypes != null) {
            sb.append("VariableTypes:").append(this.variableTypes);
        }
        if (this.headTableForDetailTableExtra != null) {
            sb.append("headTableForDetailTableExtra:").append(this.headTableForDetailTableExtra);
        }
        if (this.groupDetailTable != null) {
            sb.append("groupDetailTable:").append(this.groupDetailTable);
        }
        return sb.toString();
    }

    public void setHeadTableName(String headTableName) {
        this.headTableName = headTableName;
    }

    public String getHeadTableName() {
        return this.headTableName;
    }

    public String[] getPreSubmitHeadTableNames() {
        if (this.preCommitHeadTableNames == null) {
            if (MdbDSNItems.instance.isEmpty()) {
                return ArrayUtils.EMPTY_STRING_ARRAY;
            }
            if (this.fixedType == TableGroupType.DetailTableInGroupByDetailTable) {
                this.preCommitHeadTableNames = new String[]{this.headTableName};
            } else if (this.fixedType == TableGroupType.DetailTableExtra) {
                this.preCommitHeadTableNames = new String[]{this.headTableForDetailTableExtra.headTableName};
            } else if (this.variableTypes != null) {
                ArrayList<String> preCommitHeadTableNameList = new ArrayList<String>();
                for (Map.Entry<String, TableGroupType> entry : this.variableTypes.entrySet()) {
                    TableGroupType tableGroupType = entry.getValue();
                    if (tableGroupType != TableGroupType.DetailTableInGroupByHeadTable && tableGroupType != TableGroupType.OtherDetailTableInGroupByDetailTable) continue;
                    preCommitHeadTableNameList.add(entry.getKey());
                }
                this.preCommitHeadTableNames = preCommitHeadTableNameList.toArray(new String[preCommitHeadTableNameList.size()]);
            } else {
                this.preCommitHeadTableNames = ArrayUtils.EMPTY_STRING_ARRAY;
            }
        }
        return this.preCommitHeadTableNames;
    }

    public boolean hasExtraChild() {
        return this.bHasExtraChild;
    }
}

