/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.group;

import com.bokesoft.yes.mid.mysqls.group.IntGroupField;
import com.bokesoft.yes.mid.mysqls.route.meta.type.EGroupFieldType;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;

public class YearMonthGroupField
extends IntGroupField {
    public YearMonthGroupField(String key) {
        super(key);
    }

    @Override
    public EGroupFieldType getGroupType() {
        return EGroupFieldType.PERIOD;
    }

    @Override
    public int[] getValues(int start, int end) {
        if (this.defaultValues != null && end - start > this.defaultValues[this.defaultValues.length - 1] - this.defaultValues[0]) {
            if (start < this.defaultValues[0]) {
                start = Integer.min(this.defaultValues[0], end);
            }
            if (end > this.defaultValues[this.defaultValues.length - 1]) {
                end = Integer.max(this.defaultValues[this.defaultValues.length - 1], start);
            }
        }
        int current = start;
        int currentYear = start / 1000;
        int currentMonth = start % 100;
        int endYear = end / 1000;
        int endMonth = end % 100;
        int estimateCount = (endYear - currentYear) * 17 + (endMonth - currentMonth) + 1;
        ArrayList<Integer> periodList = new ArrayList<Integer>(estimateCount);
        while (current <= end) {
            periodList.add(current);
            if (currentMonth < 17) {
                current = currentYear * 1000 + currentMonth;
                ++currentMonth;
                continue;
            }
            currentMonth = 0;
            current = ++currentYear * 1000 + currentMonth;
        }
        return ArrayUtils.toPrimitive((Integer[])periodList.toArray(new Integer[periodList.size()]));
    }
}

