/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.dsntablename;

import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.mysqls.dsntablename.DeleteDSNTableNameCalc;
import com.bokesoft.yes.mid.mysqls.group.Group;
import com.bokesoft.yes.mid.mysqls.group.GroupField;
import com.bokesoft.yes.mid.mysqls.group.GroupTable;
import com.bokesoft.yes.mid.mysqls.group.OneGroupValue;
import com.bokesoft.yes.mid.mysqls.group.OneOrMultiValue;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProp;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupType;
import com.bokesoft.yes.mid.mysqls.oidpool.DSNTableName;
import com.bokesoft.yes.mid.mysqls.oidpool.OIDPool;
import com.bokesoft.yes.mid.mysqls.route.service.ShardingRouteService;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.UpdateSqlInfo;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.util.List;

public class UpdateDSNTableNameCalc {
    public static OneOrMultiValue<DSNTableName> calcDSNTableName(TableGroupProp tableGroupProp, UpdateSqlInfo sqlInfo, Parameters parameters, OIDPool oidPool, MultiDBManager dbm) throws Throwable {
        String tableName = tableGroupProp.getTableName();
        TableGroupType type = tableGroupProp.getFixedType();
        OneOrMultiValue<DSNTableName> result = null;
        if (type == TableGroupType.HeadTableInGroupByHeadTable) {
            result = UpdateDSNTableNameCalc.getDSNFromOIDPoolByColumn(sqlInfo, parameters, oidPool, tableName, "OID", tableGroupProp, dbm);
            if (result == null) {
                result = UpdateDSNTableNameCalc.getDSNFromOIDPoolByColumn(sqlInfo, parameters, oidPool, tableName, "SOID", tableGroupProp, dbm);
            }
            if (result == null) {
                String[] allDSNNames;
                result = new OneOrMultiValue();
                String[] stringArray = allDSNNames = ShardingRouteService.getAllDSNNames(tableGroupProp.getGroup(), (SqlInfo)sqlInfo, false);
                int n = allDSNNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String dsnName = stringArray[n2];
                    DSNTableName dsnTableName = new DSNTableName(dsnName);
                    result.addValue(dsnTableName);
                    ++n2;
                }
                return result;
            }
        } else {
            result = type == TableGroupType.DetailTableInGroupByDetailTable ? UpdateDSNTableNameCalc.genDSNDetailTableInGroupByDetailTable(sqlInfo, parameters, oidPool, tableName, tableGroupProp, dbm) : (type == TableGroupType.SimpleTable ? tableGroupProp.getGroup().getDSNName(tableName, sqlInfo, parameters, dbm) : (type == TableGroupType.DataObjectRelationTable ? DeleteDSNTableNameCalc.calcDSNTableName(tableGroupProp, sqlInfo, parameters, oidPool, (IDBManager)dbm) : DeleteDSNTableNameCalc.calcDSNTableName(tableGroupProp, sqlInfo, parameters, oidPool, (IDBManager)dbm)));
        }
        return result;
    }

    private static OneOrMultiValue<DSNTableName> getDSNFromOIDPoolByColumn(SqlInfo sqlInfo, Parameters parameters, OIDPool oidPool, String tableName, String columnNameRefHeadOID, TableGroupProp tableGroupPropForDBCheck, IDBManager dbm) throws Throwable {
        if (sqlInfo.hasGroupOriginalValue(columnNameRefHeadOID)) {
            OneOrMultiValue<Long> oids = sqlInfo.getPrimaryKeyLongOriginalValue(columnNameRefHeadOID, parameters);
            OneOrMultiValue<DSNTableName> result = new OneOrMultiValue<DSNTableName>();
            Group group = tableGroupPropForDBCheck.getGroup();
            boolean dsnNameGroupFieldUpdate = UpdateDSNTableNameCalc.isDSNNameGroupUpdate(group, sqlInfo);
            for (Long oid : oids) {
                DSNTableName curDsnTableName = oidPool.getDSNTableName(oid, tableGroupPropForDBCheck);
                DSNTableName dsnTableName = new DSNTableName(curDsnTableName.getNewDSNNames() != null ? curDsnTableName.getNewDSNNames() : curDsnTableName.getDsnNames());
                if (dsnNameGroupFieldUpdate) {
                    OneGroupValue newGroupValue = UpdateDSNTableNameCalc.getDSNNameOneGroupValue(dbm, group, sqlInfo, parameters, oid);
                    String newDSNName = group.getDSNName(tableName, newGroupValue);
                    dsnTableName.setNewDSNName(newDSNName);
                }
                result.addValue(dsnTableName);
            }
            return result;
        }
        return null;
    }

    private static OneOrMultiValue<DSNTableName> genDSNDetailTableInGroupByDetailTable(SqlInfo sqlInfo, Parameters parameters, OIDPool oidPool, String tableName, TableGroupProp tableGroupProp, MultiDBManager dbm) throws Throwable {
        Object soidTmp;
        String orgDsnName = null;
        Long oid = null;
        if (sqlInfo.hasGroupOriginalValue("OID") && sqlInfo.getPrimaryKeyLongOriginalValue("OID", parameters).isSingleValue() && (soidTmp = dbm.getOrgValueFromCacheTableByOID(tableName, oid = sqlInfo.getPrimaryKeyLongOriginalValue("OID", parameters).getSingleValue(), "SOID")) != null) {
            TableGroupProp headTableGropuProp;
            DSNTableName headDsnTableName;
            Group group = tableGroupProp.getGroup();
            OneGroupValue groupOrgValue = DeleteDSNTableNameCalc.getOneGroupOrgValue(oid, dbm, group, tableName);
            orgDsnName = group.getDSNName(tableName, groupOrgValue);
            if (Performance.RUN_IN_DEBUG && ((headDsnTableName = oidPool.getDSNTableName((Long)soidTmp, headTableGropuProp = tableGroupProp.getHeadTableName() != null ? TableGroupProps.getInstance().getTableGroupProp(tableGroupProp.getHeadTableName()) : tableGroupProp)).isSingleDsnName() ? !orgDsnName.equals(headDsnTableName.getSingleDSNName()) : !headDsnTableName.getDsnNames().asList().contains(orgDsnName))) {
                if (headTableGropuProp.getFixedType() == TableGroupType.HeadTableInGroupByDetailTable && dbm.getMoveHeadDataAfterGroupDetailChangeDSN() != null) {
                    DSNTableName movingDsnTableName = dbm.getMoveHeadDataAfterGroupDetailChangeDSN().calcDSNTableName(headTableGropuProp.getTableName(), (Long)soidTmp);
                    if (movingDsnTableName == null || (movingDsnTableName.isSingleDsnName() ? !orgDsnName.equals(movingDsnTableName.getSingleDSNName()) : !movingDsnTableName.getDsnNames().asList().contains(orgDsnName))) {
                        throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u66f4\u65b0\u8868" + tableName + "\u8ba1\u7b97DSN\uff0c\u591a\u79cd\u65b9\u6cd5\u8ba1\u7b97\u7ed3\u679c\u4e0d\u4e00\u81f4\u3002");
                    }
                } else {
                    throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u66f4\u65b0\u8868" + tableName + "\u8ba1\u7b97DSN\uff0c\u4e24\u79cd\u65b9\u6cd5\u8ba1\u7b97\u7ed3\u679c\u4e0d\u4e00\u81f4\u3002");
                }
            }
        }
        Group group = tableGroupProp.getGroup();
        boolean dsnNameGroupFieldUpdate = UpdateDSNTableNameCalc.isDSNNameGroupUpdate(group, sqlInfo);
        if (orgDsnName == null) {
            String[] allDSNNames;
            if (dsnNameGroupFieldUpdate) {
                throw new RuntimeException("SQL\u4e0d\u652f\u6301\u5206\u5e93\uff0c\u4e0d\u5f97\u6279\u91cf\u66f4\u65b0\u5206\u5e93\u5173\u8054\u5b57\u6bb5\u503c\uff0c\u8bf7\u4fee\u6539\u3002\n" + sqlInfo.getSql());
            }
            OneOrMultiValue<DSNTableName> result = new OneOrMultiValue<DSNTableName>();
            String[] stringArray = allDSNNames = ShardingRouteService.getAllDSNNames(tableGroupProp.getGroup(), sqlInfo, true);
            int n = allDSNNames.length;
            int movingDsnTableName = 0;
            while (movingDsnTableName < n) {
                String dsnNameTmp = stringArray[movingDsnTableName];
                DSNTableName dsnTableName = new DSNTableName(dsnNameTmp);
                result.addValue(dsnTableName);
                ++movingDsnTableName;
            }
            return result;
        }
        DSNTableName dsnTableName = new DSNTableName(orgDsnName);
        OneOrMultiValue<DSNTableName> result = new OneOrMultiValue<DSNTableName>();
        if (dsnNameGroupFieldUpdate) {
            OneGroupValue newGroupValue = UpdateDSNTableNameCalc.getDSNNameOneGroupValue(dbm, group, sqlInfo, parameters, oid);
            String newDSNName = group.getDSNName(tableName, newGroupValue);
            dsnTableName.setNewDSNName(newDSNName);
        }
        result.addValue(dsnTableName);
        return result;
    }

    private static boolean isDSNNameGroupUpdate(Group group, SqlInfo sqlInfo) throws Throwable {
        String tableName = sqlInfo.getTableName();
        GroupTable groupTable = group.getGroupTable(tableName);
        if (groupTable != null) {
            String[] stringArray = groupTable.getGroupColumnNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String groupColumn = stringArray[n2];
                if (groupColumn != null && sqlInfo.hasGroupNewValue(groupColumn)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static OneGroupValue getDSNNameOneGroupValue(IDBManager dbManager, Group group, SqlInfo sqlInfo, Parameters parameters, Long oid) throws Throwable {
        OneGroupValue result = new OneGroupValue();
        List<GroupField> groupFields = group.getGroupFields();
        String tableName = sqlInfo.getTableName();
        for (GroupField groupField : groupFields) {
            Object value;
            String columnName = group.getColumnNameInTable(groupField, tableName);
            if (columnName == null) {
                value = group.getGroupFieldValueByRelationTables(tableName, groupField, result);
            } else {
                value = group.getGroupFieldValue(tableName, groupField, result, sqlInfo, parameters);
                if (value == null && groupField.getKey().equalsIgnoreCase("SOID")) {
                    value = parameters.getHeadOID("SOID");
                }
                if (value == null) {
                    value = dbManager.getCacheDBRequest().getValueFromCacheTableByOID(tableName, oid, columnName);
                }
                if (value == null) {
                    throw new RuntimeException("\u5206\u5e93\u9519\u8bef\uff0c\u8868" + tableName + "\u53d6\u4e0d\u5230\u5206\u7ec4\u5b57\u6bb5" + columnName + "\u7684\u503c\u3002" + sqlInfo.getSql());
                }
            }
            result.setGroupValue(groupField.getKey(), value);
        }
        return result;
    }
}

