/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.dsntablename;

import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.connection.MdbDSNItems;
import com.bokesoft.yes.mid.connection.MultiDBDSNItem;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.mysqls.group.DataObjectRelationTable;
import com.bokesoft.yes.mid.mysqls.group.Group;
import com.bokesoft.yes.mid.mysqls.group.GroupConfig;
import com.bokesoft.yes.mid.mysqls.group.GroupField;
import com.bokesoft.yes.mid.mysqls.group.GroupTable;
import com.bokesoft.yes.mid.mysqls.group.HeadDetailTable;
import com.bokesoft.yes.mid.mysqls.group.OneGroupValue;
import com.bokesoft.yes.mid.mysqls.group.OneOrMultiValue;
import com.bokesoft.yes.mid.mysqls.group.RefDataObject;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProp;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupType;
import com.bokesoft.yes.mid.mysqls.oidpool.DSNTableName;
import com.bokesoft.yes.mid.mysqls.oidpool.OIDPool;
import com.bokesoft.yes.mid.mysqls.route.service.ShardingRouteService;
import com.bokesoft.yes.mid.mysqls.sql.DeleteSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfo;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeleteDSNTableNameCalc {
    public static OneOrMultiValue<DSNTableName> calcDSNTableName(TableGroupProp tableGroupProp, DeleteSqlInfo sqlInfo, Parameters parameters, OIDPool oidPool, IDBManager dbm) throws Throwable {
        return DeleteDSNTableNameCalc.calcDSNTableName(tableGroupProp, (SqlInfo)sqlInfo, parameters, oidPool, dbm);
    }

    public static OneOrMultiValue<DSNTableName> calcDSNTableName(TableGroupProp tableGroupProp, SqlInfo sqlInfo, Parameters parameters, OIDPool oidPool, IDBManager dbm) throws Throwable {
        OneOrMultiValue<DSNTableName> result;
        block15: {
            TableGroupType type;
            String tableName;
            block17: {
                block16: {
                    block14: {
                        tableName = tableGroupProp.getTableName();
                        type = tableGroupProp.getFixedType();
                        result = null;
                        if (type != TableGroupType.HeadTableInGroupByHeadTable) break block14;
                        result = DeleteDSNTableNameCalc.getDSNFromOIDPoolByColumn(sqlInfo, parameters, oidPool, tableName, "OID", tableGroupProp);
                        if (result == null || result.isEmpty()) {
                            result = DeleteDSNTableNameCalc.getDSNFromOIDPoolByColumn(sqlInfo, parameters, oidPool, tableName, "SOID", tableGroupProp);
                        }
                        if (result != null && !result.isEmpty()) break block15;
                        result = tableGroupProp.getGroup().getDSNName(tableName, sqlInfo, parameters, dbm);
                        break block15;
                    }
                    if (type != TableGroupType.DetailTableExtra) break block16;
                    HeadDetailTable headTableForDetailTableExtra = tableGroupProp.getHeadTableForDetailTableExtra();
                    TableGroupProp headGroupProp = TableGroupProps.getInstance().getTableGroupProp(headTableForDetailTableExtra.headTableName);
                    result = DeleteDSNTableNameCalc.getDSNFromOIDPoolByColumn(sqlInfo, parameters, oidPool, tableName, headTableForDetailTableExtra.columnNameRefHeadOID, headGroupProp);
                    if (result != null && !result.isEmpty()) break block15;
                    DSNTableName dsnTableName = ShardingRouteService.getAllDSNInGroup(tableName, headGroupProp.getGroup(), sqlInfo);
                    result = new OneOrMultiValue<DSNTableName>(dsnTableName);
                    break block15;
                }
                if (type != TableGroupType.DetailTableInGroupByDetailTable) break block17;
                TableGroupProp checkTableGroupProp = tableGroupProp.getHeadTableName() != null ? TableGroupProps.getInstance().getTableGroupProp(tableGroupProp.getHeadTableName()) : tableGroupProp;
                result = DeleteDSNTableNameCalc.getDSNFromOIDPoolByColumn(sqlInfo, parameters, oidPool, tableName, "SOID", checkTableGroupProp);
                if (result != null && !result.isEmpty()) break block15;
                result = tableGroupProp.getGroup().getDSNName(tableName, sqlInfo, parameters, dbm);
                break block15;
            }
            if (type == TableGroupType.HeadTableInGroupByDetailTable) {
                result = DeleteDSNTableNameCalc.getDSNFromOIDPoolByColumn(sqlInfo, parameters, oidPool, tableName, "OID", tableGroupProp);
                if (result == null || result.isEmpty()) {
                    result = DeleteDSNTableNameCalc.getDSNFromOIDPoolByColumn(sqlInfo, parameters, oidPool, tableName, "SOID", tableGroupProp);
                }
                if (result == null || result.isEmpty()) {
                    TableGroupProp headGroupProp = tableGroupProp.getGroupDetailTable();
                    DSNTableName dsnTableName = ShardingRouteService.getAllDSNInGroup(tableName, headGroupProp.getGroup(), sqlInfo);
                    result = new OneOrMultiValue<DSNTableName>(dsnTableName);
                }
                for (DSNTableName tmp : result) {
                    tmp.setIsDataMayRepeat();
                }
            } else if (type == TableGroupType.SimpleTable) {
                result = tableGroupProp.getGroup().getDSNName(tableName, sqlInfo, parameters, dbm);
            } else if (type == TableGroupType.DataObjectRelationTable) {
                result = DeleteDSNTableNameCalc.calcDSNTableNameDataObjectRelationTable(sqlInfo, parameters, tableName, oidPool, dbm);
            } else {
                result = DeleteDSNTableNameCalc.calcDSNTableNameBySOIDs(sqlInfo, parameters, oidPool, tableGroupProp, dbm);
                if (result == null || result.isEmpty()) {
                    result = DeleteDSNTableNameCalc.calcDSNTableNameByPOIDs(sqlInfo, parameters, oidPool, tableGroupProp, dbm);
                }
                if (result == null || result.isEmpty()) {
                    DSNTableName dsnTableName = DeleteDSNTableNameCalc.getAllDSNByTableName(tableGroupProp, sqlInfo);
                    result = new OneOrMultiValue<DSNTableName>(dsnTableName);
                }
                if (type == TableGroupType.OtherDetailTableInGroupByDetailTable || tableGroupProp.getVariableTypes() != null && tableGroupProp.getVariableTypes().containsValue(TableGroupType.OtherDetailTableInGroupByDetailTable)) {
                    for (DSNTableName tmp : result) {
                        tmp.setIsDataMayRepeat();
                    }
                }
            }
        }
        return result;
    }

    private static OneOrMultiValue<DSNTableName> getDSNFromOIDPoolByColumn(SqlInfo sqlInfo, Parameters parameters, OIDPool oidPool, String tableName, String columnNameRefHeadOID, TableGroupProp tableGroupPropForDBCheck) throws Throwable {
        if (sqlInfo.hasGroupOriginalValue(columnNameRefHeadOID)) {
            OneOrMultiValue<Long> oids = sqlInfo.getPrimaryKeyLongOriginalValue(columnNameRefHeadOID, parameters);
            OneOrMultiValue<DSNTableName> result = new OneOrMultiValue<DSNTableName>();
            DSNTableName dsnTableName = new DSNTableName();
            for (Long oid : oids) {
                DSNTableName tempDsnTableName = oidPool.getDSNTableName(oid, tableGroupPropForDBCheck);
                if (tempDsnTableName == null || tempDsnTableName.isDsnNameEmpty()) continue;
                dsnTableName.addDSNNames(tempDsnTableName.getNewDSNNames() != null ? tempDsnTableName.getNewDSNNames() : tempDsnTableName.getDsnNames());
            }
            if (!dsnTableName.isDsnNameEmpty()) {
                result.addValue(dsnTableName);
            }
            return result;
        }
        return null;
    }

    private static DSNTableName getAllDSNByTableName(TableGroupProp tableGroupProp, SqlInfo sqlInfo) {
        String tableName = tableGroupProp.getTableName();
        Object[] actions = new Object[]{"\u53d6\u8868", tableName, "\u7684\u6240\u6709\u6570\u636e\u6e90\uff01"};
        Performance.endActive((int)Performance.startAction((Object[])actions), (Object[])actions);
        DSNTableName result = new DSNTableName();
        for (Map.Entry<String, TableGroupType> entry : tableGroupProp.getVariableTypes().entrySet()) {
            String dsnName;
            int n;
            int n2;
            String[] stringArray;
            TableGroupProp headTableGroupProp;
            String headTableName = entry.getKey();
            TableGroupType type = entry.getValue();
            if (type == TableGroupType.NotGroup) {
                result.addDSNName(CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName());
                continue;
            }
            if (type == TableGroupType.DetailTableInGroupByHeadTable) {
                headTableGroupProp = TableGroupProps.getInstance().getTableGroupProp(headTableName);
                stringArray = ShardingRouteService.getAllDSNNames(headTableGroupProp.getGroup(), sqlInfo, false);
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    dsnName = stringArray[n];
                    result.addDSNName(dsnName);
                    ++n;
                }
                continue;
            }
            if (type == TableGroupType.SonDetailTableInGroupByDetailTable) {
                headTableGroupProp = TableGroupProps.getInstance().getTableGroupProp(headTableName);
                stringArray = ShardingRouteService.getAllDSNNames(headTableGroupProp.getGroupDetailTable().getGroup(), sqlInfo, false);
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    dsnName = stringArray[n];
                    result.addDSNName(dsnName);
                    ++n;
                }
                continue;
            }
            if (type != TableGroupType.OtherDetailTableInGroupByDetailTable) continue;
            headTableGroupProp = TableGroupProps.getInstance().getTableGroupProp(headTableName);
            stringArray = ShardingRouteService.getAllDSNNames(headTableGroupProp.getGroupDetailTable().getGroup(), sqlInfo, false);
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                dsnName = stringArray[n];
                result.addDSNName(dsnName);
                ++n;
            }
        }
        return result;
    }

    private static OneOrMultiValue<DSNTableName> calcDSNTableNameBySOIDs(SqlInfo sqlInfo, Parameters parameters, OIDPool oidPool, TableGroupProp tableGroupProp, IDBManager dbm) throws Throwable {
        OneOrMultiValue<Long> tmp = null;
        if (sqlInfo.hasGroupOriginalValue("SOID")) {
            tmp = sqlInfo.getPrimaryKeyLongOriginalValue("SOID", parameters);
        } else if (sqlInfo.hasGroupNewValue("SOID")) {
            tmp = new OneOrMultiValue<Long>(sqlInfo.getPrimaryKeyLongNewValue("SOID", parameters));
        } else if (sqlInfo.hasGroupOriginalValue("OID")) {
            Object tmpOIDs = sqlInfo.getPrimaryKeyOriginalValue("OID", parameters);
            String tableName = tableGroupProp.getTableName();
            if (tmpOIDs instanceof Long) {
                Object soid = dbm.getCacheDBRequest().getOrgValueFromCacheTableByOID(tableName, (Long)tmpOIDs, "OID");
                if (soid == null) {
                    return null;
                }
                tmp = new OneOrMultiValue<Long>((Long)soid);
            } else if (tmpOIDs instanceof Long[]) {
                tmp = new OneOrMultiValue();
                Long[] longArray = (Long[])tmpOIDs;
                int n = longArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Long oid = longArray[n2];
                    Object soid = dbm.getCacheDBRequest().getOrgValueFromCacheTableByOID(tableName, oid, "OID");
                    if (soid == null) {
                        return null;
                    }
                    tmp.addValue((Long)soid);
                    ++n2;
                }
            }
        }
        if (tmp == null) {
            return null;
        }
        List<Long> soids = tmp.asList();
        Map<String, List<Long>> headTableNameAndOIDs = DeleteDSNTableNameCalc.getHeadTableAndOIDs(soids, tableGroupProp, dbm);
        if (headTableNameAndOIDs == null) {
            return null;
        }
        OneOrMultiValue<DSNTableName> result = new OneOrMultiValue<DSNTableName>();
        for (Map.Entry<String, List<Long>> entry : headTableNameAndOIDs.entrySet()) {
            DSNTableName dsnTableName;
            TableGroupProp headTableGroupProp;
            String headTableName = entry.getKey();
            TableGroupType type = tableGroupProp.getVariableType(headTableName);
            if (type == TableGroupType.NotGroup) {
                result.addValue(new DSNTableName(CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName()));
                continue;
            }
            if (type == TableGroupType.DetailTableInGroupByHeadTable) {
                headTableGroupProp = TableGroupProps.getInstance().getTableGroupProp(headTableName);
                for (Long oid : entry.getValue()) {
                    dsnTableName = oidPool.getDSNTableName(oid, headTableGroupProp);
                    result.addValue(DSNTableName.getDSNTableNameNewValue(dsnTableName));
                }
                continue;
            }
            if (type == TableGroupType.SonDetailTableInGroupByDetailTable) {
                headTableGroupProp = TableGroupProps.getInstance().getTableGroupProp(headTableName);
                for (Long oid : entry.getValue()) {
                    dsnTableName = oidPool.getDSNTableName(oid, headTableGroupProp);
                    result.addValue(DSNTableName.getDSNTableNameNewValue(dsnTableName));
                }
                continue;
            }
            if (type != TableGroupType.OtherDetailTableInGroupByDetailTable) continue;
            headTableGroupProp = TableGroupProps.getInstance().getTableGroupProp(headTableName);
            for (Long oid : entry.getValue()) {
                dsnTableName = oidPool.getDSNTableName(oid, headTableGroupProp);
                result.addValue(DSNTableName.getDSNTableNameNewValue(dsnTableName));
            }
        }
        return result;
    }

    private static Map<String, List<Long>> getHeadTableAndOIDs(List<Long> oids, TableGroupProp tableGroupProp, IDBManager dbm) throws Throwable {
        HashMap<String, List<Long>> result = new HashMap<String, List<Long>>();
        Map<String, TableGroupType> types = tableGroupProp.getVariableTypes();
        int count = oids.size();
        boolean[] flags = new boolean[count];
        for (String headTableName : types.keySet()) {
            List<Long> tableOIDs = null;
            int i = 0;
            while (i < count) {
                Long oid = oids.get(i);
                if (!flags[i] && dbm.getCacheDBRequest().hasOIDInCacheTable(headTableName, oid)) {
                    tableOIDs = DeleteDSNTableNameCalc.putValue(tableOIDs, oid);
                    flags[i] = true;
                }
                ++i;
            }
            if (tableOIDs == null) continue;
            result.put(headTableName, tableOIDs);
        }
        int i = 0;
        while (i < count) {
            if (!flags[i]) {
                return null;
            }
            ++i;
        }
        return result;
    }

    private static List<Long> putValue(List<Long> list, Long oid) {
        if (list == null) {
            list = new ArrayList<Long>();
        }
        list.add(oid);
        return list;
    }

    private static OneOrMultiValue<DSNTableName> calcDSNTableNameByPOIDs(SqlInfo sqlInfo, Parameters parameters, OIDPool oidPool, TableGroupProp tableGroupProp, IDBManager dbm) throws Throwable {
        OneOrMultiValue<Long> tmp = null;
        if (sqlInfo.hasGroupOriginalValue("POID")) {
            tmp = sqlInfo.getPrimaryKeyLongOriginalValue("POID", parameters);
        } else if (sqlInfo.hasGroupNewValue("POID")) {
            tmp = new OneOrMultiValue<Long>(sqlInfo.getPrimaryKeyLongNewValue("POID", parameters));
        }
        if (tmp == null) {
            return null;
        }
        List<Long> poids = tmp.asList();
        Map<String, List<Long>> headTableNameAndOIDs = DeleteDSNTableNameCalc.getParentGroupTableAndOIDs(poids, tableGroupProp, dbm);
        if (headTableNameAndOIDs == null) {
            return null;
        }
        OneOrMultiValue<DSNTableName> result = new OneOrMultiValue<DSNTableName>();
        for (Map.Entry<String, List<Long>> entry : headTableNameAndOIDs.entrySet()) {
            String dsnName;
            OneGroupValue groupValue;
            Group group;
            TableGroupType type;
            String groupTableName = entry.getKey();
            TableGroupProp groupTableGroupProp = TableGroupProps.getInstance().getTableGroupProp(groupTableName);
            TableGroupType tableGroupType = type = groupTableGroupProp == null ? TableGroupType.NotGroup : groupTableGroupProp.getFixedType();
            if (type == TableGroupType.NotGroup) {
                result.addValue(new DSNTableName(CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName()));
                continue;
            }
            if (type == TableGroupType.HeadTableInGroupByHeadTable) {
                group = groupTableGroupProp.getGroup();
                for (Long oid : entry.getValue()) {
                    groupValue = DeleteDSNTableNameCalc.getOneGroupOrgValue(oid, dbm, groupTableGroupProp.getGroup(), groupTableName);
                    if (groupValue.isAllValueEmpty()) continue;
                    dsnName = group.getDSNName(groupTableName, groupValue);
                    result.addValue(new DSNTableName(dsnName));
                }
                continue;
            }
            if (type != TableGroupType.DetailTableInGroupByDetailTable) continue;
            group = groupTableGroupProp.getGroup();
            for (Long oid : entry.getValue()) {
                groupValue = DeleteDSNTableNameCalc.getOneGroupOrgValue(oid, dbm, groupTableGroupProp.getGroup(), groupTableName);
                if (groupValue.isAllValueEmpty()) continue;
                dsnName = group.getDSNName(groupTableName, groupValue);
                result.addValue(new DSNTableName(dsnName));
            }
        }
        return result;
    }

    public static OneGroupValue getOneGroupOrgValue(Long oid, IDBManager dbm, Group group, String groupTableName) throws Throwable {
        GroupTable groupTable = group.getDefTableNams().get(groupTableName);
        String[] columnNames = groupTable.getGroupColumnNames();
        List<GroupField> groupFields = group.getGroupFields();
        OneGroupValue result = new OneGroupValue();
        int i = 0;
        int size = groupFields.size();
        while (i < size) {
            Object value = null;
            value = columnNames[i] != null ? dbm.getCacheDBRequest().getOrgValueFromCacheTableByOID(groupTableName, oid, columnNames[i]) : group.getGroupFieldValueByRelationTables(groupTableName, groupFields.get(i), result);
            result.setGroupValue(groupFields.get(i).getKey(), value);
            ++i;
        }
        return result;
    }

    private static Map<String, List<Long>> getParentGroupTableAndOIDs(List<Long> poids, TableGroupProp tableGroupProp, IDBManager dbm) throws Throwable {
        HashMap<String, List<Long>> result = new HashMap<String, List<Long>>();
        String tableName = tableGroupProp.getTableName();
        List<MetaDataObject> dataObjects = DataObjects.getInstance().getDataObjectsByTableName(tableName);
        int count = poids.size();
        boolean[] flags = new boolean[count];
        for (MetaDataObject dataObject : dataObjects) {
            MetaTable metaTable = DataObjects.getMetaTableByTableNameIgnoreCase(dataObject, tableName);
            String parentTableKey = metaTable.getParentKey();
            if (parentTableKey.length() == 0 || parentTableKey.startsWith("$")) continue;
            List<Long> tableOIDs = null;
            int i = 0;
            while (i < count) {
                Long oid = poids.get(i);
                if (!flags[i] && dbm.getCacheDBRequest().hasOIDInCacheTable(parentTableKey, oid)) {
                    tableOIDs = DeleteDSNTableNameCalc.putValue(tableOIDs, oid);
                    flags[i] = true;
                }
                ++i;
            }
            if (tableOIDs != null) {
                TableGroupProp parentTableGroupProp = TableGroupProps.getInstance().getTableGroupProp(parentTableKey);
                if (parentTableGroupProp != null) {
                    TableGroupType parentType = parentTableGroupProp.getFixedType();
                    while (parentType != TableGroupType.HeadTableInGroupByHeadTable && parentType != TableGroupType.DetailTableInGroupByDetailTable) {
                        MetaTable parentMetaTable = DataObjects.getMetaTableByTableNameIgnoreCase(dataObject, parentTableKey);
                        String parentParentTableKey = parentMetaTable.getParentKey();
                        ArrayList<Long> parentPOIDOrSOIDs = new ArrayList<Long>();
                        if (parentParentTableKey.length() > 0) {
                            if (parentParentTableKey.startsWith("$")) break;
                            for (Long oid : tableOIDs) {
                                Long poid = (Long)dbm.getCacheDBRequest().getValueFromCacheTableByOID(parentTableKey, oid, "POID");
                                if (parentPOIDOrSOIDs.contains(poid)) continue;
                                parentPOIDOrSOIDs.add(poid);
                            }
                            parentTableKey = parentParentTableKey;
                        } else {
                            for (Long oid : tableOIDs) {
                                Long soid = (Long)dbm.getCacheDBRequest().getValueFromCacheTableByOID(parentTableKey, oid, "SOID");
                                if (parentPOIDOrSOIDs.contains(soid)) continue;
                                parentPOIDOrSOIDs.add(soid);
                            }
                            parentTableKey = dataObject.getMainTableNotNull().getKey();
                        }
                        tableOIDs = parentPOIDOrSOIDs;
                        parentTableGroupProp = TableGroupProps.getInstance().getTableGroupProp(parentTableKey);
                        parentType = parentTableGroupProp.getFixedType();
                    }
                }
                if (!parentTableKey.startsWith("$")) {
                    result.put(parentTableKey, tableOIDs);
                }
            }
            boolean foundAll = true;
            int i2 = 0;
            while (i2 < count) {
                if (!flags[i2]) {
                    foundAll = false;
                    break;
                }
                ++i2;
            }
            if (!foundAll) continue;
            return result;
        }
        return null;
    }

    private static OneOrMultiValue<DSNTableName> calcDSNTableNameDataObjectRelationTable(SqlInfo sqlInfo, Parameters parameters, String tableName, OIDPool oidPool, IDBManager dbm) throws Throwable {
        DataObjectRelationTable dataObjectRelationTable = GroupConfig.instance.getDataObjectRelationTable(tableName);
        DSNTableName dsnTableName = new DSNTableName();
        boolean hasSOIDField = false;
        for (RefDataObject refDataObject : dataObjectRelationTable.getRefDataObjects()) {
            String refSOIDColumnName = refDataObject.refSOIDColumnName;
            String refKeyColumnName = refDataObject.refKeyColumnName;
            if (!sqlInfo.hasGroupOriginalValue(refSOIDColumnName)) continue;
            Object tmp = sqlInfo.getPrimaryKeyOriginalValue(refSOIDColumnName, parameters);
            if (tmp.getClass().isArray()) {
                Object[] values;
                Object[] objectArray = values = (Object[])tmp;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    Object value = objectArray[n2];
                    hasSOIDField = DeleteDSNTableNameCalc.calcDSNTableNameDataObjectRelationTableBySOID(value, refDataObject, refSOIDColumnName, refKeyColumnName, parameters, sqlInfo, dsnTableName, oidPool, dbm);
                    ++n2;
                }
                continue;
            }
            hasSOIDField = DeleteDSNTableNameCalc.calcDSNTableNameDataObjectRelationTableBySOID(tmp, refDataObject, refSOIDColumnName, refKeyColumnName, parameters, sqlInfo, dsnTableName, oidPool, dbm);
        }
        if (!hasSOIDField) {
            Object[] actions = new Object[]{"\u53d6\u8868", tableName, "\u7684\u6240\u6709\u6570\u636e\u6e90\uff01"};
            Performance.endActive((int)Performance.startAction((Object[])actions), (Object[])actions);
            for (MultiDBDSNItem dsnItem : MdbDSNItems.instance) {
                dsnTableName.addDSNName(dsnItem.getName());
            }
            dsnTableName.setIsDataMayRepeat();
        }
        return new OneOrMultiValue<DSNTableName>(dsnTableName);
    }

    private static boolean calcDSNTableNameDataObjectRelationTableBySOID(Object value, RefDataObject refDataObject, String refSOIDColumnName, String refKeyColumnName, Parameters parameters, SqlInfo sqlInfo, DSNTableName dsnTableName, OIDPool oidPool, IDBManager dbm) throws Throwable {
        if (value != null && !(value instanceof Long)) {
            throw new RuntimeException("ERROR!");
        }
        Long soid = TypeConvertor.toLong((Object)value);
        if (soid <= 0L) {
            return false;
        }
        String[] dataObjectKeys = null;
        String refObjectKey = refDataObject.refKey;
        if (StringUtil.isBlankOrNull((String)refObjectKey)) {
            if (!sqlInfo.hasGroupOriginalValue(refKeyColumnName)) {
                return false;
            }
            dataObjectKeys = sqlInfo.getPrimaryKeyOriginalStringValues(refKeyColumnName, parameters);
        } else {
            dataObjectKeys = new String[]{refObjectKey};
        }
        if (dataObjectKeys.length == 0) {
            throw new RuntimeException("\u5206\u5e93\u9519\u8bef\uff0c\u6570\u636e\u5bf9\u8c61\u5173\u7cfb\u8868\u7684\u67e5\u8be2\u8bed\u53e5\u6709SOID\u503c\uff0c\u4f46\u6ca1\u6709\u6307\u5b9a\u6570\u636e\u5bf9\u8c61\u6807\u8bc6\u3002" + sqlInfo);
        }
        String[] stringArray = dataObjectKeys;
        int n = dataObjectKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String dataObjectKey = stringArray[n2];
            DeleteDSNTableNameCalc.calcDSNTableNameDataObjectRelationTable(oidPool, dsnTableName, dataObjectKey, soid, dbm);
            ++n2;
        }
        return true;
    }

    public static DSNTableName calcDSNTableNameDataObjectRelationTable(OIDPool oidPool, DSNTableName dsnTableName, String dataObjectKey, Long soid, IDBManager dbm) throws Throwable {
        TableGroupProp headTable = DeleteDSNTableNameCalc.getHeadTableGroupProp(dataObjectKey);
        if (headTable == null) {
            dsnTableName.addDSNName(CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName());
        } else {
            DSNTableName tmp = oidPool.getDSNTableName(soid, headTable);
            dsnTableName.addDSNNames(tmp.hasNewDSNName() ? tmp.getNewDSNNames() : tmp.getDsnNames());
        }
        return dsnTableName;
    }

    public static TableGroupProp getHeadTableGroupProp(String dataObjectKey) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaDataObject metaDataObject = metaFactory.getDataObject(dataObjectKey);
        String headTableName = metaDataObject.getMainTableKey() != null ? metaDataObject.getMainTableKey() : ((MetaTable)metaDataObject.getTableCollection().get(0)).getKey();
        return TableGroupProps.getInstance().getTableGroupProp(headTableName);
    }
}

