/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.dbstruct;

import com.bokesoft.yes.mid.mysqls.dbstruct.DBStruct;
import com.bokesoft.yes.mid.mysqls.dbstruct.SchemaCheck;
import com.bokesoft.yes.mid.mysqls.dbstruct.SchemaCreate;
import com.bokesoft.yigo.meta.schema.MetaIndex;
import com.bokesoft.yigo.meta.schema.MetaIndexCollection;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.util.Iterator;
import java.util.List;

public class SchemaProcess {
    public static final SchemaProcess instance = new SchemaProcess();

    private SchemaProcess() {
    }

    public void tableRebuild(IDBManager dbm, String dsnName, DBStruct dbStruct, MetaSchemaTable table) throws Throwable {
        boolean bReloadStruct = false;
        SchemaCreate creator = new SchemaCreate(table);
        if (dbStruct == null || !dbStruct.existTableName(dsnName, table.getKey())) {
            String sql = creator.createTable(dbm);
            dbm.execPrepareUpdate(sql, new Object[0]);
            bReloadStruct = true;
            MetaIndexCollection indexCollection = table.getIndexCollection();
            if (indexCollection != null) {
                Iterator iterator = indexCollection.iterator();
                MetaIndex index = null;
                while (iterator.hasNext()) {
                    index = (MetaIndex)iterator.next();
                    this.createIndex(dbm, dsnName, creator, table.getKey(), index);
                }
            }
        } else {
            List<MetaIndex> indexList;
            SchemaCheck checker = new SchemaCheck(table);
            List<MetaSchemaColumn> list = checker.checkTable(dsnName, dbStruct);
            if (list.size() != 0) {
                String alterSql = dbm.getAlterTableStr(table, list);
                dbm.execPrepareUpdate(alterSql, new Object[0]);
                bReloadStruct = true;
            }
            if ((indexList = checker.checkIndex(dsnName, dbStruct)).size() != 0) {
                for (MetaIndex d : indexList) {
                    this.createIndex(dbm, dsnName, creator, table.getKey(), d);
                }
                bReloadStruct = true;
            }
        }
        if (dbStruct != null) {
            dbStruct.changeTableStruct(dsnName, table.getKey());
            if (bReloadStruct) {
                dbStruct.reloadTableStruct(dsnName, table.getKey());
            }
        }
    }

    private void createIndex(IDBManager DBManager, String dsnName, SchemaCreate sc, String tableKey, MetaIndex index) throws Throwable {
        try {
            String sql = sc.createIndex(index, DBManager);
            DBManager.execPrepareUpdate(sql, new Object[0]);
        }
        catch (Throwable e) {
            String tableName = DBManager.searchIndex(index.getKey());
            if (tableName != null) {
                throw new MidCoreException(19, MidCoreException.formatMessage(null, (int)19, (Object[])new Object[]{tableKey, index.getKey(), tableName}));
            }
            throw e;
        }
    }
}

