/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.dbstruct;

import com.bokesoft.yes.mid.connection.dbmanager.MySqlClusterDBManager;
import com.bokesoft.yigo.meta.schema.MetaIndex;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.util.DBManagerUtil;

public class SchemaCreate {
    private String tableSql = "";
    private MetaSchemaTable table = null;

    public MetaSchemaTable getTable() {
        return this.table;
    }

    public void setTable(MetaSchemaTable table) {
        this.table = table;
    }

    public SchemaCreate(MetaSchemaTable table) {
        this.table = table;
    }

    public String createTable(IDBManager DBManager) throws Throwable {
        boolean addedPK = false;
        StringBuilder sql = new StringBuilder("create table ");
        sql.append(DBManager.keyWordEscape(this.table.getKey()));
        sql.append(" (");
        for (MetaSchemaColumn column : this.table.getColumnCollection()) {
            sql.append(DBManager.getColumnDef(column)).append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        for (MetaSchemaColumn column : this.table.getColumnCollection()) {
            if (!column.isPK()) continue;
            if (!addedPK) {
                addedPK = true;
                if (!DBManagerUtil.isMySQLLikeDatabase((int)DBManager.getDBType())) {
                    sql.append(",CONSTRAINT ");
                    sql.append(DBManager.keyWordEscape("PK_" + this.table.getPrimaryKey()));
                    sql.append(" PRIMARY KEY(");
                } else {
                    sql.append(", PRIMARY KEY(");
                }
            }
            sql.append(DBManager.keyWordEscape(column.getKey())).append(",");
        }
        if (addedPK) {
            sql.setCharAt(sql.length() - 1, ')');
        }
        sql.append(" )");
        if (DBManager.getDBType() == 4) {
            sql.append("ENGINE=INNODB");
        } else if (DBManager.getDBType() == 6) {
            sql.append("ENGINE=NDB");
        }
        this.tableSql = sql.toString();
        return this.tableSql;
    }

    public String createIndex(MetaIndex index, IDBManager DBManager) {
        String[] cols;
        StringBuilder sb = new StringBuilder("create ");
        sb.append(index.isUnique() != false ? "unique index " : "index ");
        sb.append(index.getKey());
        sb.append(" on ");
        sb.append(DBManager.keyWordEscape(this.table.getKey()));
        sb.append("(");
        String[] stringArray = cols = index.getColumns().split(",");
        int n = cols.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(DBManager.keyWordEscape(s));
            sb.append(",");
            ++n2;
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    public String createPartition(IDBManager DBManager) {
        if (DBManager.getDBType() == 6) {
            return MySqlClusterDBManager.getAlterPartitionSql((IDBManager)DBManager, (MetaSchemaTable)this.table);
        }
        throw new UnsupportedOperationException();
    }
}

