/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.migration.period;

import com.bokesoft.erp.mid.schema.ERPSchemaMaintance;
import com.bokesoft.erp.mid.schema.ERPSchemaProcess;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.meta.datamigration.calculate.MetaMigrationParas;
import com.bokesoft.yes.mid.connection.MdbDSNItems;
import com.bokesoft.yes.mid.connection.MultiDBDSNItem;
import com.bokesoft.yes.mid.connection.dbmanager.BatchPsPara;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.migration.AbstractRemigrateStrategy;
import com.bokesoft.yes.mid.migration.IReMigrateStrategy;
import com.bokesoft.yes.mid.migration.InsertFastMySQLStrategy;
import com.bokesoft.yes.mid.migration.InsertFastNormalStrategy;
import com.bokesoft.yes.mid.migration.InsertFastSqlServerStrategy;
import com.bokesoft.yes.mid.migration.groupkeys.RowData;
import com.bokesoft.yes.mid.migration.period.DataTableBatchPsPara;
import com.bokesoft.yes.mid.migration.period.MigrationStruct;
import com.bokesoft.yes.mid.migration.period.PeriodMigration;
import com.bokesoft.yes.mid.migration.period.ReMigrateScope;
import com.bokesoft.yes.mid.migration.process.KeysTableSaveData;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProp;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.document.MigrationMerge;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeysTableFocusChangeReMigrate {
    public void reMigrate(DefaultContext context, String objectKey, boolean rebuildDBStruct) throws Throwable {
        this.reMigrateInner(context, objectKey, null, rebuildDBStruct);
    }

    private void reMigrateInner(DefaultContext context, String objectKey, ReMigrateScope reMigrateScope, boolean rebuildDBStruct) throws Throwable {
        IDBManager dbManager = context.getDBManager();
        try (IDBManager dbManager4Lock = null;){
            dbManager4Lock = context.newDBManager();
            dbManager4Lock.setRowLockEnsureInSYSLock("ReMigration");
            dbManager.getCacheDBRequest().stopLocalIsUseCacheDB();
            MigrationStruct struct = MigrationStruct.get(objectKey);
            DataTable lastPointData = this.getLastPointValue(dbManager, struct, reMigrateScope);
            this.deleteOldData(dbManager, struct, rebuildDBStruct, reMigrateScope);
            this.insertSumFactData(context, struct, reMigrateScope);
            MigrationMerge migrationMerge = new MigrationMerge(objectKey, false);
            migrationMerge.merge(context);
            boolean isNeedRollData = KeysTableFocusChangeReMigrate.rollbackLPToPrevPeriod(reMigrateScope, lastPointData, struct, dbManager);
            if (reMigrateScope != null) {
                if (isNeedRollData) {
                    this.rollData(context, struct, lastPointData);
                }
            } else {
                this.rollData(context, struct, lastPointData);
            }
        }
    }

    private static boolean rollbackLPToPrevPeriod(ReMigrateScope reMigrateScope, DataTable lastPointData, MigrationStruct struct, IDBManager dbManager) throws Throwable {
        if (reMigrateScope != null && lastPointData != null && !lastPointData.isEmpty() && reMigrateScope.getFromPeriod() != -1) {
            String periodColumnName = struct.getMetaPeriodColumn().getBindingDBColumnName();
            int periodValue = lastPointData.getInt(0, periodColumnName);
            if (periodValue < reMigrateScope.getFromPeriod()) {
                return false;
            }
            String newTableName = struct.getNewTableName();
            SqlString getPrevPeriodSql = new SqlString();
            getPrevPeriodSql.append("select max(").append(periodColumnName).append(") prevPeriod from ").append(newTableName).append(" where ").append(reMigrateScope.getPeriodGroupWhereExpSql()).append(" and ").append(periodColumnName).append("<").appendPara(reMigrateScope.getFromPeriod());
            DataTable dataTable = dbManager.execPrepareQuery(getPrevPeriodSql.getSql(), getPrevPeriodSql.getParameterList());
            if (!dataTable.isEmpty() && dataTable.getInt(0, 0) > 0) {
                Integer prevPeriod = dataTable.getInt(0, 0);
                SqlString updateLPSql = new SqlString();
                updateLPSql = updateLPSql.append("update ").append(struct.getLastPointTableName()).append(" set ").append(periodColumnName).append("=").appendPara(prevPeriod).append(" where ").append(periodColumnName).append("=").appendPara(periodValue).append(" and ").append(reMigrateScope.getPeriodGroupWhereExpSql());
                dbManager.execPrepareUpdate(updateLPSql.getSql(), updateLPSql.getParameterList());
                dbManager.commit();
            } else {
                SqlString deleteLPSql = new SqlString();
                deleteLPSql = deleteLPSql.append("delete from ").append(struct.getLastPointTableName()).append(" where ").append(periodColumnName).append("=").appendPara(periodValue).append(" and ").append(reMigrateScope.getPeriodGroupWhereExpSql());
                dbManager.execPrepareUpdate(deleteLPSql.getSql(), deleteLPSql.getParameterList());
                dbManager.commit();
            }
        }
        return true;
    }

    public void reMigrate(DefaultContext context, String objectKey, Map<String, Object> periodGroupValueMap, int fromPeriod) throws Throwable {
        MigrationStruct struct = MigrationStruct.get(objectKey);
        List<MetaColumn> metaPeriodGroupColumns = struct.getMetaPeriodGroupColumns();
        if (struct.getMetaPeriodColumn() == null || metaPeriodGroupColumns == null) {
            throw new RuntimeException(String.valueOf(objectKey) + "\u4e0d\u652f\u6301\u7f29\u5c0f\u91cd\u65b0\u8fc1\u79fb\u8303\u56f4\uff0c\u8c22\u8c22\u3002");
        }
        ReMigrateScope reMigrateScope = new ReMigrateScope(periodGroupValueMap, fromPeriod);
        this.reMigrateInner(context, objectKey, reMigrateScope, false);
    }

    private DataTable getLastPointValue(IDBManager dbManager, MigrationStruct struct, ReMigrateScope reMigrateScope) throws Throwable {
        String lastPointTableName = struct.getLastPointTableName();
        if (lastPointTableName == null || !dbManager.checkTableExist(lastPointTableName)) {
            return null;
        }
        SqlString sql = new SqlString();
        sql.append("select ");
        for (MetaColumn metaColumn : struct.getMetaPeriodGroupColumns()) {
            sql.append(metaColumn.getBindingDBColumnName()).append(",");
        }
        sql.append(struct.getMetaPeriodColumn().getBindingDBColumnName());
        sql.append(" from ", struct.getLastPointTableName(), " where OID>").appendPara(0);
        if (reMigrateScope != null) {
            SqlString periodGroupCondPart = new SqlString();
            for (Map.Entry<String, Object> entry : reMigrateScope.getPeriodGroupValues().entrySet()) {
                if (!periodGroupCondPart.isEmpty()) {
                    sql.append(" and ");
                }
                periodGroupCondPart.append(entry.getKey(), "=").appendPara(entry.getValue());
            }
            sql.append(" and ").append(periodGroupCondPart);
        }
        DataTable result = dbManager.execPrepareQuery(sql.getSql(), sql.getParameterList());
        dbManager.commit();
        return result;
    }

    private void deleteOldData(IDBManager dbManager, MigrationStruct struct, boolean rebuildDBStruct, ReMigrateScope reMigrateScope) throws Throwable {
        TableGroupProp tableGroupProp;
        boolean isSplitDB = false;
        String groupKey = null;
        if (dbManager instanceof MultiDBManager && (tableGroupProp = TableGroupProps.getInstance().getTableGroupProp(struct.getNewTableName())) != null) {
            groupKey = tableGroupProp.getGroup().getKey();
            isSplitDB = true;
        }
        if (isSplitDB) {
            for (MultiDBDSNItem dsnItem : MdbDSNItems.instance) {
                if (!dsnItem.hasGroupKey(groupKey)) continue;
                String dsnName = dsnItem.getName();
                try (IDBManager subDBM = null;){
                    subDBM = MultiDBManager.createDBManager(dsnName);
                    this.deleteOldDataOneDB(subDBM, struct, rebuildDBStruct, reMigrateScope);
                }
                KeysTableSaveData.getCache(struct, dsnName).clear();
            }
        } else {
            this.deleteOldDataOneDB(dbManager, struct, rebuildDBStruct, reMigrateScope);
            KeysTableSaveData.getCache(struct, "").clear();
        }
    }

    private void deleteOldDataOneDB(IDBManager dbManager, MigrationStruct struct, boolean rebuildDBStruct, ReMigrateScope reMigrateScope) throws Throwable {
        if (rebuildDBStruct) {
            for (String viewName : struct.getViewNames()) {
                try {
                    dbManager.execUpdate("drop view " + viewName);
                }
                catch (SQLSyntaxErrorException e) {
                    LogSvr.getInstance().debug(viewName, (Throwable)e);
                }
            }
            for (MetaSchemaTable metaSchemaTable : struct.getMetaSchemaTables()) {
                try {
                    String sql = "drop table " + metaSchemaTable.getKey();
                    if (dbManager.getDBType() == 2) {
                        sql = String.valueOf(sql) + " purge";
                    }
                    dbManager.execUpdate(sql);
                }
                catch (SQLSyntaxErrorException e) {
                    LogSvr.getInstance().debug(metaSchemaTable.getKey(), (Throwable)e);
                }
            }
            ERPSchemaProcess schemaProcess = new ERPSchemaProcess(dbManager);
            for (MetaSchemaTable metaSchemaTable : struct.getMetaSchemaTables()) {
                schemaProcess.tableRebuild(dbManager, metaSchemaTable);
            }
            ERPSchemaMaintance.generateUnionIndex(dbManager, struct.metaDataObject, schemaProcess);
            for (Map.Entry entry : struct.getCreateViewSqls(dbManager).entrySet()) {
                dbManager.execUpdate((String)entry.getValue());
            }
        } else {
            for (MetaSchemaTable metaSchemaTable : struct.getMetaSchemaTables()) {
                SqlString deleteSql = new SqlString().append("delete from " + metaSchemaTable.getKey());
                if (reMigrateScope != null) {
                    MetaColumn metaPeriodColumn;
                    int fromPeriod = reMigrateScope.getFromPeriod();
                    if (metaSchemaTable.getKey().equals(struct.getLastPointTableName()) && fromPeriod != -1) continue;
                    deleteSql.append(" where ").append(reMigrateScope.getPeriodGroupWhereExpSql());
                    if (metaSchemaTable.getKey().equals(struct.getKeysTableName()) && fromPeriod != -1) {
                        deleteSql.append(" and OID not in (");
                        deleteSql.append(" select ", "GroupId", " from ", struct.getNewTableName(), " where ");
                        deleteSql.append(reMigrateScope.getPeriodGroupWhereExpSql());
                        metaPeriodColumn = struct.getMetaPeriodColumn();
                        deleteSql.append(" and ").append(metaPeriodColumn.getBindingDBColumnName()).append("<").appendPara(fromPeriod);
                        deleteSql.append(") ");
                    }
                    if ((metaPeriodColumn = struct.getMetaPeriodColumn()) != null && metaSchemaTable.getColumnCollection().get(metaPeriodColumn.getBindingDBColumnName()) != null && fromPeriod != -1) {
                        deleteSql.append(" and ").append(metaPeriodColumn.getBindingDBColumnName()).append(">=").appendPara(fromPeriod);
                    }
                }
                dbManager.execPrepareUpdate(deleteSql.getSql(), deleteSql.getParameterList());
            }
        }
        dbManager.commit();
    }

    private void insertSumFactData(DefaultContext context, MigrationStruct struct, ReMigrateScope reMigrateScope) throws Throwable {
        int i = 0;
        while (i < struct.getMetaDataMigrations().size()) {
            this.insertSumFactData(context, struct, struct.getMetaDataMigrations().get(i), i == 0, reMigrateScope);
            ++i;
        }
    }

    private void insertSumFactData(DefaultContext context, MigrationStruct struct, MetaDataMigration metaDataMigration, Boolean isFirst, ReMigrateScope reMigrateScope) throws Throwable {
        if (struct.getMetaPeriodColumn() != null) {
            SqlString distinctPeriodGroupAndPeriodValueSql = struct.getDistinctPeriodGroupAndPeriodValueSql(metaDataMigration, reMigrateScope);
            IDBManager dbManager = context.getDBManager();
            DataTable periodGroupAndPeriodValues = dbManager.execPrepareQuery(distinctPeriodGroupAndPeriodValueSql.getSql(), distinctPeriodGroupAndPeriodValueSql.getParameterList());
            if (periodGroupAndPeriodValues == null) {
                return;
            }
            int rowIndex = 0;
            int size = periodGroupAndPeriodValues.size();
            while (rowIndex < size) {
                int columnIndex = 0;
                ArrayList<Long> periodGroupValues = new ArrayList<Long>();
                int peroidGroupdSize = struct.getMetaPeriodGroupColumns().size();
                while (columnIndex < peroidGroupdSize) {
                    Long periodGroupValue = periodGroupAndPeriodValues.getLong(rowIndex, columnIndex);
                    periodGroupValues.add(periodGroupValue);
                    ++columnIndex;
                }
                int periodValue = periodGroupAndPeriodValues.getInt(rowIndex, columnIndex);
                this.insertSumFactData(context, struct, metaDataMigration, periodValue, periodGroupValues, isFirst);
                ++rowIndex;
            }
        } else {
            this.insertSumFactData(context, struct, metaDataMigration, 0, null, isFirst);
        }
    }

    private void insertSumFactData(DefaultContext context, MigrationStruct struct, MetaDataMigration metaDataMigration, int periodValue, List<Long> groupValues, Boolean isFirst) throws Throwable {
        DataTable sumFactDataAsNew;
        String sumFactDataAsNewSql = struct.getSumFactDataAsNewSql(metaDataMigration);
        IDBManager dbManager = context.getDBManager();
        if (struct.getMetaPeriodColumn() != null) {
            ArrayList<Number> arguments = new ArrayList<Number>(groupValues.size() + 1);
            arguments.addAll(groupValues);
            arguments.add(periodValue);
            sumFactDataAsNew = dbManager.execPrepareQuery(sumFactDataAsNewSql, arguments);
        } else {
            sumFactDataAsNew = dbManager.execQuery(sumFactDataAsNewSql);
        }
        this.processGroupID(context, struct, sumFactDataAsNew);
        this.processOID(context, sumFactDataAsNew);
        RefObject argumentSize = new RefObject((Object)0);
        String insertSql = struct.getInsertIncrSql((RefObject<Integer>)argumentSize);
        DataTableBatchPsPara batchPsPara = new DataTableBatchPsPara(insertSql, sumFactDataAsNew, (Integer)argumentSize.getValue());
        dbManager.executeUpdate((BatchPsPara)batchPsPara);
        dbManager.commit();
    }

    public static IReMigrateStrategy getInsertFastStrategy(MetaMigrationParas migrationParas, DefaultContext defaultContext, MigrationStruct struct, String insertSQL) throws Throwable {
        AbstractRemigrateStrategy abstractStrategy = null;
        int dbType = defaultContext.getDBManager().getDBType();
        switch (dbType) {
            case 4: 
            case 6: 
            case 9: {
                abstractStrategy = new InsertFastMySQLStrategy();
                abstractStrategy.setInsertSQL(insertSQL);
                String updateSql = struct.getInsertFastSql();
                abstractStrategy.setUpdateSql(updateSql);
                break;
            }
            case 2: 
            case 8: {
                abstractStrategy = new InsertFastNormalStrategy();
                break;
            }
            case 1: {
                abstractStrategy = new InsertFastSqlServerStrategy();
                break;
            }
            default: {
                throw new Throwable("\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b\uff01\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff01");
            }
        }
        abstractStrategy.setMigrationParas(migrationParas);
        return abstractStrategy;
    }

    private void processGroupID(DefaultContext context, MigrationStruct struct, DataTable sumFactDataAsNew) throws Throwable {
        KeysTableSaveData keysTableSaveData = new KeysTableSaveData();
        RowData[] rowDatas = keysTableSaveData.saveKeysTable(context, sumFactDataAsNew, struct);
        int groupIDColumnIndex = sumFactDataAsNew.getMetaData().findColumnIndexByKey("GroupId");
        int i = 0;
        int size = sumFactDataAsNew.size();
        while (i < size) {
            Long groupID = rowDatas[i].getGroupId();
            if (groupID == null || groupID.equals(0L)) {
                throw new RuntimeException("GroupID\u8ba1\u7b97\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
            }
            sumFactDataAsNew.setLong(i, groupIDColumnIndex, groupID);
            ++i;
        }
    }

    private void processOID(DefaultContext context, DataTable sumFactDataAsNew) throws Throwable {
        int rowIndex = 0;
        int size = sumFactDataAsNew.size();
        while (rowIndex < size) {
            sumFactDataAsNew.setLong(rowIndex, 0, context.applyNewOID());
            ++rowIndex;
        }
    }

    private void rollData(DefaultContext context, MigrationStruct struct, DataTable lastPointData) throws Throwable {
        PeriodMigration periodMigration = new PeriodMigration(context, struct.metaDataObject.getKey());
        int size = lastPointData == null ? 0 : lastPointData.size();
        int i = 0;
        while (i < size) {
            HashMap<String, Long> groupValues = new HashMap<String, Long>();
            for (MetaColumn metaColumn : struct.getMetaPeriodGroupColumns()) {
                String columnName = metaColumn.getBindingDBColumnName();
                Long groupValue = lastPointData.getLong(i, columnName);
                groupValues.put(columnName, groupValue);
            }
            int periodValue = lastPointData.getInt(i, struct.getMetaPeriodColumn().getBindingDBColumnName());
            periodMigration.rollData(context, periodValue, groupValues);
            context.getDBManager().commit();
            ++i;
        }
    }
}

