/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.materializedquery;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.mid.materializedquery.AndExpression;
import com.bokesoft.yes.mid.materializedquery.CompareExpression;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.HashMap;
import java.util.List;

public abstract class WhereExpression {
    static final int GE = 1;
    static final int EQ = 2;
    static final int LE = 3;
    static final int GT = 4;
    static final int NE = 5;
    static final int LT = 6;
    static final int IN = 8;
    private int hash = 0;

    public SqlString toSQL() throws Throwable {
        return this.toSQL(false);
    }

    public SqlString toSQL(SqlString sqlString) throws Throwable {
        return this.toSQL(sqlString, false);
    }

    public abstract SqlString toSQL(boolean var1) throws Throwable;

    public abstract SqlString toSQL(SqlString var1, boolean var2) throws Throwable;

    public abstract List<MetaTable> getMetaTables();

    public abstract HashMap<String, MetaColumn> getMetaColumns() throws Throwable;

    public abstract MetaColumn getMetaColumn() throws Throwable;

    public abstract Object getMetaColumnValue(MetaColumn var1);

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.toString().hashCode();
        }
        return this.hash;
    }

    public String toString() {
        try {
            return this.toSQL().toString();
        }
        catch (Throwable e) {
            LogSvr.getInstance().error(e.getMessage(), e);
            return null;
        }
    }

    public static String getOperatorString(int operator) throws Throwable {
        switch (operator) {
            case 2: {
                return "=";
            }
            case 3: {
                return "<=";
            }
            case 4: {
                return ">";
            }
            case 5: {
                return "<>";
            }
            case 6: {
                return "<";
            }
            case 1: {
                return ">=";
            }
            case 8: {
                return "in";
            }
        }
        throw new Exception("\u76ee\u524d\u4e0d\u652f\u6301\u8fd9\u4e2a\u64cd\u4f5c\u7b26" + operator + ".");
    }

    public static int getOperatorInt(String operator) throws Throwable {
        if ((operator = operator.intern()).equals("=") || operator.equals("==")) {
            return 2;
        }
        if (operator.equals("<=")) {
            return 3;
        }
        if (operator.equals(">")) {
            return 4;
        }
        if (operator.equals("<>") || operator.equals("!=")) {
            return 5;
        }
        if (operator.equals("<")) {
            return 6;
        }
        if (operator.equals(">=")) {
            return 1;
        }
        if (operator.equalsIgnoreCase("in")) {
            return 8;
        }
        throw new Exception("\u76ee\u524d\u4e0d\u652f\u6301\u8fd9\u4e2a\u64cd\u4f5c\u7b26" + operator + ".");
    }

    abstract boolean isMatch(DataTable var1, int var2, boolean var3) throws Throwable;

    abstract boolean isSame(WhereExpression var1) throws Throwable;

    public static WhereExpression eq(MetaColumn metaColumn, Object value) {
        return new CompareExpression(metaColumn, value);
    }

    public static WhereExpression in(MetaColumn metaColumn, String[] value) {
        return new CompareExpression(metaColumn, value, 8);
    }

    public static WhereExpression in(MetaColumn metaColumn, Integer[] value) {
        return new CompareExpression(metaColumn, value, 8);
    }

    public static WhereExpression in(MetaColumn metaColumn, int[] value) {
        return new CompareExpression(metaColumn, value, 8);
    }

    public static WhereExpression in(MetaColumn metaColumn, Long[] value) {
        return new CompareExpression(metaColumn, value, 8);
    }

    public static WhereExpression operator(MetaColumn metaColumn, String operator, Object value) throws Throwable {
        int opt = WhereExpression.getOperatorInt(operator);
        return new CompareExpression(metaColumn, value, opt);
    }

    public WhereExpression addEQ(MetaColumn metaColumn, Object value) {
        return this.add(new CompareExpression(metaColumn, value));
    }

    public WhereExpression addIN(MetaColumn metaColumn, String[] value) {
        return this.add(new CompareExpression(metaColumn, value, 8));
    }

    public WhereExpression addIN(MetaColumn metaColumn, Integer[] value) {
        return this.add(new CompareExpression(metaColumn, value, 8));
    }

    public WhereExpression addLong(MetaColumn metaColumn, Long[] value) {
        return this.add(new CompareExpression(metaColumn, value, 8));
    }

    public WhereExpression addIN(MetaColumn metaColumn, int[] value) {
        return this.add(new CompareExpression(metaColumn, value, 8));
    }

    public WhereExpression addOperator(MetaColumn metaColumn, String operator, Object value) throws Throwable {
        int opt = WhereExpression.getOperatorInt(operator);
        return this.add(new CompareExpression(metaColumn, value, opt));
    }

    private WhereExpression add(CompareExpression expression) {
        if (this instanceof AndExpression) {
            ((AndExpression)this).addExpression(expression);
            return this;
        }
        return new AndExpression(this, expression);
    }

    public abstract boolean hasMetaColumnWhereClause(MetaColumn var1);
}

