/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache.structure;

import com.bokesoft.yes.common.struct.HashMapIgnoreCaseFastGet;
import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.dbcache.CacheDBRequest;
import com.bokesoft.yes.mid.dbcache.WhereExpressionForCache;
import com.bokesoft.yes.mid.dbcache.commit.SubmitDataTable;
import com.bokesoft.yes.mid.dbcache.config.HeadDetailTables;
import com.bokesoft.yes.mid.dbcache.config.TablePrimarySetting;
import com.bokesoft.yes.mid.dbcache.datatable.DataTableExUtil;
import com.bokesoft.yes.mid.dbcache.datatable.DataTableResultSetUtil;
import com.bokesoft.yes.mid.dbcache.datatable.OrderByUtil;
import com.bokesoft.yes.mid.dbcache.parsedsql.LongOrLongArray;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedDelete;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedInsert;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSelect;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSql;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedUpdate;
import com.bokesoft.yes.mid.dbcache.preload.PreLoad;
import com.bokesoft.yes.mid.dbcache.structure.CacheDB;
import com.bokesoft.yes.mid.dbcache.structure.Eval;
import com.bokesoft.yes.mid.dbcache.structure.NewRowDefaultValuesCache;
import com.bokesoft.yes.mid.dbcache.structure.OrderBy;
import com.bokesoft.yes.mid.io.doc.util.DocLockCheckUtil;
import com.bokesoft.yes.mid.materializedquery.MQGenData;
import com.bokesoft.yes.mid.mysqls.group.HeadDetailTable;
import com.bokesoft.yes.mid.mysqls.resultset.DataTableResultSet;
import com.bokesoft.yes.struct.abstractdatatable.SortCriteria;
import com.bokesoft.yes.struct.datatable.Row;
import com.bokesoft.yes.struct.datatype.DataTypeAction;
import com.bokesoft.yes.util.VarUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.domain.MetaDomain;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.util.DBManagerUtil;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.insert.Insert;
import net.boke.jsqlparser.statement.update.Update;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class CacheTable {
    public final String tableName;
    private DataTable data;
    private boolean isChanged = false;
    private Map<Long, Integer> oidIndex = null;
    private Map<Long, List<Integer>> soidIndex = null;
    private int oidColumnIndex = -2;
    private int soidColumnIndex = -2;
    private int secondFieldIndex = -2;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static HashMap<MetaTable, HashMapIgnoreCaseFastGet<MetaColumn>> allUpperCaseKeyMetaTables;
    private static final int INT_NotExist_Bookmark = -1;
    Set<Long> newInsertSOIDs = null;
    private Map<Long, Long> deletedOids = null;
    private List<WhereExpressionForCache> preLoadingArguments;
    private List<WhereExpressionForCache> preLoadedArguments;

    public CacheTable(String tableName) {
        this.tableName = tableName;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    private void initDataStruct() throws Throwable {
        if (this.data == null) {
            MetaTable metaTable = MetaTableCache.getFullMetaTable(this.tableName);
            this.data = MetaTableCache.newEmptyDataTable(metaTable);
        }
    }

    public DataTableResultSet query(IDBManager dbManager, ParsedSelect select, QueryArguments paras) throws Throwable {
        DataTableResultSet result = this.query(select, paras);
        if (result == null && PreLoad.preLoad(this, dbManager, this.tableName, select, paras)) {
            result = this.query(select, paras);
        }
        return result;
    }

    public void clearDataStruct() throws Throwable {
        this.lock.writeLock().lock();
        try {
            this.data = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private DataTableResultSet query(ParsedSelect select, QueryArguments paras) throws Throwable {
        if (!select.isSupportCache()) {
            throw new RuntimeException("\u672c\u8bed\u53e5\u4e0d\u652f\u6301\u7f13\u5b58\u3002");
        }
        if (this.data == null) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            if (this.data == null) {
                return null;
            }
            DataTableResultSet result = null;
            if (select.hasOIDWhere()) {
                LongOrLongArray oids = LongOrLongArray.getLongs(paras, select.getOIDIndex());
                if (this.oidIndex != null && LongOrLongArray.isMapContainsKey(this.oidIndex, oids)) {
                    result = this.query_ExistOIDs(select, paras, oids);
                }
            } else if (select.hasSOIDWhere()) {
                long soid = TypeConvertor.toLong((Object)paras.get(select.getSOIDIndex()));
                Expression whereClause = select.getWhereClause();
                if (this.oidIndex != null && this.oidIndex.containsKey(soid)) {
                    result = this.query_ExistOID(select, paras, soid);
                } else if (this.soidIndex != null && this.soidIndex.containsKey(soid)) {
                    result = this.query_ExistSOID(select, whereClause, paras, soid);
                }
                if (result == null && select.hasSecondFieldWhere()) {
                    result = this.query_ExistSOIDAndSecondField(select, whereClause, paras, soid);
                }
            }
            DataTableResultSet dataTableResultSet = result;
            return dataTableResultSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private DataTableResultSet query_ExistOID(ParsedSelect select, QueryArguments paras, long oid) throws Throwable {
        DataTableResultSet result = null;
        int[] columnIndexes = select.getColumnIndexes(this.data);
        int bookmark = this.oidIndex.get(oid);
        if (bookmark >= 0) {
            Row row;
            boolean match;
            int rowIndex = DataTableExUtil.getRowIndexByBookmark(this.data, bookmark);
            result = select.isOnlyOIDOrSOID() ? DataTableResultSetUtil.newResultSet(select, columnIndexes, this.data, new int[]{rowIndex}) : ((match = this.isMatch(row = DataTableExUtil.getRowByIndex(this.data, rowIndex), select.getWhereClause(), select, paras)) ? DataTableResultSetUtil.newResultSet(select, columnIndexes, this.data, new int[]{rowIndex}) : DataTableResultSetUtil.newResultSet(select, columnIndexes, this.data, ArrayUtils.EMPTY_INT_ARRAY));
        } else {
            result = DataTableResultSetUtil.newResultSet(select, columnIndexes, this.data, ArrayUtils.EMPTY_INT_ARRAY);
        }
        return result;
    }

    private DataTableResultSet query_ExistOIDs(ParsedSelect select, QueryArguments paras, LongOrLongArray oids) throws Throwable {
        DataTableResultSet result = null;
        int[] columnIndexes = select.getColumnIndexes(this.data);
        ArrayList<Integer> rowIndexes = new ArrayList<Integer>();
        for (Long oid : oids) {
            int bookmark = this.oidIndex.get(oid);
            if (bookmark < 0) continue;
            int rowIndex = DataTableExUtil.getRowIndexByBookmark(this.data, bookmark);
            if (select.isOnlyOIDOrSOID()) {
                rowIndexes.add(rowIndex);
                continue;
            }
            Row row = DataTableExUtil.getRowByIndex(this.data, rowIndex);
            boolean match = this.isMatch(row, select.getWhereClause(), select, paras);
            if (!match) continue;
            rowIndexes.add(rowIndex);
        }
        List<OrderBy> orderbyObjects = select.getOrderByElements(this.data);
        if (orderbyObjects != null && orderbyObjects.size() > 0) {
            OrderByUtil.orderBy(rowIndexes, orderbyObjects, this.data);
        }
        int[] tmp = ArrayUtils.toPrimitive((Integer[])rowIndexes.toArray(new Integer[rowIndexes.size()]));
        result = DataTableResultSetUtil.newResultSet(select, columnIndexes, this.data, tmp);
        return result;
    }

    private DataTableResultSet query_ExistSOID(ParsedSelect select, Expression whereClause, QueryArguments paras, long soid) throws Throwable {
        DataTableResultSet result = null;
        ArrayList<Integer> validRowIndexes = new ArrayList<Integer>();
        boolean onlyOIDOrSOID = select.isOnlyOIDOrSOID();
        for (Integer bookmark : this.soidIndex.get(soid)) {
            int rowIndex = DataTableExUtil.getRowIndexByBookmark(this.data, bookmark);
            if (rowIndex == -1) continue;
            if (onlyOIDOrSOID) {
                validRowIndexes.add(rowIndex);
                continue;
            }
            Row row = DataTableExUtil.getRowByIndex(this.data, rowIndex);
            boolean match = this.isMatch(row, whereClause, select, paras);
            if (!match) continue;
            validRowIndexes.add(rowIndex);
        }
        List<OrderBy> orderbyObjects = select.getOrderByElements(this.data);
        if (orderbyObjects != null && orderbyObjects.size() > 0) {
            OrderByUtil.orderBy(validRowIndexes, orderbyObjects, this.data);
        }
        int[] columnIndexes = select.getColumnIndexes(this.data);
        int[] validRowIndexesInt = ArrayUtils.toPrimitive((Integer[])validRowIndexes.toArray(new Integer[validRowIndexes.size()]));
        result = DataTableResultSetUtil.newResultSet(select, columnIndexes, this.data, validRowIndexesInt);
        return result;
    }

    private DataTableResultSet query_ExistSOIDAndSecondField(ParsedSelect select, Expression whereClause, QueryArguments paras, long soid) throws Throwable {
        DataTableResultSet result = null;
        long secondFieldValue = TypeConvertor.toLong((Object)paras.get(select.getSecondFieldIndex()));
        int[] columnIndexes = select.getColumnIndexes(this.data);
        int rowIndex = 0;
        int size = this.data.size();
        while (rowIndex < size) {
            Row row = DataTableExUtil.getRowByIndex(this.data, rowIndex);
            if (this.isMatchGroupUnique(row, soid, secondFieldValue)) {
                boolean match = this.isMatch(row, whereClause, select, paras);
                if (match) {
                    result = DataTableResultSetUtil.newResultSet(select, columnIndexes, this.data, new int[]{rowIndex});
                    break;
                }
                result = DataTableResultSetUtil.newResultSet(select, columnIndexes, this.data, ArrayUtils.EMPTY_INT_ARRAY);
                break;
            }
            ++rowIndex;
        }
        return result;
    }

    private boolean isMatch(Row row, Expression expression, ParsedSql sql, QueryArguments paras) {
        Object result = Eval.eval(this.data, row, expression, sql, paras, -1);
        return (Boolean)result;
    }

    private boolean isMatchGroupUnique(Row row, Long soid, Long secondFieldValue) {
        return soid.equals(row.getObject(this.getSOIDColumnIndex())) && secondFieldValue.equals(row.getObject(this.getSecondFieldColumnIndex()));
    }

    private Map<Long, Integer> getHasLoadedOIDsNotNull() {
        if (this.oidIndex == null) {
            this.oidIndex = new HashMap<Long, Integer>();
        }
        return this.oidIndex;
    }

    private Map<Long, List<Integer>> getHasLoadedSOIDsNotNull() {
        if (this.soidIndex == null) {
            this.soidIndex = new HashMap<Long, List<Integer>>();
        }
        return this.soidIndex;
    }

    private int getOIDColumnIndexInResultSet(ResultSet resultSet) throws SQLException {
        if ("OID".equalsIgnoreCase(resultSet.getMetaData().getColumnLabel(1))) {
            return 1;
        }
        int columnIndex = resultSet.findColumn("OID");
        return columnIndex;
    }

    public boolean appendPreLoad(IDBManager dbManager, ResultSet resultSet, Long soid) throws Throwable {
        boolean result = false;
        this.lock.writeLock().lock();
        try {
            ArrayList<Integer> soidBookmarks;
            this.initDataStruct();
            resultSet.beforeFirst();
            int oidColumnIndex = this.getOIDColumnIndexInResultSet(resultSet);
            Map<Long, Integer> hasLoadedOIDs = this.getHasLoadedOIDsNotNull();
            ArrayList<Integer> arrayList = soidBookmarks = soid == null ? null : new ArrayList<Integer>();
            if (soid != null) {
                int[] nArray = this.data.fastFilter("SOID", (Object)soid);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int rowIndex = nArray[n2];
                    int bookmark = this.data.getBookmark(rowIndex);
                    soidBookmarks.add(bookmark);
                    ++n2;
                }
            }
            resultSet.beforeFirst();
            while (resultSet.next()) {
                Long oid = resultSet.getLong(oidColumnIndex);
                if (this.deletedOids != null && this.deletedOids.containsKey(oid)) continue;
                int oldBookmark = hasLoadedOIDs.getOrDefault(oid, -1);
                int bookmark = DataTableExUtil.appendPreLoadRow(dbManager, oldBookmark, this.data, resultSet);
                hasLoadedOIDs.put(oid, bookmark);
                if (soid != null && oldBookmark == -1) {
                    soidBookmarks.add(bookmark);
                }
                result = true;
            }
            if (soid != null) {
                this.getHasLoadedSOIDsNotNull().put(soid, soidBookmarks);
                result = true;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return result;
    }

    public boolean appendPreLoadOneOID(IDBManager dbManager, ResultSet resultSet, Long oid) throws Throwable {
        this.lock.writeLock().lock();
        if (this.deletedOids != null && this.deletedOids.containsKey(oid)) {
            return true;
        }
        try {
            this.initDataStruct();
            Map<Long, Integer> hasLoadedOIDs = this.getHasLoadedOIDsNotNull();
            if (resultSet.first()) {
                int oldBookmark = hasLoadedOIDs.getOrDefault(oid, -1);
                int bookmark = DataTableExUtil.appendPreLoadRow(dbManager, oldBookmark, this.data, resultSet);
                hasLoadedOIDs.put(oid, bookmark);
            } else {
                hasLoadedOIDs.put(oid, -1);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return true;
    }

    public int update(CacheDB cacheDB, ParsedUpdate update, List<? extends QueryArguments> parases, List<QueryArguments> notProcessParases) throws Throwable {
        if (!update.isSupportCache()) {
            throw new RuntimeException("\u672c\u8bed\u53e5\u4e0d\u652f\u6301\u7f13\u5b58\u3002");
        }
        this.lock.writeLock().lock();
        try {
            int result = 0;
            Iterator<? extends QueryArguments> iterator = parases.iterator();
            while (iterator.hasNext()) {
                ArrayList<Row> rows = new ArrayList<Row>();
                QueryArguments paras = iterator.next();
                boolean isFound = this.query(rows, update, paras);
                if (isFound) {
                    for (Row row : rows) {
                        this.updateRow(cacheDB, row, update, paras);
                        ++result;
                    }
                    continue;
                }
                notProcessParases.add(paras);
            }
            this.isChanged = true;
            int n = result;
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void updateRow(CacheDB cacheDB, Row row, ParsedUpdate update, QueryArguments paras) {
        Update sql = (Update)update.getStatement();
        List columns = sql.getColumns();
        List expressions = sql.getExpressions();
        Object[] dataList = row.getDataList();
        int state = row.getState();
        if (row.getOriginalDataList() == null) {
            row.createOriginData();
        }
        DataTableMetaData metaData = this.data.getMetaData();
        int i = 0;
        int size = columns.size();
        while (i < size) {
            Object value;
            Column column = (Column)columns.get(i);
            String columnName = column.getColumnName();
            ColumnInfo columnInfo = metaData.getColumnInfo(columnName);
            int columnIndex = columnInfo != null ? columnInfo.getColumnIndex() : -1;
            int dataType = columnInfo.getDataType();
            Expression expression = (Expression)expressions.get(i);
            dataList[columnIndex] = value = Eval.eval(this.data, row, expression, update, paras, dataType);
            ++i;
        }
        row.updateIndex();
        row.setState(state == 0 ? 2 : state);
        this.updateRow_updateIndex(cacheDB, row);
    }

    private void updateRow_updateIndex(CacheDB cacheDB, Row row) {
        row.updateIndex();
        int soidColumnIndex = this.getSOIDColumnIndex();
        if (soidColumnIndex >= 0) {
            Object object = row.getObject(soidColumnIndex);
            if (object == null) {
                return;
            }
            Long soid = (Long)object;
            cacheDB.clearBillEntity(soid);
        }
    }

    private boolean query(List<Row> rows, ParsedSql sql, QueryArguments paras) throws Throwable {
        block8: {
            block7: {
                if (this.data == null) {
                    return false;
                }
                if (!sql.hasOIDWhere()) break block7;
                LongOrLongArray oids = LongOrLongArray.getLongs(paras, sql.getOIDIndex());
                for (Long oid : oids) {
                    Row row;
                    if (this.oidIndex == null || !this.oidIndex.containsKey(oid)) continue;
                    int bookmark = this.oidIndex.get(oid);
                    Row row2 = row = bookmark >= 0 ? DataTableExUtil.getRowByBookmark(this.data, bookmark) : null;
                    if (row == null || 3 == row.getState()) {
                        return false;
                    }
                    if (sql.isOnlyOIDOrSOID() && bookmark >= 0) {
                        rows.add(row);
                        continue;
                    }
                    boolean match = this.isMatch(row, sql.getWhereClause(), sql, paras);
                    if (!match || bookmark < 0) continue;
                    rows.add(row);
                }
                break block8;
            }
            if (!sql.hasSOIDWhere()) break block8;
            long soid = TypeConvertor.toLong((Object)paras.get(sql.getSOIDIndex()));
            if (this.soidIndex != null && this.soidIndex.containsKey(soid)) {
                for (Integer bookmark : this.soidIndex.get(soid)) {
                    Row row = DataTableExUtil.getRowByBookmark(this.data, bookmark);
                    if (3 == row.getState()) continue;
                    if (sql.isOnlyOIDOrSOID()) {
                        rows.add(row);
                        continue;
                    }
                    boolean match = this.isMatch(row, sql.getWhereClause(), sql, paras);
                    if (!match) continue;
                    rows.add(row);
                }
            }
        }
        return rows.size() > 0;
    }

    public int insert(CacheDB cacheDB, ParsedInsert insert, List<? extends QueryArguments> parases, List<QueryArguments> notProcessParases) throws Throwable {
        if (!insert.isSupportCache()) {
            throw new RuntimeException("\u672c\u8bed\u53e5\u4e0d\u652f\u6301\u7f13\u5b58\u3002");
        }
        this.lock.writeLock().lock();
        try {
            int result = 0;
            for (QueryArguments queryArguments : parases) {
                this.insertRow(cacheDB, insert, queryArguments, notProcessParases);
                ++result;
            }
            this.isChanged = true;
            int n = result;
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void insertRow(CacheDB cacheDB, ParsedInsert insert, QueryArguments paras, List<QueryArguments> notProcessParases) throws Throwable {
        this.initDataStruct();
        int[] columnIndexes = insert.getColumnIndexes(this.data);
        if (columnIndexes.length == 0) {
            notProcessParases.add(paras);
            return;
        }
        Insert sql = (Insert)insert.getStatement();
        ExpressionList itemsList = (ExpressionList)sql.getItemsList();
        List expressions = itemsList.getExpressions();
        Row row = DataTableExUtil.appendDataTable(this.data);
        row.setState(1);
        Object[] dataList = row.getDataList();
        Object[] defaultValues = NewRowDefaultValuesCache.getDefaultValues(this.tableName);
        System.arraycopy(defaultValues, 0, dataList, 0, defaultValues.length);
        DataTableMetaData metaData = this.data.getMetaData();
        int i = 0;
        int size = columnIndexes.length;
        while (i < size) {
            Object value;
            Expression expression = (Expression)expressions.get(i);
            int columnIndex = columnIndexes[i];
            int dataType = metaData.getColumnInfo(columnIndex).getDataType();
            dataList[columnIndex] = value = Eval.eval(this.data, null, expression, insert, paras, dataType);
            ++i;
        }
        row.updateIndex();
        this.insertRow_updateIndex(cacheDB, row);
    }

    private int getOIDColumnIndex() {
        if (this.oidColumnIndex == -2) {
            this.oidColumnIndex = this.data.getMetaData().findColumnIndexByKey(TablePrimarySetting.getOIDField(this.tableName));
        }
        return this.oidColumnIndex;
    }

    private int getSOIDColumnIndex() {
        if (this.soidColumnIndex == -2) {
            this.soidColumnIndex = this.data.getMetaData().findColumnIndexByKey(TablePrimarySetting.getSOIDField(this.tableName));
        }
        return this.soidColumnIndex;
    }

    private int getSecondFieldColumnIndex() {
        if (this.secondFieldIndex == -2) {
            this.secondFieldIndex = this.data.getMetaData().findColumnIndexByKey(TablePrimarySetting.getGroupSOIDUniqueIndexSecondField(this.tableName));
        }
        return this.secondFieldIndex;
    }

    private void insertRow_updateIndex(CacheDB cacheDB, Row row) throws Throwable {
        Long oid = (Long)row.getObject(this.getOIDColumnIndex());
        int bookmark = row.getBookmark();
        this.getHasLoadedOIDsNotNull().put(oid, bookmark);
        int soidColumnIndex = this.getSOIDColumnIndex();
        if (soidColumnIndex >= 0) {
            Object object = row.getObject(soidColumnIndex);
            Long soid = (Long)object;
            if (oid.equals(soid)) {
                if (this.newInsertSOIDs == null) {
                    this.newInsertSOIDs = new HashSet<Long>();
                }
                this.newInsertSOIDs.add(soid);
            }
            if ((this.soidIndex == null || !this.soidIndex.containsKey(soid)) && cacheDB.isNewInsertSOID(this.tableName, soid)) {
                this.getHasLoadedSOIDsNotNull().put(soid, new ArrayList());
            }
            if (this.soidIndex != null && this.soidIndex.containsKey(soid)) {
                this.soidIndex.get(soid).add(bookmark);
            }
            cacheDB.clearBillEntity(soid);
        }
    }

    public int delete(CacheDB cacheDB, ParsedDelete delete, List<? extends QueryArguments> parases, List<QueryArguments> notProcessParases) throws Throwable {
        if (!delete.isSupportCache()) {
            throw new RuntimeException("\u672c\u8bed\u53e5\u4e0d\u652f\u6301\u7f13\u5b58\u3002");
        }
        this.lock.writeLock().lock();
        try {
            int result = 0;
            if (delete.isOnlyOidIn()) {
                QueryArguments paras = parases.get(0);
                int i = 0;
                int size = paras.size();
                while (i < size) {
                    Long oid = TypeConvertor.toLong((Object)paras.get(i));
                    if (this.oidIndex != null && this.oidIndex.containsKey(oid)) {
                        Row row;
                        int bookmark = this.oidIndex.get(oid);
                        Row row2 = row = bookmark >= 0 ? DataTableExUtil.getRowByBookmark(this.data, bookmark) : null;
                        if (row != null && 3 != row.getState()) {
                            this.deleteRow(cacheDB, row);
                            ++result;
                        }
                    }
                    ++i;
                }
                if (result != paras.size()) {
                    notProcessParases.add(paras);
                }
            } else {
                Iterator<? extends QueryArguments> iterator = parases.iterator();
                while (iterator.hasNext()) {
                    ArrayList<Row> rows = new ArrayList<Row>();
                    QueryArguments paras = iterator.next();
                    boolean isFound = this.query(rows, delete, paras);
                    if (isFound) {
                        for (Row row : rows) {
                            this.deleteRow(cacheDB, row);
                            ++result;
                        }
                        continue;
                    }
                    notProcessParases.add(paras);
                }
            }
            this.isChanged = true;
            int n = result;
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void deleteRow(CacheDB cacheDB, Row row) throws Throwable {
        Object object;
        Object object2;
        int soidColumnIndex = this.getSOIDColumnIndex();
        if (soidColumnIndex >= 0 && (object2 = row.getObject(soidColumnIndex)) != null) {
            List<Integer> bookmarks;
            int index;
            cacheDB.clearBillEntity((Long)object2);
            if (this.soidIndex != null && this.soidIndex.containsKey(object2) && (index = (bookmarks = this.soidIndex.get(object2)).indexOf(row.getBookmark())) >= 0) {
                bookmarks.remove(index);
            }
        }
        int rowIndex = this.data.getRowIndexByBookmark(row.getBookmark());
        int oidColumnIndex = this.getOIDColumnIndex();
        if (oidColumnIndex >= 0 && (object = row.getObject(oidColumnIndex)) != null) {
            if (this.oidIndex != null) {
                this.oidIndex.remove(object);
            }
            Long oid = (Long)object;
            if (this.deletedOids == null) {
                this.deletedOids = new ConcurrentHashMap<Long, Long>();
            }
            this.deletedOids.put(oid, oid);
        }
        this.data.delete(rowIndex);
    }

    private HashMapIgnoreCaseFastGet<MetaColumn> getIgnoreCaseColumnMap(MetaTable metaTable) {
        HashMapIgnoreCaseFastGet upperColumnKeys;
        if (allUpperCaseKeyMetaTables == null) {
            allUpperCaseKeyMetaTables = new HashMap();
        }
        if ((upperColumnKeys = allUpperCaseKeyMetaTables.get(metaTable)) == null) {
            upperColumnKeys = new HashMapIgnoreCaseFastGet();
            for (MetaColumn metaColumn : metaTable) {
                String columnKey = metaColumn.getKey().toUpperCase();
                upperColumnKeys.put(columnKey, (Object)metaColumn);
            }
            allUpperCaseKeyMetaTables.put(metaTable, (HashMapIgnoreCaseFastGet<MetaColumn>)upperColumnKeys);
        }
        return upperColumnKeys;
    }

    public boolean saveDataTable(CacheDB cacheDB, DataTable dataTable, MetaTable metaTable, int dbType) throws Throwable {
        return this.saveDataTable(cacheDB, dataTable, metaTable, dbType, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean saveDataTable(CacheDB cacheDB, DataTable dataTable, MetaTable metaTable, int dbType, boolean isOnlyCheckVer4GlobalTable) throws Throwable {
        dataTable.setShowDeleted(true);
        int rowSize = dataTable.size();
        if (rowSize == 0) {
            return true;
        }
        this.lock.writeLock().lock();
        try {
            Row row;
            this.initDataStruct();
            DataTableMetaData cacheMetaData = this.data.getMetaData();
            DataTableMetaData metaData = dataTable.getMetaData();
            int columnSize = metaData.getColumnCount();
            int[] columnIndexes = new int[columnSize];
            ColumnInfo[] columnInfos = new ColumnInfo[columnSize];
            boolean isColumnNameCaseSensitive = DBManagerUtil.isColumnNameCaseSensitive((int)dbType);
            HashMapIgnoreCaseFastGet<MetaColumn> ignoreCaseColumnMap = isColumnNameCaseSensitive ? null : this.getIgnoreCaseColumnMap(metaTable);
            int i = 0;
            while (i < columnSize) {
                String dbColumnName;
                ColumnInfo columnInfo;
                columnInfos[i] = columnInfo = metaData.getColumnInfo(i);
                if (metaTable == null) {
                    dbColumnName = columnInfo.getColumnKey();
                } else {
                    MetaDomain metaDomain;
                    MetaDataElement metaDataElement;
                    String metaColumnKey = columnInfo.getColumnKey();
                    MetaColumn metaColumn = isColumnNameCaseSensitive ? (MetaColumn)metaTable.get(metaColumnKey) : (MetaColumn)ignoreCaseColumnMap.get(metaColumnKey);
                    dbColumnName = metaColumn == null || metaColumn.isPersist() == false ? null : metaColumn.getBindingDBColumnName();
                    MetaDataElement metaDataElement2 = metaDataElement = metaColumn == null ? null : metaColumn.getDataElement();
                    if (metaDataElement != null && (metaDomain = metaDataElement.getDomain()) != null) {
                        Integer caseType = metaDomain.getCase();
                        columnInfo.setCaseType(caseType);
                    }
                }
                columnIndexes[i] = dbColumnName == null ? -1 : cacheMetaData.findColumnIndexByKey(dbColumnName);
                ++i;
            }
            int oidColumnIndex = metaData.findColumnIndexByKey("OID");
            if (oidColumnIndex < 0) {
                return false;
            }
            this.loadNotLoadUpdateRow(dataTable, cacheDB.dbManager, oidColumnIndex, columnIndexes, isOnlyCheckVer4GlobalTable);
            int veridColumnIndex = metaData.findColumnIndexByKey("VERID");
            if (CacheTable.isBPMTable(this.tableName) && veridColumnIndex > 0) {
                veridColumnIndex = -1;
            }
            if (isOnlyCheckVer4GlobalTable) {
                int rowIndex = 0;
                while (rowIndex < rowSize) {
                    row = DataTableExUtil.getRowByIndex(dataTable, rowIndex);
                    int rowState = row.getState();
                    Long oid = TypeConvertor.toLong((Object)row.getObject(oidColumnIndex));
                    if (!cacheDB.hasCheckVerID(oid, this.tableName)) {
                        cacheDB.setCheckVerID(oid, this.tableName);
                        if (rowState == 3) {
                            if (this.oidIndex == null || this.oidIndex.getOrDefault(oid, -1) == -1) throw new RuntimeException("\u5220\u9664\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f7d\u5165\u6570\u636e");
                            int deleteRowIndex = DataTableExUtil.getRowIndexByBookmark(this.data, this.oidIndex.get(oid));
                            Row latestRow = DataTableExUtil.getRowByIndex(this.data, deleteRowIndex);
                            boolean checkIndividually = DocLockCheckUtil.getCheckIndividually();
                            if (checkIndividually && veridColumnIndex >= 0 && !latestRow.getObject("VERID").equals(row.getObject("VERID"))) {
                                throw new RuntimeException("\u6570\u636e\u5df2\u88ab\u4fee\u6539,\u8bf7\u91cd\u65b0\u8f7d\u5165\u6570\u636e");
                            }
                        } else if (rowState == 2) {
                            int updateRowVerIDValue;
                            int verIDValue;
                            if (this.oidIndex == null || this.oidIndex.getOrDefault(oid, -1) == -1) {
                                throw new RuntimeException("\u66f4\u65b0\u7684\u6570\u636e\u6ca1\u6709\u627e\u5230\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u8f7d\u5165\u6570\u636e");
                            }
                            int updateRowIndex = DataTableExUtil.getRowIndexByBookmark(this.data, this.oidIndex.get(oid));
                            Row latestRow = DataTableExUtil.getRowByIndex(this.data, updateRowIndex);
                            Object[] rowDataList = row.getDataList();
                            boolean checkIndividually = DocLockCheckUtil.getCheckIndividually();
                            if (checkIndividually && veridColumnIndex >= 0 && !latestRow.isNew() && (verIDValue = TypeConvertor.toInteger((Object)rowDataList[veridColumnIndex]).intValue()) != (updateRowVerIDValue = TypeConvertor.toInteger((Object)latestRow.getObject("VERID")).intValue())) {
                                throw new RuntimeException("\u5904\u7406\u4e2d\u7684\u90e8\u5206\u6570\u636e\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\uff0c\u8c22\u8c22\u3002\n\u8868" + this.tableName + "\u6570\u636e\u5df2\u8fc7\u671f\uff0c\u6570\u636e\u5e93\u4e2d\u7248\u672c\u503c\u4e3a" + updateRowVerIDValue + "\uff0c\u6570\u636e\u5bf9\u8c61\u4e2d\u7248\u672c\u503c\u4e3a" + verIDValue + "\u3002");
                            }
                        }
                    }
                    ++rowIndex;
                }
                return true;
            } else {
                int rowIndex = 0;
                while (rowIndex < rowSize) {
                    Object[] rowDataList;
                    int tmpColumnIndex;
                    row = DataTableExUtil.getRowByIndex(dataTable, rowIndex);
                    int rowState = row.getState();
                    Long oid = TypeConvertor.toLong((Object)row.getObject(oidColumnIndex));
                    if (rowState == 3) {
                        Row deleteRow;
                        if (this.oidIndex != null && this.oidIndex.getOrDefault(oid, -1) != -1) {
                            int deleteRowIndex = DataTableExUtil.getRowIndexByBookmark(this.data, this.oidIndex.get(oid));
                            deleteRow = DataTableExUtil.getRowByIndex(this.data, deleteRowIndex);
                        } else {
                            if (this.oidIndex != null && this.oidIndex.containsKey(oid) && this.oidIndex.get(oid) == -1) {
                                throw new RuntimeException("\u5220\u9664\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
                            }
                            deleteRow = DataTableExUtil.appendDataTable(this.data);
                            deleteRow.setState(0);
                            Object[] deleteRowDataList = deleteRow.getDataList();
                            Object[] rowDataList2 = row.getDataList();
                            int i2 = 0;
                            while (i2 < columnSize) {
                                tmpColumnIndex = columnIndexes[i2];
                                if (tmpColumnIndex >= 0) {
                                    deleteRowDataList[tmpColumnIndex] = rowDataList2[i2];
                                }
                                ++i2;
                            }
                        }
                        boolean checkIndividually = DocLockCheckUtil.getCheckIndividually();
                        if (checkIndividually && veridColumnIndex >= 0 && !deleteRow.getObject("VERID").equals(row.getObject("VERID"))) {
                            throw new RuntimeException("\u6570\u636e\u5df2\u88ab\u4fee\u6539,\u8bf7\u91cd\u65b0\u8f7d\u5165\u6570\u636e");
                        }
                        this.deleteRow(cacheDB, deleteRow);
                    } else if (rowState == 2) {
                        if (this.oidIndex == null || this.oidIndex.getOrDefault(oid, -1) == -1) {
                            throw new RuntimeException("\u66f4\u65b0\u7684\u6570\u636e\u6ca1\u6709\u627e\u5230\u8bb0\u5f55\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
                        }
                        int updateRowIndex = DataTableExUtil.getRowIndexByBookmark(this.data, this.oidIndex.get(oid));
                        Row updateRow = DataTableExUtil.getRowByIndex(this.data, updateRowIndex);
                        if (updateRow.isDeleted()) {
                            throw new RuntimeException("\u66f4\u65b0\u7684\u6570\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
                        }
                        Object[] rowOrginalDataList = row.getOriginalDataList();
                        Object[] updateRowDataList = updateRow.getDataList();
                        rowDataList = row.getDataList();
                        int updataRowState = updateRow.getState();
                        if (updataRowState == 0 && updateRow.getOriginalDataList() == null) {
                            updateRow.createOriginData();
                        }
                        boolean hasUpdateColumn = false;
                        int lastModifiedColumnIndex = metaData.findColumnIndexByKey("LastModified");
                        int i3 = 0;
                        while (i3 < columnSize) {
                            if (i3 != oidColumnIndex && i3 != veridColumnIndex && i3 != lastModifiedColumnIndex && (tmpColumnIndex = columnIndexes[i3]) >= 0) {
                                boolean valueChanged;
                                Object value = this.convertValue(rowDataList[i3], columnInfos[i3]);
                                boolean bl = valueChanged = VarUtil.compare(value, rowOrginalDataList[i3]) != 0;
                                if (valueChanged) {
                                    updateRowDataList[tmpColumnIndex] = value;
                                    hasUpdateColumn = true;
                                }
                            }
                            ++i3;
                        }
                        if (!hasUpdateColumn) {
                            updateRow.setState(updataRowState);
                        } else {
                            boolean checkIndividually;
                            if (updataRowState == 0) {
                                updateRow.setState(2);
                            }
                            if ((checkIndividually = DocLockCheckUtil.getCheckIndividually()) && veridColumnIndex >= 0 && !updateRow.isNew() && !cacheDB.hasCheckVerID(oid, this.tableName)) {
                                int verIDValue = TypeConvertor.toInteger((Object)rowDataList[veridColumnIndex]);
                                Object[] updateRowOrginalDataList = updateRow.getOriginalDataList();
                                int updateRowOrginalOldVerIDValue = TypeConvertor.toInteger((Object)updateRowOrginalDataList[columnIndexes[veridColumnIndex]]);
                                int updateRowVerIDValue = TypeConvertor.toInteger((Object)updateRowDataList[veridColumnIndex]);
                                int newVerIDValue = (updateRowOrginalOldVerIDValue + 1) * -1;
                                if (updateRowOrginalOldVerIDValue != verIDValue && newVerIDValue != verIDValue && verIDValue != updateRowVerIDValue) {
                                    throw new RuntimeException("\u5904\u7406\u4e2d\u7684\u90e8\u5206\u6570\u636e\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\uff0c\u8c22\u8c22\u3002\n\u8868" + this.tableName + "\u6570\u636e\u5df2\u8fc7\u671f\uff0c\u6570\u636e\u5e93\u4e2d\u7248\u672c\u503c\u4e3a" + updateRowOrginalOldVerIDValue + "\uff0c\u6570\u636e\u5bf9\u8c61\u4e2d\u7248\u672c\u503c\u4e3a" + TypeConvertor.toInteger((Object)rowDataList[veridColumnIndex]) + "\u3002");
                                }
                                rowDataList[veridColumnIndex] = newVerIDValue;
                                updateRowDataList[columnIndexes[veridColumnIndex]] = newVerIDValue;
                            }
                            this.updateRow_updateIndex(cacheDB, updateRow);
                        }
                    } else if (rowState == 1) {
                        Row insertRow;
                        int oldBookmark = this.getBookmarkIncludeDeleteByOID(oid);
                        if (oldBookmark < 0) {
                            insertRow = DataTableExUtil.appendDataTable(this.data);
                        } else {
                            insertRow = DataTableExUtil.getRowByBookmark(this.data, oldBookmark);
                            if (!insertRow.isDeleted()) {
                                throw new RuntimeException("\u65b0\u589e\u6570\u636e\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
                            }
                            if (insertRow.getOriginalDataList() == null) {
                                insertRow.createOriginData();
                            }
                        }
                        Object[] insertRowDataList = insertRow.getDataList();
                        Object[] defaultValues = NewRowDefaultValuesCache.getDefaultValues(this.tableName);
                        System.arraycopy(defaultValues, 0, insertRowDataList, 0, defaultValues.length);
                        rowDataList = row.getDataList();
                        int i4 = 0;
                        while (i4 < columnSize) {
                            tmpColumnIndex = columnIndexes[i4];
                            if (tmpColumnIndex >= 0) {
                                insertRowDataList[tmpColumnIndex] = this.convertValue(rowDataList[i4], columnInfos[i4]);
                            }
                            ++i4;
                        }
                        if (insertRow.isDeleted()) {
                            this.data.recoverRow(insertRow);
                            this.updateRow_updateIndex(cacheDB, insertRow);
                        } else {
                            insertRow.setState(1);
                        }
                        this.insertRow_updateIndex(cacheDB, insertRow);
                    }
                    ++rowIndex;
                }
                this.isChanged = true;
            }
            return true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected Object convertValue(Object value, ColumnInfo columnInfo) {
        Integer caseType;
        int columnFieldType = columnInfo.getDataType();
        if ((columnFieldType == 1002 || columnFieldType == 1012 || columnFieldType == 1011) && (caseType = Integer.valueOf(columnInfo.getCaseType())) != null) {
            if (1 == caseType) {
                value = ((String)value).toLowerCase();
            } else if (2 == caseType) {
                value = ((String)value).toUpperCase();
            }
        }
        return value;
    }

    private void loadNotLoadUpdateRow(DataTable dataTable, IDBManager dbManager, int oidColumnIndex, int[] columnIndexes, boolean isOnlyCheckVer4GlobalTable) throws Throwable {
        int dataColumnSize;
        int cacheColumnSize = this.data.getMetaData().getColumnCount();
        boolean hasAllColumn = cacheColumnSize == (dataColumnSize = dataTable.getMetaData().getColumnCount()) || cacheColumnSize == dataColumnSize + 1 && !dataTable.getMetaData().constains("Slock");
        ArrayList<Long> notLoadUpdateOIDList = new ArrayList<Long>();
        int rowIndex = 0;
        int rowSize = dataTable.size();
        while (rowIndex < rowSize) {
            Long oid;
            Row row = DataTableExUtil.getRowByIndex(dataTable, rowIndex);
            if (isOnlyCheckVer4GlobalTable) {
                if (row.isModified() || row.isDeleted()) {
                    oid = TypeConvertor.toLong((Object)row.getObject(oidColumnIndex));
                    if (this.oidIndex == null || this.oidIndex.getOrDefault(oid, -1) == -1) {
                        notLoadUpdateOIDList.add(oid);
                    }
                }
            } else if (row.isModified()) {
                oid = TypeConvertor.toLong((Object)row.getObject(oidColumnIndex));
                if (this.oidIndex == null || this.oidIndex.getOrDefault(oid, -1) == -1) {
                    if (hasAllColumn) {
                        Row newRow = DataTableExUtil.appendDataTable(this.data);
                        newRow.setState(0);
                        Object[] newDataList = newRow.getDataList();
                        Object[] orgDataList = row.getOriginalDataList();
                        int i = 0;
                        int size = columnIndexes.length;
                        while (i < size) {
                            int tmpColumnIndex = columnIndexes[i];
                            if (tmpColumnIndex >= 0) {
                                newDataList[tmpColumnIndex] = orgDataList[i];
                            }
                            ++i;
                        }
                        newRow.updateIndex();
                        int bookmark = newRow.getBookmark();
                        this.getHasLoadedOIDsNotNull().put(oid, bookmark);
                    } else {
                        notLoadUpdateOIDList.add(oid);
                    }
                }
            }
            ++rowIndex;
        }
        int notLoadUpdateOIDSize = notLoadUpdateOIDList.size();
        if (notLoadUpdateOIDSize > 0) {
            Long[] notLoadUpdateOIDs = notLoadUpdateOIDList.toArray(new Long[notLoadUpdateOIDSize]);
            PreLoad.preLoadByOIDs(this, dbManager, notLoadUpdateOIDs);
        }
    }

    private int getBookmarkIncludeDeleteByOID(Long oid) throws Throwable {
        ArrayList<Row> rows;
        int size;
        int result = -1;
        if (this.oidIndex != null) {
            result = this.oidIndex.getOrDefault(oid, -1);
        }
        if (result == -1 && (size = (rows = DataTableExUtil.getAllDataList(this.data)).size()) != this.data.size()) {
            int oidIndex = this.getOIDColumnIndex();
            int i = 0;
            while (i < size) {
                Row row = rows.get(i);
                if (row.isDeleted() && oid.equals(row.getObject(oidIndex))) {
                    result = row.getBookmark();
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public void submit(CacheDBRequest cacheDBRequest, IDBManager dbManager, boolean isLastUpdateBeforeCommit) throws Throwable {
        if (this.data == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            if (this.data == null) {
                return;
            }
            if (this.isChanged) {
                this.data.setShowDeleted(true);
                if (this.data.size() > 0) {
                    SubmitDataTable.saveDataTableData(cacheDBRequest, dbManager, this.data, this.tableName, isLastUpdateBeforeCommit);
                    MQGenData.genMQData(dbManager, cacheDBRequest.cacheDB.mqData, this.data, this.tableName);
                    if (dbManager instanceof MultiDBManager) {
                        ((MultiDBManager)dbManager).moveHeadData(this.tableName);
                    }
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void submitAndRemoveDelete(CacheDBRequest cacheDBRequest, IDBManager dbManager) throws Throwable {
        if (this.data == null || !this.isChanged) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            if (this.data == null || !this.isChanged) {
                return;
            }
            this.data.setShowDeleted(true);
            if (this.data.first()) {
                boolean flag = true;
                CacheDB cacheDB = cacheDBRequest.cacheDB;
                int oidColumnIndex = this.getOIDColumnIndex();
                int soidColumnIndex = this.getSOIDColumnIndex();
                int verIDColumnIndex = this.data.getMetaData().findColumnIndexByKey("VERID");
                if (CacheTable.isBPMTable(this.tableName)) {
                    verIDColumnIndex = -1;
                }
                int index = this.data.size() - 1;
                while (index >= 0) {
                    int state;
                    Row row = DataTableExUtil.getRowByIndex(this.data, index);
                    if (row != null && (state = row.getState()) != 0) {
                        if (flag) {
                            SubmitDataTable.saveDataTableData(cacheDBRequest, dbManager, this.data, this.tableName, false);
                            MQGenData.genMQData(dbManager, cacheDBRequest.cacheDB.mqData, this.data, this.tableName);
                            flag = false;
                        }
                        if (state == 1 || state == 2) {
                            int oldVerID = -1;
                            Object[] originalDataList = row.getOriginalDataList();
                            if (verIDColumnIndex >= 0 && originalDataList != null) {
                                oldVerID = TypeConvertor.toInteger((Object)originalDataList[verIDColumnIndex]);
                            }
                            row.stateUpdate();
                            if (verIDColumnIndex >= 0 && oldVerID >= 0) {
                                row.createOriginData();
                                Object[] newOriginalDataList = row.getOriginalDataList();
                                newOriginalDataList[verIDColumnIndex] = oldVerID;
                            }
                        } else {
                            List<Integer> bkmks;
                            Object SOID;
                            Long OID = oidColumnIndex >= 0 ? (Long)row.getObject(oidColumnIndex) : -1L;
                            Object object = SOID = soidColumnIndex >= 0 ? row.getObject(soidColumnIndex) : Integer.valueOf(-1);
                            if (this.oidIndex != null) {
                                this.oidIndex.remove(OID);
                            }
                            if (this.soidIndex != null && (bkmks = this.soidIndex.get(SOID)) != null) {
                                bkmks.remove((Object)row.getBookmark());
                            }
                            cacheDB.clearBillEntity(VarUtil.toLong((Object)SOID));
                            this.data.forceRemove(index);
                        }
                    }
                    --index;
                }
                if (this.data.size() == 0) {
                    this.data = null;
                } else {
                    this.data.setShowDeleted(false);
                }
                this.isChanged = false;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void rollback(CacheDBRequest cacheDBRequest, IDBManager dbManager) {
        if (this.data == null) {
            return;
        }
        this.clear();
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            if (this.oidIndex != null) {
                this.oidIndex.clear();
                this.oidIndex = null;
            }
            if (this.soidIndex != null) {
                this.soidIndex.clear();
                this.soidIndex = null;
            }
            if (this.newInsertSOIDs != null) {
                this.newInsertSOIDs.clear();
                this.newInsertSOIDs = null;
            }
            if (this.data != null) {
                this.data.clear();
            }
            this.data = null;
            this.isChanged = false;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clearBillEntity(CacheDB cacheDB) {
        this.lock.readLock().lock();
        try {
            int soidColumnIndex = this.getSOIDColumnIndex();
            if (soidColumnIndex >= 0) {
                int size = this.data == null ? 0 : this.data.size();
                int i = 0;
                while (i < size) {
                    Long soid = this.data.getLong(i, soidColumnIndex);
                    cacheDB.clearBillEntity(soid);
                    ++i;
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public DataTable queryByOID(IDBManager dbManager, Long oid) throws Throwable {
        DataTable result = this.queryByOID(oid);
        if (result == null && PreLoad.preLoadByOID(this, dbManager, oid)) {
            result = this.queryByOID(oid);
        }
        return result;
    }

    private DataTable queryByOID(Long oid) throws Throwable {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            if (this.oidIndex != null) {
                DataTable result = null;
                Integer tmp = this.oidIndex.get(oid);
                if (tmp != null) {
                    int bookmark = tmp;
                    if (bookmark >= 0) {
                        int rowIndex = DataTableExUtil.getRowIndexByBookmark(this.data, bookmark);
                        result = DataTableResultSetUtil.newResultSet(this.data, new int[]{rowIndex});
                    } else {
                        result = DataTableResultSetUtil.newResultSet(this.data, ArrayUtils.EMPTY_INT_ARRAY);
                    }
                    if (result != null && !result.first()) {
                        result.beforeFirst();
                    }
                }
                DataTable dataTable = result;
                return dataTable;
            }
            return null;
        }
        finally {
            readLock.unlock();
        }
    }

    public DataTable queryByWhereExpression(CacheDB cacheDB, IDBManager dbManager, WhereExpressionForCache whereExpression, SortCriteria[] sorts) throws Throwable {
        DataTable result = this.queryByWhereExpression(cacheDB, whereExpression, sorts);
        if (result == null && PreLoad.preLoadByExpression(this, dbManager, whereExpression)) {
            result = this.queryByWhereExpression(cacheDB, whereExpression, sorts);
        }
        return result;
    }

    private DataTable queryByWhereExpression(CacheDB cacheDB, WhereExpressionForCache whereExpression, SortCriteria[] sorts) throws Throwable {
        if (this.data == null) {
            return null;
        }
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            Integer temp;
            if (this.data == null) {
                return null;
            }
            DataTable result = null;
            if (this.oidIndex != null && !whereExpression.oid.equals(WhereExpressionForCache.Long_NotExist) && (temp = this.oidIndex.get(whereExpression.oid)) != null) {
                result = this.query_ExistOID(whereExpression, temp);
            } else if (this.preLoadedArguments != null && this.preLoadedArguments.contains(whereExpression)) {
                int[] validRowIndexes = whereExpression.fastFilter(this.data);
                if (sorts != null && validRowIndexes.length > 1) {
                    validRowIndexes = this.data.fastSort(validRowIndexes, sorts);
                }
                result = DataTableResultSetUtil.newResultSet(this.data, validRowIndexes);
            } else if (!whereExpression.soid.equals(WhereExpressionForCache.Long_NotExist)) {
                List<Integer> tmps;
                Long soid = whereExpression.soid;
                if (this.oidIndex != null && (temp = this.oidIndex.get(soid)) != null) {
                    result = this.query_ExistOID(whereExpression, temp);
                } else if (this.soidIndex != null && (tmps = this.soidIndex.get(soid)) != null) {
                    Object tempValidRowIndexes = this.isMatch(tmps, whereExpression, false, true);
                    int[] validRowIndexes = (int[])tempValidRowIndexes;
                    if (sorts != null && validRowIndexes.length > 1) {
                        validRowIndexes = this.data.fastSort(validRowIndexes, sorts);
                    }
                    result = DataTableResultSetUtil.newResultSet(this.data, validRowIndexes);
                }
                if (result == null) {
                    String secondField;
                    String string = secondField = TablePrimarySetting.hasGroupSOIDUniqueIndex(this.tableName) ? TablePrimarySetting.getGroupSOIDUniqueIndexSecondField(this.tableName) : null;
                    if (!whereExpression.soid.equals(WhereExpressionForCache.Long_NotExist) && secondField != null && whereExpression.hasField(secondField)) {
                        long secondFieldValue = TypeConvertor.toLong((Object)whereExpression.hasValue(secondField));
                        int rowIndex = 0;
                        int size = this.data.size();
                        while (rowIndex < size) {
                            Row row = DataTableExUtil.getRowByIndex(this.data, rowIndex);
                            if (this.isMatchGroupUnique(row, soid, secondFieldValue)) {
                                Object match = this.isMatch(row, whereExpression, false, false);
                                if (((Boolean)match).booleanValue()) {
                                    result = DataTableResultSetUtil.newResultSet(this.data, new int[]{rowIndex});
                                    break;
                                }
                                result = DataTableResultSetUtil.newResultSet(this.data, ArrayUtils.EMPTY_INT_ARRAY);
                                break;
                            }
                            ++rowIndex;
                        }
                    }
                }
                if (result != null && !result.first()) {
                    result.beforeFirst();
                }
            } else if (this.isRefNewInsertOIDs(cacheDB, whereExpression)) {
                int[] validRowIndexes = whereExpression.fastFilter(this.data);
                if (sorts != null && validRowIndexes.length > 1) {
                    validRowIndexes = this.data.fastSort(validRowIndexes, sorts);
                }
                result = DataTableResultSetUtil.newResultSet(this.data, validRowIndexes);
            }
            DataTable dataTable = result;
            return dataTable;
        }
        finally {
            readLock.unlock();
        }
    }

    private boolean isRefNewInsertOIDs(CacheDB cacheDB, WhereExpressionForCache whereExpression) throws Throwable {
        Long refSOID;
        int whereIndex;
        HeadDetailTable headDetailTable = HeadDetailTables.instance.getHeadDetailTableByDetailTableName(this.tableName);
        return headDetailTable != null && (whereIndex = whereExpression.getFieldIndex(headDetailTable.columnNameRefHeadOID)) >= 0 && whereExpression.operationIDs[whereIndex] == 2 && cacheDB.isNewInsertSOID(headDetailTable.headTableName, refSOID = (Long)whereExpression.columnValues[whereIndex]);
    }

    private DataTable query_ExistOID(WhereExpressionForCache whereExpression, Integer tmpBookmark) throws Throwable {
        DataTable result = null;
        int bookmark = tmpBookmark;
        if (bookmark >= 0) {
            Row row;
            Object match;
            int rowIndex = DataTableExUtil.getRowIndexByBookmark(this.data, bookmark);
            result = whereExpression.soid.equals(WhereExpressionForCache.Long_NotExist) && whereExpression.columnNames == null ? DataTableResultSetUtil.newResultSet(this.data, new int[]{rowIndex}) : (VarUtil.toBoolean((Object)(match = this.isMatch(row = DataTableExUtil.getRowByIndex(this.data, rowIndex), whereExpression, true, false))).booleanValue() ? DataTableResultSetUtil.newResultSet(this.data, new int[]{rowIndex}) : DataTableResultSetUtil.newResultSet(this.data, ArrayUtils.EMPTY_INT_ARRAY));
        } else {
            result = DataTableResultSetUtil.newResultSet(this.data, ArrayUtils.EMPTY_INT_ARRAY);
        }
        return result;
    }

    private Object isMatch(Row row, WhereExpressionForCache whereExpression, boolean oidMatch, boolean soidMatch) {
        Object value;
        Object[] dataList = row.getDataList();
        if (!oidMatch && !whereExpression.oid.equals(WhereExpressionForCache.Long_NotExist) && whereExpression.oid.compareTo(VarUtil.toLong((Object)(value = dataList[this.getOIDColumnIndex()]))) != 0) {
            return false;
        }
        if (!soidMatch && !whereExpression.soid.equals(WhereExpressionForCache.Long_NotExist) && whereExpression.soid.compareTo(VarUtil.toLong((Object)(value = dataList[this.getSOIDColumnIndex()]))) != 0) {
            return false;
        }
        if (whereExpression.columnNames != null) {
            int length = whereExpression.columnNames.length;
            if (whereExpression.columnIndexes == null) {
                whereExpression.columnIndexes = new int[length];
                whereExpression.dataTypeActions = new DataTypeAction[length];
                DataTableMetaData metaData = this.data.getMetaData();
                int i = 0;
                while (i < length) {
                    int tmp;
                    whereExpression.columnIndexes[i] = tmp = metaData.findColumnIndexByKey(whereExpression.columnNames[i]);
                    whereExpression.dataTypeActions[i] = metaData.getColumnInfo(tmp).getDataTypeAction();
                    ++i;
                }
            }
            int i = 0;
            while (i < length) {
                Object value2 = dataList[whereExpression.columnIndexes[i]];
                if (!WhereExpressionForCache.isOperationMatch(whereExpression.operationIDs[i], whereExpression.dataTypeActions[i].compare(value2, whereExpression.columnValues[i]))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private Object isMatch(List<Integer> bookmarks, WhereExpressionForCache whereExpression, boolean oidMatch, boolean soidMatch) throws Throwable {
        if (bookmarks == null || bookmarks.size() > 8) {
            return whereExpression.fastFilter(this.data);
        }
        int bookmarkSize = bookmarks.size();
        if (bookmarkSize > 8) {
            return whereExpression.fastFilter(this.data);
        }
        ArrayList<Integer> validRowIndexes = new ArrayList<Integer>(bookmarkSize);
        Long oid = whereExpression.oid;
        Long soid = whereExpression.soid;
        String[] columnNames = whereExpression.columnNames;
        int length = columnNames == null ? 0 : columnNames.length;
        Object[] columnValues = whereExpression.columnValues;
        int[] columnIndexes = whereExpression.columnIndexes;
        DataTypeAction[] dataTypeActions = whereExpression.dataTypeActions;
        if (columnIndexes == null) {
            columnIndexes = new int[length];
            dataTypeActions = new DataTypeAction[length];
            DataTableMetaData metaData = this.data.getMetaData();
            int i = 0;
            while (i < length) {
                int tmp;
                columnIndexes[i] = tmp = metaData.findColumnIndexByKey(columnNames[i]);
                dataTypeActions[i] = metaData.getColumnInfo(tmp).getDataTypeAction();
                ++i;
            }
            whereExpression.columnIndexes = columnIndexes;
            whereExpression.dataTypeActions = dataTypeActions;
        }
        boolean onlySOID = oid.equals(WhereExpressionForCache.Long_NotExist) && columnNames == null;
        boolean checkOID = !oidMatch && !oid.equals(WhereExpressionForCache.Long_NotExist);
        boolean checkSOID = !soidMatch && !soid.equals(WhereExpressionForCache.Long_NotExist);
        HashMap<Integer, Integer> bookmarkMap = DataTableExUtil.getBookmarkMap(this.data);
        for (Integer bookmark : bookmarks) {
            boolean match;
            int rowIndex = bookmarkMap.get(bookmark);
            if (rowIndex == -1) continue;
            if (onlySOID) {
                validRowIndexes.add(rowIndex);
                continue;
            }
            Row row = DataTableExUtil.getRowByIndex(this.data, rowIndex);
            Object[] dataList = row.getDataList();
            boolean bl = match = !(checkOID && oid != dataList[this.getOIDColumnIndex()] || checkSOID && soid != dataList[this.getSOIDColumnIndex()]);
            if (match && columnNames != null) {
                int i = 0;
                while (i < length) {
                    Object value = dataList[columnIndexes[i]];
                    if (!WhereExpressionForCache.isOperationMatch(whereExpression.operationIDs[i], dataTypeActions[i].compare(value, columnValues[i]))) {
                        match = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!match) continue;
            validRowIndexes.add(rowIndex);
        }
        return ArrayUtils.toPrimitive((Integer[])validRowIndexes.toArray(new Integer[validRowIndexes.size()]));
    }

    public boolean isIntersect(ParsedSql parsedSql, QueryArguments arguments, List<QueryArguments> argumentsList) throws Throwable {
        if (this.data == null) {
            return false;
        }
        this.lock.readLock().lock();
        try {
            if (this.data == null) {
                return false;
            }
            if (DataTableExUtil.hasDeletedRow(this.data)) {
                return true;
            }
            if (this.data.size() == 0) {
                return false;
            }
            if (arguments != null && parsedSql instanceof ParsedSelect && parsedSql.isOnlyOIDOrSOID()) {
                ParsedSelect parsedSelect = (ParsedSelect)parsedSql;
                if (parsedSelect.hasOIDWhere()) {
                    LongOrLongArray oids = LongOrLongArray.getLongs(arguments, parsedSelect.getOIDIndex());
                    int[] foundRowIndexes = LongOrLongArray.dataTableFastFilter(this.data, TablePrimarySetting.getOIDField(this.tableName), oids);
                    return foundRowIndexes != null && foundRowIndexes.length > 0;
                    {
                    }
                }
                if (parsedSelect.hasSOIDWhere()) {
                    Long soid = TypeConvertor.toLong((Object)arguments.get(parsedSelect.getSOIDIndex()));
                    int[] foundRowIndexes = this.data.fastFilter(TablePrimarySetting.getSOIDField(this.tableName), (Object)soid);
                    return foundRowIndexes != null && foundRowIndexes.length > 0;
                    {
                    }
                }
            }
            return true;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<WhereExpressionForCache> getPreLoadingArguments() {
        return this.preLoadingArguments;
    }

    public void clearPreLoadingArguments() {
        if (this.preLoadedArguments == null) {
            this.preLoadedArguments = this.preLoadingArguments;
            this.preLoadingArguments = null;
        } else {
            this.preLoadedArguments.addAll(this.preLoadingArguments);
            this.preLoadingArguments.clear();
            this.preLoadingArguments = null;
        }
    }

    public void addPreLoadingArgument(WhereExpressionForCache whereExpressionForCache) {
        if (this.preLoadingArguments == null) {
            this.preLoadingArguments = new ArrayList<WhereExpressionForCache>();
        }
        if (!this.preLoadingArguments.contains(whereExpressionForCache)) {
            this.preLoadingArguments.add(whereExpressionForCache);
        }
    }

    public boolean existSOID(Long soid) {
        return this.soidIndex != null && this.soidIndex.containsKey(soid);
    }

    public boolean existOID(Long oid) {
        return this.oidIndex != null && this.oidIndex.containsKey(oid);
    }

    public boolean existOIDs(LongOrLongArray oids) {
        return this.oidIndex != null && LongOrLongArray.isMapContainsKey(this.oidIndex, oids);
    }

    public boolean dataIsNull() {
        return this.data == null;
    }

    public Object getValueByOID(Long oid, String columnName) {
        int bookmark;
        int n = bookmark = this.oidIndex == null ? -1 : this.oidIndex.getOrDefault(oid, -1);
        if (bookmark == -1) {
            return null;
        }
        int rowIndex = this.data.getRowIndexByBookmark(bookmark);
        return this.data.getObject(rowIndex, columnName);
    }

    public Object getOrgValueByOID(Long oid, String columnName) {
        int bookmark;
        int n = bookmark = this.oidIndex == null ? -1 : this.oidIndex.getOrDefault(oid, -1);
        if (bookmark == -1) {
            if (this.data != null && this.data.isShowDeleted()) {
                int oidColumnIndex = this.getOIDColumnIndex();
                int rowIndex = 0;
                int size = this.data.size();
                while (rowIndex < size) {
                    if (oid.equals(this.data.getLong(rowIndex, oidColumnIndex))) {
                        return this.data.getObject(rowIndex, columnName);
                    }
                    ++rowIndex;
                }
            }
            return null;
        }
        int rowIndex = this.data.getRowIndexByBookmark(bookmark);
        return this.data.getOriginalObject(rowIndex, columnName);
    }

    public Long[] getOIDsBySOID(Long soid) throws Throwable {
        if (this.data != null && this.soidIndex != null && this.soidIndex.containsKey(soid)) {
            List<Integer> bkmks = this.soidIndex.get(soid);
            int size = bkmks.size();
            Long[] result = new Long[size];
            int i = 0;
            while (i < size) {
                int rowIndex = DataTableExUtil.getRowIndexByBookmark(this.data, bkmks.get(i));
                if (rowIndex == -1) {
                    throw new RuntimeException("SQL\u7f13\u5b58\u9519\u8bef\uff0cSOID\u7d22\u5f15\u4e2d\u6709\u4e0d\u5b58\u5728\u7684\u884c");
                }
                result[i] = (Long)this.data.getObject(rowIndex, this.getOIDColumnIndex());
                ++i;
            }
            return result;
        }
        return null;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "@" + this.tableName;
    }

    public void setSOIDLoadAll(Long soid) throws Throwable {
        ReentrantReadWriteLock.WriteLock w = this.lock.writeLock();
        w.lock();
        try {
            if (this.getHasLoadedOIDsNotNull().containsKey(soid)) {
                return;
            }
            this.initDataStruct();
            int[] rowIndexes = this.data.fastFilter("SOID", (Object)soid);
            int size = rowIndexes.length;
            ArrayList<Integer> bkmks = new ArrayList<Integer>(size);
            int i = 0;
            while (i < size) {
                int rowIndex = rowIndexes[i];
                bkmks.add(this.data.getBookmark(rowIndex));
                ++i;
            }
            this.getHasLoadedSOIDsNotNull().put(soid, bkmks);
        }
        finally {
            w.unlock();
        }
    }

    public static boolean isBPMTable(String tableName) {
        return StringUtils.startsWithIgnoreCase((CharSequence)tableName, (CharSequence)"BPM_");
    }
}

