/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache.parsedsql;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.mid.dbcache.parsedsql.DeParser;
import com.bokesoft.yes.mid.dbcache.parsedsql.IntOrIntArray;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSelect;
import com.bokesoft.yes.mid.mysqls.sql.FindJdbcParameter;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import java.util.List;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.Statement;
import net.boke.jsqlparser.statement.delete.Delete;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.Select;
import net.boke.jsqlparser.statement.update.Update;
import net.boke.jsqlparser.util.deparser.ExpressionDeParser;
import net.boke.jsqlparser.util.deparser.SelectDeParser;
import org.apache.commons.lang3.StringUtils;

public abstract class ParsedSql {
    final String sql;
    private List<String> tableNames;
    protected static HashMapIgnoreCase<MetaDataObject> allKeysTableFocusChangeDataObjects;
    private List<JdbcParameter> jdbcParameters;
    private int jdbcParameterCount = -1;
    protected IntOrIntArray oidIndex = null;
    protected int soidIndex = -1;
    protected int poidIndex = -1;
    protected boolean isOnlyOidOrSoid = true;

    public ParsedSql(String sql) {
        this.sql = sql;
    }

    public abstract boolean isSupportCache() throws Throwable;

    public List<String> getTableNames() {
        if (this.tableNames == null) {
            this.tableNames = this.findTableNames();
        }
        return this.tableNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static MetaDataObject getKeysTableFocusChangeDataObject(String tableName) throws Throwable {
        if (allKeysTableFocusChangeDataObjects != null) return (MetaDataObject)allKeysTableFocusChangeDataObjects.get(tableName);
        Class<ParsedSelect> clazz = ParsedSelect.class;
        synchronized (ParsedSelect.class) {
            if (allKeysTableFocusChangeDataObjects != null) return (MetaDataObject)allKeysTableFocusChangeDataObjects.get(tableName);
            HashMapIgnoreCase tmp = new HashMapIgnoreCase();
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            for (MetaDataObjectProfile metaDataObjectProfile : metaFactory.getDataObjectList()) {
                MetaDataObject metaDataObject;
                if (metaDataObjectProfile.getPrimaryType() != 0 || metaDataObjectProfile.getSecondaryType() != 6 || (metaDataObject = metaFactory.getDataObject(metaDataObjectProfile.getKey())).getMigrationUpdateStrategy() != 5) continue;
                MetaTable metaTable = metaDataObject.getMainTable();
                tmp.put(metaTable.getBindingDBTableName(), (Object)metaDataObject);
            }
            allKeysTableFocusChangeDataObjects = tmp;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (MetaDataObject)allKeysTableFocusChangeDataObjects.get(tableName);
        }
    }

    protected static DeParser getSelectDeParser(final List<String> tmp, StringBuffer buffer) {
        SelectDeParser selectDeParser = new SelectDeParser(){

            @Override
            public void visit(Table table) {
                String tableName = table.getName();
                tmp.add(tableName);
                try {
                    MetaDataObject dataObject = ParsedSql.getKeysTableFocusChangeDataObject(tableName);
                    if (dataObject != null) {
                        tmp.add(dataObject.getErpMigrationIncrTable().getBindingDBTableName());
                        tmp.add(dataObject.getErpMigrationKeysTable().getBindingDBTableName());
                        tmp.add(dataObject.getErpMigrationNewTable().getBindingDBTableName());
                        MetaTable lpTable = dataObject.getMigrationLastPointTable();
                        if (lpTable != null) {
                            tmp.add(lpTable.getBindingDBTableName());
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                super.visit(table);
            }
        };
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        selectDeParser.setBuffer(buffer);
        return new DeParser(expressionDeParser, selectDeParser);
    }

    protected abstract List<String> findTableNames();

    public abstract Statement getStatement();

    public List<JdbcParameter> getJdbcParameters() {
        Statement statement;
        if (this.jdbcParameters == null && (statement = this.getStatement()) != null) {
            this.jdbcParameters = FindJdbcParameter.getAllJdbcParameters(statement);
        }
        return this.jdbcParameters;
    }

    public int getJDBCParameterCount() {
        if (this.jdbcParameterCount == -1) {
            List<JdbcParameter> jdbcParameters = this.getJdbcParameters();
            this.jdbcParameterCount = jdbcParameters == null ? StringUtils.countMatches((CharSequence)this.sql, (CharSequence)"?") : jdbcParameters.size();
        }
        return this.jdbcParameterCount;
    }

    public String getCacheTableName() {
        return this.getTableNames().get(0);
    }

    public boolean hasOIDWhere() {
        return this.oidIndex != null;
    }

    public IntOrIntArray getOIDIndex() {
        return this.oidIndex;
    }

    public boolean setOIDIndex(int index) {
        if (this.oidIndex != null) {
            return false;
        }
        this.oidIndex = new IntOrIntArray(index);
        return true;
    }

    public boolean setOIDIndex(int[] indexArray) {
        if (this.oidIndex != null) {
            return false;
        }
        this.oidIndex = new IntOrIntArray(indexArray);
        return true;
    }

    public boolean hasSOIDWhere() {
        return this.soidIndex >= 0;
    }

    public int getSOIDIndex() {
        return this.soidIndex;
    }

    public boolean setSOIDIndex(int index) {
        if (this.soidIndex >= 0) {
            return false;
        }
        this.soidIndex = index;
        return true;
    }

    public int getPOIDIndex() {
        return this.poidIndex;
    }

    public void setPOIDIndex(int poidIndex) {
        this.poidIndex = poidIndex;
    }

    public boolean hasPOIDWhere() {
        return this.getPOIDIndex() >= 0;
    }

    public boolean isOnlyOIDOrSOID() {
        return this.isOnlyOidOrSoid;
    }

    public boolean isOnlyOidIn() {
        return this.hasOIDWhere() && this.oidIndex.getValueArray() != null && this.isOnlyOidOrSoid;
    }

    public Expression getWhereClause() {
        Statement statement = this.getStatement();
        if (statement instanceof Select) {
            return ((PlainSelect)((Select)statement).getSelectBody()).getWhere();
        }
        if (statement instanceof Update) {
            return ((Update)statement).getWhere();
        }
        if (statement instanceof Delete) {
            return ((Delete)statement).getWhere();
        }
        return null;
    }

    public String toString() {
        return this.sql;
    }

    public int hashCode() {
        return this.sql.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ParsedSelect)) {
            return false;
        }
        return this.sql.equals(((ParsedSelect)obj).sql);
    }
}

