/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache.parsedsql;

import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.mid.dbcache.config.GlobalSetting;
import com.bokesoft.yes.mid.dbcache.config.IgnoreSqlCacheSetting;
import com.bokesoft.yes.mid.dbcache.config.TablePrimarySetting;
import com.bokesoft.yes.mid.dbcache.datatable.CacheDataTable;
import com.bokesoft.yes.mid.dbcache.datatable.ReadOnlyDataTable;
import com.bokesoft.yes.mid.dbcache.parsedsql.DeParser;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSql;
import com.bokesoft.yes.mid.dbcache.structure.OrderBy;
import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.expression.Parenthesis;
import net.boke.jsqlparser.expression.operators.conditional.AndExpression;
import net.boke.jsqlparser.expression.operators.conditional.OrExpression;
import net.boke.jsqlparser.expression.operators.relational.Between;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.expression.operators.relational.GreaterThan;
import net.boke.jsqlparser.expression.operators.relational.InExpression;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.Statement;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.Limit;
import net.boke.jsqlparser.statement.select.OrderByElement;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.Select;
import net.boke.jsqlparser.statement.select.SelectBody;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;
import net.boke.jsqlparser.statement.select.SubSelect;

public class ParsedSelect
extends ParsedSql {
    final Select select;
    private List<OrderBy> orderByObjects;
    private DataTableMetaData dataTableMetaData = null;
    private Boolean isSupportCache;
    private String[] selectFields;
    private int secondFieldIndex = -1;
    private Boolean isGlobalQuery = null;
    private int[] columnIndexes;

    public ParsedSelect(String sql, Select select) {
        super(sql);
        this.select = select;
    }

    @Override
    public Statement getStatement() {
        return this.select;
    }

    public DataTableMetaData getDataTableMetaData() throws Throwable {
        return this.dataTableMetaData;
    }

    public void setDataTableMetaData(DataTableMetaData metaData) {
        if (this.dataTableMetaData != null) {
            throw new RuntimeException("ERROR");
        }
        this.dataTableMetaData = metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSupportCache() throws Throwable {
        if (this.isSupportCache == null) {
            ParsedSelect parsedSelect = this;
            synchronized (parsedSelect) {
                if (this.isSupportCache == null) {
                    boolean isSupportSqlField;
                    boolean notOnlyOneTable = this.getTableNames().size() != 1;
                    boolean bl = isSupportSqlField = !this.isSelectItemsSupport();
                    this.isSupportCache = notOnlyOneTable || isSupportSqlField ? Boolean.valueOf(false) : (!this.isWhereClauseSupport() ? Boolean.valueOf(false) : (!this.isLimitSupport() ? Boolean.valueOf(false) : (!this.isOrderBySupport() ? Boolean.valueOf(false) : (this.isSubSelectSupport() ? Boolean.valueOf(false) : Boolean.valueOf(MetaTableCache.getFullMetaTable(this.getCacheTableName()) != null && IgnoreSqlCacheSetting.isSupportCacheTables(this.getTableNames()))))));
                }
            }
        }
        return this.isSupportCache;
    }

    private boolean isSelectItemsSupport() {
        boolean result = true;
        List items = ((PlainSelect)this.select.getSelectBody()).getSelectItems();
        int size = items.size();
        String[] selectFieldsTmp = new String[size];
        int i = 0;
        while (i < size) {
            String columnKey;
            Object item = items.get(i);
            if (item instanceof SelectExpressionItem) {
                SelectExpressionItem selectExpressionItem = (SelectExpressionItem)item;
                Expression expression = selectExpressionItem.getExpression();
                if (!(expression instanceof Column)) {
                    selectFieldsTmp = null;
                    result = false;
                    break;
                }
                columnKey = ((Column)expression).getColumnName();
                String alias = selectExpressionItem.getAlias();
                if (alias != null && !alias.equalsIgnoreCase(columnKey)) {
                    selectFieldsTmp = null;
                    result = false;
                    break;
                }
            } else {
                selectFieldsTmp = null;
                result = false;
                break;
            }
            selectFieldsTmp[i] = columnKey;
            ++i;
        }
        this.selectFields = selectFieldsTmp;
        return result;
    }

    private boolean isWhereClauseSupport() {
        String tableName = this.getTableNames().get(0);
        String oidField = TablePrimarySetting.getOIDField(tableName);
        String soidField = TablePrimarySetting.getSOIDField(tableName);
        String secondField = TablePrimarySetting.hasGroupSOIDUniqueIndex(tableName) ? TablePrimarySetting.getGroupSOIDUniqueIndexSecondField(tableName) : null;
        Expression where = this.getWhereClause();
        if (!this.parseWhere(where, oidField, soidField, secondField)) {
            return false;
        }
        if (this.hasOIDWhere()) {
            return true;
        }
        if (this.soidIndex >= 0) {
            boolean itemHasOID = false;
            String[] stringArray = this.selectFields;
            int n = this.selectFields.length;
            int n2 = 0;
            while (n2 < n) {
                String selectField = stringArray[n2];
                if (oidField.equalsIgnoreCase(selectField)) {
                    itemHasOID = true;
                    break;
                }
                ++n2;
            }
            return itemHasOID;
        }
        return false;
    }

    private boolean isSubSelectSupport() {
        PlainSelect selectBody = (PlainSelect)this.select.getSelectBody();
        FromItem fromItem = selectBody.getFromItem();
        if (fromItem != null) {
            return fromItem instanceof SubSelect;
        }
        return false;
    }

    private boolean parseWhere(Expression expression, String oidField, String soidField, String secondField) {
        if (expression instanceof Parenthesis) {
            return this.parseWhere(((Parenthesis)expression).getExpression(), oidField, soidField, secondField);
        }
        if (expression instanceof AndExpression) {
            boolean result1 = this.parseWhere(((AndExpression)expression).getLeftExpression(), oidField, soidField, secondField);
            boolean result2 = this.parseWhere(((AndExpression)expression).getRightExpression(), oidField, soidField, secondField);
            this.isOnlyOidOrSoid = false;
            return result1 && result2;
        }
        if (expression instanceof EqualsTo) {
            EqualsTo binaryExpression = (EqualsTo)expression;
            if (ParsedSqlUtil.isConstant(binaryExpression.getLeftExpression()) && ParsedSqlUtil.isConstant(binaryExpression.getRightExpression())) {
                return true;
            }
            if (!binaryExpression.isNot() && binaryExpression.getLeftExpression() instanceof Column) {
                String columnName = ((Column)binaryExpression.getLeftExpression()).getColumnName();
                Expression value = binaryExpression.getRightExpression();
                if (oidField.equalsIgnoreCase(columnName) && value instanceof JdbcParameter) {
                    JdbcParameter jdbcParameter = (JdbcParameter)value;
                    int oidIndex = jdbcParameter.getIndexInSql();
                    if (oidIndex == -1) {
                        oidIndex = this.getJdbcParameters().indexOf(jdbcParameter);
                        jdbcParameter.setIndexInSql(oidIndex);
                    }
                    return this.setOIDIndex(oidIndex);
                }
                if (columnName.equalsIgnoreCase(soidField) && value instanceof JdbcParameter) {
                    JdbcParameter jdbcParameter = (JdbcParameter)value;
                    int soidIndex = jdbcParameter.getIndexInSql();
                    if (soidIndex == -1) {
                        soidIndex = this.getJdbcParameters().indexOf(jdbcParameter);
                        jdbcParameter.setIndexInSql(soidIndex);
                    }
                    return this.setSOIDIndex(soidIndex);
                }
                if (columnName.equalsIgnoreCase(secondField) && value instanceof JdbcParameter) {
                    JdbcParameter jdbcParameter = (JdbcParameter)value;
                    int secondFieldIndex = jdbcParameter.getIndexInSql();
                    if (secondFieldIndex == -1) {
                        secondFieldIndex = this.getJdbcParameters().indexOf(jdbcParameter);
                        jdbcParameter.setIndexInSql(secondFieldIndex);
                    }
                    this.setSecondFieldIndex(secondFieldIndex);
                }
                return true;
            }
        } else if (expression instanceof InExpression) {
            InExpression inexp = (InExpression)expression;
            String columnName = ((Column)inexp.getLeftExpression()).getColumnName();
            if (oidField.equalsIgnoreCase(columnName) && inexp.getItemsList() instanceof ExpressionList) {
                List expressionList = ((ExpressionList)inexp.getItemsList()).getExpressions();
                int count = expressionList.size();
                int[] indexes = new int[count];
                int i = 0;
                while (i < count) {
                    int index;
                    Object tmp = expressionList.get(i);
                    if (tmp instanceof JdbcParameter) {
                        index = ((JdbcParameter)tmp).getIndexInSql();
                        if (index == -1) {
                            index = this.getJdbcParameters().indexOf(tmp);
                            ((JdbcParameter)tmp).setIndexInSql(index);
                        }
                    } else {
                        return false;
                    }
                    indexes[i] = index;
                    ++i;
                }
                return this.setOIDIndex(indexes);
            }
        } else if (expression instanceof GreaterThan) {
            String columnName;
            GreaterThan greaterThan = (GreaterThan)expression;
            if (greaterThan.getLeftExpression() instanceof Column && oidField.equalsIgnoreCase(columnName = ((Column)greaterThan.getLeftExpression()).getColumnName())) {
                return true;
            }
        } else if (!(expression instanceof Between) && expression instanceof OrExpression) {
            this.isOnlyOidOrSoid = false;
        }
        return false;
    }

    private boolean isLimitSupport() {
        SelectBody selectBody = this.select.getSelectBody();
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            Limit limit = plainSelect.getLimit();
            return limit == null;
        }
        return false;
    }

    private boolean isOrderBySupport() {
        boolean isSupport = false;
        SelectBody selectBody = this.select.getSelectBody();
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            List orderByElements = plainSelect.getOrderByElements();
            if (orderByElements == null) {
                return true;
            }
            for (OrderByElement orderByElement : orderByElements) {
                Expression expression = orderByElement.getExpression();
                if (expression instanceof Column) {
                    isSupport = true;
                    continue;
                }
                isSupport = false;
                break;
            }
        }
        return isSupport;
    }

    public List<OrderBy> getOrderByElements(DataTable dataTable) {
        SelectBody selectBody;
        if (this.orderByObjects == null && (selectBody = this.select.getSelectBody()) instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            List orderByElements = plainSelect.getOrderByElements();
            int size = orderByElements != null ? orderByElements.size() : 0;
            ArrayList<OrderBy> orderByObjectsTmp = new ArrayList<OrderBy>(size);
            int i = 0;
            int length = size;
            while (i < length) {
                Expression expression = ((OrderByElement)orderByElements.get(i)).getExpression();
                boolean isAsc = ((OrderByElement)orderByElements.get(i)).isAsc();
                if (expression instanceof Column) {
                    Column column = (Column)expression;
                    String columnName = column.getColumnName();
                    int columnIndex = dataTable.getMetaData().findColumnIndexByKey(columnName);
                    orderByObjectsTmp.add(new OrderBy(columnName, columnIndex, isAsc));
                }
                ++i;
            }
            this.orderByObjects = orderByObjectsTmp;
        }
        return this.orderByObjects;
    }

    public boolean subSelectHasAlia() {
        SelectBody selectBody = this.select.getSelectBody();
        if (!(selectBody instanceof PlainSelect)) {
            return false;
        }
        boolean result = true;
        FromItem fromItem = ((PlainSelect)selectBody).getFromItem();
        if (fromItem instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)fromItem;
            List items = ((PlainSelect)subSelect.getSelectBody()).getSelectItems();
            int size = items.size();
            int i = 0;
            while (i < size) {
                Object item = items.get(i);
                if (item instanceof SelectExpressionItem) {
                    SelectExpressionItem selectExpressionItem = (SelectExpressionItem)item;
                    String alias = selectExpressionItem.getAlias();
                    Expression expression = selectExpressionItem.getExpression();
                    if (!(expression instanceof Column)) {
                        result = false;
                        break;
                    }
                    String columnKey = ((Column)expression).getColumnName();
                    if (alias != null && !alias.equalsIgnoreCase(columnKey)) {
                        result = false;
                        break;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    protected List<String> findTableNames() {
        ArrayList<String> tmp = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer(512);
        DeParser selectDeParser1 = ParsedSelect.getSelectDeParser(tmp, buffer);
        this.select.getSelectBody().accept(selectDeParser1.getSelectDeParser());
        return tmp;
    }

    public boolean hasSecondFieldWhere() {
        return this.getSecondFieldIndex() >= 0;
    }

    public int getSecondFieldIndex() {
        return this.secondFieldIndex;
    }

    public void setSecondFieldIndex(int index) {
        this.secondFieldIndex = index;
    }

    public boolean isGlobalQuery() throws Throwable {
        if (this.isGlobalQuery == null) {
            List<String> tableNames = this.getTableNames();
            boolean tmp = true;
            for (String tableName : tableNames) {
                if (GlobalSetting.isGlobalTable(tableName)) continue;
                tmp = false;
                break;
            }
            this.isGlobalQuery = tmp;
        }
        return this.isGlobalQuery;
    }

    public int[] getColumnIndexes(DataTable cache) throws Throwable {
        if (this.columnIndexes == null || this.isNeedResetColumnIndex(cache)) {
            String[] selectFields = this.getSelectFields();
            int count = selectFields.length;
            int[] result = new int[count];
            DataTableMetaData metaData = cache.getMetaData();
            int i = 0;
            while (i < count) {
                result[i] = metaData.findColumnIndexByKey(selectFields[i]);
                ++i;
            }
            this.columnIndexes = result;
        }
        return this.columnIndexes;
    }

    private boolean isNeedResetColumnIndex(DataTable table) throws Throwable {
        if (this.columnIndexes == null || !this.isGlobalQuery()) {
            return false;
        }
        if (table instanceof CacheDataTable) {
            return false;
        }
        return !(table instanceof ReadOnlyDataTable);
    }

    public String[] getSelectFields() throws Throwable {
        if (this.selectFields == null) {
            this.isSupportCache();
        }
        return this.selectFields;
    }
}

