/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache.parsedsql;

import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSql;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.boke.jsqlparser.statement.Statement;
import org.apache.commons.lang3.StringUtils;

public class ParsedOther
extends ParsedSql {
    private static List<String> ignoreSQLs;

    public static void setIgnoreSQLs(List<String> ignoreSQLs) {
        ParsedOther.ignoreSQLs = ignoreSQLs;
    }

    public ParsedOther(String sql) {
        super(sql);
    }

    @Override
    public boolean isSupportCache() {
        return false;
    }

    @Override
    public Statement getStatement() {
        return null;
    }

    @Override
    protected List<String> findTableNames() {
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.startsWithIgnoreCase((CharSequence)this.sql, (CharSequence)"DROP INDEX ") || StringUtils.startsWithIgnoreCase((CharSequence)this.sql, (CharSequence)"create unique index ") || StringUtils.startsWithIgnoreCase((CharSequence)this.sql, (CharSequence)"create index ") || StringUtils.startsWithIgnoreCase((CharSequence)this.sql, (CharSequence)"create view ")) {
            return result;
        }
        if (ignoreSQLs != null && ignoreSQLs.contains(this.sql)) {
            return result;
        }
        String exp = "\\b(from|into|update|table|join|drop\\s+view)\\s+((`|\"|\\[)?([a-zA-Z]\\w*)(\"|`|\\])?)";
        Pattern r = Pattern.compile(exp, 2);
        Matcher m = r.matcher(this.sql);
        while (m.find()) {
            String tableName = m.group(4);
            if (tableName.equalsIgnoreCase("dual") || tableName.equalsIgnoreCase("set")) continue;
            result.add(tableName);
        }
        if (result.size() == 0) {
            throw new RuntimeException("\u5f53\u524dSQL\u65e0\u6cd5\u89e3\u6790\uff1a" + this.sql + " \t \u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22.");
        }
        return result;
    }

    @Override
    public List<String> getTableNames() {
        return this.findTableNames();
    }

    @Override
    public String getCacheTableName() {
        return this.getTableNames().get(0);
    }
}

