/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache.commit;

import com.bokesoft.erp.metaobjectchange.MetaObjectChange;
import com.bokesoft.erp.metaobjectchange.MetaObjectChangeListener;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.mid.connection.dbmanager.BatchPsPara;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.dbcache.CacheDBRequest;
import com.bokesoft.yes.mid.dbcache.commit.CacheCommitStruct;
import com.bokesoft.yes.mid.dbcache.commit.UpdateRowState;
import com.bokesoft.yes.mid.dbcache.datatable.DataTableExUtil;
import com.bokesoft.yes.mid.dbcache.datatable.ValueDiff;
import com.bokesoft.yes.mid.io.doc.util.DocLockCheckUtil;
import com.bokesoft.yes.struct.datatable.Row;
import com.bokesoft.yes.util.RefParameter;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SubmitDataTable {
    private static boolean checkIndividually = DocLockCheckUtil.getCheckIndividually();
    public static final String STR_InsertSql_InsertInto = "insert into ";
    public static final String STR_InsertSql_Values = " VALUES ";
    private static Map<MetaTable, CacheCommitStruct> structs = new ConcurrentHashMap<MetaTable, CacheCommitStruct>();

    static {
        MetaObjectChange.register((MetaObjectChangeListener)new MetaObjectChangeListener(){

            public void changeMetaAll() {
                structs = new ConcurrentHashMap();
            }

            public void changeMetaForm(MetaForm metaForm) {
                structs = new ConcurrentHashMap();
            }

            public void changeMetaDataObject(MetaDataObject metaDataObject) {
                structs = new ConcurrentHashMap();
            }
        }, (String)"DBCache");
    }

    public static void setIgnorePrimaryKeyUpdate(boolean flag) {
    }

    public static void saveDataTableData(CacheDBRequest cacheDBRequest, IDBManager dbManager, DataTable rstData, String tableName, boolean isLastUpdateBeforeCommit) throws Throwable {
        MetaTable metaTable = MetaTableCache.getFullMetaTable(tableName);
        if (!metaTable.isPersist().booleanValue()) {
            return;
        }
        CacheCommitStruct struct = structs.get(metaTable);
        if (struct == null) {
            DataTableMetaData tableMetaData = rstData.getMetaData();
            struct = new CacheCommitStruct(metaTable, tableMetaData);
            structs.put(metaTable, struct);
        }
        RefParameter<BatchPsPara> insertBatchRef = new RefParameter<BatchPsPara>();
        HashMap<UpdateRowState, BatchPsPara> updateBatches = new HashMap<UpdateRowState, BatchPsPara>();
        HashMap<Boolean, BatchPsPara> deleteBatches = new HashMap<Boolean, BatchPsPara>();
        SubmitDataTable.createSQL(cacheDBRequest, dbManager, rstData, struct, insertBatchRef, updateBatches, deleteBatches, isLastUpdateBeforeCommit);
        Boolean tmp = cacheDBRequest.stopLocalIsUseCacheDB();
        for (Map.Entry<Boolean, BatchPsPara> entry : deleteBatches.entrySet()) {
            boolean hasVerIDValue = entry.getKey();
            BatchPsPara deleteBatch = entry.getValue();
            if (hasVerIDValue) {
                SubmitDataTable.checkDeleteVerID(dbManager, struct, deleteBatch);
            }
            dbManager.executeUpdateReturn(deleteBatch);
        }
        for (Map.Entry<Object, BatchPsPara> entry : updateBatches.entrySet()) {
            UpdateRowState updateRowState = (UpdateRowState)entry.getKey();
            BatchPsPara updateBatch = entry.getValue();
            int[] result = dbManager.executeUpdateReturn(updateBatch);
            if (!updateRowState.isCheckVerID()) continue;
            SubmitDataTable.checkUpdateVerID(dbManager, result, struct, updateBatch);
        }
        BatchPsPara batchPsPara = insertBatchRef.getValue();
        if (batchPsPara != null) {
            dbManager.executeUpdate(batchPsPara);
        }
        cacheDBRequest.restoreLocalIsUseCacheDB(tmp);
    }

    private static void checkUpdateVerID(IDBManager generalDBManager, int[] result, CacheCommitStruct struct, BatchPsPara batchPsPara) throws Throwable {
        int firstCheck = 0;
        int resultLength = result.length;
        while (firstCheck < resultLength) {
            if (result[firstCheck] < 1) break;
            ++firstCheck;
        }
        if (firstCheck == resultLength) {
            return;
        }
        ArrayList updateArgses = batchPsPara.getBatchArgumentList();
        int argsSize = ((PSArgs)updateArgses.get(0)).size();
        ArrayList<Object> oidsAndTransactionID = new ArrayList<Object>();
        int oidIndex = struct.soidDBColumnName == null ? argsSize - 2 : argsSize - 3;
        int index = firstCheck;
        while (index < resultLength) {
            if (result[index] < 1) {
                oidsAndTransactionID.add(((PSArgs)updateArgses.get(index)).get(oidIndex));
            }
            ++index;
        }
        int checkCount = oidsAndTransactionID.size();
        String sql = struct.getCheckUpdateVerIDSql(generalDBManager, checkCount);
        oidsAndTransactionID.add(generalDBManager.getTransactionID());
        DataTable dataTable = generalDBManager.execPrepareQuery(sql, oidsAndTransactionID);
        if (dataTable.getInt(0, 0) != checkCount) {
            throw new RuntimeException("\u5904\u7406\u4e2d\u7684\u90e8\u5206\u6570\u636e\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\uff0c\u8c22\u8c22\u3002\n\u8868" + struct.tableName + "\u5171" + (checkCount - dataTable.getInt(0, 0)) + "\u6761\u6570\u636e\u5df2\u8fc7\u671f\u3002");
        }
    }

    private static void checkDeleteVerID(IDBManager generalDBManager, CacheCommitStruct struct, BatchPsPara deletePsPara) throws Throwable {
        String updateBeforeDelete = struct.getCheckVerIDBeforeDeleteSql(generalDBManager);
        BatchPsPara batch = new BatchPsPara(updateBeforeDelete);
        for (PSArgs deleteArgs : deletePsPara.getBatchArgumentList()) {
            PSArgs updateArgs = new PSArgs();
            updateArgs.addIntArg(Integer.valueOf(generalDBManager.getTransactionID()));
            updateArgs.addLongArg((Long)deleteArgs.get(0));
            if (struct.soidDBColumnName != null) {
                updateArgs.addLongArg((Long)deleteArgs.get(1));
                updateArgs.addIntArg((Integer)deleteArgs.get(2));
            } else {
                updateArgs.addIntArg((Integer)deleteArgs.get(1));
            }
            batch.putArgs(updateArgs);
        }
        int[] result = generalDBManager.executeUpdateReturn(batch);
        SubmitDataTable.checkUpdateVerID(generalDBManager, result, struct, batch);
    }

    private static void createSQL(CacheDBRequest cacheDBRequest, IDBManager DBManager, DataTable table, CacheCommitStruct struct, RefParameter<BatchPsPara> insertBatchRef, HashMap<UpdateRowState, BatchPsPara> updateBatches, HashMap<Boolean, BatchPsPara> deleteBatches, boolean isLastUpdateBeforeCommit) throws Throwable {
        int[] columnFieldTypes = struct.columnFieldTypes;
        int rowIndex = 0;
        int size = table.size();
        while (rowIndex < size) {
            Row row = DataTableExUtil.getRowByIndex(table, rowIndex);
            int rowState = row.getState();
            if (rowState == 3) {
                BatchPsPara deleteBatch;
                boolean checkVerID;
                Long oid = (Long)row.getObject(struct.oidColumnIndex);
                boolean hasCheckVerID = cacheDBRequest.cacheDB.hasCheckVerID(oid, struct.tableName);
                Object verIDValue = struct.veridColumnIndex >= 0 ? row.getOriginalObject(struct.veridColumnIndex) : null;
                boolean bl = checkVerID = checkIndividually && !hasCheckVerID && verIDValue != null;
                if (checkVerID && !isLastUpdateBeforeCommit) {
                    cacheDBRequest.cacheDB.setCheckVerID(oid, struct.tableName);
                }
                if ((deleteBatch = deleteBatches.get(checkVerID)) == null) {
                    String deleteSQL = SubmitDataTable.getDeleteSQL(DBManager, struct.tableName, struct, checkVerID);
                    deleteBatch = new BatchPsPara(deleteSQL);
                    deleteBatches.put(checkVerID, deleteBatch);
                }
                PSArgs args = new PSArgs();
                args.addArg(Integer.valueOf(1010), (Object)oid);
                if (struct.soidDBColumnName != null) {
                    args.addArg(Integer.valueOf(1010), (Object)((Long)row.getObject(struct.soidColumnIndex)));
                }
                if (checkVerID) {
                    args.addArg(Integer.valueOf(1001), verIDValue);
                }
                deleteBatch.putArgs(args);
            } else if (rowState == 2) {
                Object[] rv = row.getDataList();
                Object[] orgDataList = row.getOriginalDataList();
                Long oid = (Long)rv[struct.oidColumnIndex];
                UpdateRowState updateRowState = SubmitDataTable.getUpdateRowState(rv, orgDataList, struct, struct.updateKeyIndex, struct.veridColumnIndex);
                if (!updateRowState.isEmpty()) {
                    boolean checkVerID;
                    boolean hasCheckVerID = cacheDBRequest.cacheDB.hasCheckVerID(oid, struct.tableName);
                    boolean bl = checkVerID = checkIndividually && !hasCheckVerID && updateRowState.hasVerIDValue();
                    if (checkVerID && !isLastUpdateBeforeCommit) {
                        cacheDBRequest.cacheDB.setCheckVerID(oid, struct.tableName);
                    }
                    updateRowState.setCheckVerID(checkVerID);
                    BatchPsPara updateBatch = updateBatches.get(updateRowState);
                    if (updateBatch == null) {
                        String updateSql = SubmitDataTable.getUpdateSQL(DBManager, struct.tableName, struct, updateRowState, checkVerID);
                        updateBatch = new BatchPsPara(updateSql);
                        updateBatches.put(updateRowState, updateBatch);
                    }
                    PSArgs args = new PSArgs();
                    int[] nArray = struct.updateKeyIndex;
                    int n = struct.updateKeyIndex.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int index = nArray[n2];
                        if (updateRowState.isHasValue(index)) {
                            Object value = rv[index];
                            if (value instanceof ValueDiff) {
                                value = ((ValueDiff)value).value;
                            }
                            if (StringUtil.isBlankOrNull((Object)value)) {
                                if (columnFieldTypes[index] == 1002 || columnFieldTypes[index] == 1012 || columnFieldTypes[index] == 1011) {
                                    value = "  ";
                                } else if (columnFieldTypes[index] == 1001 || columnFieldTypes[index] == 1010 || columnFieldTypes[index] == 1005 || columnFieldTypes[index] == 1006 || columnFieldTypes[index] == 1007) {
                                    value = TypeConvertor.toDataType((int)columnFieldTypes[index], (Object)0);
                                }
                            }
                            args.addArg(Integer.valueOf(columnFieldTypes[index]), value);
                        }
                        ++n2;
                    }
                    if (checkVerID) {
                        args.addArg(Integer.valueOf(1001), (Object)DBManager.getTransactionID());
                    }
                    args.addArg(Integer.valueOf(1010), (Object)oid);
                    args.addArg(Integer.valueOf(1010), (Object)((Long)rv[struct.soidColumnIndex]));
                    if (checkVerID) {
                        int oldVerIDValue = TypeConvertor.toInteger((Object)row.getOriginalObject(struct.veridColumnIndex));
                        oldVerIDValue = oldVerIDValue < 0 ? -oldVerIDValue : oldVerIDValue;
                        args.addArg(Integer.valueOf(1001), (Object)oldVerIDValue);
                        rv[struct.veridColumnIndex] = oldVerIDValue + 1;
                    }
                    updateBatch.putArgs(args);
                }
            } else if (rowState == 1) {
                SubmitDataTable.createInsertSQL(row, cacheDBRequest, DBManager, struct, insertBatchRef, isLastUpdateBeforeCommit);
            }
            ++rowIndex;
        }
    }

    private static void createInsertSQL(Row row, CacheDBRequest cacheDBRequest, IDBManager DBManager, CacheCommitStruct struct, RefParameter<BatchPsPara> insertBatchRef, boolean isLastUpdateBeforeCommit) {
        BatchPsPara insertBatch;
        int[] columnFieldTypes = struct.columnFieldTypes;
        Object[] rv = row.getDataList();
        if (!isLastUpdateBeforeCommit && struct.veridDBColumnName != null) {
            cacheDBRequest.cacheDB.setCheckVerID((Long)rv[struct.oidColumnIndex], struct.tableName);
        }
        if ((insertBatch = insertBatchRef.getValue()) == null) {
            String insertSql = SubmitDataTable.getInsertSQL(DBManager, struct);
            insertBatch = new BatchPsPara(insertSql);
            insertBatchRef.setValue(insertBatch);
        }
        PSArgs args = new PSArgs();
        int[] nArray = struct.insertKeyIndex;
        int n = struct.insertKeyIndex.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            Object value = rv[index];
            if (StringUtil.isBlankOrNull((Object)value)) {
                if (columnFieldTypes[index] == 1002 || columnFieldTypes[index] == 1012 || columnFieldTypes[index] == 1011) {
                    value = "  ";
                } else if (columnFieldTypes[index] == 1001 || columnFieldTypes[index] == 1010 || columnFieldTypes[index] == 1005 || columnFieldTypes[index] == 1006 || columnFieldTypes[index] == 1007) {
                    value = TypeConvertor.toDataType((int)columnFieldTypes[index], (Object)0);
                }
            }
            args.addArg(Integer.valueOf(columnFieldTypes[index]), value);
            ++n2;
        }
        insertBatch.putArgs(args);
    }

    private static UpdateRowState getUpdateRowState(Object[] rv, Object[] orgDataList, CacheCommitStruct struct, int[] updateKeyIndex, int verIDColumnIndex) {
        int columnCount = rv.length;
        UpdateRowState result = new UpdateRowState(columnCount);
        int[] nArray = updateKeyIndex;
        int n = updateKeyIndex.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            Object value = rv[index];
            if (value != orgDataList[index]) {
                result.hasValue(index);
                if (value instanceof ValueDiff) {
                    result.setDiffValue(index);
                }
            }
            ++n2;
        }
        if (verIDColumnIndex >= 0) {
            result.setHasVerID();
            Object value = rv[verIDColumnIndex];
            if (value != null) {
                result.setHasVerIDValue();
            }
        }
        return result;
    }

    private static final String getInsertSQL(IDBManager DBManager, CacheCommitStruct struct) {
        ArrayList<String> resultFieldKeyList = struct.insertFieldList;
        StringBuilder SQL = new StringBuilder(1024).append(STR_InsertSql_InsertInto);
        DBManager.appendKeyWordEscape(SQL, struct.tableName);
        SQL.append("(");
        if (resultFieldKeyList == null || resultFieldKeyList.size() == 0) {
            throw new RuntimeException("\u63d2\u5165\u8bed\u53e5\u672a\u6307\u660e\u66f4\u65b0\u5217");
        }
        int columnSize = resultFieldKeyList.size();
        int i = 0;
        while (i < columnSize) {
            String fieldKey = resultFieldKeyList.get(i);
            DBManager.appendKeyWordEscape(SQL, fieldKey);
            SQL.append(",");
            ++i;
        }
        if (checkIndividually && struct.veridColumnIndex >= 0) {
            DBManager.appendKeyWordEscape(SQL, struct.veridDBColumnName);
        } else {
            SQL.deleteCharAt(SQL.length() - 1);
        }
        SQL.append(") VALUES (");
        i = 0;
        while (i < columnSize) {
            SQL.append("?,");
            ++i;
        }
        if (checkIndividually && struct.veridColumnIndex >= 0) {
            SQL.append("0)");
        } else {
            SQL.deleteCharAt(SQL.length() - 1);
            SQL.append(")");
        }
        return SQL.toString();
    }

    private static final String getUpdateSQL(IDBManager DBManager, String tableKey, CacheCommitStruct struct, UpdateRowState updateRowState, boolean checkVerID) {
        int[] updateKeyIndex = struct.updateKeyIndex;
        ArrayList<String> resultFiledKeyList = struct.updateFieldList;
        String conditionFieldKey = struct.oidDBColumnName;
        StringBuilder SQL = new StringBuilder(1024).append("update ");
        DBManager.appendKeyWordEscape(SQL, tableKey);
        SQL.append(" set ");
        if (resultFiledKeyList == null || resultFiledKeyList.size() == 0) {
            throw new RuntimeException("\u66f4\u65b0\u8bed\u53e5\u672a\u6307\u660e\u66f4\u65b0\u5217");
        }
        int columnSize = resultFiledKeyList.size();
        int i = 0;
        while (i < columnSize) {
            if (updateRowState.isHasValue(updateKeyIndex[i])) {
                String fieldKey = resultFiledKeyList.get(i);
                DBManager.appendKeyWordEscape(SQL, fieldKey);
                if (updateRowState.isDiffValue(i)) {
                    SQL.append("=");
                    DBManager.appendKeyWordEscape(SQL, fieldKey);
                    SQL.append("+?,");
                } else {
                    SQL.append("=?,");
                }
            }
            ++i;
        }
        if (checkVerID || updateRowState.hasVerID() && !updateRowState.hasVerIDValue()) {
            DBManager.appendKeyWordEscape(SQL, struct.veridDBColumnName).append("=");
            DBManager.appendKeyWordEscape(SQL, struct.veridDBColumnName).append("+1,");
        }
        if (checkVerID) {
            DBManager.appendKeyWordEscape(SQL, struct.slockDBColumnName).append("=?,");
        }
        SQL.deleteCharAt(SQL.length() - 1);
        SQL.append(" where ");
        DBManager.appendKeyWordEscape(SQL, conditionFieldKey);
        SQL.append("=? AND ");
        DBManager.appendKeyWordEscape(SQL, struct.soidDBColumnName);
        SQL.append("=?");
        if (checkVerID) {
            SQL.append(" and ");
            DBManager.appendKeyWordEscape(SQL, struct.veridDBColumnName).append("=?");
        }
        return SQL.toString();
    }

    private static final String getDeleteSQL(IDBManager DBManager, String tableKey, CacheCommitStruct struct, boolean checkVerID) {
        StringBuilder SQL = new StringBuilder(256);
        SQL.append("delete from ");
        DBManager.appendKeyWordEscape(SQL, tableKey);
        SQL.append(" where ");
        DBManager.appendKeyWordEscape(SQL, struct.oidDBColumnName);
        SQL.append("=?");
        if (struct.soidDBColumnName != null) {
            SQL.append(" AND ");
            DBManager.appendKeyWordEscape(SQL, struct.soidDBColumnName);
            SQL.append("=?");
        }
        if (checkVerID) {
            SQL.append(" and ");
            DBManager.appendKeyWordEscape(SQL, struct.veridDBColumnName).append("=?");
        }
        return SQL.toString();
    }
}

