/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache.commit;

import com.bokesoft.yes.mid.dbcache.structure.CacheTable;
import com.bokesoft.yes.mid.io.doc.util.DocLockCheckUtil;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;

class CacheCommitStruct {
    public final MetaTable metaTable;
    public final String tableName;
    public int[] updateKeyIndex;
    public int[] insertKeyIndex;
    public int[] columnFieldTypes;
    public ArrayList<String> updateFieldList;
    public ArrayList<String> insertFieldList;
    public int oidColumnIndex;
    public String oidDBColumnName;
    public int soidColumnIndex;
    public String soidDBColumnName;
    public int veridColumnIndex = -1;
    public String veridDBColumnName;
    public String slockDBColumnName;
    private String checkUpdateVerIDSql_Tmp;

    public CacheCommitStruct(MetaTable metaTable, DataTableMetaData tableMetaData) {
        this.metaTable = metaTable;
        this.tableName = metaTable.getBindingDBTableName();
        int fieldSize = tableMetaData.getColumnCount();
        this.updateFieldList = new ArrayList(fieldSize);
        this.insertFieldList = new ArrayList(fieldSize);
        ArrayList<Integer> updateKeyIndex = new ArrayList<Integer>(fieldSize);
        ArrayList<Integer> insertKeyIndex = new ArrayList<Integer>(fieldSize);
        this.columnFieldTypes = new int[fieldSize];
        int i = 0;
        while (i < fieldSize) {
            block5: {
                MetaColumn metaColumn;
                String columnKey;
                ColumnInfo columnInfo;
                block7: {
                    block8: {
                        block6: {
                            columnInfo = tableMetaData.getColumnInfo(i);
                            columnKey = columnInfo.getColumnKey();
                            metaColumn = (MetaColumn)metaTable.get(columnKey);
                            if (metaColumn == null) break block5;
                            if (!columnKey.equalsIgnoreCase("VERID") || CacheTable.isBPMTable(this.tableName)) break block6;
                            this.veridColumnIndex = i;
                            this.veridDBColumnName = metaColumn.getBindingDBColumnName();
                            if (!DocLockCheckUtil.getCheckIndividually()) break block7;
                            break block5;
                        }
                        if (!columnKey.equalsIgnoreCase("Slock")) break block8;
                        this.slockDBColumnName = metaColumn.getBindingDBColumnName();
                        if (!DocLockCheckUtil.getCheckIndividually()) break block7;
                        break block5;
                    }
                    if (columnKey.equalsIgnoreCase("OID")) {
                        this.oidColumnIndex = i;
                        this.oidDBColumnName = metaColumn.getBindingDBColumnName();
                    } else if (columnKey.equalsIgnoreCase("SOID")) {
                        this.soidColumnIndex = i;
                        this.soidDBColumnName = metaColumn.getBindingDBColumnName();
                    }
                }
                if (metaColumn.isPersist().booleanValue() && !metaColumn.isIgnoreSave().booleanValue() && columnInfo.isHasWriteRights()) {
                    this.columnFieldTypes[i] = columnInfo.getDataType();
                    this.insertFieldList.add(columnKey);
                    insertKeyIndex.add(i);
                    this.updateFieldList.add(columnKey);
                    updateKeyIndex.add(i);
                }
            }
            ++i;
        }
        this.insertKeyIndex = ArrayUtils.toPrimitive((Integer[])insertKeyIndex.toArray(new Integer[insertKeyIndex.size()]));
        this.updateKeyIndex = ArrayUtils.toPrimitive((Integer[])updateKeyIndex.toArray(new Integer[updateKeyIndex.size()]));
    }

    public String getCheckUpdateVerIDSql(IDBManager dbManager, int size) {
        StringBuilder sb;
        if (this.checkUpdateVerIDSql_Tmp == null) {
            sb = new StringBuilder(256);
            sb.append("select count(");
            dbManager.appendKeyWordEscape(sb, this.oidDBColumnName).append(") count from ");
            dbManager.appendKeyWordEscape(sb, this.tableName).append(" where ");
            dbManager.appendKeyWordEscape(sb, this.oidDBColumnName).append(" in(?");
            this.checkUpdateVerIDSql_Tmp = sb.toString();
        }
        sb = new StringBuilder(256 + size * 2);
        sb.append(this.checkUpdateVerIDSql_Tmp);
        int i = 1;
        while (i < size) {
            sb.append(",?");
            ++i;
        }
        sb.append(") and ");
        dbManager.appendKeyWordEscape(sb, this.slockDBColumnName).append("  = ? ");
        return sb.toString();
    }

    public String getCheckVerIDBeforeDeleteSql(IDBManager dbManager) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("update ");
        dbManager.appendKeyWordEscape(sb, this.tableName).append(" set ");
        dbManager.appendKeyWordEscape(sb, this.slockDBColumnName).append("=? where ");
        dbManager.appendKeyWordEscape(sb, this.oidDBColumnName).append("=? and ");
        if (this.soidDBColumnName != null) {
            dbManager.appendKeyWordEscape(sb, this.soidDBColumnName).append("=? and ");
        }
        dbManager.appendKeyWordEscape(sb, this.veridDBColumnName).append("=?");
        return sb.toString();
    }
}

