/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache;

import com.bokesoft.yes.mid.dbcache.IWhereExpression;
import com.bokesoft.yes.mid.dbcache.datatable.DataTableExUtil;
import com.bokesoft.yes.struct.datatable.Row;
import com.bokesoft.yes.struct.datatype.DataTypeAction;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class WhereExpressionForCache
implements IWhereExpression {
    public static final Long Long_NotExist = -125L;
    public static final int GE = 1;
    public static final int EQ = 2;
    public static final int LE = 3;
    public static final int GT = 4;
    public static final int NE = 5;
    public static final int LT = 6;
    public static final int INT_Min_CompareOperationID = 1;
    public static final int INT_Max_CompareOperationID = 6;
    public final Long oid;
    public final Long soid;
    public final String[] columnNames;
    public final Object[] columnValues;
    public final int[] operationIDs;
    public int[] columnIndexes;
    public DataTypeAction[] dataTypeActions;

    public WhereExpressionForCache(Long oid, Long soid, String[] columnNames, Object[] columnValues, int[] operationIDs) {
        this.oid = oid;
        this.soid = soid;
        this.columnNames = columnNames;
        this.columnValues = columnValues;
        this.operationIDs = operationIDs;
    }

    public int[] fastFilter(DataTable dataTable) throws Throwable {
        int columnSize = this.columnNames == null ? 0 : this.columnNames.length;
        int allColumnSize = (this.oid.equals(Long_NotExist) ? 0 : 1) + (this.soid.equals(Long_NotExist) ? 0 : 1);
        boolean isAllEqual = true;
        int i = 0;
        while (i < columnSize) {
            if (this.operationIDs[i] == 2) {
                ++allColumnSize;
            } else {
                isAllEqual = false;
            }
            ++i;
        }
        String[] allColumnNames = new String[allColumnSize];
        Object[] allColumnValues = new Object[allColumnSize];
        int index = 0;
        if (!this.oid.equals(Long_NotExist)) {
            allColumnNames[index] = "OID";
            allColumnValues[index] = this.oid;
            ++index;
        }
        if (!this.soid.equals(Long_NotExist)) {
            allColumnNames[index] = "SOID";
            allColumnValues[index] = this.soid;
            ++index;
        }
        int[] columnIndexes = isAllEqual ? null : new int[columnSize];
        DataTypeAction[] dataTypeActions = isAllEqual ? null : new DataTypeAction[columnSize];
        int i2 = 0;
        while (i2 < columnSize) {
            if (this.operationIDs[i2] == 2) {
                allColumnNames[index] = this.columnNames[i2];
                allColumnValues[index] = this.columnValues[i2];
                ++index;
            } else {
                int tmp;
                columnIndexes[i2] = tmp = dataTable.getMetaData().findColumnIndexByKey(this.columnNames[i2]);
                dataTypeActions[i2] = dataTable.getMetaData().getColumnInfo(tmp).getDataTypeAction();
            }
            ++i2;
        }
        int[] validRows = dataTable.fastFilter(allColumnNames, allColumnValues);
        if (!isAllEqual) {
            ArrayList<Integer> validRowIndexes = new ArrayList<Integer>(validRows.length);
            int[] nArray = validRows;
            int n = validRows.length;
            int n2 = 0;
            while (n2 < n) {
                int rowIndex = nArray[n2];
                Row row = DataTableExUtil.getRowByIndex(dataTable, rowIndex);
                Object[] dataList = row.getDataList();
                boolean match = true;
                int i3 = 0;
                while (i3 < columnSize) {
                    Object value;
                    if (this.operationIDs[i3] != 2 && !WhereExpressionForCache.isOperationMatch(this.operationIDs[i3], dataTypeActions[i3].compare(value = dataList[columnIndexes[i3]], this.columnValues[i3]))) {
                        match = false;
                        break;
                    }
                    ++i3;
                }
                if (match) {
                    validRowIndexes.add(rowIndex);
                }
                ++n2;
            }
            validRows = ArrayUtils.toPrimitive((Integer[])validRowIndexes.toArray(new Integer[validRowIndexes.size()]));
        }
        return validRows;
    }

    public boolean equals(Object obj) {
        int otherColumnSize;
        if (obj == null || !(obj instanceof WhereExpressionForCache)) {
            return false;
        }
        WhereExpressionForCache other = (WhereExpressionForCache)obj;
        if (!this.oid.equals(other.oid) || !this.soid.equals(other.soid)) {
            return false;
        }
        int columnSize = this.columnNames == null ? 0 : this.columnNames.length;
        int n = otherColumnSize = other.columnNames == null ? 0 : other.columnNames.length;
        if (columnSize != otherColumnSize) {
            return false;
        }
        int i = 0;
        while (i < columnSize) {
            if (!WhereExpressionForCache.isEqual(this.columnValues[i], other.columnValues[i])) {
                return false;
            }
            if (!WhereExpressionForCache.isEqual(this.columnNames[i], other.columnNames[i])) {
                return false;
            }
            if (this.operationIDs[i] != other.operationIDs[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isEqual(Object a, Object b) {
        return a == b ? true : (a == null ? false : a.equals(b));
    }

    private boolean isSameColumns(WhereExpressionForCache other) {
        if (this.oid.equals(Long_NotExist) ^ other.oid.equals(Long_NotExist)) {
            return false;
        }
        if (this.soid.equals(Long_NotExist) ^ other.soid.equals(Long_NotExist)) {
            return false;
        }
        int columnSize = this.columnNames == null ? 0 : this.columnNames.length;
        int i = 0;
        while (i < columnSize) {
            if (!this.columnNames[i].equals(other.columnNames[i])) {
                return false;
            }
            if (this.operationIDs[i] != other.operationIDs[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static List<List<WhereExpressionForCache>> groupByColumns(List<WhereExpressionForCache> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        ArrayList<List<WhereExpressionForCache>> result = new ArrayList<List<WhereExpressionForCache>>();
        ArrayList<WhereExpressionForCache> firstList = new ArrayList<WhereExpressionForCache>();
        firstList.add(list.get(0));
        result.add(firstList);
        int i = 1;
        int size = list.size();
        while (i < size) {
            WhereExpressionForCache expression = list.get(i);
            boolean found = false;
            int j = 0;
            int listSize = result.size();
            while (j < listSize) {
                List tmp = (List)result.get(j);
                if (((WhereExpressionForCache)tmp.get(0)).isSameColumns(expression)) {
                    tmp.add(expression);
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                ArrayList<WhereExpressionForCache> newList = new ArrayList<WhereExpressionForCache>();
                newList.add(expression);
                result.add(newList);
            }
            ++i;
        }
        return result;
    }

    public boolean hasField(String fieldName) {
        return this.getFieldIndex(fieldName) >= 0;
    }

    public int getFieldIndex(String fieldName) {
        int columnSize = this.columnNames == null ? 0 : this.columnNames.length;
        int i = 0;
        while (i < columnSize) {
            if (this.columnNames[i].equals(fieldName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Object hasValue(String fieldName) {
        int columnSize = this.columnNames == null ? 0 : this.columnNames.length;
        int i = 0;
        while (i < columnSize) {
            if (this.columnNames[i].equals(fieldName)) {
                return this.columnValues[i];
            }
            ++i;
        }
        return null;
    }

    public int getAllColumnCount() {
        int columnSize;
        int n = columnSize = this.columnNames == null ? 0 : this.columnNames.length;
        if (!this.oid.equals(Long_NotExist)) {
            ++columnSize;
        }
        if (!this.soid.equals(Long_NotExist)) {
            ++columnSize;
        }
        return columnSize;
    }

    public static boolean isOperationMatch(int operationID, int compareResult) {
        switch (operationID) {
            case 1: {
                return compareResult >= 0;
            }
            case 2: {
                return compareResult == 0;
            }
            case 3: {
                return compareResult <= 0;
            }
            case 4: {
                return compareResult > 0;
            }
            case 5: {
                return compareResult != 0;
            }
            case 6: {
                return compareResult < 0;
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7b26" + operationID + "\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u3002");
    }
}

