/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.util;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.connection.ArchiveDBDSNItem;
import com.bokesoft.yes.mid.connection.ArchiveDSNItems;
import com.bokesoft.yes.mid.connection.intf.IArchiveDSNIntialization;
import com.bokesoft.yes.mid.dsn.DSNFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IDSNItem;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.connection.DBType;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.dsn.IDSNFactory;

public class ArchiveDSNUtil {
    private static IArchiveDSNIntialization INSTANCE;

    public static IArchiveDSNIntialization getInstance() {
        return INSTANCE;
    }

    public static void initIArchiveDSNInitialization(IArchiveDSNIntialization archiveDSNInitialization) {
        INSTANCE = archiveDSNInitialization;
    }

    public static ArchiveDBDSNItem buildDSN(ArchiveDSNItems dsnCollection, String dsnName, String connectionType, String driver, String url, String user, String password, String dbType, String clsname) {
        ArchiveDBDSNItem dbItem = new ArchiveDBDSNItem();
        dbItem.setName(dsnName);
        if ("dbcp".equalsIgnoreCase(connectionType)) {
            dbItem.setConnectionType(1);
        } else if ("jndi".equalsIgnoreCase(connectionType)) {
            dbItem.setConnectionType(2);
        } else {
            dbItem.setConnectionType(0);
        }
        dbItem.setDriver(driver);
        dbItem.setURL(url);
        dbItem.setUser(user);
        dbItem.setPassword(password);
        dbItem.setDBType(DBType.parse((String)dbType));
        dbItem.setDriver(clsname);
        return dbItem;
    }

    public static ArchiveDBDSNItem getArchiveDBDSNItem(String dsnname) {
        return ArchiveDSNItems.instance.getDSNItem(dsnname);
    }

    public static StringHashMap<ArchiveDBDSNItem> getDSNItemMap() {
        return ArchiveDSNItems.instance.getDSNItemMap();
    }

    public static IDBManager getDBmanager(DefaultContext context, String dsnName) throws Throwable {
        IDSNFactory idsnFactory = DSNFactory.getInstance();
        if (ArchiveDSNUtil.getArchiveDBDSNItem(dsnName) != null) {
            IDBManager manager = (IDBManager)idsnFactory.createDSN((IServiceContext)context, (IDSNItem)ArchiveDSNUtil.getArchiveDBDSNItem(dsnName), dsnName);
            return manager;
        }
        return null;
    }
}

