/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager;

import com.bokesoft.yes.common.LRUCacheNew;
import com.bokesoft.yes.mid.connection.dbmanager.ExpressionDeParserEx;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.SelectDeParserEx;
import com.bokesoft.yes.mid.connection.dbmanager.SqlConvertor;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.JSQLParserException;
import net.boke.jsqlparser.parser.CCJSqlParserManager;
import net.boke.jsqlparser.statement.Statement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertSqlByDBType {
    private static final Logger logger = LoggerFactory.getLogger(ConvertSqlByDBType.class);
    private static LRUCacheNew<String, String>[] cache = new LRUCacheNew[100];

    public static String convertSql(String sql, int dbType) {
        return ConvertSqlByDBType.convertSql(sql, dbType, null);
    }

    public static String convertSql(String sql, int dbType, QueryArguments args) {
        String cacheKey;
        String result;
        List<Integer> emptyStringIndex = ConvertSqlByDBType.getEmptyStringIndex(args);
        LRUCacheNew map = cache[dbType];
        if (map == null) {
            ConvertSqlByDBType.cache[dbType] = map = new LRUCacheNew(1000);
        }
        if ((result = (String)map.get((Object)(cacheKey = new StringBuffer(1024).append(sql).append(emptyStringIndex == null ? "" : StringUtils.join(emptyStringIndex, (String)",")).toString()))) == null) {
            result = ConvertSqlByDBType.convertSqlImpl(sql, dbType, emptyStringIndex);
            map.put((Object)cacheKey, (Object)result);
        }
        return result;
    }

    private static List<Integer> getEmptyStringIndex(QueryArguments args) {
        if (args == null || args.size() == 0) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        int parameterIndex = 0;
        int size = args.size();
        while (parameterIndex < size) {
            Object arg = args.get(parameterIndex);
            if (arg instanceof String && TypeConvertor.toString((Object)arg).isEmpty()) {
                result.add(parameterIndex);
            }
            ++parameterIndex;
        }
        return result;
    }

    private static String convertSqlImpl(String sql, int dbType, List<Integer> emptyStringIndexList) {
        Statement statement;
        CCJSqlParserManager parser = new CCJSqlParserManager();
        try {
            statement = parser.parse(sql);
        }
        catch (JSQLParserException e) {
            logger.warn(">>>>\u6309\u6570\u636e\u5e93\u7c7b\u578b\u8f6c\u5316SQL\uff1a \u89e3\u6790\u5931\u8d25{}", (Object)sql);
            return sql;
        }
        StringBuffer sb = new StringBuffer(sql.length() + 16);
        SqlConvertor sqlConvertor = new SqlConvertor(sb, dbType);
        SelectDeParserEx selectDeparseEx = new SelectDeParserEx(dbType, emptyStringIndexList);
        sqlConvertor.selectDeParser = selectDeparseEx;
        sqlConvertor.expressionDeParser = new ExpressionDeParserEx(selectDeparseEx, sb, dbType);
        statement.accept(sqlConvertor);
        if (selectDeparseEx.isChange()) {
            logger.debug(">>>>\u6309\u6570\u636e\u5e93\u7c7b\u578b\u8f6c\u5316\u524dSQL\uff1a {}", (Object)sql);
            logger.debug(">>>>\u6309\u6570\u636e\u5e93\u7c7b\u578b\u8f6c\u5316\u540eSQL\uff1a {}", (Object)sb);
        }
        return selectDeparseEx.isChange() ? sb.toString() : sql;
    }
}

