/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection;

import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.mid.connection.group.GroupIntValue;
import com.bokesoft.yes.mid.connection.group.GroupLongValue;
import com.bokesoft.yes.mid.connection.group.IGroupValue;
import com.bokesoft.yes.mid.mysqls.group.DictGroupField;
import com.bokesoft.yes.mid.mysqls.group.Group;
import com.bokesoft.yes.mid.mysqls.group.GroupField;
import com.bokesoft.yes.mid.mysqls.group.IntGroupField;
import com.bokesoft.yes.mid.mysqls.group.LongGroupField;
import com.bokesoft.yes.mid.mysqls.group.OneGroupValue;
import java.util.HashMap;
import java.util.Map;

public class MdbDSNGroupValues {
    public Group group;
    private final Map<String, IGroupValue> groupValues = new HashMap<String, IGroupValue>();

    public MdbDSNGroupValues(Group group) {
        this.group = group;
        if (group == null) {
            throw new RuntimeException("ERROR!");
        }
    }

    public String getGroupkey() {
        return this.group.getKey();
    }

    public void add(GroupField groupField, String defValue) {
        IGroupValue groupValue;
        if (groupField instanceof IntGroupField) {
            groupValue = new GroupIntValue((IntGroupField)groupField, defValue);
        } else if (groupField instanceof LongGroupField || groupField instanceof DictGroupField) {
            groupValue = new GroupLongValue(groupField, defValue);
        } else {
            throw new RuntimeException("Error!");
        }
        this.groupValues.put(groupField.getKey(), groupValue);
    }

    public boolean isFitStrict(OneGroupValue oneGroupValue) {
        if (this.groupValues.size() == 0) {
            return false;
        }
        for (Map.Entry<String, IGroupValue> entry : this.groupValues.entrySet()) {
            String fieldKey = entry.getKey();
            Object value = oneGroupValue.getGroupValue(fieldKey);
            if (value == GroupField.UndefinedGroupValue) {
                throw new RuntimeException("\u5206\u5e93\u5206\u8868\u9519\u8bef\uff0c\u5206\u7ec4\u5b57\u6bb5" + fieldKey + "\u7684\u503c\u6ca1\u6709\u5b9a\u4e49\u3002");
            }
            if (entry.getValue().isFit(value)) continue;
            return false;
        }
        return true;
    }

    public boolean isFitNoStrict(OneGroupValue oneGroupValue, RefObject<Boolean> isStrictFit) {
        boolean hasUndefinedGroupValue = false;
        for (Map.Entry<String, IGroupValue> entry : this.groupValues.entrySet()) {
            String fieldKey = entry.getKey();
            Object value = oneGroupValue.getGroupValue(fieldKey);
            if (value == GroupField.UndefinedGroupValue) {
                hasUndefinedGroupValue = true;
                continue;
            }
            if (entry.getValue().isFit(value)) continue;
            return false;
        }
        isStrictFit.setValue((Object)(!hasUndefinedGroupValue ? 1 : 0));
        return true;
    }

    public IGroupValue[] getGroupValues() {
        return this.groupValues.values().toArray(new IGroupValue[0]);
    }

    public String toString() {
        return this.groupValues.toString();
    }
}

