/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.datastruct.metaload;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.datastruct.meta.MetaDataStructTable;
import com.bokesoft.yes.datastruct.metaload.ColumnExp;
import com.bokesoft.yes.datastruct.metaload.Interval;
import com.bokesoft.yes.datastruct.metaload.Point;
import com.bokesoft.yes.datastruct.metaload.Points;
import com.bokesoft.yes.datastruct.metaload.ValueRange;
import com.bokesoft.yes.datastruct.metaload.WhereExp;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yes.util.VarUtil;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

class CompareExp
extends WhereExp {
    protected Object rightData;
    protected ColumnExp rightColumn;
    protected int Operationid;
    protected ColumnExp leftColumn;
    protected Object leftData;

    public CompareExp(Object left, Object right, int operationid) {
        if (left instanceof ColumnExp) {
            this.leftColumn = (ColumnExp)left;
        } else {
            this.leftData = left;
        }
        if (right instanceof ColumnExp) {
            this.rightColumn = (ColumnExp)right;
        } else {
            this.rightData = right;
        }
        this.Operationid = operationid;
    }

    public CompareExp(ColumnExp column, Object data) {
        this(column, data, 2);
    }

    @Override
    public SqlString toSQL() throws Throwable {
        SqlString sb = new SqlString(64);
        this.toSQL(sb);
        return sb;
    }

    @Override
    public SqlString toSQL(SqlString sb) throws Throwable {
        String columnNamePrefix = String.valueOf(this.leftColumn.table.getKey()) + ".";
        int dataType = this.leftColumn.column.getDataType();
        if (this.Operationid == 8) {
            sb.append(columnNamePrefix);
            sb.append(this.leftColumn.column.getBindingDBColumnName());
            sb.append(" in (");
            if (dataType == 1002 && this.rightData instanceof String[]) {
                String[] strArray = (String[])this.rightData;
                int size = strArray.length;
                int i = 0;
                while (i < size) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.appendPara(strArray[i]);
                    ++i;
                }
            } else if (dataType == 1001 && (this.rightData instanceof int[] || this.rightData instanceof Integer[])) {
                int[] intArray = this.rightData instanceof Integer[] ? ArrayUtils.toPrimitive((Integer[])((Integer[])this.rightData)) : (int[])this.rightData;
                int size = intArray.length;
                int i = 0;
                while (i < size) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.appendPara(intArray[i]);
                    ++i;
                }
            } else if (dataType == 1010 && this.rightData instanceof Long[]) {
                Long[] longArray = (Long[])this.rightData;
                int size = longArray.length;
                int i = 0;
                while (i < size) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.appendPara(longArray[i]);
                    ++i;
                }
            } else if (dataType == 1005 && this.rightData instanceof BigDecimal[]) {
                BigDecimal[] decArray = (BigDecimal[])this.rightData;
                int size = decArray.length;
                int i = 0;
                while (i < size) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.appendPara(decArray[i]);
                    ++i;
                }
            } else {
                throw new RuntimeException("\u7c7b\u578b'" + DataType.toString((Integer)dataType) + "'\u548c\u503c" + this.rightData + "\u7ec4\u5408\u8fd8\u4e0d\u652f\u6301,\u8bf7\u4fee\u6539\u4ee3\u7801.");
            }
            sb.append(")");
        } else {
            sb.append("(").append(columnNamePrefix).append(this.leftColumn.column.getBindingDBColumnName());
            sb.append(CompareExp.getOperatorString(this.Operationid));
            if (this.rightColumn != null) {
                sb.append(this.rightColumn.table.getKey()).append(".").append(this.rightColumn.column.getBindingDBColumnName());
            } else if (dataType == 1001) {
                int Data = TypeConvertor.toInteger((Object)this.rightData);
                sb.appendPara(Data);
            } else if (dataType == 1010) {
                Long Data = TypeConvertor.toLong((Object)this.rightData);
                sb.appendPara(Data);
            } else if (dataType == 1002) {
                String Data = TypeConvertor.toString((Object)this.rightData);
                sb.appendPara(Data);
                if (StringUtil.isBlankOrNull((String)Data)) {
                    if (this.Operationid == 2) {
                        sb.append(" or ").append(columnNamePrefix).append(this.leftColumn.column.getBindingDBColumnName()).append(" is null");
                    } else if (this.Operationid == 5) {
                        sb.append(" or ").append(columnNamePrefix).append(this.leftColumn.column.getBindingDBColumnName()).append(" is not null");
                    }
                }
            } else if (dataType == 1005) {
                BigDecimal Data = TypeConvertor.toBigDecimal((Object)this.rightData);
                sb.appendPara(Data);
            } else {
                throw new Exception("\u76ee\u524d\u4e0d\u652f\u6301\u8fd9\u4e2a\u7c7b\u578b" + DataType.toString((Integer)dataType) + ",\u8bf7\u4fee\u6539\u76f8\u5173\u4ee3\u7801.");
            }
            sb.append(")");
        }
        return sb;
    }

    @Override
    public List<MetaDataStructTable> getTables() {
        MetaDataStructTable metaTableLeft = this.leftColumn != null ? this.leftColumn.table : null;
        MetaDataStructTable metaTableRight = this.rightColumn != null ? this.rightColumn.table : null;
        ArrayList<MetaDataStructTable> metaTables = null;
        if (metaTableLeft != null && metaTableRight != null) {
            metaTables = new ArrayList<MetaDataStructTable>();
            if (metaTableLeft != null) {
                metaTables.add(metaTableLeft);
            }
            if (metaTableRight != null) {
                metaTables.add(metaTableRight);
            }
        }
        return metaTables;
    }

    @Override
    public List<ColumnExp> getColumns(MetaDataStructTable table) {
        ArrayList<ColumnExp> columns = new ArrayList<ColumnExp>();
        if (this.leftColumn != null && this.leftColumn.table == table) {
            columns.add(this.leftColumn);
        }
        if (this.rightColumn != null && this.rightColumn.table == table) {
            columns.add(this.rightColumn);
        }
        return columns;
    }

    @Override
    boolean isMatch(DataTable dataTable, int rowIndex, boolean isOriginal) throws Throwable {
        String columnName = this.leftColumn.column.getBindingDBColumnName();
        Object tableEntityValue = isOriginal ? dataTable.getOriginalObject(rowIndex, columnName) : dataTable.getObject(rowIndex, columnName);
        boolean b = true;
        switch (this.Operationid) {
            case 2: {
                b = VarUtil.compare(tableEntityValue, this.rightData) == 0;
                break;
            }
            case 3: {
                b = VarUtil.compare(tableEntityValue, this.rightData) <= 0;
                break;
            }
            case 4: {
                b = VarUtil.compare(tableEntityValue, this.rightData) > 0;
                break;
            }
            case 5: {
                b = VarUtil.compare(tableEntityValue, this.rightData) != 0;
                break;
            }
            case 6: {
                b = VarUtil.compare(tableEntityValue, this.rightData) < 0;
                break;
            }
            case 1: {
                b = VarUtil.compare(tableEntityValue, this.rightData) >= 0;
                break;
            }
            case 8: {
                if (this.rightData instanceof int[] && tableEntityValue instanceof Integer) {
                    b = ArrayUtils.contains((int[])((int[])this.rightData), (int)((Integer)tableEntityValue));
                    break;
                }
                if (this.rightData instanceof Integer[] && tableEntityValue instanceof Integer) {
                    b = ArrayUtils.contains((Object[])((Integer[])this.rightData), (Object)((Integer)tableEntityValue));
                    break;
                }
                if (this.rightData instanceof String[] && tableEntityValue instanceof String) {
                    b = ArrayUtils.contains((Object[])((String[])this.rightData), (Object)((String)tableEntityValue));
                    break;
                }
                if (this.rightData instanceof BigDecimal[] && tableEntityValue instanceof BigDecimal) {
                    b = ArrayUtils.contains((Object[])((BigDecimal[])this.rightData), (Object)((BigDecimal)tableEntityValue));
                    break;
                }
                throw new Exception("\u6570\u7ec4\u6570\u636e'" + this.rightData + "'\u548c\u503c" + tableEntityValue + "\u65e0\u6cd5\u6bd4\u8f83,\u8bf7\u4fee\u6539\u4ee3\u7801.");
            }
            default: {
                throw new Exception("\u76ee\u524d\u4e0d\u652f\u6301\u8fd9\u4e2a\u64cd\u4f5c\u7b26" + this.Operationid + ".");
            }
        }
        return b;
    }

    @Override
    public boolean hasColumnWhereClause(ColumnExp column) {
        return column.equals(this.leftColumn) || column.equals(this.rightColumn);
    }

    @Override
    public Object getColumnValue(ColumnExp column) {
        if (this.leftColumn.column.compareTo((KeyPairMetaObject)column.column) == 0) {
            return this.rightData;
        }
        return null;
    }

    @Override
    protected ValueRange getValueRange(ColumnExp column) {
        if (column.equals(this.leftColumn)) {
            Object value = this.rightData == null ? this.rightColumn : this.rightData;
            switch (this.Operationid) {
                case 2: {
                    return new Point(value, false, column.column.getDataType());
                }
                case 3: {
                    return new Interval(null, false, value, true, column.column.getDataType());
                }
                case 4: {
                    return new Interval(value, false, null, false, column.column.getDataType());
                }
                case 5: {
                    return new Point(value, true, column.column.getDataType());
                }
                case 6: {
                    return new Interval(null, false, value, false, column.column.getDataType());
                }
                case 1: {
                    return new Interval(value, true, null, false, column.column.getDataType());
                }
                case 8: {
                    return new Points((Object[])this.rightData, column.column.getDataType());
                }
            }
            throw new AssertionError((Object)("\u76ee\u524d\u4e0d\u652f\u6301\u8fd9\u4e2a\u64cd\u4f5c\u7b26" + this.Operationid + "."));
        }
        if (column.equals(this.rightColumn)) {
            Object value = this.leftData == null ? this.leftColumn : this.leftData;
            switch (this.Operationid) {
                case 2: {
                    return new Point(value, false, column.column.getDataType());
                }
                case 3: {
                    return new Interval(value, true, null, false, column.column.getDataType());
                }
                case 4: {
                    return new Interval(null, false, value, false, column.column.getDataType());
                }
                case 5: {
                    return new Point(value, true, column.column.getDataType());
                }
                case 6: {
                    return new Interval(value, false, null, false, column.column.getDataType());
                }
                case 1: {
                    return new Interval(null, false, value, true, column.column.getDataType());
                }
            }
            throw new AssertionError((Object)("\u76ee\u524d\u4e0d\u652f\u6301\u8fd9\u4e2a\u64cd\u4f5c\u7b26" + this.Operationid + "."));
        }
        return null;
    }
}

