/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.datastruct.metaload;

import com.bokesoft.yes.datastruct.meta.MetaDataStructTable;
import com.bokesoft.yes.datastruct.metaload.ColumnExp;
import com.bokesoft.yes.datastruct.metaload.ValueRange;
import com.bokesoft.yes.datastruct.metaload.WhereExp;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.ArrayList;
import java.util.List;

class AndExp
extends WhereExp {
    private List<WhereExp> sub = new ArrayList<WhereExp>();

    public AndExp(WhereExp l, WhereExp r) {
        this.sub.add(l);
        this.sub.add(r);
    }

    public AndExp addExpression(WhereExp expression) {
        if (expression instanceof AndExp) {
            for (WhereExp tmp : ((AndExp)expression).sub) {
                this.addExpression(tmp);
            }
        } else {
            this.sub.add(expression);
        }
        return this;
    }

    @Override
    public SqlString toSQL() throws Throwable {
        SqlString stringBuilder = new SqlString(128);
        for (WhereExp w : this.sub) {
            stringBuilder.append(" and ").append(w.toSQL());
        }
        stringBuilder.deleteLeft(4);
        return stringBuilder;
    }

    @Override
    public SqlString toSQL(SqlString sqlString) throws Throwable {
        int i = 0;
        int size = this.sub.size();
        while (i < size) {
            WhereExp w = this.sub.get(i);
            if (i != 0) {
                sqlString.append(" and ");
            }
            w.toSQL(sqlString);
            ++i;
        }
        return sqlString;
    }

    @Override
    public List<MetaDataStructTable> getTables() {
        ArrayList<MetaDataStructTable> result = new ArrayList<MetaDataStructTable>();
        for (WhereExp w : this.sub) {
            List<MetaDataStructTable> rightTables = w.getTables();
            int size = rightTables == null ? 0 : rightTables.size();
            int i = 0;
            while (i < size) {
                if (!result.contains(rightTables.get(i))) {
                    result.add(rightTables.get(i));
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    boolean isMatch(DataTable dataTable, int rowIndex, boolean isOriginal) throws Throwable {
        for (WhereExp w : this.sub) {
            if (w.isMatch(dataTable, rowIndex, isOriginal)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasColumnWhereClause(ColumnExp column) {
        for (WhereExp w : this.sub) {
            if (!w.hasColumnWhereClause(column)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ColumnExp> getColumns(MetaDataStructTable table) throws Throwable {
        ArrayList<ColumnExp> result = new ArrayList<ColumnExp>();
        for (WhereExp w : this.sub) {
            for (ColumnExp tmp : w.getColumns(table)) {
                if (result.contains(tmp)) continue;
                result.add(tmp);
            }
        }
        return result;
    }

    @Override
    public Object getColumnValue(ColumnExp column) {
        for (WhereExp w : this.sub) {
            if (!w.hasColumnWhereClause(column)) continue;
            return w.getColumnValue(column);
        }
        return null;
    }

    public List<WhereExp> getSubList() {
        return this.sub;
    }

    @Override
    protected ValueRange getValueRange(ColumnExp column) {
        ValueRange result = null;
        for (WhereExp w : this.sub) {
            result = ValueRange.merge(result, w.getValueRange(column));
        }
        return result;
    }
}

