/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.mid.util;

import com.bokesoft.erp.mid.util.EnsureSingleDBStruct;
import com.bokesoft.erp.mid.util.EnsureSingleDBStruct4TableName;
import com.bokesoft.erp.mid.util.ProcessKeysMigrateDataObject;
import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.base.IStartListener;
import com.bokesoft.yes.mid.base.ServerSetting;
import com.bokesoft.yes.mid.connection.MdbDSNItems;
import com.bokesoft.yes.mid.connection.MultiDBDSNItem;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.mysqls.group.GroupConfig;
import com.bokesoft.yes.mid.mysqls.group.Groups;
import com.bokesoft.yes.mid.schema.DefaultSchemaProvider;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class EnsureDBStruct
implements IStartListener {
    public void invoke(DefaultContext context) throws Throwable {
        ServerSetting serverSetting = ServerSetting.getInstance();
        DefaultSchemaProvider schemaProvider = new DefaultSchemaProvider(context, serverSetting.getDeploy());
        ProcessKeysMigrateDataObject.getMDGroupColumnKeys(schemaProvider.getAllTable(), schemaProvider.getAllKeysMigrationDataObject());
        DefaultContext newContext = null;
        int action = -1;
        Object[] actions = new Object[]{"EnsureDBStruct"};
        try {
            action = Performance.startFirstAction((Object[])actions);
            newContext = new DefaultContext(context.getVE());
            IDBManager dbManager = newContext.getDBManager();
            DataTable tmp = dbManager.execPrepareQuery("SELECT UniqueKey FROM sys_lock where UniqueKey=?", new Object[]{"SYS_Lock_GlobalKey"});
            if (tmp == null || tmp.size() == 0) {
                dbManager.execPrepareUpdate("INSERT INTO sys_lock (UniqueKey) values (?)", new Object[]{"SYS_Lock_GlobalKey"});
            }
            if (dbManager instanceof MultiDBManager) {
                MultiDBManager mdbm = (MultiDBManager)dbManager;
                this.processEnsureDBStruct(mdbm);
            }
            newContext.commit();
        }
        finally {
            if (newContext != null) {
                newContext.close();
            }
            Performance.endActive((int)action, (Object[])actions);
            Performance.printLog();
        }
    }

    public void processEnsureDBStruct(MultiDBManager dbManager) throws Throwable {
        MdbDSNItems dsnCollection = MdbDSNItems.instance;
        Groups groups = GroupConfig.instance.getGroups();
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        CountDownLatch countDownLatch = new CountDownLatch(dsnCollection.getDSNItemSize() - 1);
        for (MultiDBDSNItem dbdsnItem : dsnCollection) {
            String dsnName = dbdsnItem.getName();
            if (dbdsnItem == dsnCollection.getDefaultDSN()) continue;
            executorService.submit(new EnsureSingleDBStruct(dsnName, groups, dbManager.getDBStruct(), countDownLatch));
        }
        executorService.shutdown();
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    public void processEnsureDBStruct4TableName(MultiDBManager dbManager, MetaSchemaTable table) throws Throwable {
        MdbDSNItems dsnCollection = MdbDSNItems.instance;
        Groups groups = GroupConfig.instance.getGroups();
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        CountDownLatch countDownLatch = new CountDownLatch(dsnCollection.getDSNItemSize() - 1);
        for (MultiDBDSNItem dbdsnItem : dsnCollection) {
            String dsnName = dbdsnItem.getName();
            executorService.submit(new EnsureSingleDBStruct4TableName(dsnName, table, groups, dbManager.getDBStruct(), countDownLatch));
        }
        executorService.shutdown();
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }
}

