/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.mid.schema;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.meta.dataobject.SchemaCreator;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ERPSchemaViewDependSchemaTable {
    public final MetaTable metaTable;
    public final List<MetaSchemaTable> dependSchemaTables;

    public ERPSchemaViewDependSchemaTable(MetaDataObject metaDataObject) {
        this.metaTable = metaDataObject.getMainTable();
        SchemaCreator sc = new SchemaCreator(metaDataObject);
        this.dependSchemaTables = sc.getSchemeTableList();
    }

    public boolean isDepend(HashMapIgnoreCase<String> metaSchemaTablesMap) {
        for (MetaSchemaTable tmp : this.dependSchemaTables) {
            if (!metaSchemaTablesMap.containsKey(tmp.getKey())) continue;
            return true;
        }
        return false;
    }

    public List<String> getViewNames() {
        String tableName = this.metaTable.getBindingDBTableName();
        ArrayList<String> result = new ArrayList<String>();
        result.add(tableName);
        return result;
    }

    public Map<String, String> generateViewSqls(IDBManager dbManager) throws Throwable {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String tableName = this.metaTable.getBindingDBTableName();
        StringBuilder viewUnionAll = new StringBuilder(1024);
        viewUnionAll.append("create view ").append(tableName).append(" as ");
        viewUnionAll.append(" select ");
        for (MetaColumn metaColumn : this.metaTable) {
            if (!metaColumn.isPersist().booleanValue() || metaColumn.getGroupType() == 0) continue;
            viewUnionAll.append("x.");
            dbManager.appendKeyWordEscape(viewUnionAll, metaColumn.getBindingDBColumnName()).append(", ");
        }
        viewUnionAll.append("x.");
        dbManager.appendKeyWordEscape(viewUnionAll, "GroupId").append(", ");
        for (MetaColumn metaColumn : this.metaTable) {
            if (!metaColumn.isPersist().booleanValue() || metaColumn.getGroupType() != 0) continue;
            viewUnionAll.append("y.");
            dbManager.appendKeyWordEscape(viewUnionAll, metaColumn.getBindingDBColumnName()).append(", ");
        }
        viewUnionAll.delete(viewUnionAll.length() - 2, viewUnionAll.length());
        viewUnionAll.append(" from ");
        dbManager.appendKeyWordEscape(viewUnionAll, String.valueOf(tableName) + "_NEW").append(" x ");
        viewUnionAll.append(" join ").append(dbManager.keyWordEscape(String.valueOf(tableName) + "_KEYS")).append(" y on x.").append(dbManager.keyWordEscape("GroupId")).append("=y.").append(dbManager.keyWordEscape("OID"));
        viewUnionAll.append(" union all ");
        viewUnionAll.append("select ");
        for (MetaColumn metaColumn : this.metaTable) {
            if (!metaColumn.isPersist().booleanValue() || metaColumn.getGroupType() == 0) continue;
            viewUnionAll.append("x.");
            dbManager.appendKeyWordEscape(viewUnionAll, metaColumn.getBindingDBColumnName()).append(", ");
        }
        viewUnionAll.append("x.");
        dbManager.appendKeyWordEscape(viewUnionAll, "GroupId").append(", ");
        for (MetaColumn metaColumn : this.metaTable) {
            if (!metaColumn.isPersist().booleanValue() || metaColumn.getGroupType() != 0) continue;
            viewUnionAll.append("y.");
            dbManager.appendKeyWordEscape(viewUnionAll, metaColumn.getBindingDBColumnName()).append(", ");
        }
        viewUnionAll.delete(viewUnionAll.length() - 2, viewUnionAll.length());
        viewUnionAll.append(" from ");
        dbManager.appendKeyWordEscape(viewUnionAll, String.valueOf(tableName) + "_INCR").append(" x ");
        viewUnionAll.append(" join ").append(dbManager.keyWordEscape(String.valueOf(tableName) + "_KEYS")).append(" y on x.").append(dbManager.keyWordEscape("GroupId")).append("=y.").append(dbManager.keyWordEscape("OID"));
        result.put(tableName, viewUnionAll.toString());
        return result;
    }
}

