import { bf as BaseExprHandler, bg as VisibleItemType, bh as VisibleItemSet, bi as ExprItemPos, bj as BaseComUIProcess, bk as ExprItemType, bl as ContainerBuilder, C as CompBuilder, bm as TabContainer, bn as FocusFactory, bo as FallBackUtil, m as MetaService, F as FormStack, d as MetaForm, Y as FormFactory, y as FormType, O as OperationState, Z as OptQueue, _ as NewOpt, p as FormBuilder, bp as ZIndexUtil, bq as InterActiveFactory, a3 as FuncMap, T as TypeConvertor, D as DataUtil, u as checkParamNum, v as COMPONENT_NOT_EXISTS, b3 as AttachField, b2 as AttachmentHandler, af as ExceptionStack, br as TableMode, W as FormTarget, r as FormParasUtil, bs as ModalCallbackUtil, bt as SvrMgr, V as ViewContext, a as ControlType, L as LoadingUtil, bu as addPostHandle, bv as CoreException, bw as BaseControl, bx as BaseComponentBuilder, l as Utils } from "./yes-core-73b995f9.js";
import { D as Decimal } from "./vendor-dcacb77b.js";
class TabContainerExprHandler extends BaseExprHandler {
  doCalcItemInit(meta, variant) {
  }
  doEnableItemInit(meta, variant) {
  }
  doCheckItemInit(meta, variant) {
  }
  doVisibleItemInit(meta, tree, variant) {
    var self = this;
    var metaKey = meta.key;
    if (metaKey) {
      var item = self.createVisibleItem(
        metaKey,
        metaKey,
        VisibleItemType.HEAD,
        meta.visible,
        meta.visibleDependency,
        variant
      );
      tree.add(item);
    }
    var tabGroup = meta.tabGroup;
    if (tabGroup) {
      var tabGroupKey = tabGroup.key;
      if (tabGroupKey) {
        var item = self.createVisibleItem(
          tabGroupKey,
          tabGroupKey,
          VisibleItemType.HEAD,
          tabGroup.visible,
          tabGroup.visibleDependency,
          variant
        );
        tree.add(item);
      }
      if (tabGroup.items) {
        var itemSet = new VisibleItemSet(metaKey);
        var index = 0;
        tabGroup.items.forEach(function(com) {
          var comKey = com.key;
          if (comKey) {
            var item2 = self.createVisibleItem(
              comKey,
              metaKey,
              VisibleItemType.COLUMN,
              com.visible,
              com.visibleDependency,
              variant
            );
            var pos = new ExprItemPos();
            pos.setIndex(index);
            item2.setPos(pos);
            itemSet.add(item2);
          }
          index++;
        });
        tree.add(itemSet);
      }
    }
  }
}
class TabContainerUIProcess extends BaseComUIProcess {
  async calcFormulaValue() {
  }
  calcEnableValue() {
  }
  calcCheckRuleValue() {
  }
  async calcVisibleValue(container, cxt, item) {
    var self = this;
    if (item.objectType == ExprItemType.Item) {
      let visible = await self.calcVisible(item, cxt, true);
      container.setVisible(visible);
    } else {
      self.calcTabItemVisible(container, cxt, item);
    }
  }
  calcTabItemVisible(container, cxt, itemSet) {
    var self = this;
    return itemSet.items.reduce(async (prev, item) => {
      await prev;
      let visible = await self.calcVisible(item, cxt, true);
      return container.setTabGropuItemVisible(item.target, visible);
    }, true);
  }
}
class TabContainerBuilder extends ContainerBuilder {
  // container内部配置可以配置tabgroup控件
  build(form, meta, parent) {
    var comp = super.build(form, meta, parent);
    comp.tabGroup = null;
    if (meta.tabGroup) {
      var builder = CompBuilder.get(meta.tabGroup.type);
      if (builder) {
        comp.tabGroup = builder.build(form, meta.tabGroup);
        comp.tabGroup.tabContainer = comp;
      }
    }
    return comp;
  }
  create(meta) {
    return new TabContainer(meta);
  }
}
class FocusPolicy {
  constructor() {
    this.focusOwner = null;
    this.orderList = [];
  }
  init(list) {
  }
  doInitFocus() {
  }
  requestNextFocus() {
  }
  tabFocusNext(focusOwner) {
  }
  enterFocusNext(focusOwner) {
  }
  getFocusOwner() {
    return this.focusOwner;
  }
  setFocusOwner(comp) {
    this.focusOwner = comp;
  }
  getFocusOwnerKey() {
    return this.focusOwner && this.focusOwner.key || null;
  }
}
FocusFactory.setFocuspolicy(FocusPolicy);
class MloginProvider {
  static create(option) {
    if (MloginProvider.instance) {
      return MloginProvider.instance.create(option);
    } else {
      return null;
    }
  }
  static setInstance(i) {
    MloginProvider.instance = i;
  }
}
class MLogin {
  static renderDefault() {
    let path = "./m_login.html";
    this.mlogin.renderDefault(path);
    FallBackUtil.addFallBack({
      fireClose: () => {
        this.removeHtml();
      }
    });
    window.removeLoadingView && window.removeLoadingView();
  }
  static renderLoginForm() {
    let metaService = new MetaService();
    let forms = FormStack.getFormList();
    let form = forms[forms.length - 1];
    return metaService.getMetaForm(this.loginForm).then((meta) => {
      var metaForm = new MetaForm(meta);
      let appEnv = null;
      var emptyForm = FormFactory.create(metaForm, appEnv);
      if ((emptyForm.type == FormType.ENTITY || emptyForm.type == FormType.DICT) && emptyForm.metaForm.initState == OperationState.NEW) {
        emptyForm.setOptQueue(new OptQueue(new NewOpt(emptyForm)));
      }
      return emptyForm.calcCaption().then(() => {
        var builder = new FormBuilder(metaForm.key);
        builder.setContainer(this.container);
        if (forms) {
          builder.setParentForm(form);
        }
        return builder.build(emptyForm).then(() => {
          window.removeLoadingView && window.removeLoadingView();
        });
      });
    });
  }
  static show(callBack) {
    this.mlogin = MloginProvider.create(MLogin);
    if (this.loginForm) {
      this.renderLoginForm();
    } else {
      this.renderDefault();
      let zIndex = ZIndexUtil.getZIndex(null, "login");
      this.mlogin.setZindex(zIndex);
    }
    this.callBack = callBack;
  }
  static setLoginForm(loginForm, startForm) {
    this.loginForm = loginForm;
    this.startForm = startForm;
  }
  static setContainer(container) {
    this.container = container;
  }
  static remove() {
    this.mlogin.remove();
    FallBackUtil.removeFallBack();
    this.callBack();
  }
  // 默认的的登录界面，取消按钮触发的事件
  static removeHtml() {
    this.mlogin.remove();
    if (FallBackUtil.fallBacks.length == 1) {
      FallBackUtil.removeFallBack();
      if (InterActiveFactory.Interactive.canInteractive()) {
        InterActiveFactory.Interactive.doBackPress();
      } else {
        location.reload();
      }
    } else {
      FallBackUtil.removeFallBack();
    }
  }
  static setLoginStatus(flag) {
    this.loginStatus = flag;
  }
  // 配置的登录界面取消
  static doClose(form) {
    if (form.formKey == this.loginForm) {
      if (this.loginStatus) {
        FallBackUtil.removeFallBack();
        this.callBack();
      } else {
        if (FallBackUtil.fallBacks.length == 1) {
          FallBackUtil.removeFallBack();
          if (InterActiveFactory.Interactive.canInteractive()) {
            InterActiveFactory.Interactive.doBackPress();
          } else {
            location.reload();
          }
        } else {
          FallBackUtil.removeFallBack();
        }
      }
    }
  }
}
let BaseUploadAttachment = FuncMap.getFun("UploadAttachment");
let BaseDownloadAttachment = FuncMap.getFun("DownloadAttachment");
const ExportExcel = (evl, name, cxt, args) => {
  var form = cxt.form;
  var needDownload = true;
  var exportTables = "";
  var exportCurPage = false;
  var postExportServiceName = "";
  var exportServiceName = "";
  var exportFileName = "";
  if (args.length > 0) {
    needDownload = TypeConvertor.toBoolean(args[0]);
  }
  if (args.length > 1) {
    exportTables = TypeConvertor.toString(args[1]);
  }
  if (args.length > 2) {
    exportCurPage = TypeConvertor.toBoolean(args[2]);
  }
  if (args.length > 3) {
    postExportServiceName = TypeConvertor.toString(args[3]);
  }
  if (args.length > 4) {
    exportServiceName = TypeConvertor.toString(args[4]);
  }
  if (args.length > 5) {
    exportFileName = TypeConvertor.toString(args[5]);
  }
  var doc = DataUtil.toJSONDoc(form.getDocument());
  var options = {
    needDownload,
    exportTables,
    onlyCurrentPage: exportCurPage,
    exportServiceName,
    postExportServiceName,
    exportFileName,
    service: "ExportFile",
    cmd: "ExportExcel",
    formKey: form.formKey,
    document: JSON.stringify(doc),
    parameters: form.getParas().toJSON(),
    filterMap: JSON.stringify(form.getFilterMap()),
    condition: JSON.stringify(form.getCondParas()),
    mode: 2
  };
  if (InterActiveFactory.Interactive.canInteractive()) {
    InterActiveFactory.Interactive.exportExcel(options);
  }
};
const sumOutGrid = async (form, grid, cxt, cellKey, colIndex, condition) => {
  var sumValue = new Decimal(0);
  var newCxt = new ViewContext(form);
  await grid.getDatas(cxt.getPara("groupKey")).reduce(async (prev, row, i) => {
    await prev;
    if (row.bkmkRow) {
      let rowIndex = row.rowIndex ? row.rowIndex : i;
      newCxt.updateLocation(grid.key, i, colIndex);
      var value = await oneValue(form, grid, newCxt, condition, row, colIndex, rowIndex);
      sumValue = sumValue.plus(value);
    }
  }, true);
  return sumValue;
};
const oneValue = async (form, grid, cxt, condition, row, colIndex, rowIndex) => {
  var ret = true;
  if (condition) {
    ret = await form.__eval(condition, cxt);
  }
  var value = new Decimal(0);
  if (grid.type == ControlType.TABLEVIEW) {
    if (TypeConvertor.toBoolean(ret) && row.data[colIndex]) {
      value = TypeConvertor.toDecimal(row.data[colIndex].value);
    }
  } else {
    if (TypeConvertor.toBoolean(ret)) {
      value = TypeConvertor.toDecimal(grid.getValueAt(rowIndex, colIndex));
    }
  }
  return value;
};
const Sum = (evl, name, cxt, args) => {
  checkParamNum(name, args, 1);
  var form = cxt.form, cellKey = TypeConvertor.toString(args[0]);
  var condition = "";
  if (args.length > 1) {
    condition = TypeConvertor.toString(args[1]);
  }
  var sepIndex = cellKey.indexOf(",");
  if (sepIndex == -1) {
    sepIndex = cellKey.indexOf(":");
  }
  var loc = form.getCellLocation(cellKey), grid = form.getComponent(loc.key);
  if (grid == null) {
    return COMPONENT_NOT_EXISTS(loc.key);
  }
  return sumOutGrid(form, grid, cxt, cellKey, loc.column, condition);
};
const UploadAttachment = (evl, name, cxt, args) => {
  checkParamNum(name, args, 2);
  var tableKey = TypeConvertor.toString(args[1]);
  var maxSize = -1;
  if (args.length > 2) {
    maxSize = TypeConvertor.toLong(args[2]);
  }
  var allowedTypes;
  if (args.length > 3 && args[3]) {
    allowedTypes = TypeConvertor.toString(args[3]);
  }
  var seriesPath = "";
  if (args.length > 6) {
    seriesPath = TypeConvertor.toString(args[6]);
  }
  var callback = "";
  if (args.length > 7) {
    callback = TypeConvertor.toString(args[7]);
  }
  var provider = "";
  if (args.length > 8) {
    provider = TypeConvertor.toString(args[8]);
  }
  var deleteOld = true;
  if (args.length > 9) {
    deleteOld = TypeConvertor.toBoolean(args[9]);
  }
  var form = cxt.form;
  var doc = form.getDocument(), table;
  if (doc) {
    table = doc.getByKey(tableKey);
  }
  var oid = form.getOID();
  if (oid == -1) {
    oid = form.getPara("OID") || -1;
  }
  var grid;
  if (tableKey) {
    grid = form.getGrid(tableKey);
    if (!grid) {
      grid = form.getListView(tableKey);
    }
    if (!grid) {
      grid = form.getTableRow(tableKey);
    }
  }
  var path = "", rowIndex = -1;
  if (grid) {
    rowIndex = grid.getFocusRowIndex();
    var row = grid.getRowDataAt(rowIndex);
    if (row.bkmkRow) {
      table.setByBkmk(row.bkmkRow.getBookmark());
      path = TypeConvertor.toString(table.getByKey(AttachField.PATH));
    }
  } else {
    if (table) {
      table.first();
      path = TypeConvertor.toString(table.getByKey(AttachField.PATH));
    }
  }
  var options = {
    formKey: form.formKey,
    path: encodeURIComponent(path),
    deleteOld,
    seriesPath,
    maxSize,
    types: allowedTypes,
    callback,
    provider,
    oid
  };
  if (InterActiveFactory.Interactive.canInteractive()) {
    InterActiveFactory.Interactive.uploadAttachment(options).then(async function(result) {
      var datas = [];
      result[0] ? datas = result : datas[0] = result;
      var arr = Object.keys(datas);
      for (var i = 0; i < arr.length; i++) {
        var data = datas[arr[i]];
        options.callback = callback;
        await AttachmentHandler.updateAttachmentData(form, grid, data, tableKey, rowIndex, options);
        rowIndex++;
      }
    }).catch((e) => {
      ExceptionStack.push(e, cxt.form);
      throw e;
    });
  } else {
    BaseUploadAttachment(evl, name, cxt, args);
  }
  return true;
};
const DownloadAttachment = (evl, name, cxt, args) => {
  checkParamNum(name, args, 2);
  var form = cxt.form;
  var tableKey = TypeConvertor.toString(args[1]);
  var path = "";
  if (args.length > 2) {
    path = TypeConvertor.toString(args[2]);
  }
  var provider = "";
  if (args.length > 3) {
    provider = TypeConvertor.toString(args[3]);
  }
  if (!path) {
    var doc = form.getDocument(), tbl = doc.getByKey(tableKey);
    if (tbl.tableMode == TableMode.DETAIL) {
      var grid = form.getGrid(tableKey);
      if (grid == null || grid == void 0 || !grid) {
        grid = form.getListView(tableKey);
      }
      if (grid == null || grid == void 0 || !grid) {
        grid = form.getTableRow(tableKey);
      }
      var rowIndex = cxt.getLoc(grid.key).getRow();
      if (rowIndex == -1) {
        return false;
      }
      var row = grid.getRowDataAt(rowIndex);
      tbl.setByBkmk(row.bkmkRow.getBookmark());
    } else {
      tbl.first();
    }
    path = tbl.getByKey(AttachField.PATH);
  }
  if (!path) {
    return false;
  }
  var options = {
    formKey: form.formKey,
    tableKey,
    provider,
    path,
    parameters: form.getParas().toJSON()
  };
  if (InterActiveFactory.Interactive.canInteractive()) {
    InterActiveFactory.Interactive.downloadAttachment(options).catch((e) => {
      ExceptionStack.push(e, cxt.form);
      throw e;
    });
  } else {
    BaseDownloadAttachment(evl, name, cxt, args);
  }
  return true;
};
const ShowByEntry = (evl, name, cxt, args) => {
  checkParamNum(name, args, 1);
  var form = cxt.form;
  var entryPath = args[0];
  var container = form.getContainer();
  var target = FormTarget.NEWTAB;
  var appKey = args[1];
  if (args.length > 1) {
    target = FormTarget.parse(args[1]);
  }
  var builder = new FormBuilder("");
  builder.setContainer(container);
  builder.setTarget(target);
  builder.setParentForm(form);
  return builder.newEmptyByEntry(entryPath, appKey).then((emptyForm) => {
    emptyForm.entryPath = entryPath;
    FormParasUtil.processCallParas(form, emptyForm);
    if ((emptyForm.type == FormType.ENTITY || emptyForm.type == FormType.DICT) && emptyForm.metaForm.initState == OperationState.NEW) {
      emptyForm.setOptQueue(new OptQueue(new NewOpt(emptyForm)));
    }
    return builder.build(emptyForm);
  });
};
const Login = async (evl, name, cxt, args) => {
  var form = cxt.form;
  args[0];
  let userCode = args[0];
  let password = args[1] || "";
  args[2] || -1;
  args[3] || -1;
  let validateCode = args[4];
  var mapCallback = {};
  if (args.length > 5) {
    if (args[5]) {
      mapCallback = ModalCallbackUtil.splitPara(args[5]);
    }
  }
  var form = cxt.form;
  let paras = args[6];
  return SvrMgr.doLogin(userCode, password, paras, validateCode, null, 2).then((ret) => {
    InterActiveFactory.Interactive.saveCookie({ "clientID": ret.clientID });
    MLogin.setLoginStatus(true);
    return form.asyncEval(mapCallback["OK"]);
  }).catch((err) => {
    if (mapCallback["ERROR"]) {
      return form.asyncEval(mapCallback["ERROR"]);
    } else {
      throw err;
    }
  });
};
const mobilefun = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  DownloadAttachment,
  ExportExcel,
  Login,
  ShowByEntry,
  Sum,
  UploadAttachment
}, Symbol.toStringTag, { value: "Module" }));
class ErrorUtils {
  static async loginHtml(callback) {
    MLogin.setLoginStatus(false);
    MLogin.show(callback);
    LoadingUtil.hide();
    return;
  }
  // static async throwE(error, callback) {
  // 	if (ErrorUtils.checkLoginCode(error)) {
  // 		MLogin.setLoginStatus(false);
  // 		//用户未登录，请退出重新登录。 这里需要游客身份登录一次，
  // 		if (error.code === "800A0002") {
  // 			await SvrMgr.touristLogin();
  // 		}
  // 		MLogin.show(callback);
  // 		LoadingUtil.hide();
  // 		return true
  // 	}
  // 	return false
  // }
  static checkLoginCode(error) {
    if (error.code === "800A0011" || error.code === "800A0003" || error.code === "800A0004" || error.code === "800A0005" || error.code === "800A0007" || error.code === "800A0009" || error.code === "800A000A" || error.code === "800A000B" || error.code === "800A000C") {
      ExceptionStack.clear();
      return true;
    } else if (error.code === "800A0002") {
      SvrMgr.touristLogin();
      return true;
    } else {
      return false;
    }
  }
  static LoginInfo() {
    let self = this;
    addPostHandle(function() {
      let response = arguments[0];
      let { error } = response["data"];
      if (error) {
        var e = new CoreException(error.error_code, error.error_info);
        if (self.checkLoginCode(e)) {
          return new Promise((reslove) => {
            ErrorUtils.loginHtml(() => {
              SvrMgr.ErrorUtilsLogin(arguments).then(() => {
                reslove(arguments);
              });
            });
          });
        }
      }
    });
  }
}
class MainMenuProvider {
  static create(option) {
    if (MainMenuProvider.instance) {
      return MainMenuProvider.instance.create(option);
    } else {
      return null;
    }
  }
  static setInstance(i) {
    MainMenuProvider.instance = i;
  }
}
class MainMenu {
  constructor(options) {
    this.form = options.form;
    options.doForm = this.doForm;
    this.entryPath = options.entryPath;
    options.getItems = this.getItems;
    this.mainmenu = MainMenuProvider.create(options);
  }
  async getItems() {
    return await new MetaService(this.form).getEntry(this.entryPath, null);
  }
  doForm(entryPath, formKey) {
    let form = this.form;
    var builder = new FormBuilder(formKey);
    var container = form.getContainer();
    var target = FormTarget.NEWTAB;
    var appKey = null;
    var builder = new FormBuilder("");
    builder.setContainer(container);
    builder.setTarget(target);
    builder.setParentForm(form);
    return builder.newEmptyByEntry(entryPath, appKey).then((emptyForm) => {
      FormParasUtil.processCallParas(form, emptyForm);
      if ((emptyForm.type == FormType.ENTITY || emptyForm.type == FormType.DICT) && emptyForm.metaForm.initState == OperationState.NEW) {
        emptyForm.setOptQueue(new OptQueue(new NewOpt(emptyForm)));
      }
      return builder.build(emptyForm);
    });
  }
}
const _operation = (items, operationkey) => {
  let item;
  for (var i = 0; i < items.length; i++) {
    if (items[i].key == operationkey) {
      item = items[i];
      break;
    }
    if (items[i].items) {
      _operation(items[i].items, operationkey);
    }
  }
  if (item) {
    return item;
  }
};
class NavigationList extends BaseControl {
  constructor(meta) {
    super(meta);
    this.items = meta;
  }
  async doItemOnClick(key, target) {
    if (this.enable) {
      let item = _operation(this.items, key);
      if (item.entryKey) {
        let menu = await this.handler.goEntryPath(this, item.entryKey);
        if (menu) {
          this.doMainMenu(target, menu);
          this.itemHidden();
        }
      }
      return await this.handler.doItemOnClick(this, item.onClick);
    }
  }
  itemHidden() {
    this.impl && this.impl.itemHidden();
  }
  itemShow() {
    this.impl && this.impl.itemShow();
  }
  async doMainMenu(el, menu) {
    let options = {
      el,
      itemHidden: this.itemHidden.bind(this),
      itemShow: this.itemShow.bind(this),
      getImageBase64URL: this.getImageBase64URL.bind(this),
      form: this.getForm(),
      menu,
      entryPath: this.meta.entryPath,
      columnCount: this.meta.columnCount
    };
    this.mainmenu = new MainMenu(options);
  }
}
class NavigationListBuilder extends BaseComponentBuilder {
  constructor() {
    super();
  }
  initParas(form, navlist, meta) {
    super.initParas(form, navlist, meta);
    navlist.items = Utils.isUndefined(meta.items) ? navlist.items : meta.items;
    navlist.source = Utils.isUndefined(meta.source) ? navlist.source : meta.source;
    navlist.imageScaleType = Utils.isUndefined(meta.imageScaleType) ? navlist.imageScaleType : meta.imageScaleType;
    navlist.listRow = Utils.isUndefined(meta.listRow) ? navlist.listRow : meta.listRow;
    navlist.columnCount = Utils.isUndefined(meta.columnCount) ? navlist.columnCount : meta.columnCount;
    navlist.itemStyle = Utils.isUndefined(meta.style) ? navlist.itemStyle : meta.style;
  }
  create(meta) {
    return new NavigationList(meta);
  }
}
CompBuilder.reg(ControlType.NAVIGATIONLIST, new NavigationListBuilder());
export {
  ErrorUtils as E,
  MainMenu as M,
  TabContainerExprHandler as T,
  MLogin as a,
  MloginProvider as b,
  MainMenuProvider as c,
  TabContainerUIProcess as d,
  TabContainerBuilder as e,
  mobilefun as m
};
//# sourceMappingURL=yes-core-m-afcb68d3.js.map
