import Control from "./control.js";
/**
 * 扩展字段，文本框
 */
export default class TextEditor extends Control {
    constructor(options) {
        super(options);
    }

    createHtml() {
        this.el = document.createElement("div");
        this.el.classList.add('login-strip', 'login-' + this.key + '-rows');
        this.el.setAttribute("sortkey", this.key);
        this.el.setAttribute("key", this.key);

        this.$label = document.createElement("div");
        this.$label.classList.add('login-label');
        this.caption && (this.$label.innerHTML = this.caption);
        this.el.appendChild(this.$label);

        this.$inp = document.createElement("input");
        this.$inp.setAttribute("type", 'text');
        this.el.appendChild(this.$inp);
    }
    setDefaultValue() {
        super.setDefaultValue();
        if (this.defaultValue) {
            this.commitValue(this.key, this.defaultValue);
        }
    }
    install() {
        var self = this;
        this.$inp.addEventListener("focusout", (e) => {
            self.commitValue(self.key, e.target.value);
            e.stopPropagation();
        });
    }
}