var completed = function (fn) {
    window.removeEventListener("load", fn);
    document.removeEventListener("DOMContentLoaded", completed);
    fn();
};
//DOMContentLoaded监听来替代$.ready(),不支持的仍用window.onload
window.onload = function (cb) {
    window.addEventListener("load", cb);
    document.addEventListener("DOMContentLoaded", function () {
        completed(cb);
    });
};

/**
 * _targetWin:环境window
 *            适配H5的登录界面是iframe嵌套，这里的window应该是parent.window 
 */
const getLang = (_targetWin = window) => {
    let locale = _targetWin.YIUI.CookiesUtil.get("locale");
    if (!locale) {
        locale = (
            _targetWin.navigator.language || _targetWin.navigator.userLanguage
        ).toLowerCase();
        const idx = locale.indexOf("-");
        locale =
            locale.substring(0, idx) +
            "-" +
            locale.substring(idx + 1).toUpperCase();
    }

    return locale;
}

/**
 * 设置默认多语言
 * _targetWin:环境window
 *            适配H5登录界面是iframe嵌套，这里的window应该是parent.window 
 */
export const setDefaultLanguage = (_targetWin = window) => {
    return new Promise(resolve => {
        _targetWin.addEventListener("YIUI-loaded", async e => {
            var language = getLang(_targetWin);
            try {
                if (language && language !== "zh-CN") {
                    const i18NData = await import(`../home/js/language/${language}/data/i18n.js`);
                    const plugInData = await import(`../home/js/language/${language}/data/plug-in.js`);
                    const stringtableData = await import(`../home/js/language/${language}/data/stringtable.js`);
                    _targetWin.YIUI.I18N.reg(i18NData.default);
                    _targetWin.YIUI.I18N.reg(plugInData.default);
                    _targetWin.YIUI.I18N.regStringTables(stringtableData.default);
                }
            } catch (error) {
                console.error(`“${language}”语言载入失败`, error);
            } finally {
                resolve();
            }
        });
    });
};
/**
 * 设置登录界面I18N
 */
export const setI18N = (_targetWin = window) => {
    return new Promise(resolve => {
        _targetWin.addEventListener("YIUI-loaded", async e => {
            let locale = _targetWin.YIUI.CookiesUtil.get("locale");
            try {
                if (locale) {
                    // I18N会校验版本，重置
                    _targetWin.YIUI.I18N.seti18nVersion(-1);
                    let strings = await _targetWin.YIUI.SvrMgr.loadi18nData();
                    _targetWin.YIUI.I18N.seti18nStrings(strings);
                    var doms = document.querySelectorAll('[i18n]');
                    for (var i = 0; i < doms.length; i++) {
                        var dom = doms[i];
                        var zhCNText = dom.getAttribute('zh-CN');
                        var langText = _targetWin.YIUI.I18N.getString(zhCNText, zhCNText);
                        if (langText) {
                            dom.innerText = langText;
                            if (dom.classList.contains('login-label')) {
                                var next = dom.nextElementSibling;
                                if (next && next.tagName.toUpperCase() == "INPUT") {
                                    next.placeholder = langText;
                                }
                            }
                        }

                    }
                }
            } catch (error) {
                console.error(error);
            } finally {
                resolve();
            }
        });
    });
};

// 后台服务未开启之前，判断服务状态
const statusResponse = async () => {
    const response = await fetch("./health/yigo-container/status", {
        "headers": {
            "content-type": "application/x-www-form-urlencoded;charset=UTF-8",
        },
        "body": "service=YigoUxService&cmd=GetSetting&mode=1&isYES2=true",
        "method": "POST"
    });
    return response.json()
}
const loadLogin = async () => {
    await setI18N();
    // 调用ux相关
    const uxSetting = await fetch("./servlet/YigoUxService/GetSetting", {
        "headers": {
            "content-type": "application/x-www-form-urlencoded;charset=UTF-8",
        },
        "body": "service=YigoUxService&cmd=GetSetting&mode=1&isYES2=true",
        "method": "POST"
    });
    const result = await uxSetting.json();
    window.YigoClassicUxSetting = result.data;
    import("../login/js/login.js")
}
/**
 * 载入 登录页面 脚本
 */
export const initLoginPage = async () => {
    await setDefaultLanguage(); // 设置多语言
    if (YIUI.AppSetting.isDev) { // 开发模式
        await setI18N();
        await loadUXSetting();
        import("../login/js/login.js")
    } else { // 生产模式
        document.querySelector('.login-main').style.display = 'none';
        document.querySelector('.waitting-box').style.display = 'flex';
        // 页面开启时，如果后台服务已经启动完毕，那么界面上已经注入READY的状态
        const InstanceStatus = window.YigoClientPageVariable && window.YigoClientPageVariable.InstanceStatus;
        if (InstanceStatus && InstanceStatus.status === "READY") {
            await loadLogin();
        } else {
            // 优先请求一次，判断此时的状态
            const { status } = await statusResponse();
            if (status === "READY") {
                await loadLogin();
            } else {
                let timer = setInterval(async () => {
                    try {
                        const { status } = await statusResponse();
                        if (status === "READY") {
                            timer && clearInterval(timer);
                            await loadLogin()
                        }
                    } catch (error) {
                        // 如果这里有报错，先吃掉
                    }
                }, 3 * 1000);
            }
        }
    }
};

/**
 * 载入 mainFrame 页面 脚本
 */
export const initMainFramePage = async () => {
    await setDefaultLanguage(); // 设置多语言
    await loadUXSetting();
    const { uxInit } = await import("../ux/load-ux.js");
    await uxInit();

    await import("../home/js/home.js");
    await import("../home/js/navigation.js");
    import("../extension/yigo-extension.js");
};

/**
 * 载入 mainFrame-m 页面 脚本
 */
export const init_M_Home_Page = async () => {
    await setDefaultLanguage(); // 设置多语言
    await loadUXSetting();
    import("../ux/load-mux.js");
};

/**
 * 加载UX相关数据，考虑开发环境，生产环境下，这里window已经存在相关数据
 * 将原有的load-ux.js中的逻辑移到此处
 */
export const loadUXSetting = async () => {
    if ((window.location.hash || "").indexOf("debug=ux") >= 0) { /* 支持使用 /yigo/#debug=ux 进行调试 */
        //这部分代码只用于调试, 因为还需要考虑不包含 UX 运行的情况
        const response = await fetch("./servlet/YigoUxService/GetSetting", {
            "headers": {
                "content-type": "application/x-www-form-urlencoded;charset=UTF-8",
            },
            "body": "service=YigoUxService&cmd=GetSetting&mode=1&isYES2=true",
            "method": "POST"
        });
        const result = await response.json();
        window.YigoClassicUxSetting = result.data;
    } else {
        if (window.YigoClientPageVariable) {
            window.YigoClassicUxSetting = window.YigoClientPageVariable.YigoClassicUxSetting;
        }
    }
};

/**
 * 获取UX配置对应的数据
 */
export const GetLangSetting = (value) => {
    if (window.YigoClassicUxSetting) {
        let extendedFields = window.YigoClassicUxSetting.loginDecoration?.extendedFields;
        return extendedFields?.filter(item => item.key === value)[0];
    }
    return null;
};