import { Y as YElement, e as YesVBaseComponent, T as Tabs$1, g as addClass, D as Dialog, i as hasClass, j as YesVGrid, k as YesDictTrace, a as YesGridBuilder, C as ControlMapping, l as YesDictViewBuilder, m as YesDictBuilder } from "./yes-ui-29852ed4.js";
import { i as DesignModeSetting, a as ControlType, aT as Form, b7 as SessionInfo, S as StringUtil, b8 as PositionUtil, b9 as HistoryInputCache, ab as extend, aN as OperatorParas, o as MainUIOptTracer, I as I18N, a8 as DialogType, W as FormTarget, F as FormStack, ba as StackContainer, bb as ModalContainer, bc as DictTraceUtil, bd as DictTraceHandler, be as RichEditorProvider, n as FormEvent, T as TypeConvertor, p as FormBuilder } from "./yes-core-73b995f9.js";
import { h } from "./vendor-dcacb77b.js";
import { H as HistorySetting, S as ShowHelpTxt, A as AutoRecord, R as RecordCase, P as Polling, D as DOMUtil } from "./erp-yes-core-25f33c37.js";
const historyInputCache = new HistoryInputCache();
var historyInputMouseDown = (self) => {
  let mdHandler = (e) => {
    try {
      const target = e.target;
      console.log("历史记录：", self._hasShow, target.tagName, target.classList.contains("historyinput-item"));
      if (self._hasShow && target.tagName != "LI" || !target.classList.contains("historyinput-item")) {
        self.hideDropView();
      }
      document.removeEventListener("mousedown", mdHandler);
    } catch (e2) {
      document.removeEventListener("mousedown", mdHandler);
      throw e2;
    }
  };
  document.addEventListener("mousedown", mdHandler);
};
class HistoryInput {
  constructor(yescomp) {
    this.yescomp = yescomp;
    const owner = yescomp.owner;
    this.owner = owner;
    this.cacheKey = owner && this.getHistoryCacheKey(owner);
    this.inputEl = this.cacheKey && owner && yescomp.getInput && yescomp.getInput();
    this.isNeedCacheHistory = this.cacheKey && this.inputEl && this.needCacheHistory(owner);
  }
  render() {
    if (!this.isNeedCacheHistory) {
      return;
    }
    this.createHtml();
    this.install();
  }
  createHtml() {
    this.$dropView = YElement.buildFromVNode(h("div.historyinput"));
    var rawDropview = document.createElement("div");
    document.body.appendChild(rawDropview);
    this.$dropView.$setRawDomElm(rawDropview);
    this.$dropView.$addClass("ui-hidden").$setAttr("id", this.yescomp.owner.getId() + "_historyinput");
    this.$dropUl = YElement.buildFromVNode(h("ul")).$appendTo(this.$dropView);
  }
  install() {
    if (!this.inputEl) {
      return;
    }
    const self = this;
    self.bindHistoryKeydown();
    self.inputEl.$addListener("blur", () => {
      if (self._hasShow) {
        return;
      }
      self.hideDropView();
    });
  }
  destroy() {
    this.$dropView && this.$dropView.$remove();
  }
  needCacheHistory(owner) {
    if (!owner) {
      return false;
    }
    const isDeployMode = !DesignModeSetting.isDesignMode && !(owner.tableKey && owner.tableKey === "MetaForm");
    const isSupportHistory = !owner.noHistory && owner.visible && (owner.type === ControlType.TEXTEDITOR || owner.type === ControlType.MASKEDITOR || owner.type === ControlType.TEXTAREA || owner.type === ControlType.TEXTBUTTON || owner.type === ControlType.NUMBEREDITOR || owner.type === ControlType.DATEPICKER || owner.type === ControlType.UTCDATEPICKER || owner.type === ControlType.MONTHPICKER || owner.type === ControlType.TIMEPICKER || owner.type === ControlType.DICT || owner.type === ControlType.DYNAMICDICT || owner.type === ControlType.COMPDICT);
    return isDeployMode && isSupportHistory;
  }
  getCacheKey() {
    return this.cacheKey;
  }
  getHistoryCacheKey(owner) {
    const form = owner.getForm && owner.getForm();
    if (!form || !(form instanceof Form)) {
      console.warn("HistoryInput owner is not a component", owner.key, owner.type);
      return "";
    }
    var entryKey = form ? form.getPara("EntryKey") : "";
    var formKey = form ? form.getFormKey() : "global";
    var userId = SessionInfo.getUserID();
    var tagName = owner.meta.tagName;
    var key = owner.meta.key;
    return userId + "__" + tagName + "__" + entryKey + "__" + formKey + "__" + key;
  }
  static cacheHistoryInput(yescomp, cacheKey, ri = -1, ci = -1) {
    if (!cacheKey) {
      return [];
    }
    const owner = yescomp.owner;
    const settingDef = HistorySetting.loadSetting(owner == null ? void 0 : owner.getForm());
    const getShowTextDef = async () => {
      var _a;
      if (owner.cellType == owner.type) {
        const grid = owner.getControl();
        const caption = (_a = grid.getCellDataAt(ri, ci)) == null ? void 0 : _a.caption;
        return caption;
      }
      return owner == null ? void 0 : owner.getShowText();
    };
    return Promise.all([settingDef, getShowTextDef()]).then((result) => {
      return HistoryInput.addCache(cacheKey, result);
    });
  }
  static addCache(cacheKey, inputData) {
    const [setting, showText] = inputData;
    const text = showText && StringUtil.trim(showText);
    if (!text) {
      return;
    }
    if (text.length < setting.minItemLength || text.length > setting.maxItemLength) {
      return;
    }
    return historyInputCache.get(cacheKey).then((cacheValue) => {
      const timestamp = (/* @__PURE__ */ new Date()).getTime();
      if (!cacheValue) {
        const cacheValue2 = [{ "content": text, "timestamp": timestamp }];
        historyInputCache.put(cacheKey, cacheValue2);
        return;
      }
      const existItem = cacheValue.find((item) => item.content === text);
      if (existItem) {
        existItem.timestamp = timestamp;
      } else {
        const historyItem = { "content": text, "timestamp": timestamp };
        cacheValue.push(historyItem);
      }
      const maxItemCount = setting.maxItemCount;
      const curItemCount = cacheValue.length;
      if (curItemCount > maxItemCount) {
        cacheValue.sort((a, b) => b.timestamp - a.timestamp);
        cacheValue.splice(maxItemCount);
      }
      historyInputCache.put(cacheKey, cacheValue);
    });
  }
  bindHistoryKeydown() {
    const input = this.inputEl;
    const needCache = this.isNeedCacheHistory;
    if (!needCache) {
      return;
    }
    const self = this;
    const keydownHandler = async (event) => {
      if (!self.$dropView) {
        return;
      }
      const key = event.key;
      let needRenderHistoryInput = false;
      if (key === " ") {
        needRenderHistoryInput = true;
      }
      if (event.shiftKey && key === "Enter") {
        needRenderHistoryInput = true;
      }
      if (needRenderHistoryInput) {
        await self.openDropView();
      }
      if (key === "Tab") {
        self.hideDropView();
      }
    };
    input.$keydown(keydownHandler);
  }
  async openDropView() {
    const self = this;
    if (self._hasShow) {
      return;
    }
    const viewItems = await this.getMatchHistoryItems();
    const list = this.$dropUl;
    list.$empty();
    if (viewItems && viewItems.length > 0) {
      for (var i = 0, _len = viewItems.length; i < _len; i++) {
        const _li = YElement.buildFromVNode(
          h(
            "li.historyinput-item",
            {
              attrs: {
                itemValue: viewItems[i].content,
                index: i
              },
              on: {
                mousedown: async (e) => {
                  await self.itemClick.call(this, e, self);
                }
              }
            },
            viewItems[i].content
          )
        );
        _li.$appendTo(list);
      }
      self.$dropView.$removeClass("ui-hidden");
    }
    self.$dropView.addPostpatchHook(() => {
      if (!self.$dropView.hasClass("ui-hidden")) {
        PositionUtil.setViewPos(
          self.yescomp.el.getElm(),
          self.$dropView.getElm(),
          false
        );
        self._hasShow = true;
        historyInputMouseDown(self);
      }
    });
    self.$dropView.$slideDown();
  }
  hideDropView() {
    this.$dropView.$slideUp();
    this.$dropView.$addClass("ui-hidden");
    this._hasShow = false;
  }
  itemClick(e, self) {
    var _a, _b;
    e.preventDefault();
    console.log("历史记录", "itemClick", this.inputEl);
    (_a = this.inputEl) == null ? void 0 : _a.$focus();
    const value = e.target.getAttribute("itemValue");
    value && ((_b = this.inputEl) == null ? void 0 : _b.$setInputValue(value));
    self.hideDropView();
  }
  async getMatchHistoryItems() {
    var _a;
    const setting = await HistorySetting.loadSetting((_a = this.owner) == null ? void 0 : _a.getForm());
    if (!setting || !setting.enable) {
      return;
    }
    const input = this.inputEl.getElm();
    const searchValue = StringUtil.trim(input == null ? void 0 : input.value);
    let cacheValue = await historyInputCache.get(this.cacheKey);
    if (!cacheValue || cacheValue.length == 0) {
      return;
    }
    let matchedItems = cacheValue;
    let matcher = searchValue && new RegExp(this.escapeRegex(searchValue), "i");
    matchedItems = cacheValue.filter((item, index) => {
      let match = !!item.content;
      if (matcher) {
        const i = item.content && item.content.search(matcher);
        match = i != null && i !== "" && i >= 0;
      }
      return match;
    });
    matchedItems && matchedItems.sort((item1, item2) => {
      if (matcher) {
        return item1.content.search(matcher) - item1.content.search(matcher);
      }
      return item2.timestamp - item1.timestamp;
    });
    if (!this.matchAllHistoryItem && matchedItems) {
      const curMatchCount = matchedItems.length;
      const maxMatchCount = setting.maxMatchCount;
      if (curMatchCount > maxMatchCount) {
        matchedItems.splice(maxMatchCount);
      }
    }
    return matchedItems;
  }
  escapeRegex(value) {
    return value.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g, "\\$&");
  }
}
YElement.buildFromVNode;
class YesVBaseComponentExt {
  afterRender() {
    var _a;
    this.installHelpEvent();
    this.base.afterRender();
    !this.inputHis && (this.inputHis = new HistoryInput(this));
    (_a = this.inputHis) == null ? void 0 : _a.render();
  }
  destroy() {
    this.inputHis && this.inputHis.destroy();
    this.inputHis = null;
    this.base.destroy();
  }
  installHelpEvent() {
    var _a, _b, _c, _d;
    const self = this;
    const meta = (_a = self.owner) == null ? void 0 : _a.meta;
    const form = (_b = self.owner) == null ? void 0 : _b.getForm();
    if (!form || !meta) {
      return;
    }
    if (meta.type == ControlType.RADIOBUTTON || meta.type == ControlType.CHECKBOX) {
      (_c = self.el) == null ? void 0 : _c.$click(() => {
        form.formID;
        form.currentFocusedKey = meta.key;
      });
    } else if (meta.type != ControlType.GRID && meta.type != ControlType.CONTAINER && meta.type != ControlType.DICTVIEW) {
      self.getInput && ((_d = self.getInput()) == null ? void 0 : _d.$click(() => {
        form.formID;
        form.currentFocusedKey = meta.key;
      }));
    }
  }
  async commitValue(...args) {
    var _a, _b;
    const owner = this.owner;
    if (owner.hasOwnProperty("key")) {
      await OperatorParas.setCommitValueCompKey(owner.key);
    }
    const isNeedCacheHistory = (_a = this.inputHis) == null ? void 0 : _a.isNeedCacheHistory;
    const cacheKey = (_b = this.inputHis) == null ? void 0 : _b.getCacheKey();
    const change = await owner.commitValue.apply(owner, args);
    await HistoryInput.cacheHistoryInput(this, isNeedCacheHistory && cacheKey, owner.rowIndex, owner.colIndex);
    if (change != false && !owner.getControl()) {
      owner.getForm().getUIOptTracer().traceOnValueChanged(owner, owner.value);
    }
    return change;
  }
}
extend(YesVBaseComponent, YesVBaseComponentExt);
class TabsExt {
  install() {
    const self = this;
    self.base.install();
    self.ul.addEventListener("contextmenu", function(e) {
      var e = e || window.event, target = e.target.closest("li");
      if (!target)
        return;
      const li = target.closest("li");
      const formID = li.getAttribute("formID");
      const menu = self.createTabsContextMenu(formID);
      menu.style.left = e.clientX + "px";
      menu.style.top = e.clientY + "px";
      menu.style.zIndex = 99;
      menu.style.display = "block";
      let key = li.getAttribute("formKey") || "";
      let caption = li.innerText || "";
      MainUIOptTracer.getInstance().traceOnClick(MainUIOptTracer.ClickType.FormTabItemRightClick, { key, caption });
    });
  }
  createTabsContextMenu(formID) {
    const self = this;
    document.oncontextmenu = function(e) {
      var ev = e || window.event;
      if (ev.preventDefault) {
        ev.preventDefault();
      } else {
        ev.returnValue = false;
        ev.cancelBubble = true;
      }
      return false;
    };
    let menu = document.getElementById("contextmenu_main_tabs");
    const mousedownHandler = function(e) {
      document.oncontextmenu = function(e2) {
        var ev = e2 || window.event;
        return ev.returnValue = true;
      };
      var stop = hasClass(e.target, "menu-list");
      if (!stop) {
        stop = e.target.closest(".menu-list");
      }
      if (stop) {
        return false;
      }
      menu.style.display = "none";
      document.removeEventListener("mousedown", mousedownHandler);
    };
    document.addEventListener("mousedown", mousedownHandler);
    if (menu) {
      menu.setAttribute("formID", formID);
      return menu;
    }
    menu = document.createElement("div");
    addClass(menu, "contextmenu");
    menu.setAttribute("id", "closemenu");
    menu.setAttribute("formID", formID);
    menu.style.position = "fixed";
    self.parent.appendChild(menu);
    const ul = document.createElement("ul");
    addClass(ul, "menu-list");
    ul.setAttribute("id", "closemenu_ul");
    menu.appendChild(ul);
    const menuItems = [
      {
        id: "closeall",
        caption: I18N.getString("GRID_COLSEALL", "关闭所有")
      },
      {
        id: "closeright",
        caption: I18N.getString("GRID_COLSERIGHT", "关闭右侧")
      },
      {
        id: "closeleft",
        caption: I18N.getString("GRID_COLSELEFT", "关闭左侧")
      },
      {
        id: "closeother",
        caption: I18N.getString("GRID_COLSEOTHER", "关闭其他")
      }
    ];
    menuItems.forEach((item) => {
      const id = item.id;
      const caption = item.caption;
      const li = document.createElement("li");
      li.setAttribute("id", id);
      ul.appendChild(li);
      const a = document.createElement("a");
      a.innerText = caption;
      li.appendChild(a);
    });
    menu.addEventListener("click", function(e) {
      var e = e || window.event, target = e.target.closest("li");
      if (!target)
        return;
      const targetFormID = parseInt(menu.getAttribute("formID"), 10);
      if (targetFormID <= 0) {
        return;
      }
      const li = target.closest("li");
      const action = li.getAttribute("id");
      MainUIOptTracer.getInstance().traceOnClick(MainUIOptTracer.ClickType.FormTabItemRightClick, { menuAction: action, menuItems });
      self.doContextMenuAction(targetFormID, action).then(() => {
        document.oncontextmenu = function(e2) {
          var ev = e2 || window.event;
          return ev.returnValue = true;
        };
        menu.style.display = "none";
        document.removeEventListener("mousedown", mousedownHandler);
      });
    });
    return menu;
  }
  async doContextMenuAction(formID, action) {
    if (action == "closeall") {
      await this.closeAll();
    } else if (action == "closeother") {
      const result = await this.closeOther(formID);
      if (result) {
        this.setCurrent(formID);
      }
    } else if (action == "closeleft") {
      await this.closeLeft(formID);
    } else if (action == "closeright") {
      await this.closeRight(formID);
    }
  }
  closeLeft(formID) {
    var self = this;
    var options = {
      msg: I18N.getString(
        "TOOLBAR_CLOSELEFT",
        "是否关闭左边表单?"
      ),
      msgType: DialogType.YES_NO,
      events: {
        YES: function() {
          let id = parseInt(formID, 10);
          const tabs = self.ul.querySelectorAll("li.ui-state-default.tabcontainer");
          for (let index = 0; index < tabs.length; index++) {
            const tab = tabs[index];
            const targetFormID = parseInt(tab.getAttribute("formID"), 10);
            if (targetFormID == id) {
              break;
            }
            const yesform = self.yesformMap.get(targetFormID);
            const form = yesform.form;
            if (form.entryClose != false) {
              form.close();
            }
          }
          self.setCurrent(formID);
          return Promise.resolve(true);
        },
        NO: function() {
          return Promise.resolve(false);
        }
      }
    };
    var dialog = new Dialog(options);
    return dialog.show();
  }
  closeRight(formID) {
    var self = this;
    var options = {
      msg: I18N.getString(
        "TOOLBAR_CLOSERIGHT",
        "是否关闭右边表单?"
      ),
      msgType: DialogType.YES_NO,
      events: {
        YES: function() {
          let id = parseInt(formID, 10);
          const tabs = self.ul.querySelectorAll("li.ui-state-default.tabcontainer");
          for (let index = tabs.length; index > 0; index--) {
            const tab = tabs[index - 1];
            const targetFormID = parseInt(tab.getAttribute("formID"), 10);
            if (targetFormID == id) {
              break;
            }
            const yesform = self.yesformMap.get(targetFormID);
            const form = yesform.form;
            if (form.entryClose != false) {
              form.close();
            }
          }
          self.setCurrent(formID);
          return Promise.resolve(true);
        },
        NO: function() {
          return Promise.resolve(false);
        }
      }
    };
    var dialog = new Dialog(options);
    return dialog.show();
  }
  addTab(form) {
    const ul = this.ul;
    const formID = form.formID;
    const tab = document.createElement("li");
    tab.classList.add("ui-state-default", "tabcontainer");
    tab.setAttribute("aria-controls", formID + "_main_ct");
    tab.setAttribute("formKey", form.formKey);
    tab.setAttribute("draggable", "true");
    form.entryPath && tab.setAttribute("entryPath", form.entryPath);
    form.entryParas && tab.setAttribute("paras", form.entryParas);
    tab.setAttribute("formid", formID);
    tab.addEventListener("click", (e) => {
      if (formID === this.currentFormID) {
        return;
      }
      MainUIOptTracer.getInstance().traceOnClick(
        MainUIOptTracer.ClickType.FormTabItemClick,
        { key: form.formKey, caption: form.getCaption() }
      );
      this.setCurrent(formID);
      form.doActiveEvent();
      MainUIOptTracer.getInstance().traceOnResult(
        null,
        { key: form.formKey, caption: form.getCaption(), clickType: MainUIOptTracer.ClickType.FormTabItemClick }
      );
      e.stopPropagation();
    });
    this.dragHandler(tab);
    const activeFormID = this.getActiveFormID() || -1;
    const activeTab = activeFormID > 0 && ul.querySelector('li[formid="' + activeFormID + '"]');
    let target = form.getParentForm() ? form.getTarget() : form.getMetaForm().target;
    if (target == FormTarget.NEWTAB && activeTab) {
      activeTab.after(tab);
    } else {
      ul.appendChild(tab);
    }
    const a = document.createElement("a");
    a.classList.add("ui-tans-anchor");
    tab.appendChild(a);
    const label = document.createElement("label");
    label.classList.add("ui-anchor-label");
    label.innerHTML = form.getAbbrCaption();
    a.appendChild(label);
    const span = document.createElement("span");
    span.classList.add("tab-icon", "tab-icon-close");
    a.appendChild(span);
    if (form.entryClose == false) {
      span.style.display = "none";
    }
    span.addEventListener("click", (e) => {
      e.stopPropagation();
      if (form) {
        MainUIOptTracer.getInstance().traceOnClick(
          MainUIOptTracer.ClickType.FormTabItemClose,
          { key: form.formKey, caption: form.getCaption() }
        );
        form.fireClose();
      }
    });
  }
  setCurrent(formID) {
    this.base.setCurrent(formID);
  }
  show(info) {
    let list = this.getTabListByFormKey(info.formKey);
    let len = list.length;
    if (!len) {
      return false;
    }
    for (let i = 0; i < len; i++) {
      var paras = list[i].getAttribute("paras") || "";
      var entryPath = list[i].getAttribute("entryPath") || "";
      if (paras == info.paras && entryPath == info.path) {
        const formID = list[i].getAttribute("formID");
        this.setCurrent(formID);
        return true;
      }
    }
    return false;
  }
}
const Tabs = extend(Tabs$1, TabsExt);
const initHelp = () => {
  document.addEventListener("keydown", (e) => {
    if (e.keyCode != 112) {
      return;
    }
    e.preventDefault();
    const currentForm = FormStack.findFocusForm();
    if (currentForm) {
      const _formKey = currentForm.formKey;
      const fo = currentForm.getFocusManager().getFocusOwner();
      let _fieldKey = currentForm.currentFocusedKey || fo && fo.key || "";
      if (fo && fo.type == ControlType.GRID) {
        const row = fo.getFocusRowIndex();
        const col = fo.getFocusColIndex();
        if (row >= 0 && col >= 0) {
          const dataCol = fo.findIndex(fo.getViewColumnAt(col).key);
          const cellData = fo.getCellDataAt(row, dataCol);
          _fieldKey = cellData.meta.key;
        }
      }
      if (_fieldKey) {
        currentForm.currentFocusedKey = _fieldKey;
        ShowHelpTxt(null, "", null, ["DZ", _formKey + "&" + _fieldKey]);
      }
    }
  });
};
const popdicttrace = "";
class YesVGridExt extends YesVGrid {
  //     createCellEditor(options: any, cell: any, ri: any, ci: any, vci: any, opt: any): void {
  //         options.rowIndex = ri;
  //         options.colIndex = ci;
  //         const result = super.createCellEditor(options, cell, ri, ci, vci, opt);
  //         if (options.commitValue) {
  //             const baseCommitValue = options.commitValue;
  //             options.commitValue = value => {
  //                 const editor = cell.getCustomData("editor");
  //                 if (!editor) {
  //                     return baseCommitValue(value);
  //                 }
  //                 var cellEditOpt = this.owner.getCellEditOpt(ri, ci);
  //                 cellEditOpt.displayCols = editor.displayCols;
  //                 return baseCommitValue(value);
  //             }
  //         }
  //         return result;
  //     }
  // editCellAttrs(column, editOpt, cellData, rowData) {
  //     return {
  //         'meta-cellkey': editOpt.key,
  //         'meta-columnkey': editOpt.columnKey
  //     }
  // }
  enhanceCell(rowData, cellData, $cell, ri, ci, vci) {
    if (!rowData || !cellData || !cellData.meta) {
      return;
    }
    const meta = cellData.meta;
    const itemKey = meta.itemKey || meta.editOptions && meta.editOptions.itemKey || meta.properties && meta.properties.itemKey;
    const form = this.owner.getForm();
    let canPopDict;
    if (form.getContainer() instanceof StackContainer && form.getContainer().getForm().getContainer() instanceof ModalContainer || form.getContainer() instanceof ModalContainer) {
      canPopDict = false;
    } else {
      canPopDict = DictTraceUtil.canPopupDict(form, meta, itemKey);
    }
    if (canPopDict) {
      const h_opts = {
        form: this.owner.getForm(),
        meta: cellData.meta,
        itemKey
      };
      const handler = new DictTraceHandler(h_opts);
      const opts = {
        container: $cell,
        associatedComp: this.owner,
        key: cellData.key,
        meta: cellData.meta,
        handler,
        form: this.owner.getForm(),
        ri,
        ci
      };
      const yestrace = new YesDictTrace(opts);
      yestrace.render($cell);
    }
  }
  // editCell(rowIndex, colIndex, editCell:YElement){
  //     const popElms = editCell.$findByClassName("popup-dic-td");
  //     if(popElms && popElms.length==1){
  //         popElms[0].$addClass('ui-hidden');
  //     }
  // }
  // endEditCell(ri, ci, cell){
  //     const popElms = cell.$findByClassName("popup-dic-td");
  //     if(popElms && popElms.length==1){
  //         popElms[0].$removeClass('ui-hidden');
  //     }
  // }
  addExtOpt() {
    var _a;
    const gridKey = this.key;
    const form = (_a = this.owner) == null ? void 0 : _a.form;
    if (!form || "GridSettingVariantDialog" == form.getFormKey()) {
      return [];
    }
    const hasTree = this.options.hasTree;
    const opts = [];
    if (hasTree) {
      if (this.owner.add)
        ;
      opts.push({
        key: "ExpandAll",
        caption: I18N.getString("GRID_Tree_ExpandAll", "全部展开"),
        cssClass: "ui-icon-expand-all",
        visible: "true",
        content: "ExpandAll('" + gridKey + "');"
      });
      opts.push({
        key: "CollapseAll",
        caption: I18N.getString("GRID_Tree_CollapseAll", "全部折叠"),
        cssClass: "ui-icon-collapse-all",
        visible: "true",
        content: "CollapseAll('" + gridKey + "');"
      });
    }
    opts.push({
      key: "ClickPaste",
      caption: I18N.getString("GRID_ClickPaste", "点击粘贴"),
      cssClass: "ui-icon-clickpaste",
      visible: "true",
      content: "ClickPaste('" + gridKey + "');"
    });
    opts.push({
      key: "FilePaste",
      caption: I18N.getString("GRID_FilePaste", "上传粘贴"),
      cssClass: "ui-icon-filepaste",
      visible: "true",
      content: "FilePaste('" + gridKey + "');"
    });
    if (this.owner.locate || this.owner.meta.locate) {
      opts.push({
        key: "locate",
        caption: I18N.getString("LOCATE", "定位"),
        cssClass: "ui-icon-extOpt ui-icon-locate",
        content: "ShowLocateForm('" + gridKey + "')"
      });
    }
    return opts;
  }
  // 寻找下一个焦点,参数为keyCode, row, column, dir
  // keyCode: tab=> 9, enter => 13,108
  // row,column 当前焦点行列,dir:方向
  // 返回为空表示内置方法处理
  // findFocusPos(keyCode, row, column, dir) {
  //     let form = this.owner.getForm();
  //     const isERPForm = form && form.getIsERPForm && form.getIsERPForm();
  //     if(!isERPForm){
  //         return;
  //     }
  //     if (keyCode == 13 || keyCode == 108) {
  //         const viewColumns = this.owner.getViewColumns();
  //         if (!viewColumns) {
  //             return;
  //         }
  //         const length = viewColumns.length;
  //         for( let i = column + 1;i < length;i++ ) {
  //             if (viewColumns[i].visible) {
  //                 return { row, column:i };
  //             }
  //         }
  //         return {};
  //     }
  // }
}
class YesGridBuilderExt extends YesGridBuilder {
  static create(options) {
    return new YesVGridExt(options);
  }
}
RichEditorProvider.regCustomOperator("helpAddLink", {
  render: (key, el, yesCom) => {
    var self = yesCom;
    el.className = `custom-${key}`;
    el.addEventListener("click", () => {
      const pForm = self.owner.getForm();
      if (!pForm) {
        return;
      }
      const builder = new FormBuilder("AddLink");
      builder.setTarget(FormTarget.MODAL);
      builder.setParentForm(pForm);
      builder.newEmpty().then((form) => {
        return new Promise((resove, reject) => {
          form.regEvent(FormEvent.CLOSE, function() {
            const content = TypeConvertor.toString(form.getPara("LinkContent"));
            console.log(content);
            resove(content);
          });
          return builder.build(form);
        });
      }).then((data) => {
        if (data.length > 0) {
          self.editor.focus();
          var range = self.editor.getSelection();
          self.editor.insertText(range.index, data);
          self.finishInput();
        }
      });
    });
  }
});
const customColorpicker = "";
const ps_projectbuilder = "";
const message = "";
const advancedquery = "";
const historyinput = "";
const yesimageext = "";
const yesricheditorext = "";
const yesgrid = "";
class ErpDesignerExt {
  static addSelectedBorder($component, isFeer) {
    this.base.addSelectedBorder($component, isFeer);
    if (AutoRecord.AutoRecord && AutoRecord.SelectNodeTree !== "true") {
      let isSelectCell = false;
      let isSelectControl = false;
      let compLocation;
      let targetEl = $component[0];
      let targetElClass = targetEl.getAttribute("class");
      if (targetElClass == null && targetEl.tagName.toLowerCase() == "td") {
        let colNum = targetEl.getAttribute("col");
        let rowNum = targetEl.parentElement.getAttribute("row");
        let panelKey = targetEl.parentElement.parentElement.parentElement.getAttribute("id").replace(/\d+_/, "");
        compLocation = "网格:" + panelKey + "," + (parseInt(rowNum) + 1) + "," + (parseInt(colNum) + 1);
      } else if (targetElClass != null && targetEl.hasAttribute("aria-describedby") && targetEl.tagName.toLowerCase() == "td") {
        isSelectCell = true;
        let cellInfo = RecordCase.getCellInfo(targetEl);
        let thElements = RecordCase.getElementsByXpath("./ancestor::div[@class='ui-ygrid-bdiv']/../div[@class='ui-ygrid-hdiv']//th", targetEl);
        let thId = targetEl.getAttribute("aria-describedby");
        let index = 1;
        for (let i = 0; i < thElements.length; i++) {
          if (thElements[i].getAttribute("id") === thId) {
            break;
          }
          if (thElements[i].getAttribute("title").trim() === cellInfo.columnCaption) {
            index++;
          }
        }
        let thName = index > 1 ? cellInfo.columnCaption + "#" + index : cellInfo.columnCaption;
        compLocation = thName + "&" + cellInfo.gridKey + "&" + cellInfo.rowNum;
      } else if (targetEl.tagName.toLowerCase() == "th" && targetElClass.indexOf("ui-th-ltr") > -1) {
        let thId = targetEl.getAttribute("id");
        let gridKey = thId.replace(/\d+_/, "").replace(/_column\d+/, "");
        let colCaption = targetEl.getAttribute("title").trim();
        let colKey = targetEl.hasAttribute("oldkey") ? targetEl.getAttribute("oldkey") : targetEl.getAttribute("meta-key");
        compLocation = "表格:" + colCaption + "&" + colKey + "&" + gridKey;
      } else if (targetEl.tagName.toLowerCase() == "li" && targetElClass.indexOf("tbr-item") > -1) {
        let optKey = targetEl.getAttribute("key");
        let optName = targetEl.querySelector("a > span").textContent;
        compLocation = "操作:" + optName + "&" + optKey;
      } else {
        if (targetEl.tagName.toLowerCase() == "input") {
          targetEl = targetEl.parentElement;
          let targetElClass1 = targetEl.getAttribute("class");
          if (targetElClass1 != null && (targetElClass1.indexOf("ui-control") > -1 || targetElClass1.indexOf("ui-rdo") > -1)) {
            isSelectControl = true;
          }
        } else if (targetElClass != null && (targetElClass.indexOf("ui-control") > -1 || targetElClass.indexOf("ui-rdo") > -1)) {
          isSelectControl = true;
        }
        if (isSelectControl) {
          let caption = RecordCase.getCompCaptionByHeadDiv(targetEl);
          let key = targetEl.getAttribute("id").replace(/\d+_/, "");
          compLocation = "表头:" + caption + "&" + key;
        }
      }
      if (compLocation != null && compLocation != "" && this.borderCompLocation !== compLocation) {
        this.borderCompLocation = compLocation;
        if (isSelectCell) {
          RecordCase.requestRecordStep("选择:表格:" + compLocation + ":false");
        } else {
          RecordCase.requestRecordStep("设计器选择:控件:" + compLocation);
        }
      }
    }
  }
}
ErpDesignerExt.borderCompLocation = "";
class ErpDesignerEntryExt {
  installSearchBoxEvent(searchtext) {
    this.base.installSearchBoxEvent(searchtext);
    let elements = document.querySelectorAll(".fileMatchItems");
    elements.forEach((elm) => {
      elm.addEventListener("click", search);
    });
  }
}
const search = function(e) {
  if (AutoRecord.AutoRecord) {
    let target = e.target;
    let search2 = document.querySelector(".designeFileTreeSearch input");
    let value = search2.value;
    let number = RecordCase.getElementsByXpath("./../preceding-sibling::li", target).length + 1;
    RecordCase.requestRecordStep("设计器搜索:" + value + "#" + number);
  }
};
class DialogOpt {
  click(key) {
    if (AutoRecord.AutoRecord) {
      let button = document.querySelector("button[key='" + key + "']");
      let buttonVal = button.textContent;
      let content = button.parentElement.previousElementSibling.textContent;
      let title = button.parentElement.parentElement.parentElement.previousElementSibling.previousElementSibling.querySelector(".dialog-title").textContent;
      if (content == "是否关闭所有表单?" && buttonVal == "是") {
        RecordCase.requestRecordStep("关闭所有界面");
        return;
      }
      RecordCase.requestRecordStep("提示框:" + title + ":" + buttonVal + ":" + content);
    }
    this.base.click(key);
  }
  // closeBtnClick(){
  //     if(AutoRecord.AutoRecord){
  //         RecordCase.requestRecordStep("点击:X");
  //     }
  //     // @ts-ignore
  //     this.base.closeBtnClick();
  // }
  show() {
    const ret = this.base.show();
    let msg = document.querySelector(".dialog-content-inner").textContent;
    let title = document.querySelector(".dialog-title").textContent;
    document.querySelectorAll("div.dialog.show .dialog-close").forEach((item) => {
      item.onmousedown = function() {
        if (AutoRecord.AutoRecord) {
          RecordCase.requestRecordStep("提示框:" + title + ":[X]:" + msg);
        }
      };
    });
    return ret;
  }
}
class PrintResizeState {
  mouseup(e) {
    if (AutoRecord.AutoRecord) {
      let startW = this.startWidth;
      let endW = this.endWidth;
      let ele2 = e.target;
      let td = ele2.parentElement;
      let rowIndex = parseInt(td.getAttribute("rowindex"));
      let colindex = parseInt(td.getAttribute("colindex"));
      let tableBeforeThis = RecordCase.getElementsByXpath("./../../../../preceding-sibling::table", ele2);
      let tableIndex = tableBeforeThis.length;
      RecordCase.requestRecordStep("打印模板拖动:" + (tableIndex + 1) + "," + (rowIndex + 1) + "," + (colindex + 1) + ",x:" + (endW - startW));
    }
    this.base.mouseup(e);
  }
}
class PrintRowResizeState {
  mouseup(e) {
    if (AutoRecord.AutoRecord) {
      let startH = this.startHeight;
      let endH = this.endHeight;
      let ele2 = e.target;
      let td = ele2.parentElement;
      let rowIndex = parseInt(td.getAttribute("rowindex"));
      let colindex = parseInt(td.getAttribute("colindex"));
      let tableBeforeThis = RecordCase.getElementsByXpath("./../../../../preceding-sibling::table", ele2);
      let tableIndex = tableBeforeThis.length;
      RecordCase.requestRecordStep("打印模板拖动:" + (tableIndex + 1) + "," + (rowIndex + 1) + "," + (colindex + 1) + ",y:" + (endH - startH));
    }
    this.base.mouseup(e);
  }
}
class PrintSelectCell {
  mouseup(e) {
    if (AutoRecord.AutoRecord) {
      let ele2 = e.target;
      if (ele2.getAttribute("class") == "printarea") {
        RecordCase.requestRecordStep("打印模板点击:空白区域");
        return;
      }
      if (ele2.tagName == "SPAN") {
        ele2 = ele2.parentElement;
      }
      let colIndex = parseInt(ele2.getAttribute("colindex"));
      let rowIndex = parseInt(ele2.getAttribute("rowindex"));
      let tableBeforeThis = RecordCase.getElementsByXpath("./../../../preceding-sibling::table", ele2);
      let tableIndex = tableBeforeThis.length;
      RecordCase.requestRecordStep("打印模板点击:" + (tableIndex + 1) + "," + (rowIndex + 1) + "," + (colIndex + 1));
    }
    this.base.mouseup(e);
  }
}
class PrintSelectArea {
  mouseup(e) {
    if (AutoRecord.AutoRecord) {
      let selectTds = document.querySelectorAll("div.main div[class*=tabs-body-inner]:not([style*='display: none']) div.complex-design-view div.printarea table td.selected");
      if (!selectTds) {
        return;
      }
      let lastTd = selectTds[selectTds.length - 1];
      let startRowIndex = this.startRowindex;
      let startColIndex = this.startColindex;
      let endRowIndex = parseInt(lastTd.getAttribute("rowindex"));
      let endColIndex = parseInt(lastTd.getAttribute("colindex"));
      let tableBeforeThis = RecordCase.getElementsByXpath("./../../../preceding-sibling::table", lastTd);
      let tableIndex = tableBeforeThis.length;
      RecordCase.requestRecordStep("打印模板选择:" + (tableIndex + 1) + ":" + (startRowIndex + 1) + "," + (startColIndex + 1) + ":" + (endRowIndex + 1) + "," + (endColIndex + 1));
    }
    this.base.mouseup(e);
  }
}
class PrintCellInput {
  initInputState(sefl, e) {
    if (AutoRecord.AutoRecord) {
      var view2 = sefl.getSectionViews();
      var el = e.target;
      var offsetParent = el.parentElement;
      var startX = Number(offsetParent.getAttribute("rowindex"));
      var startY = Number(offsetParent.getAttribute("colindex"));
      var childNode1 = view2.getChildNode(startX, startY);
      var tagNode1 = childNode1 == null ? void 0 : childNode1.getTagNode();
      var oldValue = tagNode1 == null ? void 0 : tagNode1.getAttributeValue("Caption", "");
      let inputValue = String($(el).val());
      if (oldValue == inputValue) {
        return;
      }
      let rowIndex = parseInt(el.getAttribute("rowindex"));
      let colIndex = parseInt(el.getAttribute("colindex"));
      let tableBeforeThis = RecordCase.getElementsByXpath("./../../../../preceding-sibling::table", ele);
      let tableIndex = tableBeforeThis.length;
      RecordCase.requestRecordStep("打印模板录入:" + (tableIndex + 1) + "," + (rowIndex + 1) + "," + (colIndex + 1) + ":" + inputValue);
    }
    this.base.initInputState(sefl, e);
  }
}
class ExcelThEventStateExtend {
  mousedown(e) {
    this.base.mousedown(e);
    if (AutoRecord.AutoRecord) {
      console.log("选择行列");
      let row = this.el.getAttribute("rowindex");
      let col = this.el.getAttribute("colindex");
      if (row == null) {
        RecordCase.requestRecordStep("设计器Excel模板选择:列:" + this.el.innerText);
      } else if (col == null) {
        RecordCase.requestRecordStep("设计器Excel模板选择:行:" + this.el.innerText);
      }
    }
  }
}
class ExcelSelectAreaStateExtend {
  mouseup(e) {
    this.base.mouseup(e);
    let excel = RecordCase.getActiveExcelForm();
    if (excel && AutoRecord.AutoRecord) {
      let tdElement = excel.querySelectorAll("td.selected");
      if (tdElement.length <= 0) {
        return;
      }
      let cellInfoFirst = RecordCase.getExcelCellInfo(tdElement[0]);
      let cellInfoLast = RecordCase.getExcelCellInfo(tdElement[tdElement.length - 1]);
      if (!cellInfoFirst || !cellInfoLast) {
        return;
      }
      RecordCase.requestRecordStep("设计器Excel模板选择:多选单元格:" + cellInfoFirst.location + "," + cellInfoLast.location);
    }
  }
}
class NormalStateExtend {
  mouseup(e) {
    this.base.mouseup(e);
    let excel = RecordCase.getActiveExcelForm();
    if (excel && AutoRecord.AutoRecord) {
      let tdElement = excel.querySelectorAll("td.selected");
      if (tdElement.length <= 0) {
        return;
      }
      let cellInfo = RecordCase.getExcelCellInfo(tdElement[0]);
      if (!cellInfo) {
        return;
      }
      RecordCase.requestRecordStep("设计器Excel模板选择:单元格:" + cellInfo.location);
    }
  }
}
class ExcelGraphicViewExtend {
  initInputState(sefl, e) {
    let excel = RecordCase.getActiveExcelForm();
    let tdElement = null;
    let cellInfo = null;
    if (excel && AutoRecord.AutoRecord) {
      let elements = excel.querySelectorAll("td.selected");
      if (elements.length > 0) {
        tdElement = elements[0];
        cellInfo = RecordCase.getExcelCellInfo(tdElement);
      }
    }
    this.base.initInputState(sefl, e);
    if (tdElement && cellInfo) {
      let text = tdElement.querySelectorAll("input")[0].value;
      RecordCase.requestRecordStep("设计器Excel模板录入:" + cellInfo.location + ":" + text);
    }
  }
}
class WfGraphicViewExtend {
  doMoveNodeCmd(offsetX, offsetY) {
    this.base.doMoveNodeCmd(offsetX, offsetY);
    if (AutoRecord.AutoRecord) {
      let activeBPMForm = RecordCase.getActiveBPMForm();
      if (!activeBPMForm)
        return;
      let node = RecordCase.getSelectedBPMNode();
      let nodeInfo = RecordCase.getBpmNodeInfo(node);
      RecordCase.requestRecordStep("设计器工作流选择:移动:" + nodeInfo.finalCaption + ":" + nodeInfo.location);
    }
  }
  doNewNodeCmd(type, x, y) {
    this.base.doNewNodeCmd(type, x, y);
    if (AutoRecord.AutoRecord) {
      try {
        let activeBPMForm = RecordCase.getActiveBPMForm();
        if (!activeBPMForm)
          return;
        let node = RecordCase.getSelectedBPMNode();
        let nodeInfo = RecordCase.getBpmNodeInfo(node);
        if (Polling.CreateWord == "设计器工作流创建") {
          RecordCase.requestRecordStep(Polling.CreateWord + ":" + Polling.BPMNodeType + ":" + nodeInfo.location);
        } else if (Polling.CreateWord == "设计器工作流选择:快捷操作") {
          RecordCase.requestRecordStep(Polling.CreateWord + ":" + Polling.CurNode.finalCaption + ":" + Polling.BPMNodeType + ":" + nodeInfo.location);
        }
      } catch (e) {
        throw new Error("录制创建工作流节点失败");
      } finally {
        Polling.CreateWord = null;
      }
    }
    Polling.CreateWord = null;
  }
  doNewLinkCmd(type, fromTag, toKey) {
    this.base.doNewLinkCmd(type, fromTag, toKey);
    if (AutoRecord.AutoRecord) {
      try {
        let activeBPMForm = RecordCase.getActiveBPMForm();
        if (!activeBPMForm)
          return;
        if (Polling.CreateWord == "设计器工作流创建") {
          RecordCase.requestRecordStep(Polling.CreateWord + ":" + Polling.BPMNodeType + ":" + Polling.PreNode.finalCaption + "," + Polling.CurNode.finalCaption);
        } else if (Polling.CreateWord == "设计器工作流选择:快捷操作") {
          RecordCase.requestRecordStep(Polling.CreateWord + ":" + Polling.PreNode.finalCaption + ":" + Polling.BPMNodeType + ":" + Polling.CurNode.finalCaption);
        }
      } catch (e) {
        throw new Error("录制创建工作流顺序流失败");
      } finally {
        Polling.CreateWord = null;
      }
    }
    Polling.CreateWord = null;
  }
  doDeleteElementCmd() {
    if (AutoRecord.AutoRecord) {
      try {
        let activeBPMForm = RecordCase.getActiveBPMForm();
        if (!activeBPMForm)
          return;
        let node = RecordCase.getSelectedBPMNode();
        let nodeInfo = RecordCase.getBpmNodeInfo(node);
        RecordCase.requestRecordStep("设计器工作流选择:快捷操作:" + nodeInfo.finalCaption + ":删除");
      } catch (e) {
        throw new Error("录制删除工作流节点失败");
      }
    }
    this.base.doDeleteElementCmd();
    Polling.CreateWord = null;
  }
}
class DesignRecordExtend {
  // 拓展
  static addExtend() {
    extend(Dialog, DialogOpt);
    extend(ERPDESIGNER, ErpDesignerExt);
    extend(ERPDESIGNER.ErpDesignerEntry, ErpDesignerEntryExt);
    extend(ERPDESIGNER.PrintReszieState, PrintResizeState);
    extend(ERPDESIGNER.PrintRowReszieState, PrintRowResizeState);
    extend(ERPDESIGNER.PrintNormalState, PrintSelectCell);
    extend(ERPDESIGNER.PrintSelectAreaState, PrintSelectArea);
    extend(ERPDESIGNER.PrintGraphicView, PrintCellInput);
    extend(ERPDESIGNER.ExcelGraphicView, ExcelGraphicViewExtend);
    extend(ERPDESIGNER.ExcelNormalState, NormalStateExtend);
    extend(ERPDESIGNER.ExcelSelectAreaState, ExcelSelectAreaStateExtend);
    extend(ERPDESIGNER.ExcelThEventState, ExcelThEventStateExtend);
    extend(ERPDESIGNER.BPMWfGraphicView, WfGraphicViewExtend);
  }
}
class DesignRecordInit {
  // @ts-ignore
  static async init() {
    try {
      DOMUtil.waitForElementsReady(".nav .nav-right div#autorecord", (elems) => {
        if (AutoRecord.sys_record == "true") {
          DesignRecordExtend.addExtend();
        }
      });
    } catch (e) {
      console.log(e);
    }
  }
}
DesignRecordInit.init();
ControlMapping.getInstance().reg(ControlType.DICTVIEW, YesDictViewBuilder);
ControlMapping.getInstance().reg(ControlType.DICT, YesDictBuilder);
ControlMapping.getInstance().reg(ControlType.DYNAMICDICT, YesDictBuilder);
ControlMapping.getInstance().reg(ControlType.GRID, YesGridBuilderExt);
class ERPInit {
}
ERPInit.init = () => {
  initHelp();
  return ERPDESIGNER.ErpDesignerInit();
};
export {
  ERPInit as E,
  Tabs as T,
  YesVGridExt as Y,
  YesGridBuilderExt as a
};
//# sourceMappingURL=erp-yes-ui-4313cb43.js.map
