/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.entity.util;

import com.bokesoft.erp.entity.util.AbstractBillEntity;
import com.bokesoft.erp.entity.util.ITableEntity;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.mid.cmd.richdocument.strut.IDLookup;
import com.bokesoft.yes.mid.dbcache.datatable.DataTableExUtil;
import com.bokesoft.yes.util.ERPStringUtil;
import com.bokesoft.yes.util.VarUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractTableEntity
implements ITableEntity {
    protected String[] _metaFormKeys;
    protected String[] _dataObjectKeys;
    public String tableKey = null;
    public AbstractBillEntity billEntity = null;
    protected DefaultContext context;
    protected DataTable dataTable;
    protected DataTable dataTable_T;
    private DataTableMetaData metaData;
    public Long oid;
    private int bookmark = -1;
    private int hash = 0;

    public DefaultContext getContext() {
        return this.context;
    }

    protected AbstractTableEntity() {
    }

    protected AbstractTableEntity(DefaultContext context, DataTable dataTable, Long oid, int rowIndex) {
        this.context = context;
        this.dataTable = dataTable;
        this.metaData = dataTable.getMetaData();
        this.bookmark = dataTable.getBookmark(rowIndex);
        this.oid = oid;
    }

    @Override
    public Object valueByFieldKey(String fieldKey) throws Throwable {
        return this.valueByColumnName(this.getColumnNameByKey(fieldKey));
    }

    @Override
    public Object originalValueByFieldKey(String fieldKey) throws Throwable {
        return this.originalValueByColumnName(this.getColumnNameByKey(fieldKey));
    }

    @Override
    public void valueByFieldKey(String fieldKey, Object value) throws Throwable {
        this.valueByColumnName(this.getColumnNameByKey(fieldKey), value);
    }

    protected abstract String getColumnNameByKey(String var1);

    private void synchronizedDataTable() throws Throwable {
        DataTable rstNew;
        AbstractBillEntity billEntity = this.getBillEntity();
        if (billEntity != null && this.dataTable != (rstNew = billEntity.document.get_impl(this.tableKey))) {
            this.dataTable = rstNew;
        }
    }

    @Deprecated
    public DataTable getDataTable() throws Throwable {
        AbstractBillEntity billEntity = this.getBillEntity();
        if (billEntity != null) {
            DataTable dataTable = billEntity.document.get(this.tableKey);
            return dataTable;
        }
        return this.dataTable;
    }

    public DataTableMetaData getMetaData() throws Throwable {
        AbstractBillEntity billEntity = this.getBillEntity();
        DataTable dt = null;
        dt = billEntity != null ? billEntity.document.get_impl(this.tableKey) : this.dataTable;
        return dt.getMetaData();
    }

    @Override
    public Object valueByColumnName(String columnName) throws Throwable {
        AbstractBillEntity billEntity = this.getBillEntity();
        if (billEntity != null) {
            Iterator iterator;
            this.synchronizedDataTable();
            if (this.dataTable.size() == 0) {
                return null;
            }
            IDLookup idLookup = IDLookup.getIDLookup((MetaForm)billEntity.document.getMetaForm());
            List fieldKeys = idLookup.getFieldListKeyByTableColumnKey(this.tableKey, columnName);
            if (fieldKeys != null && fieldKeys.size() > 0 && (iterator = fieldKeys.iterator()).hasNext()) {
                String fieldKey = (String)iterator.next();
                if (this.bookmark >= 0) {
                    MetaColumn metaColumn = idLookup.getMetaColumnByFieldKey(fieldKey);
                    if (metaColumn != null && metaColumn.isSupportI18n().booleanValue()) {
                        String tableKey = idLookup.getTableKeyByFieldKey(fieldKey);
                        DataTable dataTable = billEntity.document.getDataTable(String.valueOf(tableKey) + "_T");
                        if (dataTable == null || dataTable.size() == 0) {
                            return billEntity.document.getValue(fieldKey, this.bookmark);
                        }
                        String[] key = new String[]{"SrcLangOID", "Lang"};
                        Object[] value = new Object[]{this.oid, billEntity.document.getContext().getEnv().getLocale()};
                        int[] rows = dataTable.fastFilter(key, value);
                        if (rows.length > 0) {
                            return dataTable.getObject(rows[0], fieldKey);
                        }
                        return dataTable.getObject(0, fieldKey);
                    }
                    return billEntity.document.getValue(fieldKey, this.bookmark);
                }
                return billEntity.getValue(fieldKey, this.oid);
            }
        }
        if (this.dataTable == null || this.dataTable.size() == 0) {
            return null;
        }
        int rowIndex = DataTableExUtil.getRowIndexByBookmark((DataTable)this.dataTable, (int)this.bookmark);
        int col = this.metaData.findColumnIndexByKey(columnName);
        if (rowIndex < 0) {
            throw new Exception("Bookmark:" + this.bookmark + "\u5728 DataTable \u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1");
        }
        if (col < 0) {
            return null;
        }
        return this.dataTable.getObject(rowIndex, col);
    }

    @Override
    public Object originalValueByColumnName(String columnName) throws Throwable {
        this.synchronizedDataTable();
        if (this.dataTable.size() == 0) {
            return null;
        }
        int rowIndex = DataTableExUtil.getRowIndexByBookmark((DataTable)this.dataTable, (int)this.bookmark);
        int col = this.metaData.findColumnIndexByKey(columnName);
        if (rowIndex < 0) {
            throw new Exception("Bookmark:" + this.bookmark + "\u5728 DataTable \u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1");
        }
        if (col < 0) {
            throw new Exception("\u5b57\u6bb5ColumnName:" + columnName + "\u5728 DataTable \u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1");
        }
        return this.dataTable.getOriginalObject(rowIndex, col);
    }

    protected int value_Int(String columnName) throws Throwable {
        return TypeConvertor.toInteger((Object)this.valueByColumnName(columnName));
    }

    protected Long value_Long(String columnName) throws Throwable {
        return TypeConvertor.toLong((Object)this.valueByColumnName(columnName));
    }

    protected String value_String(String columnName) throws Throwable {
        return TypeConvertor.toString((Object)this.valueByColumnName(columnName));
    }

    protected BigDecimal value_BigDecimal(String columnName) throws Throwable {
        return TypeConvertor.toBigDecimal((Object)this.valueByColumnName(columnName));
    }

    protected Date value_Date(String columnName) throws Throwable {
        return new Date(TypeConvertor.toDate((Object)this.valueByColumnName(columnName)).getTime());
    }

    protected Timestamp value_Timestamp(String columnName) throws Throwable {
        return VarUtil.toTimestamp((Object)this.valueByColumnName(columnName));
    }

    @Override
    public void valueByColumnName(String columnName, Object value) throws Throwable {
        AbstractBillEntity billEntity = this.getBillEntity();
        List fieldKeys = new ArrayList();
        if (billEntity != null) {
            this.synchronizedDataTable();
            IDLookup idLookup = IDLookup.getIDLookup((MetaForm)billEntity.document.getMetaForm());
            fieldKeys = idLookup.getFieldListKeyByTableColumnKey(this.tableKey, columnName);
        }
        if (fieldKeys != null && fieldKeys.size() > 0 && billEntity != null) {
            int i = 0;
            while (i < fieldKeys.size()) {
                String fieldKey = (String)fieldKeys.get(i);
                if (!ERPStringUtil.isBlankOrNull((Object)fieldKey)) {
                    if (billEntity.isRunValueChanged()) {
                        billEntity.document.setValue(fieldKey, this.bookmark, value);
                    } else {
                        billEntity.document.setValueNoChanged(fieldKey, this.bookmark, value);
                    }
                    if (columnName.equalsIgnoreCase("OID")) {
                        this.oid = TypeConvertor.toLong((Object)value);
                    }
                }
                ++i;
            }
            return;
        }
        int rowIndex = DataTableExUtil.getRowIndexByBookmark((DataTable)this.dataTable, (int)this.bookmark);
        int col = this.metaData.findColumnIndexByKey(columnName);
        if (rowIndex < 0) {
            throw new Exception("Bookmark:" + this.bookmark + "\u5728 DataTable \u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1");
        }
        if (col < 0) {
            throw new Exception("\u5b57\u6bb5ColumnName:" + columnName + "\u5728 DataTable \u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1");
        }
        Object oldValue = this.dataTable.getObject(rowIndex, col);
        if (TypeConvertor.compare((Object)value, (Object)oldValue) != 0) {
            this.dataTable.setObject(rowIndex, col, value);
        }
    }

    public void valueByColumnName(String columnName, BigDecimal value, int scale, RoundingMode roundingMode) throws Throwable {
        AbstractBillEntity billEntity = this.getBillEntity();
        List fieldKeys = new ArrayList();
        if (billEntity != null) {
            this.synchronizedDataTable();
            IDLookup idLookup = IDLookup.getIDLookup((MetaForm)billEntity.document.getMetaForm());
            fieldKeys = idLookup.getFieldListKeyByTableColumnKey(this.tableKey, columnName);
        }
        if (fieldKeys != null && fieldKeys.size() > 0 && billEntity != null) {
            for (String fieldKey : fieldKeys) {
                if (billEntity.isRunValueChanged()) {
                    billEntity.document.setValue(fieldKey, this.bookmark, (Object)value);
                    continue;
                }
                billEntity.document.setValueNoChanged(fieldKey, this.bookmark, (Object)value);
            }
        } else {
            if (value != null && value.scale() > scale) {
                value = value.setScale(scale, roundingMode);
            }
            int rowIndex = DataTableExUtil.getRowIndexByBookmark((DataTable)this.dataTable, (int)this.bookmark);
            int col = this.metaData.findColumnIndexByKey(columnName);
            if (rowIndex < 0) {
                throw new Exception("Bookmark:" + this.bookmark + "\u5728 DataTable \u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1");
            }
            if (col < 0) {
                throw new Exception("\u5b57\u6bb5ColumnName:" + columnName + "\u5728 DataTable \u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1");
            }
            Object oldValue = this.dataTable.getObject(rowIndex, col);
            if (TypeConvertor.compare((Object)value, (Object)oldValue) != 0) {
                this.dataTable.setObject(rowIndex, col, (Object)value);
            }
        }
    }

    public boolean isAddnew() throws Throwable {
        this.synchronizedDataTable();
        int rowIndex = DataTableExUtil.getRowIndexByBookmark((DataTable)this.dataTable, (int)this.bookmark);
        if (rowIndex < 0) {
            throw new Exception("Bookmark:" + this.bookmark + "\u5728 DataTable \u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1");
        }
        return this.dataTable.getState(rowIndex) == 1;
    }

    public boolean isUpdated() throws Throwable {
        this.synchronizedDataTable();
        int rowIndex = DataTableExUtil.getRowIndexByBookmark((DataTable)this.dataTable, (int)this.bookmark);
        if (rowIndex < 0) {
            throw new Exception("Bookmark:" + this.bookmark + "\u5728 DataTable \u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1");
        }
        return this.dataTable.getState(rowIndex) == 2;
    }

    public boolean isColumnUpdated(String columnName) throws Throwable {
        this.synchronizedDataTable();
        Object value = this.valueByColumnName(columnName);
        Object originalValue = this.originalValueByColumnName(columnName);
        boolean result = VarUtil.compare((Object)value, (Object)originalValue) != 0;
        return result;
    }

    public abstract AbstractBillEntity getBillEntity();

    public MetaTable metaTable() throws Throwable {
        AbstractBillEntity bill = this.getBillEntity();
        if (bill != null) {
            return bill.document.getMetaForm().getDataSource().getDataObject().getMetaTable(this.tableKey);
        }
        throw new Exception("\u62a5\u9519");
    }

    protected abstract String metaTablePropItem_getBillKey();

    public abstract Long primaryID() throws Throwable;

    public Long getSOID() throws Throwable {
        this.synchronizedDataTable();
        if (this.dataTable.size() == 0) {
            return 0L;
        }
        int rowIndex = DataTableExUtil.getRowIndexByBookmark((DataTable)this.dataTable, (int)this.bookmark);
        int col = this.metaData.findColumnIndexByKey("SOID");
        if (rowIndex < 0) {
            throw new Exception("Bookmark:" + this.bookmark + "\u5728 DataTable \u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1");
        }
        if (col < 0) {
            throw new Exception("\u5b57\u6bb5ColumnName:SOID\u5728 DataTable \u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1");
        }
        return TypeConvertor.toLong((Object)this.dataTable.getObject(rowIndex, col));
    }

    public int getBookMark() throws Throwable {
        this.synchronizedDataTable();
        if (this.dataTable.size() == 0) {
            return -1;
        }
        return this.bookmark;
    }

    public int get_RowIndex() throws Throwable {
        int bookMark = this.getBookMark();
        return this.dataTable.getRowIndexByBookmark(bookMark);
    }

    public int hashCode() {
        if (this.hash == 0 && this.oid != null) {
            this.hash = this.oid.hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof AbstractTableEntity) {
            AbstractTableEntity anotherString = (AbstractTableEntity)anObject;
            Long oid = anotherString.oid;
            try {
                if (this.oid.compareTo(oid) == 0) {
                    return true;
                }
            }
            catch (Throwable e) {
                LogSvr.getInstance().error(e.getMessage(), e);
            }
        }
        return false;
    }

    public String toString() {
        try {
            return String.valueOf(this.tableKey) + ":" + DataTableExUtil.getRowByBookmark((DataTable)this.dataTable, (int)this.bookmark).toString();
        }
        catch (Throwable e) {
            return String.valueOf(this.tableKey) + " error";
        }
    }
}

