/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.intero;

import com.bokesoft.erp.extension.ExtensionProcessScanner;
import com.bokesoft.erp.extension.IExtensionProcess;
import com.bokesoft.erp.intero.intf.ExtensionPointExecutor;
import com.bokesoft.yes.erp.message.MessageFacade;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;

public class ExtensionPoint {
    private static final Logger log = LoggerFactory.getLogger(ExtensionPoint.class);
    private static ListableBeanFactory springBeanFactory;

    public static final void setSpringBeanFactory(ListableBeanFactory listableBeanFactory) {
        springBeanFactory = listableBeanFactory;
    }

    public static <T> void invoke(Class<T> clazz, ExtensionPointExecutor<T> extensionPointExecutor) {
        ExtensionPoint.a(clazz, false, extensionPointExecutor);
    }

    public static <T> void invokeSingleton(Class<T> clazz, ExtensionPointExecutor<T> extensionPointExecutor) {
        ExtensionPoint.a(clazz, true, extensionPointExecutor);
    }

    private static <T> void a(Class<T> clazz, boolean bl, ExtensionPointExecutor<T> extensionPointExecutor) {
        Map map;
        if (clazz.isAssignableFrom(IExtensionProcess.class)) {
            MessageFacade.throwException((String)"ROW000", (Object[])new Object[]{clazz, IExtensionProcess.class.getName()});
        }
        if ((map = springBeanFactory.getBeansOfType(clazz)).size() == 0) {
            return;
        }
        if (map.size() > 1 && bl) {
            MessageFacade.throwException((String)"ROW001", (Object[])new Object[]{clazz, StringUtils.join(map.keySet(), (String)",")});
        }
        HashSet hashSet = new HashSet(map.keySet());
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            log.debug("\u5f00\u59cb\u6267\u884c\u6269\u5c55\u70b9[{}]: '{}', \u5b9e\u4f8b{} ...", new Object[]{clazz, string, v});
            hashSet.remove(string);
            try {
                if (ExtensionProcessScanner.getInstance().isExtensionActive(v.getClass().getName())) {
                    log.info("\u6269\u5c55\u70b9[{}]: '{}' \u6ca1\u6709\u6fc0\u6d3b, \u5b9e\u4f8b{} ...", new Object[]{clazz, string, v});
                    continue;
                }
                extensionPointExecutor.execute(v);
                log.debug("\u6269\u5c55\u70b9[{}]: '{}' \u6267\u884c\u5b8c\u6210, \u5b9e\u4f8b{} ...", new Object[]{clazz, string, v});
            }
            catch (Throwable throwable) {
                log.error("\u6269\u5c55\u70b9[" + clazz + "] '" + string + "' \u6267\u884c\u5931\u8d25\uff0c\u5b9e\u4f8b " + v + ".", throwable);
                int n = hashSet.size();
                if (n > 0) {
                    log.error("\u6269\u5c55\u70b9[{}]\u5b58\u5728 {} \u4e2a\u5b9e\u4f8b\u56e0\u9519\u8bef '{}' \u65e0\u6cd5\u7ee7\u7eed\u6267\u884c: {}", new Object[]{clazz, n, ExceptionUtils.getRootCauseMessage((Throwable)throwable), StringUtils.join(hashSet, (String)",")});
                }
                ExceptionUtils.rethrow((Throwable)throwable);
            }
        }
    }
}

