/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.i18n;

import com.bokesoft.erp.entity.util.EntityContextAction;
import com.bokesoft.erp.i18n.baiduTranslate.BaiduTranslate;
import com.bokesoft.erp.i18n.youdaoTranslate.YoudaoTranslate;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.io.IOException;

public class TranslationFormula
extends EntityContextAction {
    private static final String BAIDU = "Baidu";
    private static final String YOUDAO = "Youdao";
    private static final String ZH_CN = "zh-CN \u7b80\u4f53\u4e2d\u6587";
    private static final String ZH_CHT = "zh-CHT \u7e41\u9ad4\u4e2d\u6587";
    private static final String EN_US = "en-US \u82f1\u6587";
    private static final String RU_RU = "ru-RU \u4fc4\u6587";
    private static final String JA_JP = "ja-JP \u65e5\u6587";
    private static final String FR_FR = "fr-FR \u6cd5\u6587";
    private static final String ES_ES = "es-ES \u897f\u73ed\u7259\u6587";
    private static final String PT_PT = "pt-PT \u8461\u8404\u7259\u6587";
    private static final String DE_DE = "de-DE \u5fb7\u6587";
    private static final String AR_AE = "ar-AE \u963f\u62c9\u4f2f\u6587";
    private static final String KO_KR = "ko_KR \u97e9\u8bed";
    private static final String TH_TH = "th-TH \u6cf0\u8bed";
    private static final String HU_HU = "hu-HU \u5308\u7259\u5229\u8bed";
    private static final String ZH = "zh";
    private static final String ZH_CHS = "zh-CHS";
    private static final String CHT = "cht";
    private static final String YOUDAO_CHT = "zh-CHT";
    private static final String EN = "en";
    private static final String RU = "ru";
    private static final String JP = "jp";
    private static final String JA = "ja";
    private static final String FRA = "fra";
    private static final String FR = "fr";
    private static final String SPA = "spa";
    private static final String ES = "es";
    private static final String PT = "pt";
    private static final String DE = "de";
    private static final String ARA = "ara";
    private static final String AR = "ar";
    private static final String KO = "kor";
    private static final String TH = "th";
    private static final String HU = "hu";
    private static final String YOUDAO_KO = "ko";

    public TranslationFormula(RichDocumentContext richDocumentContext) {
        super(richDocumentContext);
    }

    public String getSrcLanguage(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (BAIDU.equals(string)) {
            stringBuilder.append(";").append(ZH).append(",").append(ZH_CN);
            stringBuilder.append(";").append(CHT).append(",").append(ZH_CHT);
            stringBuilder.append(";").append(EN).append(",").append(EN_US);
            stringBuilder.append(";").append(RU).append(",").append(RU_RU);
            stringBuilder.append(";").append(JP).append(",").append(JA_JP);
            stringBuilder.append(";").append(FRA).append(",").append(FR_FR);
            stringBuilder.append(";").append(SPA).append(",").append(ES_ES);
            stringBuilder.append(";").append(PT).append(",").append(PT_PT);
            stringBuilder.append(";").append(DE).append(",").append(DE_DE);
            stringBuilder.append(";").append(ARA).append(",").append(AR_AE);
            stringBuilder.append(";").append(KO).append(",").append(KO_KR);
            stringBuilder.append(";").append(TH).append(",").append(TH_TH);
            stringBuilder.append(";").append(HU).append(",").append(HU_HU);
        }
        if (YOUDAO.equals(string)) {
            stringBuilder.append(";").append(ZH_CHS).append(",").append(ZH_CN);
            stringBuilder.append(";").append(YOUDAO_CHT).append(",").append(ZH_CHT);
            stringBuilder.append(";").append(EN).append(",").append(EN_US);
            stringBuilder.append(";").append(RU).append(",").append(RU_RU);
            stringBuilder.append(";").append(JA).append(",").append(JA_JP);
            stringBuilder.append(";").append(FR).append(",").append(FR_FR);
            stringBuilder.append(";").append(ES).append(",").append(ES_ES);
            stringBuilder.append(";").append(PT).append(",").append(PT_PT);
            stringBuilder.append(";").append(DE).append(",").append(DE_DE);
            stringBuilder.append(";").append(AR).append(",").append(AR_AE);
            stringBuilder.append(";").append(YOUDAO_KO).append(",").append(KO_KR);
            stringBuilder.append(";").append(TH_TH).append(",").append(TH);
            stringBuilder.append(";").append(HU_HU).append(",").append(HU);
        }
        return stringBuilder.toString().isEmpty() ? stringBuilder.toString() : stringBuilder.substring(1);
    }

    public boolean getEnable(String string) {
        if (string == null || "".equals(string)) {
            return true;
        }
        return !this.isDefaultLanguage(string);
    }

    public void getTransResult(String string, String string2, String string3) throws Throwable {
        RichDocument richDocument = this.getDocument();
        DataTable dataTable = richDocument.getDataTable("BK_TranslationDtl");
        if (dataTable.size() > 0) {
            int n = 0;
            while (n < dataTable.size()) {
                String string4 = dataTable.getString(n, "Language");
                if (BAIDU.equals(string)) {
                    dataTable.setString(n, "TranslationResult", this.baiduTranslate(string3, string2, string4));
                }
                if (YOUDAO.equals(string)) {
                    dataTable.setString(n, "TranslationResult", this.youdaoTranslate(string3, string2, string4));
                }
                ++n;
            }
        } else {
            if (BAIDU.equals(string)) {
                this.setTranslationResult(dataTable, ZH_CN, this.baiduTranslate(string3, string2, ZH));
                this.setTranslationResult(dataTable, ZH_CHT, this.baiduTranslate(string3, string2, CHT));
                this.setTranslationResult(dataTable, EN_US, this.baiduTranslate(string3, string2, EN));
                this.setTranslationResult(dataTable, RU_RU, this.baiduTranslate(string3, string2, RU));
                this.setTranslationResult(dataTable, JA_JP, this.baiduTranslate(string3, string2, JP));
                this.setTranslationResult(dataTable, FR_FR, this.baiduTranslate(string3, string2, FRA));
                this.setTranslationResult(dataTable, ES_ES, this.baiduTranslate(string3, string2, SPA));
                this.setTranslationResult(dataTable, PT_PT, this.baiduTranslate(string3, string2, PT));
                this.setTranslationResult(dataTable, DE_DE, this.baiduTranslate(string3, string2, DE));
                this.setTranslationResult(dataTable, AR_AE, this.baiduTranslate(string3, string2, ARA));
                this.setTranslationResult(dataTable, KO_KR, this.baiduTranslate(string3, string2, KO));
                this.setTranslationResult(dataTable, TH_TH, this.baiduTranslate(string3, string2, TH));
                this.setTranslationResult(dataTable, HU_HU, this.baiduTranslate(string3, string2, HU));
            }
            if (YOUDAO.equals(string)) {
                this.setTranslationResult(dataTable, ZH_CN, this.youdaoTranslate(string3, string2, ZH_CHS));
                this.setTranslationResult(dataTable, ZH_CHT, this.youdaoTranslate(string3, string2, YOUDAO_CHT));
                this.setTranslationResult(dataTable, EN_US, this.youdaoTranslate(string3, string2, EN));
                this.setTranslationResult(dataTable, RU_RU, this.youdaoTranslate(string3, string2, RU));
                this.setTranslationResult(dataTable, JA_JP, this.youdaoTranslate(string3, string2, JA));
                this.setTranslationResult(dataTable, FR_FR, this.youdaoTranslate(string3, string2, FR));
                this.setTranslationResult(dataTable, ES_ES, this.youdaoTranslate(string3, string2, ES));
                this.setTranslationResult(dataTable, PT_PT, this.youdaoTranslate(string3, string2, PT));
                this.setTranslationResult(dataTable, DE_DE, this.youdaoTranslate(string3, string2, DE));
                this.setTranslationResult(dataTable, AR_AE, this.youdaoTranslate(string3, string2, AR));
                this.setTranslationResult(dataTable, KO_KR, this.baiduTranslate(string3, string2, YOUDAO_KO));
                this.setTranslationResult(dataTable, TH_TH, this.baiduTranslate(string3, string2, TH));
                this.setTranslationResult(dataTable, HU_HU, this.baiduTranslate(string3, string2, HU));
            }
        }
        richDocument.setDataTable("BK_TranslationDtl", dataTable);
    }

    public boolean isDefaultLanguage(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        return ZH_CN.equals(string) || ZH_CHT.equals(string) || EN_US.equals(string) || RU_RU.equals(string) || JA_JP.equals(string) || FR_FR.equals(string) || ES_ES.equals(string) || PT_PT.equals(string) || DE_DE.equals(string) || AR_AE.equals(string) || KO_KR.equals(string) || TH_TH.equals(string) || HU_HU.equals(string);
    }

    public void setTranslationResult(DataTable dataTable, String string, String string2) {
        int n = dataTable.append();
        dataTable.setString(n, "Language", string);
        dataTable.setString(n, "TranslationResult", string2);
    }

    public String baiduTranslate(String string, String string2, String string3) throws Throwable {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            LogSvr.getInstance().error(interruptedException.getMessage(), (Throwable)interruptedException);
        }
        if (ZH_CN.equals(string3)) {
            string3 = ZH;
        }
        if (ZH_CHT.equals(string3)) {
            string3 = CHT;
        }
        if (EN_US.equals(string3)) {
            string3 = EN;
        }
        if (RU_RU.equals(string3)) {
            string3 = RU;
        }
        if (JA_JP.equals(string3)) {
            string3 = JP;
        }
        if (FR_FR.equals(string3)) {
            string3 = FRA;
        }
        if (ES_ES.equals(string3)) {
            string3 = SPA;
        }
        if (PT_PT.equals(string3)) {
            string3 = PT;
        }
        if (DE_DE.equals(string3)) {
            string3 = DE;
        }
        if (AR_AE.equals(string3)) {
            string3 = ARA;
        }
        if (KO_KR.equals(string3)) {
            string3 = KO;
        }
        if (TH_TH.equals(string3)) {
            string3 = TH;
        }
        if (HU_HU.equals(string3)) {
            string3 = HU;
        }
        return BaiduTranslate.getTransResult(this.getEnv(), string, string2, string3);
    }

    public String youdaoTranslate(String string, String string2, String string3) throws IOException {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            LogSvr.getInstance().error(interruptedException.getMessage(), (Throwable)interruptedException);
        }
        if (ZH_CN.equals(string3)) {
            string3 = ZH_CHS;
        }
        if (ZH_CHT.equals(string3)) {
            string3 = YOUDAO_CHT;
        }
        if (EN_US.equals(string3)) {
            string3 = EN;
        }
        if (RU_RU.equals(string3)) {
            string3 = RU;
        }
        if (JA_JP.equals(string3)) {
            string3 = JA;
        }
        if (FR_FR.equals(string3)) {
            string3 = FR;
        }
        if (ES_ES.equals(string3)) {
            string3 = ES;
        }
        if (PT_PT.equals(string3)) {
            string3 = PT;
        }
        if (DE_DE.equals(string3)) {
            string3 = DE;
        }
        if (AR_AE.equals(string3)) {
            string3 = AR;
        }
        if (KO_KR.equals(string3)) {
            string3 = YOUDAO_KO;
        }
        if (TH_TH.equals(string3)) {
            string3 = TH;
        }
        if (HU_HU.equals(string3)) {
            string3 = HU;
        }
        return YoudaoTranslate.getTransResult(string, string2, string3);
    }
}

