/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.extension.openapi;

import com.bokesoft.erp.billentity.common.EGS_ExtensionTechnology;
import com.bokesoft.erp.extension.ExampleClass;
import com.bokesoft.erp.openapi.OpenAPIUtils;
import com.bokesoft.yes.util.ProjectSystemInfoUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.util.ContextBuilder;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.servers.Server;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.AbstractRequestService;
import org.springdoc.core.GenericResponseService;
import org.springdoc.core.OpenAPIService;
import org.springdoc.core.OperationService;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SpringDocProviders;
import org.springdoc.core.customizers.SpringDocCustomizers;
import org.springdoc.core.providers.SpringWebProvider;
import org.springdoc.webmvc.api.OpenApiResource;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api-docs/extension"})
@Tag(name="YigoERP\u589e\u5f3a\u63a5\u53e3API\u5217\u8868")
public class ExtensionController
extends OpenApiResource {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionController.class);

    public ExtensionController(ObjectFactory<OpenAPIService> objectFactory, AbstractRequestService abstractRequestService, GenericResponseService genericResponseService, OperationService operationService, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders, SpringDocCustomizers springDocCustomizers) {
        super(objectFactory, abstractRequestService, genericResponseService, operationService, springDocConfigProperties, springDocProviders, springDocCustomizers);
    }

    @GetMapping
    public byte[] openapiJson(HttpServletRequest httpServletRequest, String string, Locale locale) throws JsonProcessingException {
        OpenAPI openAPI = new OpenAPI();
        ArrayList<Server> arrayList = new ArrayList<Server>();
        arrayList.add(new Server().url(httpServletRequest.getContextPath()));
        openAPI.info(new Info().title("YigoERP\u589e\u5f3a\u63a5\u53e3API").version(ProjectSystemInfoUtil.getVersion())).servers(arrayList);
        DefaultContext defaultContext = null;
        try {
            defaultContext = ContextBuilder.create();
            String string2 = "select * from EGS_ExtensionTechnology order by tleft";
            DataTable dataTable = defaultContext.getDBManager().execPrepareQuery(string2, new Object[0]);
            List list = EGS_ExtensionTechnology.parseRowset(null, (DataTable)dataTable);
            if (list == null) {
                return null;
            }
            try {
                LinkedHashMap<String, Schema> linkedHashMap = new LinkedHashMap<String, Schema>();
                for (Object object : list) {
                    if (object.getParentID() == 0L) continue;
                    Schema schema = new Schema();
                    schema.setName(object.getName());
                    schema.setTitle(object.getExtensionPoint());
                    linkedHashMap.put(object.getName(), schema);
                    try {
                        Method[] methodArray;
                        ExampleClass exampleClass;
                        Class<?> clazz = Class.forName(object.getExtensionPoint());
                        OpenAPIDefinition openAPIDefinition = clazz.getAnnotation(OpenAPIDefinition.class);
                        if (openAPIDefinition != null) {
                            schema.setDescription(openAPIDefinition.info().description());
                        }
                        if (clazz.getAnnotation(Deprecated.class) != null) {
                            schema.setDeprecated(Boolean.valueOf(true));
                        }
                        if ((exampleClass = clazz.getAnnotation(ExampleClass.class)) != null) {
                            schema.setExample((Object)exampleClass.className());
                        }
                        Method[] methodArray2 = methodArray = clazz.getDeclaredMethods();
                        int n = methodArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Parameter parameter;
                            Parameter[] parameterArray;
                            Method method = methodArray2[n2];
                            Schema schema2 = new Schema();
                            schema2.setName(method.getName());
                            schema2.setTitle(String.valueOf(clazz.getName()) + "." + method.getName());
                            Operation operation = method.getAnnotation(Operation.class);
                            if (operation != null) {
                                schema2.setDescription(operation.description());
                            }
                            Parameter[] parameterArray2 = parameterArray = method.getParameters();
                            int n3 = parameterArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                parameter = parameterArray2[n4];
                                io.swagger.v3.oas.annotations.Parameter parameter2 = parameter.getAnnotation(io.swagger.v3.oas.annotations.Parameter.class);
                                Schema schema3 = new Schema();
                                OpenAPIUtils.setSchemaType(schema3, parameter.getType());
                                schema3.setName(parameter.getName());
                                schema3.setTitle(parameter.getType().getName());
                                if (parameter2 == null) {
                                    schema3.setDescription("\u53c2\u6570\u672a\u63cf\u8ff0");
                                } else {
                                    schema3.setDescription(parameter2.description());
                                }
                                schema2.addProperty("\u53c2\u6570\uff1a" + parameter.getName(), schema3);
                                ++n4;
                            }
                            if (method.getAnnotation(Deprecated.class) != null) {
                                schema2.setDeprecated(Boolean.valueOf(true));
                            }
                            parameter = new Schema();
                            OpenAPIUtils.setSchemaType(parameter, method.getReturnType());
                            parameter.setName("\u8fd4\u56de\u503c\uff1a");
                            parameter.setTitle(method.getReturnType().getName());
                            schema2.addProperty(parameter.getName(), (Schema)parameter);
                            schema.addProperty("\u65b9\u6cd5\uff1a" + method.getName(), schema2);
                            ++n2;
                        }
                    }
                    catch (Exception exception) {
                        logger.debug(exception.toString());
                    }
                }
                openAPI.setComponents(new Components());
                openAPI.setPaths(new Paths());
                if (linkedHashMap != null) {
                    for (Object object : linkedHashMap.keySet()) {
                        openAPI.getComponents().addSchemas((String)object, (Schema)linkedHashMap.get(object));
                    }
                }
            }
            catch (Throwable throwable) {
                logger.debug(throwable.toString());
                throw new RuntimeException(throwable);
            }
        }
        finally {
            if (defaultContext != null) {
                try {
                    defaultContext.close();
                }
                catch (Throwable throwable) {
                    logger.debug(throwable.toString());
                }
            }
        }
        return super.writeJsonValue(openAPI);
    }

    protected String getServerUrl(HttpServletRequest httpServletRequest, String string) {
        String string2 = this.decode(httpServletRequest.getRequestURL().toString());
        Optional optional = this.springDocProviders.getSpringWebProvider();
        String string3 = "";
        if (optional.isPresent()) {
            string3 = ((SpringWebProvider)optional.get()).findPathPrefix(this.springDocConfigProperties);
        }
        return string2.substring(0, string2.length() - string.length() - string3.length());
    }
}

