/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.dataInterface.openapi;

import com.bokesoft.erp.dataInterface.openapi.DataInterfaceEntity;
import com.bokesoft.erp.dataInterface.openapi.DataInterfaceField;
import com.bokesoft.yes.mid.cmd.richdocument.strut.IDLookup;
import com.bokesoft.yes.util.ERPStringUtil;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboBoxProperties;
import com.bokesoft.yigo.meta.paratable.MetaParaItem;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.util.ContextBuilder;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class DataInterfaceRepository {
    private static final String _GetReqSQL = "Select m.API, m.FormKey,t.Name From EGS_DataInterface m JOIN EGS_DataInterface_T t ON (m.SOID = t.SOID and t.Lang = ?) ";
    private static final String _GetFieldSQL = "Select SequenceNumber, FieldKey, Required, Example From EGS_DaInfaceAcptFldsSet WHERE SOID = ? ORDER BY SequenceNumber";
    private static final String _GetVestFieldSQL = "Select SequenceNumber, FieldKey, Required, Example From EGS_DaInfaceAcptFldsSetVest WHERE SOID = ? ORDER BY SequenceNumber";
    private static final String _GetDataInterfaceSOIDSQL = "Select SOID, FormKey From EGS_DataInterface where Code = ? ";
    private static String ServiceLocale = "";

    public static void setServiceLoacle(String string) {
        ServiceLocale = string;
    }

    public static List<DataInterfaceEntity> getDataInterfaceList() throws Throwable {
        try (DefaultContext defaultContext = ContextBuilder.create();){
            DataTable dataTable = defaultContext.getDBManager().execPrepareQuery(_GetReqSQL, new Object[]{ServiceLocale});
            ArrayList<DataInterfaceEntity> arrayList = new ArrayList<DataInterfaceEntity>();
            int n = 0;
            while (n < dataTable.size()) {
                DataInterfaceEntity dataInterfaceEntity = new DataInterfaceEntity();
                dataInterfaceEntity.setDataInterfaceAPI(dataTable.getString(n, "API"));
                dataInterfaceEntity.setDataInterfaceName(dataTable.getString(n, "Name"));
                String string = dataTable.getString(n, "FormKey");
                if (!ERPStringUtil.isBlankOrNull((Object)string)) {
                    dataInterfaceEntity.setDataInterfaceFormKey(string);
                    String string2 = defaultContext.getVE().getMetaFactory().getMetaForm(string).getProjectKey();
                    dataInterfaceEntity.setProjectKey(string2);
                    String string3 = defaultContext.getVE().getMetaFactory().getMetaProject(string2).getCaption();
                    dataInterfaceEntity.setProjectCaption(string3);
                    arrayList.add(dataInterfaceEntity);
                }
                ++n;
            }
            ArrayList<DataInterfaceEntity> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    public static Map<String, List<DataInterfaceField>> getFieldListByAPI(String string) throws Throwable {
        try (DefaultContext defaultContext = ContextBuilder.create();){
            DataTable dataTable = defaultContext.getDBManager().execPrepareQuery(_GetDataInterfaceSOIDSQL, new Object[]{string.toUpperCase()});
            if (dataTable == null || dataTable.size() == 0) {
                return null;
            }
            String string2 = dataTable.getString(0, "FormKey");
            MetaForm metaForm = defaultContext.getVE().getMetaFactory().getMetaForm(string2);
            IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)metaForm);
            HashMap<String, List<DataInterfaceField>> hashMap = new HashMap<String, List<DataInterfaceField>>();
            DataTable dataTable2 = defaultContext.getDBManager().execPrepareQuery(_GetFieldSQL, new Object[]{dataTable.getLong(0)});
            DataInterfaceRepository.a(dataTable2, iDLookup, hashMap, defaultContext);
            DataTable dataTable3 = defaultContext.getDBManager().execPrepareQuery(_GetVestFieldSQL, new Object[]{dataTable.getLong(0)});
            DataInterfaceRepository.a(dataTable3, iDLookup, hashMap, defaultContext);
            HashMap<String, List<DataInterfaceField>> hashMap2 = hashMap;
            return hashMap2;
        }
    }

    private static void a(DataTable dataTable, IDLookup iDLookup, Map<String, List<DataInterfaceField>> map, DefaultContext defaultContext) throws Throwable {
        int n = 0;
        while (n < dataTable.size()) {
            DataInterfaceField dataInterfaceField = new DataInterfaceField();
            String string = dataTable.getString(n, "FieldKey");
            String string2 = dataTable.getString(n, "SequenceNumber");
            int n2 = dataTable.getInt(n, "Required");
            String string3 = dataTable.getString(n, "Example");
            dataInterfaceField.setKey(string);
            dataInterfaceField.setSequenceNumber(TypeConvertor.toInteger((Object)string2));
            dataInterfaceField.setRequired(n2 == 1);
            dataInterfaceField.setExample(string3);
            if (iDLookup.containFieldKey(string)) {
                Object object;
                Object object2;
                String string4;
                Object object3;
                Object object4;
                MetaComponent metaComponent = iDLookup.getComponentByKey(string);
                if (metaComponent != null) {
                    dataInterfaceField.setCaption(metaComponent.getCaption());
                } else {
                    object4 = iDLookup.getGridCellByKey(string);
                    if (object4 != null) {
                        dataInterfaceField.setCaption(object4.getCaption());
                    }
                }
                object4 = DataType.toString((Integer)iDLookup.getDataTypeByFieldKey(string));
                dataInterfaceField.setDataType((String)object4);
                if (((String)object4).equalsIgnoreCase("Varchar")) {
                    object3 = iDLookup.getMetaColumnByFieldKey(string);
                    dataInterfaceField.setMaxLength(object3.getLength());
                }
                object3 = ControlType.toString((Integer)iDLookup.getControlType(string));
                dataInterfaceField.setControlType((String)object3);
                ArrayList<String> arrayList = new ArrayList<String>();
                if (iDLookup.getControlType(string) == 204) {
                    string4 = null;
                    if (metaComponent != null) {
                        string4 = (MetaComboBoxProperties)metaComponent.getProperties();
                    } else {
                        object2 = iDLookup.getGridCellByKey(string);
                        if (object2 != null) {
                            string4 = (MetaComboBoxProperties)object2.getProperties();
                        }
                    }
                    if (string4.getSourceType() == 4) {
                        object2 = string4.getGroupKey();
                        object = MetaUtil.getParaGroup((IMetaFactory)defaultContext.getVE().getMetaFactory(), (String)object2);
                        if (object != null) {
                            Iterator iterator = object.iterator();
                            while (iterator.hasNext()) {
                                MetaParaItem metaParaItem = (MetaParaItem)iterator.next();
                                arrayList.add(String.valueOf(metaParaItem.getValue()) + "_" + metaParaItem.getCaption());
                            }
                        }
                    }
                }
                if (arrayList.size() > 0) {
                    dataInterfaceField.setEnum(arrayList);
                }
                string4 = iDLookup.getTableKeyByFieldKey(string);
                object2 = iDLookup.getTableByFieldKey(string);
                if (object2 != null) {
                    dataInterfaceField.setTableCapiton(object2.getCaption());
                }
                if (string4 != null && string4.equalsIgnoreCase(iDLookup.getHeadTableKey())) {
                    string4 = String.valueOf(string4) + "(HeadTable)";
                }
                if (map.containsKey(string4)) {
                    map.get(string4).add(dataInterfaceField);
                } else {
                    object = new ArrayList();
                    object.add(dataInterfaceField);
                    map.put(string4, (List<DataInterfaceField>)object);
                }
            }
            ++n;
        }
    }
}

