/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.authority.setup;

import com.bokesoft.erp.authority.setup.base.IFormInfo;
import com.bokesoft.erp.authority.setup.base.IgnoreAuthorityFormInfo;
import com.bokesoft.erp.authority.setup.context.IAuthoritySetupContext;
import com.bokesoft.erp.authority.setup.context.MetaFactorySetupContext;
import com.bokesoft.erp.authority.setup.context.RichDocumentSetupContext;
import com.bokesoft.erp.authority.setup.entity.AuthoritySetupForm;
import com.bokesoft.erp.authority.setup.entity.SetupAuthorityObject;
import com.bokesoft.erp.authority.setup.entity.SetupOptTCode;
import com.bokesoft.erp.authority.setup.entity.SetupTCode;
import com.bokesoft.erp.authority.setup.entity.SetupTCodeAuthorityRelation;
import com.bokesoft.erp.authority.setup.executor.AbstractAuthoritySetupExecutor;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractAuthoritySetupManager<T extends AbstractAuthoritySetupExecutor> {
    private boolean a = false;
    private AbstractAuthoritySetupExecutor b = null;

    protected AbstractAuthoritySetupManager(T t) {
        this.b = t;
    }

    public synchronized void reset() {
        this.a = false;
    }

    public synchronized void initByContext(RichDocumentContext richDocumentContext) throws Throwable {
        this.init(new RichDocumentSetupContext(richDocumentContext));
    }

    public synchronized void initByMetaFactory(IMetaFactory iMetaFactory) throws Throwable {
        this.init(new MetaFactorySetupContext(iMetaFactory));
    }

    public synchronized void init(IAuthoritySetupContext iAuthoritySetupContext) throws Throwable {
        if (!this.a) {
            this.b.init(iAuthoritySetupContext);
            this.a = true;
        }
    }

    public List<IFormInfo> getAllSetupFormList() {
        ArrayList<IFormInfo> arrayList = new ArrayList<IFormInfo>();
        for (AuthoritySetupForm authoritySetupForm : this.b.getAuthoritySetupForms()) {
            arrayList.add(authoritySetupForm);
        }
        return arrayList;
    }

    public List<IFormInfo> getTodoSetupFormList() {
        if (this.b == null) {
            return Collections.emptyList();
        }
        ArrayList<IFormInfo> arrayList = new ArrayList<IFormInfo>();
        for (AuthoritySetupForm authoritySetupForm : this.b.getAuthoritySetupForms()) {
            if (authoritySetupForm.hasParentForm() || !this.a(authoritySetupForm)) continue;
            arrayList.add(authoritySetupForm);
        }
        return arrayList;
    }

    public List<IFormInfo> getControledSetupFormList() {
        if (this.b == null) {
            return Collections.emptyList();
        }
        ArrayList<IFormInfo> arrayList = new ArrayList<IFormInfo>();
        for (AuthoritySetupForm authoritySetupForm : this.b.getAuthoritySetupForms()) {
            if (this.a(authoritySetupForm) || this.b.isIgnoreFormAuthority(authoritySetupForm.getKey())) continue;
            arrayList.add(authoritySetupForm);
        }
        return arrayList;
    }

    public AuthoritySetupForm getSetupForm(String string) {
        return this.b.getAuthoritySetupForm(string);
    }

    public Set<IgnoreAuthorityFormInfo> getIgnoreSetupFormList() {
        if (this.b == null) {
            return Collections.emptySet();
        }
        return this.b.getIgnoreAuthorityFormKeys();
    }

    public void reloadFormIgnoreAuthority(RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            this.b.reloadFormIgnoreAuthority(this.a(richDocumentContext));
        }
    }

    public void reloadFieldIgnoreAuthority(String string, RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            this.b.reloadFieldIgnoreAuthority(string, this.a(richDocumentContext));
        }
    }

    public void dealFormFieldIgnoreAuthority(String string, String string2, String string3, String string4, boolean bl, RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            this.b.dealFormFieldIgnoreAuthority(string, string2, string3, string4, bl, this.a(richDocumentContext));
        }
    }

    public boolean isIgnoreFormAuthority(String string) {
        if (this.b != null) {
            return this.b.isIgnoreFormAuthority(string);
        }
        return false;
    }

    public boolean isIgnoreFormAuthority(String string, String string2) {
        if (this.b != null) {
            return this.b.isIgnoreFormAuthority(string, string2);
        }
        return false;
    }

    public boolean isControledFormAuthority(String string) {
        AuthoritySetupForm authoritySetupForm;
        if (this.b != null && (authoritySetupForm = this.getSetupForm(string)) != null) {
            Set<String> set = authoritySetupForm.getAllUsedTCode();
            if (set.isEmpty() && authoritySetupForm.existSetupField()) {
                return false;
            }
            for (String string2 : set) {
                if (this.isControledFormAuthority(string, string2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isControledFormAuthority(String string, String string2) {
        AuthoritySetupForm authoritySetupForm;
        if (this.b != null && (authoritySetupForm = this.getSetupForm(string)) != null) {
            return authoritySetupForm.isAllFieldConfirmedInTCode(string2);
        }
        return false;
    }

    public void saveAuthorityObject(String string, Map<String, SetupAuthorityObject> map, RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            this.b.saveAuthorityObject(string, map, this.a(richDocumentContext));
        }
    }

    public void saveAuthorityTCode(String string, List<SetupTCode> list, RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            this.b.saveAuthorityTCode(string, list, this.a(richDocumentContext));
        }
    }

    public void saveTCodeAuthorityObjectRelation(String string, List<SetupTCodeAuthorityRelation> list, RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            this.b.saveTCodeAuthorityObjectRelation(string, list, this.a(richDocumentContext));
        }
    }

    public String getCaptionByTCode(String string, RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            return this.b.getCaptionByTCode(string, this.a(richDocumentContext));
        }
        return "";
    }

    public String getCaptionByAuthorityObjectCode(String string, RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            return this.b.getCaptionByAuthorityObjectCode(string, this.a(richDocumentContext));
        }
        return "";
    }

    public void resetSetupForm(String string, RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            this.b.resetSetupForm(string, this.a(richDocumentContext));
        }
    }

    protected Set<String> getLinkedTCodes(String string, String string2, RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            return this.b.getLinkedTCodes(string, string2, this.a(richDocumentContext));
        }
        return new HashSet<String>();
    }

    protected Set<String> getLinkedAuthorityObjects(String string, String string2, RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            return this.b.getLinkedAuthorityObjects(string, string2, this.a(richDocumentContext));
        }
        return new HashSet<String>();
    }

    public void dealControlFieldAuthority(String string, String string2, String string3, boolean bl, RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            this.b.dealControlFieldAuthority(string, string2, string3, bl, this.a(richDocumentContext));
        }
    }

    public void addFormAuthorityExtendRelation(String string, String string2, RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            this.b.addFormAuthorityExtendRelation(string, string2, this.a(richDocumentContext));
            this.b.reloadFormAuthorityExtendRelation(this.a(richDocumentContext));
        }
    }

    public Map<String, String> getFormAuthorityExtendRelation(RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            return this.b.getFormAuthorityExtendRelation(this.a(richDocumentContext));
        }
        return new HashMap<String, String>();
    }

    public void deleteFormAuthorityExtendRelation(String string, String string2, RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            this.b.deleteFormAuthorityExtendRelation(string, string2, this.a(richDocumentContext));
            this.b.reloadFormAuthorityExtendRelation(this.a(richDocumentContext));
        }
    }

    public Set<String> getAuthorityObjectByDataElement(String string, RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            return this.b.getAuthorityObjectByDataElement(string, this.a(richDocumentContext));
        }
        return new HashSet<String>();
    }

    public void addBindFormTCode(String string, String string2, Long l, RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            this.b.addBindFormTCode(string, string2, l, this.a(richDocumentContext));
            this.resetSetupForm(string, richDocumentContext);
        }
    }

    protected Long getTCodePackID(String string, RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            return this.b.getTCodePackID(string, this.a(richDocumentContext));
        }
        return 0L;
    }

    public void saveEntryTCodeRelation(String string, String string2, String string3, Set<SetupOptTCode> set, RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            this.b.saveEntryTCodeRelation(string, string2, string3, set, this.a(richDocumentContext));
            this.resetSetupForm(string, richDocumentContext);
        }
    }

    public void deleteEntryTCodeRelation(String string, String string2, RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            this.b.deleteEntryTCodeRelation(string, string2, this.a(richDocumentContext));
            this.resetSetupForm(string, richDocumentContext);
        }
    }

    public void deleteFormTCode(String string, String string2, RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            this.b.deleteFormTCode(string, string2, this.a(richDocumentContext));
            this.resetSetupForm(string, richDocumentContext);
        }
    }

    public void checkAllAuthorityExtend(List<Object> list, IAuthoritySetupContext iAuthoritySetupContext) throws Throwable {
        if (this.b != null) {
            this.b.checkAllAuthorityExtend(list, iAuthoritySetupContext);
        }
    }

    private IAuthoritySetupContext a(RichDocumentContext richDocumentContext) {
        return new RichDocumentSetupContext(richDocumentContext);
    }

    private boolean a(AuthoritySetupForm authoritySetupForm) {
        if (this.b.isIgnoreFormAuthority(authoritySetupForm.getKey())) {
            return false;
        }
        Set<String> set = authoritySetupForm.getAllUsedTCode();
        if (set.isEmpty() && authoritySetupForm.existSetupField()) {
            return true;
        }
        boolean bl = false;
        if (!bl) {
            for (String string : set) {
                if (this.b.isIgnoreFormAuthority(authoritySetupForm.getKey(), string) || authoritySetupForm.isAllFieldConfirmedInTCode(string)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean existAuthorityObject(String string, RichDocumentContext richDocumentContext) throws Throwable {
        if (this.b != null) {
            return this.b.existAuthorityObject(string, this.a(richDocumentContext));
        }
        return false;
    }
}

