/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp;

import ch.obermuhlner.math.big.BigDecimalMath;
import com.bokesoft.erp.entity.util.AbstractBillEntity;
import com.bokesoft.erp.entity.util.AbstractTableEntity;
import com.bokesoft.erp.entity.util.AbstractTableLoader;
import com.bokesoft.erp.entity.util.EntityContextAction;
import com.bokesoft.erp.entity.util.EntityHelper;
import com.bokesoft.erp.exception.ERPException;
import com.bokesoft.erp.lock.BusinessLockUtils;
import com.bokesoft.erp.simulate.SimulateFormula;
import com.bokesoft.yes.common.util.DateUtil;
import com.bokesoft.yes.common.util.NumericUtil;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.erp.annotation.ClientFunctionProcessInServer;
import com.bokesoft.yes.erp.annotation.FunctionRunOnlyInClient;
import com.bokesoft.yes.erp.annotation.FunctionRunOnlyInServer;
import com.bokesoft.yes.erp.message.MessageFacade;
import com.bokesoft.yes.mid.authority.util.AuthorityCheckUtil;
import com.bokesoft.yes.mid.cmd.mid.InvokeExtServiceCmd;
import com.bokesoft.yes.mid.cmd.richdocument.expand.column.ExpandColumn;
import com.bokesoft.yes.mid.cmd.richdocument.expand.item.ExpandItem;
import com.bokesoft.yes.mid.cmd.richdocument.expand.model.ExpandDataModel;
import com.bokesoft.yes.mid.cmd.richdocument.expand.model.multikey.TableMultiKeyInfo;
import com.bokesoft.yes.mid.cmd.richdocument.strut.IDLookup;
import com.bokesoft.yes.mid.cmd.richdocument.strut.LocationInfo;
import com.bokesoft.yes.mid.cmd.richdocument.strut.LocationMap;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichServiceFilterImpl;
import com.bokesoft.yes.mid.cmd.richdocument.strut.UICommand;
import com.bokesoft.yes.mid.cmd.richdocument.strut.authority.GetEntryTCodeCmd;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yes.mid.parameterizedsql.SqlStringUtil;
import com.bokesoft.yes.mid.rights.IRightsProvider;
import com.bokesoft.yes.mid.rights.RightsProviderFactory;
import com.bokesoft.yes.tools.dic.filter.BaseItemFilter;
import com.bokesoft.yes.util.DictFilterSqlUtil;
import com.bokesoft.yes.util.ERPDateUtil;
import com.bokesoft.yes.util.ERPStringUtil;
import com.bokesoft.yes.util.VarUtil;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.common.def.RoundingMode;
import com.bokesoft.yigo.common.struct.PairItemList;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.commondef.MetaStatus;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.control.MetaDict;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableView;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.dict.io.DictIOFactory;
import com.bokesoft.yigo.mid.dict.io.IDictIO;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.struct.dict.Item;
import com.bokesoft.yigo.struct.dict.ItemData;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.env.Env;
import com.bokesoft.yigo.struct.rights.DictRights;
import com.bokesoft.yigo.tools.dict.IItemFilter;
import com.bokesoft.yigo.tools.ve.VE;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class ShortNameFunction
extends EntityContextAction {
    private static final String[] UNIT = new String[]{"\u4e07", "\u4edf", "\u4f70", "\u62fe", "\u4ebf", "\u4edf", "\u4f70", "\u62fe", "\u4e07", "\u4edf", "\u4f70", "\u62fe", "\u5706", "\u89d2", "\u5206"};
    private static final String[] NUM = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};

    public ShortNameFunction(RichDocumentContext richDocumentContext) {
        super(richDocumentContext);
    }

    public Object Sqrt(Object object) {
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            return BigDecimalMath.sqrt((BigDecimal)bigDecimal, (MathContext)MathContext.DECIMAL128);
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            return Math.sqrt(l.longValue());
        }
        if (object instanceof Integer) {
            int n = (Integer)object;
            return Math.sqrt(n);
        }
        if (object instanceof Double) {
            double d = (Double)object;
            return Math.sqrt(d);
        }
        MessageFacade.throwException((String)"SHORTNAMEFUNCTION000", (Object[])new Object[0]);
        return object;
    }

    public Object Sin(Object object) {
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            return BigDecimalMath.sin((BigDecimal)bigDecimal, (MathContext)MathContext.DECIMAL128);
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            return Math.sin(l.longValue());
        }
        if (object instanceof Integer) {
            int n = (Integer)object;
            return Math.sin(n);
        }
        if (object instanceof Double) {
            double d = (Double)object;
            return Math.sin(d);
        }
        MessageFacade.throwException((String)"SHORTNAMEFUNCTION000", (Object[])new Object[0]);
        return object;
    }

    public Object Cos(Object object) {
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            return BigDecimalMath.cos((BigDecimal)bigDecimal, (MathContext)MathContext.DECIMAL128);
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            return Math.cos(l.longValue());
        }
        if (object instanceof Integer) {
            int n = (Integer)object;
            return Math.cos(n);
        }
        if (object instanceof Double) {
            double d = (Double)object;
            return Math.cos(d);
        }
        MessageFacade.throwException((String)"SHORTNAMEFUNCTION000", (Object[])new Object[0]);
        return object;
    }

    public Object Tan(Object object) {
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            return BigDecimalMath.tan((BigDecimal)bigDecimal, (MathContext)MathContext.DECIMAL128);
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            return Math.tan(l.longValue());
        }
        if (object instanceof Integer) {
            int n = (Integer)object;
            return Math.tan(n);
        }
        if (object instanceof Double) {
            double d = (Double)object;
            return Math.tan(d);
        }
        MessageFacade.throwException((String)"SHORTNAMEFUNCTION000", (Object[])new Object[0]);
        return object;
    }

    public Object Abs(Object object) {
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            return bigDecimal.abs();
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            return Math.abs(l);
        }
        if (object instanceof Integer) {
            int n = (Integer)object;
            return Math.abs(n);
        }
        return object;
    }

    public Object Mod(Object object, Object object2) throws Throwable {
        BigDecimal bigDecimal = null;
        if (StringUtil.isNumeric((Object)object) && StringUtil.isNumeric((Object)object2)) {
            if (BigDecimal.ZERO.compareTo(TypeConvertor.toBigDecimal((Object)object2)) == 0) {
                MessageFacade.throwException((String)"SHORTNAMEFUNCTION009", (Object[])new Object[0]);
            }
            bigDecimal = TypeConvertor.toBigDecimal((Object)object).remainder(TypeConvertor.toBigDecimal((Object)object2));
        } else {
            MessageFacade.throwException((String)"SHORTNAMEFUNCTION000", (Object[])new Object[0]);
        }
        return bigDecimal;
    }

    public static Object Round(Object object, int n) throws Throwable {
        if (ERPStringUtil.isBlankOrNull((Object)object)) {
            return "";
        }
        if (!StringUtil.isNumeric((Object)object)) {
            MessageFacade.throwException((String)"SHORTNAMEFUNCTION010", (Object[])new Object[]{object});
            return "";
        }
        BigDecimal bigDecimal = TypeConvertor.toBigDecimal((Object)object);
        if (bigDecimal.scale() > n) {
            bigDecimal = bigDecimal.setScale(n, NumericUtil.roundMode((int)4));
        }
        return bigDecimal;
    }

    public static Object Round(Object object, int n, String string) {
        if (ERPStringUtil.isBlankOrNull((Object)object)) {
            return "";
        }
        if (!StringUtil.isNumeric((Object)object)) {
            MessageFacade.throwException((String)"SHORTNAMEFUNCTION010", (Object[])new Object[]{object});
            return "";
        }
        BigDecimal bigDecimal = TypeConvertor.toBigDecimal((Object)object);
        if (bigDecimal.scale() > n) {
            int n2 = 4;
            if (string != null && string.length() > 0) {
                n2 = RoundingMode.parse((String)string);
            }
            bigDecimal = bigDecimal.setScale(n, NumericUtil.roundMode((int)n2));
        }
        return bigDecimal;
    }

    public boolean ExistField(String string) throws Throwable {
        if (this.getDocument() == null) {
            return false;
        }
        MetaForm metaForm = this.getMidContext().getRichDocument().getMetaForm();
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)metaForm);
        return iDLookup.containFieldKey(string);
    }

    public Object AdvancedQueriesConvertValue(int n, Object object) {
        Object object2 = object;
        try {
            switch (n) {
                case 1003: {
                    object2 = TypeConvertor.toDate((Object)object);
                    break;
                }
                case 1004: {
                    object2 = TypeConvertor.toDataType((int)n, (Object)object);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object2;
    }

    public Object GetFormKey() {
        RichDocument richDocument = this.getMidContext().getRichDocument();
        if (richDocument == null) {
            return "";
        }
        return richDocument.getMetaForm().getKey();
    }

    public Object LocaleFormat(Object object, Object object2, Object ... objectArray) throws Throwable {
        return ERPStringUtil.formatMessage((Env)this.getEnv(), (String)((String)object2), (Object[])objectArray);
    }

    public Object GetSourceFormKey() {
        RichDocument richDocument = this.getMidContext().getRichDocument();
        if (richDocument == null) {
            return "";
        }
        MetaForm metaForm = richDocument.getMetaForm();
        return StringUtil.isBlankOrNull((String)metaForm.getExtend()) ? metaForm.getKey() : metaForm.getExtend();
    }

    public Object SetValue(String string, Object object) throws Throwable {
        RichDocumentContext richDocumentContext = this.getMidContext();
        RichDocument richDocument = richDocumentContext.getRichDocument();
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)richDocument.getMetaForm());
        String string2 = iDLookup.getTableKeyByFieldKey(string);
        String string3 = iDLookup.getGridKeyByFieldKey(string);
        if (StringUtil.isBlankOrNull((String)string2) && string3 == null) {
            richDocument.setValueNoChanged(richDocumentContext, string, -1, object, true);
            return object;
        }
        int n = richDocumentContext.getRichDocument().getCurrentBookMark(string2);
        richDocument.setValueNoChanged(richDocumentContext, string, n, object, true);
        return object;
    }

    public Object SetValue(String string, Object object, Object object2) throws Throwable {
        RichDocumentContext richDocumentContext = this.getMidContext();
        RichDocument richDocument = richDocumentContext.getRichDocument();
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)richDocument.getMetaForm());
        if (object instanceof String && !iDLookup.containFieldKey(string)) {
            String string2 = TypeConvertor.toString((Object)string);
            String string3 = TypeConvertor.toString((Object)object);
            Object object3 = object2;
            DataTable dataTable = richDocumentContext.getDocument().get(string2);
            if (dataTable != null) {
                if (!dataTable.isValid()) {
                    dataTable.setObject(0, string3, object3);
                } else {
                    dataTable.setObject(string3, object3);
                }
                richDocumentContext.getDocument().setModified();
                return true;
            }
            return false;
        }
        String string4 = string;
        Object object4 = object;
        boolean bl = object2 instanceof Boolean && TypeConvertor.toBoolean((Object)object2) != false;
        String string5 = iDLookup.getTableKeyByFieldKey(string4);
        String string6 = iDLookup.getGridKeyByFieldKey(string4);
        if (StringUtil.isBlankOrNull((String)string5) && string6 == null) {
            if (bl) {
                richDocument.setHeadFieldValue(string4, object4);
            } else {
                richDocument.setValueNoChanged(richDocumentContext, string4, -1, object4, true);
            }
            return object4;
        }
        int n = richDocumentContext.getRichDocument().getCurrentBookMark(string5);
        if (bl) {
            richDocument.setValue(string4, n, object4);
        } else {
            richDocument.setValueNoChanged(richDocumentContext, string4, n, object4, true);
        }
        return object4;
    }

    public Date ToDate(Object ... objectArray) throws Throwable {
        if (objectArray == null || objectArray.length < 1) {
            return null;
        }
        Object object = objectArray[0];
        if (StringUtil.isNumeric((Object)object)) {
            return new Date(TypeConvertor.toLong((Object)object));
        }
        return DateUtil.getDate((String)TypeConvertor.toString((Object)object));
    }

    public Long DateLong() {
        return ERPDateUtil.getNowDateLong();
    }

    public Long TimeLong() {
        return ERPDateUtil.getTimeLong();
    }

    public Date ServerDate() {
        return ERPDateUtil.getNowTime();
    }

    public Date Date() {
        return ERPDateUtil.getNowTime();
    }

    public Object GetOldValue() {
        RichDocumentContext richDocumentContext = this.getMidContext();
        RichDocumentContext richDocumentContext2 = (RichDocumentContext)richDocumentContext.getDefaultContext();
        String string = richDocumentContext2.getRichDocument().getExpandValue("OldValue");
        String string2 = richDocumentContext2.getRichDocument().getExpandValue("OldValueFieldKey");
        if (string2 == null || "".equals(string2) || string2.length() == 0) {
            return null;
        }
        MetaForm metaForm = this._context.getRichDocument().getMetaForm();
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)metaForm);
        int n = iDLookup.getDataTypeByFieldKey(string2);
        return TypeConvertor.toDataType((int)n, (Object)string);
    }

    public Object GetValue(String string) throws Throwable {
        return this.a(string, false);
    }

    @FunctionRunOnlyInServer
    public Object GetOriginalValue(String string) throws Throwable {
        return this.a(string, true);
    }

    private Object a(String string, boolean bl) throws Throwable {
        RichDocumentContext richDocumentContext = this.getMidContext();
        RichDocument richDocument = richDocumentContext.getRichDocument();
        if (richDocument == null || richDocument.getMetaForm() == null) {
            return null;
        }
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)richDocument.getMetaForm());
        if (IDLookup.isOtherField((String)string)) {
            return richDocument.getHeadFieldValue(string);
        }
        String string2 = iDLookup.getGridKeyByFieldKey(string);
        String string3 = iDLookup.getTableKeyByFieldKey(string);
        if (StringUtil.isBlankOrNull((String)string3) && string2 == null) {
            return bl ? richDocument.getOldValue(string, -1) : richDocument.getValue(string, -1);
        }
        int n = richDocumentContext.getRichDocument().getCurrentBookMark(string3);
        if (n == -1 && bl) {
            return TypeConvertor.toDataType((int)iDLookup.getDataTypeByFieldKey(string), null);
        }
        Object object = bl ? richDocument.getOldValue(string, n) : richDocument.getValue(string, n);
        return object;
    }

    public Object GetLastValue(String string) throws Throwable {
        Object object = null;
        RichDocumentContext richDocumentContext = this.getMidContext();
        RichDocument richDocument = richDocumentContext.getRichDocument();
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)richDocument.getMetaForm());
        if (!iDLookup.containFieldKey(string)) {
            throw new RuntimeException("\u8868\u5355" + richDocument.getMetaForm().getKey() + "\u4e2d\u4e0d\u5b58\u5728\u5b57\u6bb5" + string + ",\u8bf7\u68c0\u67e5\u914d\u7f6e\uff01");
        }
        String string2 = iDLookup.getGridKeyByFieldKey(string);
        String string3 = iDLookup.getTableKeyByFieldKey(string);
        if (StringUtil.isBlankOrNull((String)string3) && string2 == null) {
            return richDocument.getValue(string, -1);
        }
        String string4 = iDLookup.getColumnKeyByFieldKey(string);
        int n = richDocumentContext.getRichDocument().getCurrentBookMark(string3);
        DataTable dataTable = richDocument.get_impl(string3);
        if (dataTable.size() == 0) {
            return null;
        }
        if (n < 0) {
            return dataTable.getObject(dataTable.size() - 1, string4);
        }
        int n2 = 0;
        int n3 = dataTable.size();
        while (n2 < n3) {
            int n4 = dataTable.getBookmark(n2);
            if (n4 == n) {
                object = dataTable.getObject(n2 - 1, string4);
                break;
            }
            ++n2;
        }
        return object;
    }

    public Object isWFMapping() {
        RichDocumentContext richDocumentContext = this.getMidContext();
        RichDocument richDocument = richDocumentContext.getRichDocument();
        return richDocument.isWFMapping();
    }

    public boolean IsNew() {
        boolean bl = false;
        RichDocumentContext richDocumentContext = this.getMidContext();
        RichDocument richDocument = richDocumentContext.getRichDocument();
        if (richDocument.isNew()) {
            bl = true;
        }
        return bl;
    }

    public int GetRowIndex(String string) throws Throwable {
        if (string == null || "".equalsIgnoreCase(string)) {
            return -1;
        }
        RichDocumentContext richDocumentContext = this.getMidContext();
        RichDocument richDocument = richDocumentContext.getRichDocument();
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)richDocument.getMetaForm());
        String string2 = iDLookup.getTableKeyByGridKey(string);
        int n = richDocumentContext.getRichDocument().getCurrentBookMark(string2);
        int n2 = 0;
        DataTable dataTable = richDocument.get_impl(string2);
        int n3 = dataTable.size();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = dataTable.getBookmark(n4);
            if (n5 == n) break;
            ++n2;
            ++n4;
        }
        return n2;
    }

    public int GetRowCount(String string) throws Throwable {
        MetaGrid metaGrid;
        int n;
        if (StringUtil.isBlankOrNull((String)string)) {
            return 0;
        }
        RichDocumentContext richDocumentContext = this.getMidContext();
        RichDocument richDocument = richDocumentContext.getRichDocument();
        if (richDocument == null) {
            return 0;
        }
        MetaForm metaForm = richDocument.getMetaForm();
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)metaForm);
        String string2 = null;
        String string3 = null;
        MetaComponent metaComponent = metaForm.componentByKey(string);
        int n2 = n = metaComponent == null ? -1 : metaComponent.getControlType();
        if (217 == n) {
            String string4;
            metaGrid = iDLookup.getMetaGridByGridKey(string);
            if (metaGrid == null) {
                MessageFacade.throwException((String)"SHORTNAMEFUNCTION007", (Object[])new Object[]{string});
            }
            if (StringUtil.isBlankOrNull((String)(string2 = iDLookup.getTableKeyByGridKey(string)))) {
                MessageFacade.throwException((String)"SHORTNAMEFUNCTION008", (Object[])new Object[]{string});
            }
            if (!StringUtil.isBlankOrNull((String)(string4 = metaGrid.getParentGridKey()))) {
                string3 = iDLookup.getTableKeyByGridKey(string4);
            }
        } else if (216 == n || 256 == n || 305 == n || 257 == n || 259 == n || 258 == n || 263 == n || 264 == n) {
            metaGrid = (MetaComponent)MetaComponent.class.cast(iDLookup.getMetaObjectByKey(string));
            string2 = metaGrid.getTableKey();
        }
        if (StringUtils.isBlank((CharSequence)string2)) {
            return 0;
        }
        metaGrid = richDocument.getDataTable(string2);
        int n3 = metaGrid.size();
        if (StringUtil.isBlankOrNull((String)string3) || n3 == 0) {
            return n3;
        }
        int n4 = richDocument.getCurrentBookMark(string3);
        if (n4 < 0) {
            return 0;
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            if (metaGrid.getParentBookmark(n6) == n4) {
                ++n5;
            }
            ++n6;
        }
        return n5;
    }

    public BigDecimal Sum(String string) throws Throwable {
        String string2;
        IDLookup iDLookup;
        DataTable dataTable;
        RichDocument richDocument = this.getMidContext().getRichDocument();
        if (richDocument == null) {
            richDocument = this.getMidContext().getParentDocument();
        }
        if ((dataTable = richDocument.getDataTable((iDLookup = IDLookup.getIDLookup((MetaForm)richDocument.getMetaForm())).getTableKeyByFieldKey(string))) == null || dataTable.size() == 0) {
            return BigDecimal.ZERO;
        }
        String string3 = iDLookup.getGridKeyByFieldKey(string);
        MetaGrid metaGrid = iDLookup.getMetaGridByGridKey(string3);
        String string4 = metaGrid.getParentGridKey();
        boolean bl = !StringUtil.isBlankOrNull((String)string4);
        int n = -1;
        if (bl) {
            string2 = iDLookup.getTableKeyByGridKey(string4);
            n = this.getMidContext().getRichDocument().getCurrentBookMark(string2);
        }
        string2 = iDLookup.getColumnKeyByFieldKey(string);
        BigDecimal bigDecimal = BigDecimal.ZERO;
        int n2 = dataTable.size();
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5 = n4 = bl ? dataTable.getParentBookmark(n3) : -1;
            if (n4 == n) {
                Object object = dataTable.getObject(n3, string2);
                bigDecimal = bigDecimal.add(TypeConvertor.toBigDecimal((Object)object));
            }
            ++n3;
        }
        return bigDecimal;
    }

    public Object DateLongAdd(Long l, String string, int n) {
        Long l2 = ERPDateUtil.dateLongAdd((String)string, (int)n, (Long)l);
        return l2;
    }

    public Object DateLongDiff(Long l, Long l2, String string) {
        Object object = ERPDateUtil.dateLongDiff((Long)l, (Long)l2, (String)string);
        return object;
    }

    public Object Max(Object object, Object object2) {
        int n = VarUtil.compare((Object)object, (Object)object2);
        if (n == 1) {
            return object;
        }
        return object2;
    }

    public Object MinValue(String string) throws Throwable {
        RichDocumentContext richDocumentContext;
        RichDocument richDocument;
        IDLookup iDLookup;
        String string2;
        RichDocument richDocument2 = this.getDocument();
        DataTable dataTable = richDocument2.getDataTable(string2 = (iDLookup = IDLookup.getIDLookup((MetaForm)(richDocument = (richDocumentContext = this.getMidContext()).getRichDocument()).getMetaForm())).getTableNameByFieldKey(string));
        if (dataTable == null || dataTable.size() == 0) {
            return BigDecimal.ZERO;
        }
        String string3 = richDocument.getMetaForm().getMetaTable(string2).getParentKey();
        int n = richDocument.getCurrentBookMark(string3);
        String string4 = iDLookup.getColumnKeyByFieldKey(string);
        BigDecimal bigDecimal = BigDecimal.ZERO;
        int n2 = 0;
        while (n2 < dataTable.size()) {
            if (dataTable.getParentBookmark(n2) == n) {
                BigDecimal bigDecimal2 = dataTable.getNumeric(n2, string4);
                if (n2 == 0 || bigDecimal2.compareTo(bigDecimal) < 0) {
                    bigDecimal = bigDecimal2;
                }
            }
            ++n2;
        }
        return bigDecimal;
    }

    public Object MaxValue(String string) throws Throwable {
        RichDocumentContext richDocumentContext;
        RichDocument richDocument;
        IDLookup iDLookup;
        String string2;
        RichDocument richDocument2 = this.getDocument();
        DataTable dataTable = richDocument2.getDataTable(string2 = (iDLookup = IDLookup.getIDLookup((MetaForm)(richDocument = (richDocumentContext = this.getMidContext()).getRichDocument()).getMetaForm())).getTableNameByFieldKey(string));
        if (dataTable == null || dataTable.size() == 0) {
            return BigDecimal.ZERO;
        }
        String string3 = iDLookup.getColumnKeyByFieldKey(string);
        Object object = dataTable.getObject(0, string3);
        int n = 0;
        while (n < dataTable.size()) {
            BigDecimal bigDecimal;
            Object object2 = dataTable.getObject(n, string3);
            BigDecimal bigDecimal2 = TypeConvertor.toBigDecimal((Object)object2);
            if (bigDecimal2.compareTo(bigDecimal = TypeConvertor.toBigDecimal((Object)object)) > 0) {
                object = object2;
            }
            ++n;
        }
        return object;
    }

    public boolean HasParent() throws Throwable {
        MetaForm metaForm = null;
        if (this.getMidContext().getParentDocument() != null) {
            metaForm = this.getMidContext().getParentDocument().getMetaForm();
        }
        return metaForm != null;
    }

    public Object GetPara(String string) {
        Object object = this.getMidContext().getPara(string);
        if (object == null) {
            return "";
        }
        return object;
    }

    public boolean ExistsVariable(String string) {
        Object v;
        Object object = this.getMidContext().getPara(string);
        return !ERPStringUtil.isBlankOrNull((Object)object) || !ERPStringUtil.isBlankOrNull(v = this.getMidContext().getEnv().getSessionParas().get(string));
    }

    public Object SetPara(String string, Object object) {
        this.getMidContext().setPara(string, object);
        return object;
    }

    public void RemovePara(String string) {
        this.getMidContext().removePara(string);
    }

    public Object GetAndRemovePara(String string) throws Throwable {
        Object object = this.GetPara(string);
        this.RemovePara(string);
        return object;
    }

    public Object GetEntryPara(String string) {
        return this.getMidContext().getPara(string, false);
    }

    public Object SetEntryPara(String string, Object object) {
        this.getMidContext().setPara(string, object, false);
        return object;
    }

    public boolean CheckItemHasFilter(Object object) {
        return object != null && !StringUtil.isBlankOrNull((Object)object) && !"0".equalsIgnoreCase(object.toString()) && !"-1".equalsIgnoreCase(object.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FunctionRunOnlyInServer
    public SqlString GetFilterByMultiDicValue(String string) throws Throwable {
        Object object = this.GetValue(string);
        if (!(object instanceof Long)) {
            if (!(object instanceof String)) return null;
            if (object.toString().length() <= 0) return null;
        }
        SqlString sqlString = new SqlString();
        String[] stringArray = TypeConvertor.toString((Object)object).split(",");
        if (stringArray == null) return sqlString;
        if (stringArray.length <= 0) return sqlString;
        if ("0".equalsIgnoreCase(stringArray[0])) return null;
        if ("-1".equalsIgnoreCase(stringArray[0])) {
            return null;
        }
        SqlString sqlString2 = new SqlString();
        try {
            String string2 = "";
            Boolean bl = false;
            MetaDict metaDict = null;
            IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)this.getRichDocument().getMetaForm());
            MetaComponent metaComponent = iDLookup.getComponentByKey(string);
            if (metaComponent != null && metaComponent.getControlType() == 206) {
                metaDict = (MetaDict)metaComponent;
                string2 = metaDict.getItemKey();
                bl = metaDict.isEditValue();
            }
            if (bl.booleanValue()) {
                RichDocumentContext richDocumentContext = this.getMidContext();
                MetaDataObject metaDataObject = richDocumentContext.getMetaFactory().getDataObject(string2);
                SqlString sqlString3 = this.a((String)object, string);
                sqlString.append(new Object[]{" select soid from ", metaDataObject.getMainTableKey(), " where ", sqlString3});
                return sqlString;
            }
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                String string3;
                if (n2 >= n) {
                    if (sqlString2.length() > 0) {
                        sqlString2 = sqlString2.deleteRight(3);
                    }
                    string3 = (RichDocumentContext)this.getMidContext().getDefaultContext();
                    sqlString.append(new Object[]{" select soid from ", string3.getVE().getMetaFactory().getDataObject(string2).getMainTableKey(), " where ", sqlString2});
                    return sqlString;
                }
                string3 = stringArray2[n2];
                RichDocumentContext richDocumentContext = this.getMidContext();
                Item item = richDocumentContext.getDicItem(string2, TypeConvertor.toLong((Object)string3));
                if (item == null) {
                    return null;
                }
                int n3 = TypeConvertor.toInteger((Object)item.getValue("TLeft"));
                int n4 = TypeConvertor.toInteger((Object)item.getValue("TRight"));
                if (n3 > 0 && n4 > 0) {
                    sqlString2.append(new Object[]{"(tleft>="}).appendPara((Object)n3).append(new Object[]{" and tright<="}).appendPara((Object)n4).append(new Object[]{") or "});
                } else {
                    sqlString2.append(new Object[]{"(soid="}).appendPara((Object)string3).append(new Object[]{") or "});
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            sqlString.append(new Object[]{SqlStringUtil.genMultiParameters((String)TypeConvertor.toString((Object)object))});
        }
        return sqlString;
    }

    @FunctionRunOnlyInServer
    public SqlString GetMultiDicFldFilter(String string) throws Throwable {
        MetaDict metaDict = (MetaDict)IDLookup.getIDLookup((MetaForm)this.getRichDocument().getMetaForm()).getComponentByKey(string);
        if (metaDict.isAllowMultiSelection().booleanValue()) {
            String string2 = (String)this.GetValue(string);
            if (metaDict.isEditValue().booleanValue()) {
                return this.a(string2, string);
            }
            return new SqlString().append(new Object[]{"oid in (", SqlStringUtil.genMultiParameters((String)string2), ")"});
        }
        return null;
    }

    @FunctionRunOnlyInServer
    public SqlString GetMultiValue4SqlString(String string) throws Throwable {
        MetaDict metaDict;
        String string2 = (String)this.GetValue(string);
        if (StringUtil.isBlankOrNull((String)string) || StringUtil.isBlankOrNull((String)string2)) {
            return null;
        }
        MetaComponent metaComponent = IDLookup.getIDLookup((MetaForm)this.getRichDocument().getMetaForm()).getComponentByKey(string);
        if (metaComponent instanceof MetaDict && (metaDict = (MetaDict)metaComponent).isAllowMultiSelection().booleanValue()) {
            if (metaDict.isEditValue().booleanValue()) {
                return this.a(string2, string);
            }
            if (Objects.equals(string2, "0")) {
                if (this.CheckMultiDictAllChecked(string)) {
                    return new SqlString().append(new Object[]{" 1 = 1 "});
                }
                BaseItemFilter baseItemFilter = this.getDocument().getDictFilter(this.getMidContext().getFormKey(), string, metaDict.getItemKey());
                ItemData itemData = new ItemData(metaDict.getItemKey(), 0L);
                IDictIO iDictIO = DictIOFactory.getInstance().createDictIO((VE)this.getMidContext().getVE(), metaDict.getItemKey());
                List list = iDictIO.getChildren((DefaultContext)this.getMidContext(), metaDict.getItemKey(), 0, itemData, metaDict.getStateMask().intValue(), (IItemFilter)baseItemFilter, false, this.getMidContext().getFormKey(), string);
                StringBuilder stringBuilder = new StringBuilder();
                for (ItemData itemData2 : list) {
                    stringBuilder.append(",");
                    stringBuilder.append(itemData2.getOID());
                }
                if (stringBuilder.length() > 0) {
                    return SqlStringUtil.genMultiParameters((String)stringBuilder.toString().substring(1));
                }
                return SqlStringUtil.genMultiParameters((String)"0");
            }
        }
        return SqlStringUtil.genMultiParameters((String)string2);
    }

    @FunctionRunOnlyInServer
    public boolean CheckMultiDictAllChecked(String string) throws Throwable {
        MetaDict metaDict;
        String string2 = (String)this.GetValue(string);
        if (StringUtil.isBlankOrNull((String)string) || StringUtil.isBlankOrNull((String)string2)) {
            return false;
        }
        if (!Objects.equals(string2, "0")) {
            return false;
        }
        MetaComponent metaComponent = IDLookup.getIDLookup((MetaForm)this.getRichDocument().getMetaForm()).getComponentByKey(string);
        if (metaComponent instanceof MetaDict && (metaDict = (MetaDict)metaComponent).isAllowMultiSelection().booleanValue()) {
            BaseItemFilter baseItemFilter = this.getDocument().getDictFilter(this.getMidContext().getFormKey(), string, metaDict.getItemKey());
            ItemData itemData = new ItemData(metaDict.getItemKey(), 0L);
            IDictIO iDictIO = DictIOFactory.getInstance().createDictIO((VE)this.getMidContext().getVE(), metaDict.getItemKey());
            List list = iDictIO.getChildren((DefaultContext)this.getMidContext(), metaDict.getItemKey(), 0, itemData, metaDict.getStateMask().intValue(), (IItemFilter)baseItemFilter, false, this.getMidContext().getFormKey(), string);
            List list2 = iDictIO.getAllItems((DefaultContext)this.getMidContext(), metaDict.getItemKey(), null, 0, 7, true);
            return list.size() == list2.size();
        }
        return false;
    }

    @FunctionRunOnlyInServer
    private SqlString a(String string, String string2) throws Throwable {
        RichDocumentContext richDocumentContext = this.getMidContext();
        return DictFilterSqlUtil.GetMultiValueQueryStringIsEditValue((String)string, (String)string2, (RichDocumentContext)richDocumentContext);
    }

    @FunctionRunOnlyInServer
    public SqlString GetNormalValues4SqlString(String string) {
        return SqlStringUtil.genMultiParameters((String)string);
    }

    public String Right(String string, int n) throws Throwable {
        if (string == null || string.length() == 0) {
            return "";
        }
        if (n <= string.length()) {
            return string.substring(string.length() - n);
        }
        MessageFacade.throwException((String)"SHORTNAMEFUNCTION001", (Object[])new Object[]{n});
        return string;
    }

    public String Left(String string, int n) throws Throwable {
        if (string == null || string.length() == 0) {
            return "";
        }
        if (n <= string.length()) {
            return string.substring(0, n);
        }
        MessageFacade.throwException((String)"SHORTNAMEFUNCTION001", (Object[])new Object[]{n});
        return string;
    }

    public boolean IsNumeric(Object object) {
        return StringUtil.isNumeric((Object)object);
    }

    private SqlString a(String string, Object[] objectArray) {
        SqlString sqlString = new SqlString(1024);
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object != null) {
                int n3;
                int n4 = n3 = object instanceof SqlString ? ((SqlString)object).length() : object.toString().length();
                if (n3 > 0) {
                    if (sqlString.length() > 0) {
                        sqlString.append(new Object[]{string});
                    }
                    sqlString.append(new Object[]{object});
                }
            }
            ++n2;
        }
        return sqlString;
    }

    private String b(String string, Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder(128);
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            String string2 = TypeConvertor.toString((Object)object);
            if (string2 != null && string2.length() > 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(string2);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public Object Join(String string, Object ... objectArray) {
        Object object;
        boolean bl = false;
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = objectArray2[n2];
            if (object != null && object instanceof SqlString) {
                bl = true;
                break;
            }
            ++n2;
        }
        object = bl ? this.a(string, objectArray) : this.b(string, objectArray);
        return object;
    }

    public Long MoveID(String string, String string2, Long l) throws Throwable {
        Object[] objectArray = ShortNameFunction.a(string2);
        if (objectArray == null || objectArray.length == 0) {
            return 0L;
        }
        if ("MoveFirst".equalsIgnoreCase(string)) {
            return objectArray[0];
        }
        if ("MovePre".equalsIgnoreCase(string)) {
            int n = ArrayUtils.indexOf((Object[])objectArray, (Object)l);
            if (n <= 0) {
                return objectArray[0];
            }
            return objectArray[n - 1];
        }
        if ("MoveNext".equalsIgnoreCase(string)) {
            int n = ArrayUtils.indexOf((Object[])objectArray, (Object)l);
            if (n < 0) {
                return objectArray[objectArray.length - 1];
            }
            return objectArray[n + 1];
        }
        if ("MoveLast".equalsIgnoreCase(string)) {
            return objectArray[objectArray.length - 1];
        }
        MessageFacade.throwException((String)"SHORTNAMEFUNCTION002", (Object[])new Object[]{string});
        return objectArray[0];
    }

    public Long MoveID(String string, String string2) throws Throwable {
        return this.MoveID(string, string2, 0L);
    }

    private static Long[] a(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(";");
        int n = stringArray.length;
        Long[] longArray = new Long[n];
        int n2 = 0;
        while (n2 < n) {
            longArray[n2] = TypeConvertor.toLong((Object)stringArray[n2]);
            ++n2;
        }
        return longArray;
    }

    public BigDecimal Sum(String string, String string2) throws Throwable {
        IDLookup iDLookup;
        String string3;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        RichDocument richDocument = this.getMidContext().getRichDocument();
        DataTable dataTable = richDocument.getDataTable(string3 = (iDLookup = IDLookup.getIDLookup((MetaForm)richDocument.getMetaForm())).getTableKeyByFieldKey(string));
        if (dataTable == null || dataTable.size() == 0) {
            return BigDecimal.ZERO;
        }
        int n = dataTable.size();
        int n2 = richDocument.getCurrentBookMark(string3);
        int n3 = 0;
        while (n3 < n) {
            int n4 = dataTable.getBookmark(n3);
            richDocument.setCurrentBookMark(string3, n4);
            boolean bl = TypeConvertor.toBoolean((Object)this._context.evalFormula(string2, ""));
            if (bl) {
                Object object = dataTable.getObject(n3, iDLookup.getColumnKeyByFieldKey(string));
                bigDecimal = bigDecimal.add(TypeConvertor.toBigDecimal((Object)object));
            }
            ++n3;
        }
        richDocument.setCurrentBookMark(string3, n2);
        return bigDecimal;
    }

    public String GetSelDtlFldValue(String string, String string2) throws Throwable {
        String string3 = "";
        MetaForm metaForm = this.getRichDocument().getMetaForm();
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)metaForm);
        String string4 = iDLookup.getGridKeyByFieldKey(string);
        String string5 = iDLookup.getTableKeyByGridKey(string4);
        DataTable dataTable = this.getDocument().getDataTable(string5);
        MetaGrid metaGrid = iDLookup.getMetaGridByGridKey(string4);
        String string6 = "";
        block0: for (Object object : metaGrid.getRowCollection()) {
            int n = object.getRowType();
            if (n != 2) continue;
            int n2 = 0;
            while (n2 < object.size()) {
                MetaGridCell metaGridCell = (MetaGridCell)object.get(n2);
                if (metaGridCell.getKey().equalsIgnoreCase(string)) {
                    string6 = metaGridCell.getDataBinding().getColumnKey();
                    continue block0;
                }
                ++n2;
            }
        }
        dataTable.beforeFirst();
        while (dataTable.next()) {
            Object object;
            if (dataTable.getInt("SelectField") != 1) continue;
            object = dataTable.getObject(string6).toString();
            string3 = String.valueOf(string3) + string2 + (String)object;
        }
        if (string3.length() > 0) {
            string3 = string3.substring(string2.length(), string3.length());
        }
        return string3;
    }

    public String GetSelDtlFldValue(String string) throws Throwable {
        String string2 = this.GetSelDtlFldValue(string, ",");
        return string2;
    }

    public String GetSelDtlFldValue(String string, String string2, String string3) throws Throwable {
        String string4 = this.GetSelDtlFldValue(string, string2);
        this.SetPara(string3, string4);
        return string4;
    }

    public String Space(int n) {
        String string = " ";
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            string2 = String.valueOf(string2) + string;
            ++n2;
        }
        return string2;
    }

    public String GetCaption(String string) {
        RichDocumentContext richDocumentContext = this.getMidContext();
        RichDocument richDocument = richDocumentContext.getRichDocument();
        MetaForm metaForm = richDocument.getMetaForm();
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)metaForm);
        String string2 = iDLookup.getFieldCaption(string);
        return string2;
    }

    public void DeleteRow() throws Throwable {
        RichDocument richDocument = this.getDocument();
        String string = richDocument.getCurTableKey();
        int n = richDocument.getCurrentBookMark(string);
        richDocument.deleteDetail(string, n);
        richDocument.addDirtyTableFlag(string);
    }

    public void DeleteRow(String string) throws Throwable {
        RichDocument richDocument = this.getDocument();
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)richDocument.getMetaForm());
        String string2 = iDLookup.getTableKeyByGridKey(string);
        int n = richDocument.getCurrentBookMark(string2);
        richDocument.deleteDetail(string2, n);
        richDocument.addDirtyTableFlag(string2);
    }

    public void DeleteRow(String string, int n) throws Throwable {
        RichDocument richDocument = this.getDocument();
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)richDocument.getMetaForm());
        String string2 = iDLookup.getTableKeyByGridKey(string);
        int n2 = richDocument.getDataTable(string2).getBookmark(n);
        richDocument.deleteDetail(string2, n2);
        richDocument.addDirtyTableFlag(string2);
    }

    public boolean ReadOnly() throws Throwable {
        RichDocument richDocument = this.getDocument();
        int n = richDocument.getForm_OperationState();
        boolean bl = n != 1 && n != 2;
        return bl;
    }

    public String GetFormType() throws Throwable {
        MetaForm metaForm = this.getDocument().getMetaForm();
        return FormType.toString((Integer)metaForm.getFormType());
    }

    @FunctionRunOnlyInServer
    public SqlString SqlPara(Object object) {
        return SqlString.sqlPara((Object)object);
    }

    @FunctionRunOnlyInServer
    public SqlString SqlLikePara(Object object, String string, String string2) {
        return SqlString.sqlLikePara((Object)object, (String)"%", (String)"%");
    }

    @FunctionRunOnlyInServer
    public String SqlString(SqlString sqlString) {
        return SqlStringUtil.SqlStringToString((SqlString)sqlString);
    }

    @FunctionRunOnlyInServer
    public DataTable DBQuery(Object ... objectArray) throws Throwable {
        List list;
        SqlString sqlString = SqlStringUtil.ToSqlString((Object)objectArray[0]);
        if (objectArray.length > 1) {
            list = sqlString.getParameterListNotNull();
            int n = 1;
            while (n < objectArray.length) {
                list.add(objectArray[n]);
                ++n;
            }
        }
        list = this.getMidContext();
        return list.getResultSet(sqlString);
    }

    @FunctionRunOnlyInServer
    public Object DBQueryValue(Object ... objectArray) throws Throwable {
        List list;
        SqlString sqlString = SqlStringUtil.ToSqlString((Object)objectArray[0]);
        if (objectArray.length > 1) {
            list = sqlString.getParameterListNotNull();
            int n = 1;
            while (n < objectArray.length) {
                list.add(objectArray[n]);
                ++n;
            }
        }
        list = this.getMidContext();
        DataTable dataTable = list.getResultSet(sqlString);
        return dataTable.getObject(0, 0);
    }

    public Object RMB(Object object) {
        BigDecimal bigDecimal;
        Object object2;
        String string = object.toString();
        BigDecimal bigDecimal2 = new BigDecimal(string);
        String string2 = "";
        if (bigDecimal2.compareTo(BigDecimal.ZERO) < 0) {
            object2 = string.split("-");
            bigDecimal2 = new BigDecimal(object2[1]);
            string2 = "\u8d1f";
        }
        if ((bigDecimal = ((BigDecimal)(object2 = bigDecimal2.multiply(new BigDecimal(100)))).setScale(0, 1)).equals(new BigDecimal(0))) {
            return "\u96f6\u5143\u6574";
        }
        String string3 = bigDecimal.toString();
        boolean bl = false;
        int n = 0;
        int n2 = UNIT.length - string3.length();
        if (n2 < 0) {
            n2 = 0;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (n < string3.length()) {
            char c = string3.charAt(n);
            if (c == '0') {
                bl = true;
                if ("\u4ebf".equals(UNIT[n2]) || "\u4e07".equals(UNIT[n2]) || "\u5143".equals(UNIT[n2])) {
                    stringBuilder.append(UNIT[n2]);
                    bl = false;
                }
            } else {
                if (bl) {
                    stringBuilder.append("\u96f6");
                    bl = false;
                }
                stringBuilder.append(NUM[Integer.parseInt(String.valueOf(c))]).append(UNIT[n2]);
            }
            ++n2;
            ++n;
        }
        String string4 = stringBuilder.toString();
        if (!string4.endsWith("\u89d2") && !string4.endsWith("\u5206")) {
            string4 = String.valueOf(string4) + "\u6574";
        }
        if (string2.length() > 0) {
            string4 = String.valueOf(string2) + string4;
        }
        return string4;
    }

    public int StatusValue(String string) throws Throwable {
        IMetaFactory iMetaFactory;
        MetaStatusCollection metaStatusCollection;
        int n = 0;
        MetaDataSource metaDataSource = this.getMidContext().getRichDocument().getMetaForm().getDataSource();
        MetaDataObject metaDataObject = null;
        if (metaDataSource != null) {
            metaDataObject = metaDataSource.getDataObject();
        }
        if ((metaStatusCollection = MetaUtil.getStatusCollection((IMetaFactory)(iMetaFactory = this.getMidContext().getMetaFactory()), (MetaDataObject)metaDataObject)) != null) {
            MetaStatus metaStatus2 = null;
            for (MetaStatus metaStatus2 : metaStatusCollection) {
                if (!metaStatus2.getKey().equalsIgnoreCase(string)) continue;
                return metaStatus2.getValue();
            }
        }
        return n;
    }

    public Long FirstDayOfMonth() throws Throwable {
        return this.FirstDayOfMonth(null);
    }

    public Long FirstDayOfMonth(Object object) {
        if (object == null) {
            object = ERPDateUtil.getNowDate();
        }
        return ERPDateUtil.getFirstDayOfMonth((Object)object);
    }

    public Long LastDayOfMonth() throws Throwable {
        return this.LastDayOfMonth(null);
    }

    public Long LastDayOfMonth(Object object) {
        if (object == null) {
            object = ERPDateUtil.getNowDate();
        }
        return ERPDateUtil.getLastDayOfMonth((Object)object);
    }

    public Long FirstDayOfWeek() throws Throwable {
        return this.FirstDayOfWeek(null);
    }

    public Long FirstDayOfWeek(Object object) {
        if (object == null) {
            object = ERPDateUtil.getNowDate();
        }
        return ERPDateUtil.getFirstDayOfWeek((Object)object);
    }

    public Long LastDayOfWeek() throws Throwable {
        return this.LastDayOfWeek(null);
    }

    public Long LastDayOfWeek(Object object) {
        if (object == null) {
            object = ERPDateUtil.getNowDate();
        }
        return ERPDateUtil.getLastDayOfWeek((Object)object);
    }

    public int DayOfWeek() throws Throwable {
        return this.DayOfWeek(null);
    }

    public int DayOfWeek(Object object) {
        if (object == null) {
            object = ERPDateUtil.getNowDate();
        }
        return ERPDateUtil.getWeekDay((Object)object);
    }

    public int YearOfDate() {
        return this.YearOfDate(null);
    }

    public int YearOfDate(Object object) {
        if (object == null) {
            object = ERPDateUtil.getNowDate();
        }
        return ERPDateUtil.getYear((Object)object);
    }

    public int MonthOfDate() {
        return this.MonthOfDate(null);
    }

    public int MonthOfDate(Object object) {
        if (object == null) {
            object = ERPDateUtil.getNowDate();
        }
        return ERPDateUtil.getMonth((Object)object);
    }

    @FunctionRunOnlyInServer
    public Object GetSrcHeadValue(String string) throws Throwable {
        MetaDataObject metaDataObject;
        String string2;
        if (!TypeConvertor.toBoolean((Object)this.getMidContext().getPara("IsEnhancement")).booleanValue()) {
            MessageFacade.throwException((String)"SHORTNAMEFUNCTION022", (Object[])new Object[]{"GetSrcHeadValue"});
        }
        if (StringUtil.isBlankOrNull((String)(string2 = (metaDataObject = this.getDocument().getMetaForm().getDataSource().getDataObject()).getMainTableKey()))) {
            return null;
        }
        DataTable dataTable = this.getDocument().get(string2);
        Long l = dataTable.getLong(0, "SrcSOID");
        String string3 = dataTable.getString(0, "SrcFormKey");
        if (l.compareTo(0L) <= 0 || StringUtil.isBlankOrNull((String)string3)) {
            return null;
        }
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(string3);
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)metaForm);
        MetaDataBinding metaDataBinding = iDLookup.getMetaDataBinding(string);
        if (metaDataBinding == null) {
            return null;
        }
        String string4 = metaDataBinding.getTableKey();
        String string5 = metaDataBinding.getColumnKey();
        SqlString sqlString = new SqlString().append(new Object[]{"select "}).append(new Object[]{string5}).append(new Object[]{" from "}).append(new Object[]{string4}).append(new Object[]{" where SOID = "}).appendPara((Object)l);
        DataTable dataTable2 = this.getResultSet(sqlString);
        if (!dataTable2.isEmpty()) {
            return dataTable2.getObject(0);
        }
        return null;
    }

    @FunctionRunOnlyInServer
    public Object GetSrcDtlValue(String string, String string2) throws Throwable {
        String string3;
        if (!TypeConvertor.toBoolean((Object)this.getMidContext().getPara("IsEnhancement")).booleanValue()) {
            MessageFacade.throwException((String)"SHORTNAMEFUNCTION022", (Object[])new Object[]{"GetSrcDtlValue"});
        }
        if (StringUtil.isBlankOrNull((String)(string3 = TypeConvertor.toString((Object)this.getMidContext().getPara("PointTableKey"))))) {
            return null;
        }
        DataTable dataTable = this.getDocument().get(string3);
        Long l = dataTable.getLong(0, "SrcOID");
        String string4 = dataTable.getString(0, "SrcFormKey");
        if (l.compareTo(0L) <= 0 || StringUtil.isBlankOrNull((String)string4)) {
            return null;
        }
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(string4);
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)metaForm);
        MetaDataBinding metaDataBinding = iDLookup.getMetaDataBinding(string2);
        if (metaDataBinding == null) {
            return null;
        }
        String string5 = metaDataBinding.getColumnKey();
        SqlString sqlString = new SqlString().append(new Object[]{"select "}).append(new Object[]{string5}).append(new Object[]{" from "}).append(new Object[]{string}).append(new Object[]{" where OID = "}).appendPara((Object)l);
        DataTable dataTable2 = this.getResultSet(sqlString);
        if (!dataTable2.isEmpty()) {
            return dataTable2.getObject(0);
        }
        return null;
    }

    public Long GetDictOID(String string, String string2, String string3) throws Throwable {
        String string4;
        if (ERPStringUtil.isBlankOrNull((Object)string3)) {
            return 0L;
        }
        RichDocumentContext richDocumentContext = this.getMidContext();
        IMetaFactory iMetaFactory = richDocumentContext.getMetaFactory(false);
        MetaDataObject metaDataObject = iMetaFactory.getDataObject(string);
        if (metaDataObject == null) {
            MessageFacade.throwException((String)"RIGHTFORMULA005", (Object[])new Object[]{string});
        }
        MetaTable metaTable = metaDataObject.getMainTable();
        boolean bl = metaTable.isPersist();
        String string5 = metaTable.getBindingDBTableName();
        try {
            if (!(!"Code".equals(string2) || bl && StringUtil.isBlankOrNull((String)string5))) {
                string4 = string;
                if (!iMetaFactory.hasMetaForm(string4)) {
                    string4 = "V_" + string;
                }
                if (iMetaFactory.hasMetaForm(string4)) {
                    IRightsProvider iRightsProvider;
                    DictRights dictRights;
                    boolean bl2;
                    AbstractTableLoader abstractTableLoader = EntityHelper.getInstance().getEntityClassNameMap().getLoader(richDocumentContext, string4, string5);
                    List list = (List)abstractTableLoader.addMetaColumnValueObjectOperator(string2, "=", (Object)string3).loadList();
                    if (list == null || list.size() == 0) {
                        return 0L;
                    }
                    Long l = ((AbstractTableEntity)list.get(0)).getSOID();
                    if (RichServiceFilterImpl.isCheckAdminRights() && !(bl2 = (dictRights = (iRightsProvider = RightsProviderFactory.getInstance().newRightsProvider((DefaultContext)richDocumentContext)).getDictRights(string)).hasRights(l.longValue()))) {
                        return 0L;
                    }
                    return l;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string4 = richDocumentContext.getDictCache().locate(string, string2, (Object)string3, null, null, 7, null, null, 0);
        if (string4 == null) {
            return null;
        }
        return string4.getID();
    }

    public boolean ERPShowModal(String string) throws Throwable {
        return this.ERPShowModal(string, null);
    }

    public boolean ERPShowModal(String string, String string2) throws Throwable {
        return this.ERPShowModal(string, string2, null);
    }

    public boolean ERPShowModal(String string, String string2, String string3) throws Throwable {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("FormKey", (Object)string);
        jSONObject.put("OnLoad", (Object)string2);
        jSONObject.put("Target", (Object)string3);
        this.getDocument().appendUICommand(new UICommand("ERPShowModal", (Object)jSONObject, new Object[0]));
        return true;
    }

    public boolean ERPShowModal(String string, String string2, String string3, String string4) throws Throwable {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("FormKey", (Object)string);
        jSONObject.put("OnLoad", (Object)string2);
        jSONObject.put("Target", (Object)string3);
        jSONObject.put("OperationState", (Object)string4);
        this.getDocument().appendUICommand(new UICommand("ERPShowModal", (Object)jSONObject, new Object[0]));
        return true;
    }

    public boolean IsEmptyRow(String string, int n) throws Throwable {
        RichDocumentContext richDocumentContext = this.getMidContext();
        RichDocument richDocument = richDocumentContext.getRichDocument();
        MetaForm metaForm = richDocument.getMetaForm();
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)metaForm);
        MetaGrid metaGrid = iDLookup.getMetaGridByGridKey(string);
        if (metaGrid == null) {
            MessageFacade.throwException((String)"SYSTEM0399", (Object[])new Object[]{string});
        }
        String string2 = metaGrid.getTableKey();
        int n2 = -1;
        if (n == -1) {
            n2 = richDocument.getCurrentBookMark(string2);
        } else {
            DataTable dataTable = richDocument.get(string2);
            if (dataTable.size() > n) {
                n2 = dataTable.getBookmark(n);
            }
        }
        return n2 == -1;
    }

    public boolean IsNewOrEdit() {
        RichDocumentContext richDocumentContext = this.getMidContext();
        RichDocument richDocument = richDocumentContext.getRichDocument();
        int n = richDocument.getForm_OperationState();
        return n == 1 || n == 2;
    }

    public void StartSimulate() {
        SimulateFormula.startSimulate(this.getMidContext());
    }

    public void StartImportSimulate() {
        SimulateFormula.startImportSimulate();
    }

    public void EndImportSimulate() throws Throwable {
        SimulateFormula.endImportSimulate(this.getMidContext());
    }

    public void EndSimulate() throws Throwable {
        SimulateFormula.endSimulate(this.getMidContext());
    }

    public Object SumExpand(String string) throws Throwable {
        return this.SumExpand(string, "");
    }

    public Object SumExpand(String string, String string2) throws Throwable {
        Integer[] integerArray;
        RichDocument richDocument = this.getMidContext().getRichDocument();
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)richDocument.getMetaForm());
        String string3 = iDLookup.getTableKeyByFieldKey(string);
        BigDecimal bigDecimal = BigDecimal.ZERO;
        boolean bl = true;
        ExpandDataModel expandDataModel = richDocument.getExpandModel(string3);
        if (expandDataModel == null) {
            return bigDecimal;
        }
        Integer[] integerArray2 = integerArray = expandDataModel.getCurSourceBkmks();
        int n = integerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object;
            int n3 = integerArray2[n2];
            if (string2 != null && string2.length() != 0) {
                bl = TypeConvertor.toBoolean((Object)expandDataModel.evalFormula(string3, n3, string2));
            }
            if (bl && (object = expandDataModel.getValue(string, n3, (Object)0)) != null) {
                bigDecimal = bigDecimal.add(TypeConvertor.toBigDecimal((Object)object));
            }
            ++n2;
        }
        return bigDecimal;
    }

    @FunctionRunOnlyInServer
    public Object GetExpandCellValue(String string, String string2, Object object) throws Throwable {
        RichDocumentContext richDocumentContext = this.getMidContext();
        RichDocument richDocument = richDocumentContext.getRichDocument();
        MetaForm metaForm = richDocument.getMetaForm();
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)metaForm);
        String string3 = iDLookup.getTableKeyByFieldKey(string);
        DataTable dataTable = richDocument.getDataTable(string3);
        TableMultiKeyInfo tableMultiKeyInfo = TableMultiKeyInfo.newInstance((String)string3, (DataTableMetaData)dataTable.getMetaData(), (String)string2);
        ExpandDataModel expandDataModel = richDocument.getExpandModel(string3);
        return expandDataModel.getValue(string, tableMultiKeyInfo, object);
    }

    @FunctionRunOnlyInServer
    public void SetExpandCellValue(String string, String string2, Object object) throws Throwable {
        RichDocumentContext richDocumentContext = this.getMidContext();
        RichDocument richDocument = richDocumentContext.getRichDocument();
        MetaForm metaForm = richDocument.getMetaForm();
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)metaForm);
        String string3 = iDLookup.getTableKeyByFieldKey(string);
        DataTable dataTable = richDocument.getDataTable(string3);
        TableMultiKeyInfo tableMultiKeyInfo = TableMultiKeyInfo.newInstance((String)string3, (DataTableMetaData)dataTable.getMetaData(), (String)string2);
        ExpandDataModel expandDataModel = richDocument.getExpandModel(string3);
        expandDataModel.setValue(string, tableMultiKeyInfo, object, false);
    }

    @FunctionRunOnlyInServer
    public Object GetCrossValue(String string, String string2) throws Throwable {
        return this.GetCrossValue(string, string2, "");
    }

    @FunctionRunOnlyInServer
    public Object GetCrossValue(String string, String string2, Object object) throws Throwable {
        int n;
        MetaForm metaForm;
        IDLookup iDLookup;
        String string3;
        RichDocumentContext richDocumentContext = this.getMidContext();
        RichDocument richDocument = richDocumentContext.getRichDocument();
        ExpandDataModel expandDataModel = richDocument.getExpandModel(string3 = (iDLookup = IDLookup.getIDLookup((MetaForm)(metaForm = richDocument.getMetaForm()))).getTableKeyByGridKey(string2));
        if (expandDataModel == null) {
            return object;
        }
        LocationMap locationMap = richDocumentContext.getUILocationMap();
        LocationInfo locationInfo = locationMap == null ? null : locationMap.getLocationInfo(string2);
        int n2 = n = locationInfo == null ? -1 : locationInfo.getColumn();
        if (n != -1) {
            ExpandColumn expandColumn = (ExpandColumn)expandDataModel.getColumnContext().getLeafColumns().get(n);
            List list = expandColumn.getCrossItems();
            for (ExpandItem expandItem : list) {
                if (!string.equals(expandItem.getDBColumnKey())) continue;
                return expandItem.getValue();
            }
        }
        return expandDataModel.getCurCrossValue(string);
    }

    public Long GetEmployeeID() {
        RichDocumentContext richDocumentContext = this.getMidContext();
        Long l = TypeConvertor.toLong(richDocumentContext.getEnv().getSessionParas().get("EmployeeID"));
        return l;
    }

    public boolean IsNewDtl() throws Throwable {
        int n;
        String string;
        RichDocument richDocument = this.getDocument();
        int n2 = richDocument.getRowStatus(string = richDocument.getCurTableKey(), n = richDocument.getCurrentBookMark(string));
        return n2 == 1;
    }

    public boolean IsNewRow(String string) throws Throwable {
        IDLookup iDLookup;
        String string2;
        RichDocument richDocument = this.getDocument();
        int n = richDocument.getCurrentBookMark(string2 = (iDLookup = IDLookup.getIDLookup((MetaForm)richDocument.getMetaForm())).getTableKeyByFieldKey(string));
        if (n == -1) {
            return true;
        }
        int n2 = richDocument.getRowStatus(string2, n);
        return n2 == 1;
    }

    @FunctionRunOnlyInServer
    public void ClearAllRows(String string) throws Throwable {
        Object object3;
        List list;
        RichDocumentContext richDocumentContext = this.getMidContext();
        RichDocument richDocument = richDocumentContext.getRichDocument();
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)richDocument.getMetaForm());
        MetaGrid metaGrid = iDLookup.getMetaGridByGridKey(string);
        String string2 = metaGrid == null ? null : metaGrid.getParentGridKey();
        Long l = 0L;
        if (!StringUtil.isBlankOrStrNull((String)string2)) {
            l = richDocument.getCurrentOID(iDLookup.getTableKeyByGridKey(string2));
        }
        String string3 = null;
        if (metaGrid == null) {
            list = iDLookup.getMetaTableViews();
            if (list != null && list.size() > 0) {
                block0: for (MetaTableView metaTableView : list) {
                    object3 = metaTableView.getRows();
                    if (object3 == null || object3.size() == 0) continue;
                    for (Object object2 : object3) {
                        if (!object2.getKey().equalsIgnoreCase(string)) continue;
                        string3 = object2.getTableKey();
                        continue block0;
                    }
                }
            }
        } else {
            string3 = iDLookup.getTableKeyByGridKey(string);
        }
        if (StringUtils.isBlank((CharSequence)string3)) {
            return;
        }
        list = richDocument.get_impl(string3);
        richDocument.addDirtyTableFlag(string3);
        int n = list.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            Object object2;
            object3 = list.getLong(n2, "OID");
            object2 = list.getLong(n2, "POID");
            if (StringUtil.isBlankOrStrNull((String)string2)) {
                richDocument.deleteDetail(string3, (Long)object3);
            } else if (object2 == null || (Long)object2 <= 0L || ((Long)object2).equals(l)) {
                richDocument.deleteDetail(string3, (Long)object3);
            }
            --n2;
        }
        List list2 = iDLookup.getChildGridKeyByGridKey(string);
        if (list2 == null || list2.size() == 0) {
            return;
        }
        for (Object object3 : list2) {
            this.ClearAllRows((String)object3);
        }
    }

    public void DistinctRow(String string) throws Throwable {
        this.DistinctRow(string, "", "");
    }

    public void DistinctRow(String string, String string2) throws Throwable {
        this.DistinctRow(string, string2, "");
    }

    public void DistinctRow(String string, String string2, String string3) throws Throwable {
        String[] stringArray = StringUtil.split((String)string, (String)":");
        String[] stringArray2 = StringUtil.split((String)string3, (String)":");
        RichDocument richDocument = this.getRichDocument();
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)richDocument.getMetaForm());
        String string4 = iDLookup.getGridKeyByFieldKey(stringArray[0]);
        List list = iDLookup.getGridColumnExpands(string4);
        String string5 = iDLookup.getTableKeyByFieldKey(stringArray[0]);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (list == null) {
            Long[] longArray = richDocument.getOIDs(string5);
            int n = longArray.length;
            if (longArray.length == 0) {
                return;
            }
            List list2 = iDLookup.getFieldListKeyByTableColumnKey(string5, "Sequence");
            String string6 = list2.isEmpty() ? "" : (String)list2.get(0);
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                int n4;
                Boolean bl = true;
                Integer n5 = 0;
                int n6 = 0;
                while (n6 < stringArray2.length) {
                    n4 = TypeConvertor.toInteger((Object)richDocument.getValue(stringArray2[n6], longArray[n3]));
                    if (n4 == 1) {
                        bl = false;
                        break;
                    }
                    ++n6;
                }
                if (bl.booleanValue()) {
                    String string7;
                    if (!ERPStringUtil.isBlankOrNull((Object)string6)) {
                        n5 = TypeConvertor.toInteger((Object)richDocument.getValue(string6, longArray[n3]));
                    }
                    ++n2;
                    StringBuffer stringBuffer = new StringBuffer();
                    n4 = 0;
                    while (n4 < stringArray.length) {
                        string7 = TypeConvertor.toString((Object)richDocument.getValue(stringArray[n4], longArray[n3]));
                        stringBuffer.append("|").append(string7);
                        ++n4;
                    }
                    if (hashMap.containsKey(stringBuffer.toString())) {
                        n4 = (Integer)hashMap.get(stringBuffer.toString());
                        string7 = this.a(stringArray, iDLookup);
                        if (ERPStringUtil.isBlankOrNull((Object)string2)) {
                            if (!ERPStringUtil.isBlankOrNull((Object)string6)) {
                                MessageFacade.throwException((String)"SHORTNAMEFUNCTION003", (Object[])new Object[]{n4, string7, n5});
                            } else {
                                MessageFacade.throwException((String)"SHORTNAMEFUNCTION003", (Object[])new Object[]{n4, string7, n2});
                            }
                        } else {
                            MessageFacade.throwException((String)string2, (Object[])new Object[0]);
                        }
                    }
                    if (!ERPStringUtil.isBlankOrNull((Object)string6)) {
                        hashMap.put(stringBuffer.toString(), n5);
                    } else {
                        hashMap.put(stringBuffer.toString(), n2);
                    }
                }
                ++n3;
            }
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            while (n < stringArray.length) {
                String string8 = iDLookup.getColumnKeyByFieldKey(stringArray[n]);
                arrayList.add(string8);
                ++n;
            }
            DataTable dataTable = richDocument.getDataTable(string5);
            int n7 = dataTable.size();
            int n8 = 0;
            while (n8 < n7) {
                Boolean bl = true;
                int n9 = 0;
                while (n9 < stringArray2.length) {
                    int n10 = TypeConvertor.toInteger((Object)dataTable.getObject(n8, stringArray2[n9]));
                    if (n10 == 1) {
                        bl = false;
                        break;
                    }
                    ++n9;
                }
                if (bl.booleanValue()) {
                    Object object;
                    StringBuffer stringBuffer = new StringBuffer();
                    for (String string9 : arrayList) {
                        object = TypeConvertor.toString((Object)dataTable.getObject(n8, string9));
                        stringBuffer.append("|").append((String)object);
                    }
                    for (String string10 : list) {
                        object = TypeConvertor.toString((Object)dataTable.getObject(n8, string10));
                        stringBuffer.append("|").append((String)object);
                    }
                    if (hashMap.containsKey(stringBuffer.toString())) {
                        String string11 = this.a(stringArray, iDLookup);
                        for (Object object2 : list) {
                            string11 = String.valueOf(string11) + "|" + iDLookup.getColumnCaption(string5, (String)object2);
                        }
                        MessageFacade.throwException((String)"SHORTNAMEFUNCTION004", (Object[])new Object[]{string11});
                    }
                    hashMap.put(stringBuffer.toString(), n8);
                }
                ++n8;
            }
        }
    }

    private String a(String[] stringArray, IDLookup iDLookup) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(iDLookup.getFieldCaption(stringArray[n])).append("|");
            ++n;
        }
        String string = stringBuffer.toString();
        string = string.substring(0, string.length() - 1);
        return string;
    }

    public Object InvokeService(String string, boolean bl, boolean bl2, Object ... objectArray) throws Throwable {
        return this.a(true, string, bl, bl2, objectArray);
    }

    public Object InvokeUnsafeService(String string, boolean bl, boolean bl2, String[] stringArray, String ... stringArray2) throws Throwable {
        return this.a(false, string, bl, bl2, stringArray2);
    }

    private Object a(boolean bl, String string, boolean bl2, boolean bl3, Object ... invokeExtServiceCmd) throws Throwable {
        Object object;
        ArrayList<RichDocument> arrayList = new ArrayList<RichDocument>();
        InvokeExtServiceCmd invokeExtServiceCmd2 = invokeExtServiceCmd;
        int n = ((Object[])invokeExtServiceCmd2).length;
        int n2 = 0;
        while (n2 < n) {
            object = invokeExtServiceCmd2[n2];
            arrayList.add((RichDocument)object);
            ++n2;
        }
        object = this.getDocument();
        Object object2 = null;
        if (bl2) {
            object2 = object;
        }
        n = 1;
        try {
            invokeExtServiceCmd2 = new InvokeExtServiceCmd(string, bl, (Document)object2, arrayList);
            Object object3 = invokeExtServiceCmd2.doCmd((DefaultContext)this.getMidContext());
            if (bl3 && object3 instanceof Document) {
                this.getMidContext().setDocument((Document)Document.class.cast(object3));
                if (object3 instanceof RichDocument) {
                    ((RichDocument)object3).setFullData();
                }
                n = 0;
                Boolean bl4 = true;
                return bl4;
            }
            Object object4 = object3;
            return object4;
        }
        finally {
            if (n != 0) {
                this.getMidContext().setDocument((Document)object);
            }
        }
    }

    public void SetCellValue(String string, int n, Object object, Object object2) throws Throwable {
        this.SetCellValue(string, n, object, object2, true);
    }

    public void SetCellValue(String string, int n, Object object, Object object2, boolean bl) throws Throwable {
        if (StringUtil.isNumeric((Object)object)) {
            this.a(string, n, TypeConvertor.toInteger((Object)object), object2, bl);
        } else {
            int n2;
            String string2 = TypeConvertor.toString((Object)object);
            RichDocument richDocument = this.getRichDocument();
            IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)richDocument.getMetaForm());
            String string3 = iDLookup.getTableKeyByGridKey(string);
            DataTable dataTable = richDocument.get_impl(string3);
            int n3 = n2 = n < 0 ? richDocument.getCurrentBookMark(string3) : dataTable.getBookmark(n);
            if (bl) {
                richDocument.setValue(string2, n2, object2);
            } else {
                richDocument.setValueNoChanged(this.getMidContext(), string2, n2, object2, true);
            }
        }
    }

    public Object GetCellValue(String string, int n, Object object) throws Throwable {
        int n2;
        if (StringUtil.isNumeric((Object)object)) {
            return this.a(string, n, TypeConvertor.toInteger((Object)object));
        }
        RichDocument richDocument = this.getRichDocument();
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)richDocument.getMetaForm());
        String string2 = iDLookup.getTableKeyByGridKey(string);
        DataTable dataTable = richDocument.get_impl(string2);
        int n3 = n2 = n < 0 || n >= dataTable.size() ? richDocument.getCurrentBookMark(string2) : dataTable.getBookmark(n);
        if (n2 < -1) {
            return null;
        }
        String string3 = TypeConvertor.toString((Object)object);
        return richDocument.getValue(this.getMidContext(), string3, n2);
    }

    private void a(String string, int n, int n2, Object object, boolean bl) throws Throwable {
        RichDocument richDocument = this.getRichDocument();
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)richDocument.getMetaForm());
        MetaGrid metaGrid = iDLookup.getMetaGridByGridKey(string);
        MetaGridRow metaGridRow = metaGrid.getDetailMetaRow();
        if (metaGridRow != null) {
            MetaGridCell metaGridCell = (MetaGridCell)metaGridRow.get(n2);
            this.SetCellValue(string, n, metaGridCell.getKey(), object, bl);
        }
    }

    private Object a(String string, int n, int n2) throws Throwable {
        RichDocument richDocument = this.getRichDocument();
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)richDocument.getMetaForm());
        MetaGrid metaGrid = iDLookup.getMetaGridByGridKey(string);
        MetaGridRow metaGridRow = metaGrid.getDetailMetaRow();
        if (metaGridRow != null) {
            MetaGridCell metaGridCell = (MetaGridCell)metaGridRow.get(n2);
            return this.GetCellValue(string, n, metaGridCell.getKey());
        }
        return null;
    }

    @FunctionRunOnlyInServer
    public SqlString ReplaceWhere(SqlString sqlString, String string, String string2) throws Throwable {
        if (string.length() > 0 && string2.length() > 0) {
            String[] stringArray;
            String string3 = SqlStringUtil.SqlStringToString((SqlString)sqlString);
            String[] stringArray2 = string.split(",");
            if (stringArray2.length != (stringArray = string2.split(",")).length) {
                MessageFacade.throwException((String)"SHORTNAMEFUNCTION006", (Object[])new Object[0]);
            }
            int n = 0;
            String[] stringArray3 = stringArray2;
            int n2 = stringArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                String string4 = stringArray3[n3];
                string3 = string3.replace(string4, stringArray[n++]);
                ++n3;
            }
            return SqlStringUtil.ToSqlString((Object)string3);
        }
        return sqlString;
    }

    public String GetLocale() throws Throwable {
        return this.getEnv().getLocale();
    }

    public String GetCallFormula(String string, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            String string2 = TypeConvertor.toString((Object)object);
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            if (object instanceof String) {
                string2 = "'" + string2 + "'";
            } else if (object == null) {
                string2 = "null";
            }
            stringBuilder.append(string2);
            ++n2;
        }
        return String.valueOf(string) + "(" + stringBuilder + ")";
    }

    public void RaiseErrMsg(String string, String string2, Object ... objectArray) throws Throwable {
        throw new ERPException(this.getEnv(), MessageFacade.getMsgContent((String)string, (Object[])objectArray));
    }

    public void RaiseErrMsg(String string, String string2) throws Throwable {
        throw new ERPException(this.getEnv(), MessageFacade.getMsgContent((String)string, (Object[])new Object[0]));
    }

    public String MessageFacade(String string, String string2, Object ... objectArray) throws Throwable {
        return MessageFacade.getMsgContent((String)string, (Object[])objectArray);
    }

    public String MessageFacade(String string, String string2) throws Throwable {
        return MessageFacade.getMsgContent((String)string, (Object[])new Object[0]);
    }

    public String GenLockValue(Object ... objectArray) throws Throwable {
        return BusinessLockUtils.genLockValue(objectArray);
    }

    public String GetEntryTCode() throws Throwable {
        String string = TypeConvertor.toString((Object)this._context.getPara("EntryKey"));
        Object object = new GetEntryTCodeCmd(string).doCmd((DefaultContext)this._context);
        String string2 = TypeConvertor.toString((Object)object);
        return string2;
    }

    public PairItemList GetFormByType(String string) throws Throwable {
        return MetaUtil.getFormByType((IMetaFactory)this._context.getVE().getMetaFactory(), (String)string);
    }

    @FunctionRunOnlyInServer
    public void CheckFormDataAuthority(String string, Long l, String string2, String string3) throws Throwable {
        if (!RichServiceFilterImpl.isCheckAdminRights()) {
            RichDocumentContext richDocumentContext = new RichDocumentContext((DefaultContext)this._context);
            HashMap<String, String> hashMap = richDocumentContext.getHeadInfos();
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
            }
            if (StringUtil.isBlankOrNull((String)string2) || StringUtil.isBlankOrNull((String)string3)) {
                MessageFacade.throwException((String)"AUTH021", (Object[])new Object[0]);
            }
            hashMap.put("TCode", string2);
            hashMap.put("Activity", string3);
            richDocumentContext.setHeadInfos(hashMap);
            if (StringUtil.isBlankOrNull((String)string)) {
                string = this._context.getFormKey();
            }
            String string4 = EntityHelper.getInstance().getEntityClassNameMap().getEntityClassName(string);
            Class<?> clazz = Class.forName(string4);
            Method method = clazz.getMethod("load", RichDocumentContext.class, Long.class);
            AbstractBillEntity abstractBillEntity = (AbstractBillEntity)method.invoke(null, richDocumentContext, l);
            richDocumentContext.setDocument((Document)abstractBillEntity.document);
            richDocumentContext.setFormKey(string);
            AuthorityCheckUtil.checkOperation((DefaultContext)richDocumentContext);
        }
    }

    public String UTCDateFormat(Long l, String string) throws Throwable {
        return DateUtil.format((Object)l, (String)string);
    }

    public String GetOperatorPara(String string) throws Throwable {
        String string2 = this._context.getOperatorPara(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public void SetOperatorPara(String string, String string2) throws Throwable {
        this._context.setOperatorPara(string, string2);
    }

    @FunctionRunOnlyInClient
    @ClientFunctionProcessInServer
    public void ConfirmMsg(String string, String string2, Object object, String string3, Object object2) throws Throwable {
        if (!this.getDocument().isCreateInMid()) {
            return;
        }
        this.a(string, string2, object, string3, object2, "");
    }

    @FunctionRunOnlyInClient
    public void ConfirmMsg(String string, String string2, Object object) throws Throwable {
    }

    @FunctionRunOnlyInClient
    public void ConfirmMsg(String string, String string2) throws Throwable {
    }

    @FunctionRunOnlyInClient
    public void ConfirmMsg(String string, String string2, Object object, String string3) throws Throwable {
    }

    private void a(String string, String string2, Object object, String string3, Object object2, String string4) throws Throwable {
        if (ERPStringUtil.isBlankOrNull((Object)string4)) {
            string4 = string3.equalsIgnoreCase("OK") ? "OK" : "YES";
        }
        String string5 = String.valueOf(object2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = string5.length();
        String string6 = "";
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            char c = string5.charAt(n4);
            if (c == ':' && n2 == 0) {
                string6 = string5.substring(n3, n4).trim();
            } else if (c == ',' && n2 == 0) {
                n3 = ++n4;
            } else if (c == '{') {
                if (n2 == 0) {
                    n3 = ++n4;
                }
                ++n2;
            } else if (c == '}' && --n2 == 0) {
                hashMap.put(string6, string5.substring(n3, n4));
            }
            ++n4;
        }
        String string7 = (String)hashMap.get(string4);
        this.getMidContext().getMidParser().eval(0, string7);
    }

    public void DBDistinctRow(String string) throws Throwable {
        List list;
        RichDocument richDocument = this.getDocument();
        IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)richDocument.getMetaForm());
        if (StringUtil.isBlankOrNull((String)string)) {
            string = iDLookup.getSingleDtlTableKey();
        }
        if (StringUtil.isBlankOrNull((String)string)) {
            MessageFacade.throwException((String)"SHORTNAMEFUNCTION021", (Object[])new Object[0]);
        }
        if ((list = iDLookup.getPrimaryKeyColumnKeys(string)).size() > 0) {
            Object object;
            Object object2;
            int n;
            List list2 = iDLookup.getVisibleCellKeysByPrimaryKey(richDocument, string);
            this.DistinctRow(String.join((CharSequence)":", list2));
            MetaTable metaTable = richDocument.getMetaForm().getMetaTable(string);
            DataTable dataTable = richDocument.getDataTable(string);
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            int n2 = 0;
            while (n2 < dataTable.size()) {
                String string2 = iDLookup.getPrimaryKeyValueStr(string, dataTable, n2);
                hashMap.put(string2, n2);
                ++n2;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            dataTable.setShowDeleted(true);
            int n3 = 0;
            while (n3 < dataTable.size()) {
                n = dataTable.getState(n3);
                if (n == 1) {
                    arrayList.add(dataTable.getBookmark(n3));
                    object2 = iDLookup.getPrimaryKeyValueArray(dataTable, n3);
                    object = dataTable.fastFilter(list.toArray(new String[0]), (Object[])object2);
                    if (object != null) {
                        int[] nArray = object;
                        int n4 = ((int[])object).length;
                        int n5 = 0;
                        while (n5 < n4) {
                            int n6;
                            int n7 = nArray[n5];
                            if (n7 != n3 && (n6 = dataTable.getState(n7)) == 3) {
                                arrayList.remove((Object)dataTable.getBookmark(n3));
                            }
                            ++n5;
                        }
                    }
                }
                ++n3;
            }
            dataTable.setShowDeleted(false);
            if (arrayList.isEmpty()) {
                return;
            }
            SqlString sqlString = new SqlString();
            sqlString.append(new Object[]{"select "});
            n = 0;
            while (n < list.size()) {
                if (n > 0) {
                    sqlString.append(new Object[]{","});
                }
                sqlString.append(new Object[]{list.get(n)});
                ++n;
            }
            sqlString.append(new Object[]{" from "}).append(new Object[]{metaTable.getBindingDBTableName()});
            sqlString.append(new Object[]{" where "});
            n = 0;
            while (n < arrayList.size()) {
                if (n > 0) {
                    sqlString.append(new Object[]{" or "});
                }
                int n8 = dataTable.getRowIndexByBookmark(((Integer)arrayList.get(n)).intValue());
                sqlString.append(new Object[]{"("});
                object = new SqlString();
                for (String string3 : list) {
                    if (!object.isEmpty()) {
                        object.append(new Object[]{" and "});
                    }
                    object.append(new Object[]{string3}).append(new Object[]{"="}).appendPara(dataTable.getObject(n8, string3));
                }
                sqlString.append(new Object[]{object});
                sqlString.append(new Object[]{")"});
                ++n;
            }
            DataTable dataTable2 = this._context.getResultSet(sqlString);
            if (!dataTable2.isEmpty()) {
                object2 = new StringBuilder();
                int n9 = 0;
                while (n9 < dataTable2.size()) {
                    String string4 = iDLookup.getPrimaryKeyValueStr(string, dataTable2, n9);
                    Integer n10 = (Integer)hashMap.get(string4);
                    if (((StringBuilder)object2).length() > 0) {
                        ((StringBuilder)object2).append(",");
                    }
                    ((StringBuilder)object2).append(n10 + 1);
                    ++n9;
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (String string5 : list2) {
                    String string6 = ERPStringUtil.formatMessage((Env)this.getEnv(), (String)iDLookup.getFieldCaption(string5), (Object[])new Object[0]);
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("|");
                    }
                    stringBuilder.append(string6);
                }
                MessageFacade.throwException((String)"SHORTNAMEFUNCTION020", (Object[])new Object[]{object2, stringBuilder});
            }
        }
    }

    public void DBDistinctRow() throws Throwable {
        this.DBDistinctRow(null);
    }

    public String GetItemKeyByDataElementKey(String string) throws Throwable {
        return MetaUtil.getItemKeyByDataElementKey((IMetaFactory)this.getMidContext().getVE().getMetaFactory(), (String)string);
    }

    public String GetRelationFormKey(String string, String string2) throws Throwable {
        IMetaFactory iMetaFactory = this.getMidContext().getMetaFactory();
        MetaForm metaForm = iMetaFactory.getMetaForm(string);
        String string3 = metaForm.getFormRelationCollection().getFormKey(string2);
        return string3;
    }
}

