/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.utils.codecs;

import com.bokesoft.distro.tech.yigosupport.extension.utils.codecs.GO9;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class AESUtils {
    private static final String ALGORITHM = "AES";
    private static final int KEY_SIZE = 128;

    public static String getRandomSecretKey() throws Exception {
        return AESUtils.getRandomSecretKey(null);
    }

    public static String getRandomSecretKey(String seed) throws GeneralSecurityException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(ALGORITHM);
        SecureRandom secureRandom = seed != null && !"".equals(seed) ? new SecureRandom(seed.getBytes()) : new SecureRandom();
        keyGenerator.init(128, secureRandom);
        SecretKey secretKey = keyGenerator.generateKey();
        return Base64.encodeBase64String((byte[])secretKey.getEncoded());
    }

    public static String getSecretKey(String seed) throws UnsupportedEncodingException {
        seed = seed.length() + ":" + seed;
        String encrypted = GO9.encryptPWD(seed);
        encrypted = StringUtils.reverse((String)encrypted);
        byte[] bytes = encrypted.getBytes("ISO8859-1");
        bytes = Arrays.copyOf(bytes, 16);
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static String encrypt(String data, String key) throws GeneralSecurityException, UnsupportedEncodingException {
        Key k = AESUtils.toKey(Base64.decodeBase64((String)key));
        byte[] raw = k.getEncoded();
        SecretKeySpec secretKeySpec = new SecretKeySpec(raw, ALGORITHM);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, secretKeySpec);
        byte[] bytes = cipher.doFinal(data.getBytes("UTF-8"));
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static String decrypt(String data, String key) throws GeneralSecurityException, UnsupportedEncodingException {
        Key k = AESUtils.toKey(Base64.decodeBase64((String)key));
        byte[] raw = k.getEncoded();
        SecretKeySpec secretKeySpec = new SecretKeySpec(raw, ALGORITHM);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, secretKeySpec);
        byte[] bytes = cipher.doFinal(Base64.decodeBase64((String)data));
        return new String(bytes, "UTF-8");
    }

    private static Key toKey(byte[] key) {
        SecretKeySpec secretKey = new SecretKeySpec(key, ALGORITHM);
        return secretKey;
    }
}

