/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.utils.yigo;

import com.bokesoft.distro.tech.commons.basis.MiscUtil;
import com.bokesoft.yes.tools.dic.proxy.IDictCacheProxy;
import com.bokesoft.yigo.mid.auth.Login;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.LoginInfo;
import com.bokesoft.yigo.mid.session.ISessionInfo;
import com.bokesoft.yigo.mid.session.ISessionInfoMap;
import com.bokesoft.yigo.mid.session.ISessionInfoProvider;
import com.bokesoft.yigo.mid.session.SessionInfoProviderHolder;
import com.bokesoft.yigo.mid.util.ContextBuilder;
import com.bokesoft.yigo.struct.dict.Item;
import com.bokesoft.yigo.struct.env.Env;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.json.JSONObject;

public class SessionUtils {
    public static final int LOGIN_MODE_PC = 1;
    public static final int LOGIN_MODE_MOBILE = 2;
    private static final String ENV_TIME_PATTERN = "yyyy/MM/dd HH:mm:ss";

    public static String login(String prefix, String userCode, String password, int mode) {
        return SessionUtils.processWithContext(null, ctx -> {
            Env env = ctx.getEnv();
            String clientId = prefix + "-" + UUID.randomUUID().toString();
            env.setClientID(clientId);
            String pass = null == password ? "" : password;
            LoginInfo loginInfo = new LoginInfo(userCode, pass, -1L, mode, "", null);
            Login login = new Login(loginInfo);
            try {
                login.doLogin(ctx);
            }
            catch (Throwable ex) {
                throw MiscUtil.toRuntimeException((Throwable)ex);
            }
            return clientId;
        });
    }

    public static String loginBackend(String userCode) {
        return SessionUtils.loginBackend(userCode, 1);
    }

    public static String loginBackend(String userCode, int loginMode) {
        DefaultContext ctx = null;
        try {
            ctx = ContextBuilder.create();
            String clientId = SessionUtils.loginBackend(ctx, userCode, loginMode, null);
            ctx.commit();
            String string = clientId;
            return string;
        }
        catch (Throwable ex) {
            try {
                ctx.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw MiscUtil.toRuntimeException((Throwable)ex);
        }
        finally {
            try {
                ctx.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static String loginBackend(DefaultContext ctx, String userCode, int loginMode, Map<String, Object> params) {
        return SessionUtils.loginBackend(ctx, userCode, null, loginMode, params);
    }

    public static String loginBackend(DefaultContext ctx, String userCode, String clientID, int loginMode, Map<String, Object> params) {
        Env env = ctx.getEnv();
        if (StringUtils.isEmpty((CharSequence)clientID)) {
            clientID = UUID.randomUUID().toString();
        }
        env.setClientID(clientID);
        LoginInfo loginInfo = new LoginInfo(userCode, "", -1L, loginMode, "", params);
        SSOLogin ssoLogin = new SSOLogin(loginInfo);
        try {
            JSONObject loginResult = ssoLogin.doLogin(ctx);
            long userID = loginResult.getLong("UserID");
            SessionUtils.wrapEnvSetUserID(env, userID);
            String userName = loginResult.getString("Name");
            env.setUserName(userName);
            long loginTime = loginResult.getLong("Time");
            env.setTime(DateFormatUtils.format((Date)new Date(loginTime), (String)ENV_TIME_PATTERN));
            env.setMode(loginMode);
            return clientID;
        }
        catch (Throwable e) {
            throw MiscUtil.toRuntimeException((Throwable)e);
        }
    }

    private static void wrapEnvSetUserID(Env env, long userID) {
        if (env.getUserID() instanceof Long) {
            env.setUserID(Long.valueOf(userID));
        } else {
            env.setUserID(Long.valueOf(userID));
        }
    }

    public static boolean attachSession(DefaultContext ctx, String clientId) {
        return SessionUtils.attachSession(ctx, clientId, 1);
    }

    public static boolean attachSession(DefaultContext ctx, String clientId, int loginMode) {
        Env env = ctx.getEnv();
        ISessionInfo si = SessionUtils.getLoginSession(clientId);
        if (null != si) {
            env.setClientID(si.getClientID());
            env.setClientIP(si.getIP());
            env.setClusterid(si.getClusterID());
            env.setGuestUserID(si.getGuestUserID());
            env.setMode(si.getMode());
            env.setSessionParas(si.getSessionParas());
            env.setTicketID(si.getTicketID());
            SessionUtils.wrapEnvSetUserID(env, si.getOperatorID());
            env.setRoleIDList((List)si.getRoleIDList());
            env.setMode(loginMode);
            env.setSessionParas(si.getSessionParas());
            return true;
        }
        return false;
    }

    public static boolean attachBackgroundSession(DefaultContext ctx, String userCode) {
        return SessionUtils.attachBackgroundSession(ctx, userCode, 1);
    }

    public static boolean attachBackgroundSession(DefaultContext ctx, String userCode, int loginMode) {
        Env env = ctx.getEnv();
        IDictCacheProxy cache = ctx.getDictCache();
        Item item = null;
        try {
            item = cache.locate("Operator", "Code", (Object)userCode, null, null, 7, null, null, 0);
        }
        catch (Throwable e) {
            throw MiscUtil.toRuntimeException((Throwable)e);
        }
        if (null != item) {
            Long userID = item.getID();
            env.setClientID("BG-" + UUID.randomUUID());
            SessionUtils.wrapEnvSetUserID(env, userID);
            env.setUserCode(userCode);
            env.setMode(1);
            return true;
        }
        return false;
    }

    public static ISessionInfo getLoginSession(String clientID) {
        if (StringUtils.isBlank((CharSequence)clientID)) {
            return null;
        }
        ISessionInfoProvider p = SessionInfoProviderHolder.getProvider((int)1);
        ISessionInfoMap sim = p.getSessionInfoMap();
        ISessionInfo session = sim.get(clientID);
        if (null == session) {
            p = SessionInfoProviderHolder.getProvider((int)2);
            session = p.getSessionInfoMap().get(clientID);
        }
        return session;
    }

    public static <T> T processWithContext(String clientId, YigoRunnable<T> runner) {
        T t;
        DefaultContext context = null;
        try {
            context = ContextBuilder.create();
            SessionUtils.attachSession(context, clientId);
            T result = runner.run(context);
            context.commit();
            t = result;
        }
        catch (Throwable ex) {
            if (null != context) {
                try {
                    context.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw MiscUtil.toRuntimeException((Throwable)ex);
        }
        finally {
            if (null != context) {
                try {
                    context.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return t;
    }

    public static <T> T processWithBackgroundContext(String userCode, YigoRunnable<T> runner) {
        T t;
        DefaultContext context = null;
        try {
            context = ContextBuilder.create();
            SessionUtils.attachBackgroundSession(context, userCode);
            T result = runner.run(context);
            context.commit();
            t = result;
        }
        catch (Throwable ex) {
            if (null != context) {
                try {
                    context.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw MiscUtil.toRuntimeException((Throwable)ex);
        }
        finally {
            if (null != context) {
                try {
                    context.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return t;
    }

    public static interface YigoRunnable<T> {
        public T run(DefaultContext var1) throws Throwable;
    }

    public static class SSOLogin
    extends Login {
        public SSOLogin(LoginInfo loginInfo) {
            super(loginInfo);
        }

        protected void passwordCheck(DefaultContext ctx) {
        }
    }
}

