/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.utils.yigo;

import com.bokesoft.distro.tech.commons.basis.dependency.DependencySortCore;
import com.bokesoft.distro.tech.yigosupport.extension.ServiceLoaderMidFunctionProvider;
import com.bokesoft.distro.tech.yigosupport.extension.base.IAttachmentProviderWrapper;
import com.bokesoft.distro.tech.yigosupport.extension.base.IExtServiceWrapper;
import com.bokesoft.distro.tech.yigosupport.extension.intf.IExtServiceFilter;
import com.bokesoft.distro.tech.yigosupport.extension.intf.IExtServiceFilterProvider;
import com.bokesoft.distro.tech.yigosupport.extension.intf.IExtServiceWrapperService;
import com.bokesoft.yes.mid.service.filter.IFilterMatcher;
import com.bokesoft.yes.mid.service.filter.ServiceFilterFactory;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.enhance.MetaEnhance;
import com.bokesoft.yigo.meta.enhance.MetaExtService;
import com.bokesoft.yigo.meta.enhance.MetaService;
import com.bokesoft.yigo.meta.factory.DefaultMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.setting.MetaAttachmentProvider;
import com.bokesoft.yigo.meta.setting.MetaAttachmentService;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.service.IServiceFilter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLoaderRegisteringUtil {
    private static final Logger log = LoggerFactory.getLogger(ServiceLoaderRegisteringUtil.class);

    public static void invoke(DefaultContext ctx) throws Throwable {
        ServiceLoaderRegisteringUtil.registerExtMidFunction();
        IMetaFactory mf = ctx.getVE().getMetaFactory();
        ServiceLoaderRegisteringUtil.registerMetaExtService(mf);
        ServiceLoaderRegisteringUtil.registerMetaExtAttachmentProvider(mf);
        ServiceLoaderRegisteringUtil.registerExtServiceFilter();
    }

    private static void registerMetaExtAttachmentProvider(IMetaFactory mf) {
        MetaAttachmentService attachmentService = mf.getSetting().getAttachmentService();
        if (null == attachmentService) {
            attachmentService = new MetaAttachmentService();
            mf.getSetting().setAttachmentService(attachmentService);
        }
        ServiceLoader<IAttachmentProviderWrapper> attachmentProviders = ServiceLoader.load(IAttachmentProviderWrapper.class);
        for (IAttachmentProviderWrapper attachmentProvider : attachmentProviders) {
            MetaAttachmentProvider metaAttachmentProvider = new MetaAttachmentProvider();
            metaAttachmentProvider.setDriver(attachmentProvider.getClass().getName());
            metaAttachmentProvider.setKey(attachmentProvider.getShortName());
            attachmentService.add((KeyPairMetaObject)metaAttachmentProvider);
            if (!attachmentProvider.isDefault()) continue;
            attachmentService.setDefaultProvider(attachmentProvider.getShortName());
        }
    }

    private static void registerExtMidFunction() throws Throwable {
        ServiceLoaderMidFunctionProvider serviceLoaderMidFunctionProvider = new ServiceLoaderMidFunctionProvider();
        log.info("\u52a8\u6001\u6ce8\u518c\u4e2d\u95f4\u5c42\u516c\u5f0f: {} ...", (Object)serviceLoaderMidFunctionProvider);
        try {
            Class<?> aClass = Class.forName("com.bokesoft.yigo.mid.parser.util.MidFunctionUtil");
            MethodUtils.invokeMethod(aClass.newInstance(), (String)"regFunctionProvider", (Object[])new Object[]{serviceLoaderMidFunctionProvider});
        }
        catch (ClassNotFoundException e) {
            Class<?> aClass = Class.forName("com.bokesoft.yes.mid.parser.MidFunctionImplMap");
            Object inst = MethodUtils.invokeStaticMethod(aClass, (String)"getMidInstance", (Object[])new Object[0]);
            MethodUtils.invokeMethod((Object)inst, (String)"regFunctionProvider", (Object[])new Object[]{serviceLoaderMidFunctionProvider});
        }
    }

    private static void registerMetaExtService(IMetaFactory mf) throws Throwable {
        MetaEnhance enhance = mf.getEnhance(null);
        if (null == enhance) {
            enhance = new MetaEnhance();
            Field solutionEnhanceField = DefaultMetaFactory.class.getDeclaredField("solutionEnhance");
            solutionEnhanceField.setAccessible(true);
            solutionEnhanceField.set(mf, enhance);
        }
        MetaExtService mesCollection = enhance.getMetaExtService();
        ServiceLoader<IExtServiceWrapperService> services = ServiceLoader.load(IExtServiceWrapperService.class);
        for (IExtServiceWrapperService s : services) {
            log.info("\u52a8\u6001\u6ce8\u518c\u4e2d\u95f4\u5c42\u670d\u52a1: {} ...", (Object)s.getClass().getName());
            String info = "Loading IExtServiceWrapperService '" + s.getClass().getName() + "'";
            try {
                log.info(info + " (" + s.getClass().getProtectionDomain().getCodeSource().getLocation().getPath() + ") ...");
            }
            catch (Exception ex) {
                log.info(info + " ...");
            }
            String prefix = s.getServicePrefix();
            Class<? extends IExtServiceWrapper>[] wrappers = s.getWrappers();
            ArrayList<String> logs = new ArrayList<String>();
            for (Class<? extends IExtServiceWrapper> w : wrappers) {
                try {
                    IExtServiceWrapper esw = w.newInstance();
                    String serviceName = prefix + "_" + esw.getName();
                    String serviceImpl = esw.getImpl();
                    String serviceDescr = esw.getDescription();
                    String log = serviceName + ": " + serviceImpl;
                    if (null != serviceDescr && !serviceDescr.equalsIgnoreCase(serviceImpl)) {
                        log = log + "; " + serviceDescr;
                    }
                    logs.add(log);
                    MetaService ms = new MetaService();
                    ms.setName(serviceName);
                    ms.setImpl(serviceImpl);
                    ms.setDescription(serviceDescr);
                    mesCollection.add((KeyPairMetaObject)ms);
                }
                catch (Throwable ex) {
                    String log = w.getName() + " \u52a0\u8f7d\u9519\u8bef: " + ex.getMessage();
                    logs.add(log);
                }
            }
            log.info("\u52a8\u6001\u6ce8\u518c\u4e2d\u95f4\u5c42\u670d\u52a1: {} \u5b8c\u6210:\n\t{}", (Object)s.getClass().getName(), (Object)StringUtils.join(logs, (String)"\n\t"));
        }
    }

    private static void registerExtServiceFilter() {
        ServiceLoaderRegisteringUtil.checkIExtServiceFilterExist();
        ArrayList<IExtServiceFilterProvider> providers = new ArrayList<IExtServiceFilterProvider>();
        ServiceLoader<IExtServiceFilterProvider> svcFilterProviderLoader = ServiceLoader.load(IExtServiceFilterProvider.class);
        for (IExtServiceFilterProvider provider : svcFilterProviderLoader) {
            log.info("Loading IExtServiceFilterProvider {} ...", (Object)provider.getClass().getName());
            providers.add(provider);
        }
        final List finalProviders = DependencySortCore.sort(providers);
        ServiceFilterFactory.getInstance().setMatcher(new IFilterMatcher(){

            public List<IServiceFilter> find(String serviceId, Map<String, Object> args) {
                ArrayList<IServiceFilter> filters = new ArrayList<IServiceFilter>();
                for (IExtServiceFilterProvider provider : finalProviders) {
                    filters.add(provider.getFilter());
                }
                return filters;
            }
        });
    }

    private static void checkIExtServiceFilterExist() {
        ArrayList<IExtServiceFilter> result = new ArrayList<IExtServiceFilter>();
        ServiceLoader<IExtServiceFilter> extServiceFilterLoader = ServiceLoader.load(IExtServiceFilter.class);
        for (IExtServiceFilter isf : extServiceFilterLoader) {
            result.add(isf);
        }
        if (result.size() > 0) {
            throw new RuntimeException(IExtServiceFilter.class.getName() + " \u63a5\u53e3\u5df2\u4e0d\u518d\u652f\u6301, \u6d89\u53ca\u5230\u7684\u7c7b\u6709:" + ((Object)result).toString() + ",\u8bf7\u4f7f\u7528 " + IExtServiceFilterProvider.class.getName() + " \u66ff\u4ee3");
        }
    }
}

