/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.utils.yigo;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncExecuteUtil {
    private static final Logger logger = LoggerFactory.getLogger(AsyncExecuteUtil.class);
    private static final Map<String, ThreadPoolExecutor> THREAD_POOL_EXECUTOR_MAP = new HashMap<String, ThreadPoolExecutor>();
    private static final Map<String, Runnable> RUNNABLE_MAP = new HashMap<String, Runnable>();

    private static ThreadPoolExecutor buildThreadPoolExecutor() {
        return new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            }
        });
    }

    public static void submit(String taskName, Runnable task) {
        ThreadPoolExecutor threadPoolExecutor = THREAD_POOL_EXECUTOR_MAP.computeIfAbsent(taskName, key -> AsyncExecuteUtil.buildThreadPoolExecutor());
        RUNNABLE_MAP.computeIfAbsent(taskName, key -> task);
        threadPoolExecutor.submit(task);
    }

    public static void heartCheck() {
        for (String taskName : THREAD_POOL_EXECUTOR_MAP.keySet()) {
            ThreadPoolExecutor threadPoolExecutor = THREAD_POOL_EXECUTOR_MAP.get(taskName);
            if (threadPoolExecutor.isShutdown()) {
                threadPoolExecutor = AsyncExecuteUtil.buildThreadPoolExecutor();
                THREAD_POOL_EXECUTOR_MAP.put(taskName, threadPoolExecutor);
            }
            if (null == RUNNABLE_MAP.get(taskName)) {
                logger.warn("taskName:{}\u4e0d\u5b58\u5728\u76f8\u5e94\u7684Runnable\u5b9e\u73b0,\u8be5\u4efb\u52a1\u5c06\u65e0\u6cd5\u88ab\u6267\u884c", (Object)taskName);
                continue;
            }
            threadPoolExecutor.submit(RUNNABLE_MAP.get(taskName));
        }
    }
}

