/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.exttools.funs;

import com.bokesoft.distro.tech.yigosupport.extension.exttools.sdk.EncryptImpl;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class EncryptExp {
    private static EncryptImpl encryptImpl;

    private static void ensureEncryptImpl() {
        if (null == encryptImpl) {
            throw new IllegalStateException("Unconfigured EncryptImpl for EncryptExp, run EncryptExp.Initiator.config(configer) before call EncryptExp.");
        }
    }

    public static void Encrypt(DefaultContext ctx, String tableName, String fieldName) {
        EncryptExp.ensureEncryptImpl();
        encryptImpl.encryptDocument(ctx.getDocument(), tableName, fieldName, "=*");
    }

    public static void Encrypt(DefaultContext ctx, String tableName, String fieldName, String prefix) {
        EncryptExp.ensureEncryptImpl();
        encryptImpl.encryptDocument(ctx.getDocument(), tableName, fieldName, prefix);
    }

    public static void Decrypt(DefaultContext ctx, String tableName, String fieldName) {
        EncryptExp.ensureEncryptImpl();
        encryptImpl.decryptDocument(ctx.getDocument(), tableName, fieldName);
    }

    public static String EncryptValue(String value, String prefix) {
        EncryptExp.ensureEncryptImpl();
        return encryptImpl.encrypt(value, prefix);
    }

    public static String EncryptValue(String value) {
        EncryptExp.ensureEncryptImpl();
        return encryptImpl.encrypt(value, "=*");
    }

    public static String DecryptValue(String value) {
        EncryptExp.ensureEncryptImpl();
        try {
            return encryptImpl.decrypt(value);
        }
        catch (Exception e) {
            return value;
        }
    }

    public static class Initiator {
        public static void config(EncryptImpl.Configer configer) {
            encryptImpl = new EncryptImpl(configer);
        }
    }
}

