/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.coordinate.impl;

import com.bokesoft.base.bokebase.instance.ProcessInstanceUtil;
import com.bokesoft.distro.tech.commons.basis.coordinate.intf.ILeaderStatusDetector;
import com.bokesoft.distro.tech.commons.basis.coordinate.struct.LeaderStatusConfig;
import com.bokesoft.distro.tech.yigosupport.extension.coordinate.intf.RedisCommands;
import com.bokesoft.distro.tech.yigosupport.extension.coordinate.intf.RedisFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisLeaderStatusDetector
implements ILeaderStatusDetector {
    static final Logger log = LoggerFactory.getLogger(RedisLeaderStatusDetector.class);
    private final RedisFactory factory;
    private final ScheduledExecutorService executor;
    final String instanceId = ProcessInstanceUtil.getInstanceId();
    private final Map<String, LeaderStatus> leaderStatusMap = new HashMap<String, LeaderStatus>();

    public RedisLeaderStatusDetector(RedisFactory factory) {
        this(factory, Executors.newSingleThreadScheduledExecutor(r -> {
            Thread th = new Thread(r);
            th.setDaemon(true);
            th.setName(RedisLeaderStatusDetector.class.getName());
            th.setUncaughtExceptionHandler((t, e) -> e.printStackTrace());
            return th;
        }));
    }

    public RedisLeaderStatusDetector(RedisFactory factory, ScheduledExecutorService executor) {
        this.factory = factory;
        this.executor = executor;
    }

    public boolean isLeader(String tag) {
        return this.findStatus(tag).isLeader();
    }

    public void register(String tag, LeaderStatusConfig config) {
        if (this.leaderStatusMap.containsKey(tag)) {
            throw new IllegalArgumentException("\u91cd\u590d\u6ce8\u518c\u7684\u4e1a\u52a1\u6807\u8bc6: " + tag);
        }
        LeaderStatus status = new LeaderStatus(tag, config);
        this.leaderStatusMap.put(tag, status);
        this.executor.submit(status);
    }

    private LeaderStatus findStatus(String tag) {
        LeaderStatus status = this.leaderStatusMap.getOrDefault(tag, null);
        if (status == null) {
            throw new IllegalArgumentException(String.format("\u4e0d\u5b58\u5728\u7684\u4e3b\u8282\u70b9\u72b6\u6001\u6807\u7b7e %s", tag));
        }
        return status;
    }

    private class LeaderStatus
    implements Runnable {
        private int leaderRound;
        private boolean releaseLeader = false;
        private Future future;
        final String key;
        final int heartbeatSecond;
        final long maxHeartbeatCount;
        final int retryCount;
        final int sleepSecondAfterError;

        private LeaderStatus(String key, LeaderStatusConfig config) {
            this.checkParam(config);
            this.key = key;
            this.heartbeatSecond = config.getHeartbeatSecond();
            this.maxHeartbeatCount = config.getMaxHeartbeatCount();
            this.retryCount = config.getRetryCount();
            this.sleepSecondAfterError = config.getSleepSecondAfterError();
        }

        private void checkParam(LeaderStatusConfig config) {
            if (config.getHeartbeatSecond() <= 0) {
                throw new IllegalArgumentException("\u5fc3\u8df3\u79d2\u6570\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0!");
            }
            if (config.getMaxHeartbeatCount() <= 0L) {
                config.setMaxHeartbeatCount(Long.MAX_VALUE);
            }
            if (config.getRetryCount() <= 0) {
                config.setRetryCount(1);
            }
            if (config.getSleepSecondAfterError() <= 0) {
                config.setSleepSecondAfterError(config.getHeartbeatSecond());
            }
        }

        @Override
        public synchronized void run() {
            for (int i = 0; i < this.retryCount; ++i) {
                long second = 0L;
                try {
                    second = this.runForSecond();
                }
                catch (Exception e) {
                    second = -1L;
                    log.warn("\u8282\u70b9\u72b6\u6001\u66f4\u65b0\u5931\u8d25!", (Throwable)e);
                }
                if (second >= 0L) {
                    log.debug("\u51c6\u5907 {} \u79d2\u540e\u66f4\u65b0\u8282\u70b9\u72b6\u6001...", (Object)second);
                    this.future = RedisLeaderStatusDetector.this.executor.schedule(this, second, TimeUnit.SECONDS);
                    return;
                }
                if (i + 1 >= this.retryCount) continue;
                log.warn("[{}\u8282\u70b9] instanceId={} \u66f4\u65b0\u8282\u70b9\u72b6\u6001\u5f02\u5e38,\u51c6\u5907\u7b2c {} \u6b21\u91cd\u8bd5...", new Object[]{this.isLeader() ? "\u4e3b" : "\u4ece", RedisLeaderStatusDetector.this.instanceId, i + 1});
            }
            log.warn("[{}\u8282\u70b9] instanceId={} \u66f4\u65b0\u8282\u70b9\u72b6\u6001\u5f02\u5e38,\u51c6\u5907\u7761\u7720 {} \u79d2\u540e\u91cd\u8bd5...", new Object[]{this.isLeader() ? "\u4e3b" : "\u4ece", RedisLeaderStatusDetector.this.instanceId, this.sleepSecondAfterError});
            this.future = RedisLeaderStatusDetector.this.executor.schedule(this, (long)this.sleepSecondAfterError, TimeUnit.SECONDS);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private long runForSecond() {
            try (RedisCommands redis = RedisLeaderStatusDetector.this.factory.getRedis();){
                if (this.isLeader()) {
                    if (!RedisLeaderStatusDetector.this.instanceId.equals(redis.get(this.key))) {
                        log.debug("[\u4e3b\u8282\u70b9] instanceId={} \u6210\u4e3a [\u4ece\u8282\u70b9]!", (Object)RedisLeaderStatusDetector.this.instanceId);
                        this.leaderRound = 0;
                        this.releaseLeader = false;
                        long l = redis.ttl(this.key);
                        return l;
                    }
                    if (!this.releaseLeader && (long)this.leaderRound <= this.maxHeartbeatCount) {
                        log.debug("[\u4e3b\u8282\u70b9] instanceId={} \u7b2c {} \u6b21\u53d1\u9001\u5fc3\u8df3!", (Object)RedisLeaderStatusDetector.this.instanceId, (Object)this.leaderRound);
                        redis.expire(this.key, this.heartbeatSecond);
                        ++this.leaderRound;
                        long l = this.heartbeatSecond / 2;
                        return l;
                    }
                    log.debug("[\u4e3b\u8282\u70b9] instanceId={} \u51c6\u5907\u91ca\u653e\u4e3b\u8282\u70b9...", (Object)RedisLeaderStatusDetector.this.instanceId);
                    ++this.leaderRound;
                    long l = redis.ttl(this.key);
                    return l;
                }
                redis.setNxEx(this.key, RedisLeaderStatusDetector.this.instanceId, this.heartbeatSecond);
                if (RedisLeaderStatusDetector.this.instanceId.equals(redis.get(this.key))) {
                    log.debug("[\u4ece\u8282\u70b9] instanceId={} \u6210\u4e3a [\u4e3b\u8282\u70b9]!", (Object)RedisLeaderStatusDetector.this.instanceId);
                    ++this.leaderRound;
                    long l = this.heartbeatSecond / 2;
                    return l;
                }
                log.debug("[\u4ece\u8282\u70b9] instanceId={} \u5f00\u59cb\u7b49\u5f85\u4e3b\u8282\u70b9\u5931\u6548...", (Object)RedisLeaderStatusDetector.this.instanceId);
                long l = redis.ttl(this.key);
                return l;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public synchronized boolean isLeader() {
            return this.leaderRound > 0;
        }

        public synchronized void releaseLeader() {
            this.releaseLeader = true;
        }
    }
}

