package com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.struct;

import com.alibaba.fastjson.JSONObject;

import java.util.Date;
import java.util.Map;

public class HeadsInfoVO {
    private static final String ARG_KEY_HEADINFO = "headinfos";
    /**
     * 操作标识
     */
    private String optKey;
    /**
     * 操作类型
     */
    private String optType;
    /**
     * 操作名称
     */
    private String optName;
    /**
     * 操作说明
     */
    private String optDesc;
    /**
     * 操作时间
     */
    private Date optTime;
    /**
     * 菜单入口路径
     */
    private String entryPath;

    /**
     * 表单Key
     */
    private String formKey;
    /**
     * 表单名称
     */
    private String formCaption;

    public String getOptKey() {
        return optKey;
    }

    public void setOptKey(String optKey) {
        this.optKey = optKey;
    }

    public String getOptType() {
        return optType;
    }

    public void setOptType(String optType) {
        this.optType = optType;
    }

    public String getOptName() {
        return optName;
    }

    public void setOptName(String optName) {
        this.optName = optName;
    }

    public String getOptDesc() {
        return optDesc;
    }

    public void setOptDesc(String optDesc) {
        this.optDesc = optDesc;
    }

    public Date getOptTime() {
        return optTime;
    }

    public void setOptTime(Date optTime) {
        this.optTime = optTime;
    }

    public String getEntryPath() {
        return entryPath;
    }

    public void setEntryPath(String entryPath) {
        this.entryPath = entryPath;
    }

    public String getFormKey() {
        return formKey;
    }


    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    public String getFormCaption() {
        return formCaption;
    }

    public void setFormCaption(String formCaption) {
        this.formCaption = formCaption;
    }

    public static HeadsInfoVO build(Map<String, Object> args){
        HeadsInfoVO vo=null;
        if (null != args.get(ARG_KEY_HEADINFO)) {
            vo=new HeadsInfoVO();
            JSONObject headInfoObj = (JSONObject) JSONObject.parse(args.get(ARG_KEY_HEADINFO).toString());
            if (null != headInfoObj.get("Sys_Opt")) {
                vo.setOptKey((String) headInfoObj.get("Sys_Opt"));
            }
            if (null != headInfoObj.get("Sys_Opt_Type")) {
                vo.setOptType((String) headInfoObj.get("Sys_Opt_Type"));
            }
            if (null != headInfoObj.get("Sys_Opt_Caption")) {
                vo.setOptName((String) headInfoObj.get("Sys_Opt_Caption"));
            }
            if (null != headInfoObj.get("Sys_Opt_Desc")) {
                vo.setOptDesc((String) headInfoObj.get("Sys_Opt_Desc"));
            }
            if (null != headInfoObj.get("Sys_Opt_FormKey")) {
                vo.setFormKey((String) headInfoObj.get("Sys_Opt_FormKey"));
            }
            if (null != headInfoObj.get("Sys_Opt_FormCaption")) {
                vo.setFormCaption((String) headInfoObj.get("Sys_Opt_FormCaption"));
            }
            if (null != headInfoObj.get("Sys_Entry_Path")) {
                vo.setEntryPath((String) headInfoObj.get("Sys_Entry_Path"));
            }
            vo.setOptTime(new Date());
        }
        return vo;
    }
}
