package com.bokesoft.distro.tech.yigosupport.extension.utils.yigo;

import com.bokesoft.distro.tech.commons.basis.dependency.DependencySortCore;
import com.bokesoft.distro.tech.yigosupport.extension.ServiceLoaderMidFunctionProvider;
import com.bokesoft.distro.tech.yigosupport.extension.base.IAttachmentProviderWrapper;
import com.bokesoft.distro.tech.yigosupport.extension.base.IExtServiceWrapper;
import com.bokesoft.distro.tech.yigosupport.extension.intf.IExtServiceFilter;
import com.bokesoft.distro.tech.yigosupport.extension.intf.IExtServiceFilterProvider;
import com.bokesoft.distro.tech.yigosupport.extension.intf.IExtServiceWrapperService;
import com.bokesoft.yes.mid.service.filter.IFilterMatcher;
import com.bokesoft.yes.mid.service.filter.ServiceFilterFactory;
import com.bokesoft.yigo.meta.enhance.MetaEnhance;
import com.bokesoft.yigo.meta.enhance.MetaExtService;
import com.bokesoft.yigo.meta.enhance.MetaService;
import com.bokesoft.yigo.meta.factory.DefaultMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.setting.MetaAttachmentProvider;
import com.bokesoft.yigo.meta.setting.MetaAttachmentService;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.service.IServiceFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

@SuppressWarnings("deprecation")
public class ServiceLoaderRegisteringUtil {
    private static final Logger log = LoggerFactory.getLogger(ServiceLoaderRegisteringUtil.class);


    public static void invoke(DefaultContext ctx) throws Throwable {
        registerExtMidFunction();
        IMetaFactory mf = ctx.getVE().getMetaFactory();
        registerMetaExtService(mf);
        registerMetaExtAttachmentProvider(mf);
        registerExtServiceFilter();
    }

    private static void registerMetaExtAttachmentProvider(IMetaFactory mf) {
        MetaAttachmentService attachmentService = mf.getSetting().getAttachmentService();
        if(null == attachmentService) {
            attachmentService = new MetaAttachmentService();
            mf.getSetting().setAttachmentService(attachmentService);
        }
        ServiceLoader<IAttachmentProviderWrapper> attachmentProviders = ServiceLoader.load(IAttachmentProviderWrapper.class);
        for(IAttachmentProviderWrapper attachmentProvider: attachmentProviders) {

            MetaAttachmentProvider metaAttachmentProvider = new MetaAttachmentProvider();
            metaAttachmentProvider.setDriver(attachmentProvider.getClass().getName());
            metaAttachmentProvider.setKey(attachmentProvider.getShortName());
            attachmentService.add(metaAttachmentProvider);
            if(attachmentProvider.isDefault()) {
                attachmentService.setDefaultProvider(attachmentProvider.getShortName());
            }
        }
    }

    private static void registerExtMidFunction() throws Throwable {
        ServiceLoaderMidFunctionProvider serviceLoaderMidFunctionProvider = new ServiceLoaderMidFunctionProvider();
        log.info("动态注册中间层公式: {} ...", serviceLoaderMidFunctionProvider);
		/*因 Yigo 版本不同造成，部分 API 的 package 变化导致同一份代码无法兼容多个 Yigo 版本的情况，可以通过反射等技巧解决的.新版本对yigo2
			的MidFunctionImplMap中的	regFunctionProvider()方法进行封装，生成了一个MidFunctionUtil的工具类，导致系统无法兼容。
			采用反射可以解决yigo版本适配的问题
			*/
        try {
            // new com.bokesoft.yigo.mid.parser.util.MidFunctionUtil().regFunctionProvider(IFunctionProvider)
            Class<?> aClass = Class.forName("com.bokesoft.yigo.mid.parser.util.MidFunctionUtil");
            MethodUtils.invokeMethod(aClass.newInstance(), "regFunctionProvider", serviceLoaderMidFunctionProvider);
        }catch (ClassNotFoundException e) {
            Class<?> aClass = Class.forName("com.bokesoft.yes.mid.parser.MidFunctionImplMap");
            Object inst = MethodUtils.invokeStaticMethod(aClass, "getMidInstance");
            MethodUtils.invokeMethod(inst, "regFunctionProvider", serviceLoaderMidFunctionProvider);
        }
    }


    private static void registerMetaExtService(IMetaFactory mf) throws Throwable {
        MetaEnhance enhance = mf.getEnhance(null);
        if( null == enhance) {
            enhance = new MetaEnhance();
            Field solutionEnhanceField = DefaultMetaFactory.class.getDeclaredField("solutionEnhance");
            solutionEnhanceField.setAccessible(true);
            solutionEnhanceField.set(mf,enhance);
        }
        MetaExtService mesCollection = enhance.getMetaExtService();

        ServiceLoader<IExtServiceWrapperService> services = ServiceLoader.load(IExtServiceWrapperService.class);
        for(IExtServiceWrapperService s: services) {
            log.info("动态注册中间层服务: {} ...", s.getClass().getName());

            String info = "Loading IExtServiceWrapperService '"+s.getClass().getName()+"'";
            try {
                log.info(info + " ("+s.getClass().getProtectionDomain().getCodeSource()
                        .getLocation().getPath()+") ...");
            }catch(Exception ex) {
                log.info(info + " ...");
            }

            String prefix = s.getServicePrefix();
            Class<? extends IExtServiceWrapper>[] wrappers = s.getWrappers();
            List<String> logs = new ArrayList<>();
            for(Class<? extends IExtServiceWrapper> w: wrappers) {
                try {
                    IExtServiceWrapper esw = w.newInstance();

                    String serviceName = prefix+ "_" + esw.getName();
                    String serviceImpl = esw.getImpl();
                    String serviceDescr = esw.getDescription();

                    String log = serviceName+": "+serviceImpl;
                    if (null!=serviceDescr && !serviceDescr.equalsIgnoreCase(serviceImpl)) {
                        log += "; "+serviceDescr;
                    }
                    logs.add(log);

                    MetaService ms = new MetaService();
                    ms.setName(serviceName);
                    ms.setImpl(serviceImpl);
                    ms.setDescription(serviceDescr);

                    mesCollection.add(ms);
                }catch(Throwable ex) {
                    String log = w.getName()+" 加载错误: "+ex.getMessage();
                    logs.add(log);
                }
            }
            log.info("动态注册中间层服务: {} 完成:\n\t{}", s.getClass().getName(), StringUtils.join(logs, "\n\t"));
        }
    }

    /**
     * 注册扩展服务filter
     */
    private static void registerExtServiceFilter() {
        //检验当前服务是否存在IExtServiceFilter
        checkIExtServiceFilterExist();

        List<IExtServiceFilterProvider> providers = new ArrayList<>();
        ServiceLoader<IExtServiceFilterProvider> svcFilterProviderLoader = ServiceLoader.load(IExtServiceFilterProvider.class);
        for (IExtServiceFilterProvider provider : svcFilterProviderLoader) {
            log.info("Loading IExtServiceFilterProvider {} ...", provider.getClass().getName());
            providers.add(provider);
        }
        final List<IExtServiceFilterProvider> finalProviders = DependencySortCore.sort(providers);
        ServiceFilterFactory.getInstance().setMatcher(new IFilterMatcher() {
            @Override
            public List<IServiceFilter> find(String serviceId, Map<String, Object> args) {
                List<IServiceFilter> filters = new ArrayList<>();
                for (IExtServiceFilterProvider provider : finalProviders) {
                    filters.add(provider.getFilter());
                }
                return filters;
            }
        });
    }

    /**
     * 校验当前服务是否存在IExtServiceFilter，如果存在，则抛异常
     */
    private static void checkIExtServiceFilterExist() {
        List<IExtServiceFilter> result = new ArrayList<>();
        ServiceLoader<IExtServiceFilter> extServiceFilterLoader = ServiceLoader.load(IExtServiceFilter.class);
        for (IExtServiceFilter isf : extServiceFilterLoader) {
            result.add(isf);
        }
        if (result.size() > 0) {
            throw new RuntimeException(IExtServiceFilter.class.getName() + " 接口已不再支持, 涉及到的类有:"
                      + result.toString() + ",请使用 "+IExtServiceFilterProvider.class.getName()+" 替代");
        }
    }
}
