package com.bokesoft.distro.tech.yigosupport.extension.utils.yigo;

import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.condition.ConditionItem;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.dict.ItemData;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 工具类
 * 一个用于根据 yigo context 的 condParam 的key获取 获取string类型的value
 * condParamMap 中缓存了当前请求的key和对应的string值
 * 注意：该工具类目前仅处理了 请求参数的值为 List<ItemData> 、 ItemData 以及普通 Object 类型
 */
public class ContextCondParamHelper {

    private final Map<String, String> condParamMap = new HashMap<>(16);

    public ContextCondParamHelper(DefaultContext context) {
        ConditionParas conditionParas = context.getConditionParas();
        for (int i = 0; i < conditionParas.size(); i++) {
            ConditionItem conditionItem = conditionParas.get(i);
            String key = conditionItem.getKey();
            Object conditionItemValue = conditionItem.getValue();

            String value;
            if (conditionItemValue instanceof List){
                @SuppressWarnings("unchecked")
                List<Object> itemList = (List<Object>)conditionItemValue;
                List<Object> oids = new ArrayList<>();
                for (Object itemData : itemList) {
                    Object itemValue = itemData instanceof ItemData ? ((ItemData) itemData).getOID() : itemData;
                    oids.add(itemValue);
                }
                value = StringUtils.join(oids, ",");
            }else if (conditionItemValue instanceof ItemData){
                value = ((ItemData) conditionItemValue).getOID().toString();
            }else {
                value = conditionItemValue.toString();
            }

            condParamMap.put(key, value);
        }
    }

    public String getParamValueByKey(String key){
        return condParamMap.get(key);
    }
}