package com.bokesoft.distro.tech.yigosupport.extension.redisdescr.impl.yes;

import com.bokesoft.base.bokebase.rediscache.IDataDescriber;
import com.bokesoft.base.bokebase.rediscache.struct.DescrFormat;
import com.bokesoft.base.bokebase.rediscache.struct.ValueDescription;
import com.bokesoft.yigo.common.def.LoginMode;
import com.bokesoft.yigo.mid.session.ISessionInfo;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Map;

public class MobileSessionCacheDataDescriptor implements IDataDescriber<ISessionInfo> {
    public static final String CACHEKEY = "MobileCache";
    @Override
    public ValueDescription describeData(String key, ISessionInfo sessionInfo) {
        ValueDescription valueDescription = new ValueDescription();
        String desc = getSessionDescription(sessionInfo);
        valueDescription.setDescription(desc);
        valueDescription.setFormat(DescrFormat.PLAIN);
        return valueDescription;
    }

    @Override
    public String describeKey(String s) {
        return "Yigo手持会话缓存";
    }


    @Override
    public String describeHashKey(String k,String hashKey, ISessionInfo sessionInfo) {
        String code = sessionInfo.getUserCode();
        String name = sessionInfo.getUserName();
        return "操作员:" + code +"/"+ name+"的缓存HashKey:"+hashKey;
    }

    private String getSessionDescription(ISessionInfo sessionInfo) {
        String clientID = sessionInfo.getClientID();
        String desc = "会话/clientID:'" + clientID + "'\n";
        int mode = sessionInfo.getMode();
        desc = desc + ", 登录模式:'" + LoginMode.toString(mode) + "'\n";
        String ip;
        if (mode == 2) {
            ip = sessionInfo.getAppID();
            desc = desc + ", 设备ID/appID:'" + ip + "'\n";
        }

        ip = sessionInfo.getIP();
        desc = desc + ", 请求ip地址:'" + ip + "'\n";
        if (mode != 0) {
            long operatorID = sessionInfo.getOperatorID();
            desc = desc + ", 操作员ID/operatorID:" + operatorID+"\n";
            String code = sessionInfo.getUserCode();
            desc = desc + ", 操作员code:'" + code + "'\n";
            String name = sessionInfo.getUserName();
            desc = desc + ", 操作员名/name:'" + name + "'\n";
            Date loginDate = sessionInfo.getLoginTime();
            LocalDateTime loginTime = LocalDateTime.ofInstant(loginDate.toInstant(), ZoneId.systemDefault());
            desc = desc + ", 登录时间/loginTime:" + loginTime+"\n";
            Date lastDate = sessionInfo.getLastActiveTime();
            LocalDateTime lastActiveTime = LocalDateTime.ofInstant(lastDate.toInstant(), ZoneId.systemDefault());
            desc = desc + ", 最后活跃时间/lastActiveTime:" + lastActiveTime+"\n";
            long clusterID = sessionInfo.getClusterID();
            desc = desc + ", 集团ID:clusterID:" + clusterID+"\n";
            boolean isAuthenticated = sessionInfo.isAuthenticated();
            desc = desc + ", 是否已验证/isAuthenticated:" + isAuthenticated+"\n";
            int loginFailedCount = sessionInfo.getLoginFailedCount();
            desc = desc + ", 登录失败次数:loginFailedCount:" + loginFailedCount+"\n";
            Map<String, Object> sessionParas = sessionInfo.getSessionParas();
            if (sessionParas != null) {
                desc = desc + ", 其他会话参数/sessionParas:" + sessionParas.toString()+"\n";
            }
        } else {
            String validateCode = sessionInfo.getValidateCode();
            desc = desc + ", 对应图形验证码/validateCode:'" + validateCode + "'\n";
            Date createDate = sessionInfo.getCreateTime();
            LocalDateTime createTime = LocalDateTime.ofInstant(createDate.toInstant(), ZoneId.systemDefault());
            desc = desc + ", 创建时间/createTime:" + createTime+"\n";
        }
       return desc;
    }
}