package com.bokesoft.distro.tech.yigosupport.extension.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

import com.bokesoft.yigo.mid.base.DefaultContext;

public class WrapperUtils {
	/**
	 * 根据参数查找方法名(如果找到不止一个, 报错)
	 * @param ctx Yigo 上下文
	 * @param clazz 对应的 Java 类
	 * @param args Yigo 调用参数*
	 * @param targetMethodName 需要寻找的方法名, 为空代表所有方法
	 * @return 匹配的方法名
	 */
	public static String findStaticMethod(DefaultContext ctx, Class<?> clazz, Object[] args, String targetMethodName)
			throws ReflectiveOperationException {
		//预处理并解决参数是 null 的问题
		args = ArrayUtils.nullToEmpty(args);
        Class<?>[] parameterTypes = ClassUtils.toClass(args);
        
        //准备: 第一个参数是 DefaultContext 的情况
        List<Object> tmp = new ArrayList<>();
        tmp.add(ctx);
        tmp.addAll(Arrays.asList(args));
        Object[] argsWithCtx = tmp.toArray();
		//同样需要预处理并解决参数是 null 的问题
        argsWithCtx = ArrayUtils.nullToEmpty(argsWithCtx);
        Class<?>[] parameterTypesWithCtx = ClassUtils.toClass(argsWithCtx);

        //首先查找第一个参数包含 DefaultContext 的方法
        List<Method> matchedMethods = findStaticMethods(clazz, parameterTypesWithCtx, targetMethodName);
        if (matchedMethods.size()<1) {
        	//如果找不到, 查找不包含 DefaultContext 的方法
    		matchedMethods = findStaticMethods(clazz, parameterTypes, targetMethodName);
        }
		
        String mDisp = (null==targetMethodName?"*":targetMethodName);
		if (matchedMethods.size()<1) {
			throw new NoSuchMethodException(
					"找不到方法: Class='"+clazz+"', method='"+mDisp+"', parameterTypes='"+toStr(parameterTypes)+"'");
		}
		if (matchedMethods.size()>1) {
			throw new NoSuchMethodException(
					"方法无法确定: Class='"+clazz+"', method='"+mDisp+"', parameterTypes='"+toStr(parameterTypes)+"' 具有多个方法 - "+toStr(matchedMethods));
		}
		
		return matchedMethods.get(0).getName();
	}

	private static String toStr(Class<?>[] parameterTypes) {
		return "[" + StringUtils.join(parameterTypes, ", ") + "]";
	}
	private static String toStr(List<Method> methods) {
		return "[" + StringUtils.join(methods, ", ") + "]";
	}
	
	/**
	 * 按照参数查找对应的方法.<br/>
	 * FIXME 查找过程不是很严谨, 存在参数匹配不准确的情况
	 * @param clazz 对应的 Java 类
	 * @param parameterTypes 方法参数类型
	 * @param targetMethodName 需要寻找的方法名, 为空代表所有方法
	 * @return 所有匹配方法名的集合
	 */
	protected static List<Method> findStaticMethods(Class<?> clazz, Class<?>[] parameterTypes, String targetMethodName) {
		List<Method> matchedMethods = new ArrayList<Method>();
		
        //获得所有方法
		Method[] methods = clazz.getMethods();
		
		//在所有方法中寻找符合输入参数的静态方法
		//保证一个方法只被查询一次
		Set<String> methodNames = new HashSet<>();
		for(Method m: methods) {
			if (null!=targetMethodName) {
				if (! targetMethodName.equals(m.getName())) {
					continue;
				}
			}
			
			int modifiers = m.getModifiers();
			if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers)) {
				String methodName = m.getName();
				
				if (! methodNames.contains(methodName)) {
					//避免一个方法反复被查多次
					methodNames.add(methodName);
					Method tmp = MethodUtils.getMatchingAccessibleMethod(clazz, methodName, parameterTypes);
					if (null!=tmp) {
						matchedMethods.add(tmp);
					}
				}
			}
		}
		return matchedMethods;
	}

	/**
	 * 用于 Yigo 中间层服务或者公式调用中, 将调用转换为 Java 类的静态方法;
	 * 注意：如果 Java 静态方法的第一个参数是 {@link DefaultContext} 类型, 将会自动将本方法的 ctx 参数作为方法调用的第一个参数.
	 * @param ctx Yigo 上下文
	 * @param clazz 对应的 Java 类
	 * @param method 对应的 Java 静态方法名
	 * @param args Yigo 调用参数
	 * @return 尝试执行目标静态方法
	 * @throws ReflectiveOperationException
	 */
	public static Object tryRunStaticMethod(DefaultContext ctx, Class<?> clazz, String method, Object[] args)
			throws ReflectiveOperationException {
		try{
			//首先测试第一个参数是 ctx 的方法
			Object[] argsWithCtx = new Object[args.length+1];
			argsWithCtx[0] = ctx;
			for (int i = 0; i < args.length; i++) {
				argsWithCtx[i+1] = args[i];
			}
			return MethodUtils.invokeStaticMethod(clazz, method, argsWithCtx);
		}catch(NoSuchMethodException ne){
			return  MethodUtils.invokeStaticMethod(clazz, method, args);
		}
	}

}
