package com.bokesoft.distro.tech.yigosupport.extension.impl;

import static com.bokesoft.distro.tech.yigosupport.extension.impl.BaseStaticWrapperMidFuncRunner.getDottedFormulaName;
import static com.bokesoft.distro.tech.yigosupport.extension.impl.BaseStaticWrapperMidFuncRunner.getUnderlineFormulaName;
import static com.bokesoft.distro.tech.yigosupport.extension.impl.BaseStaticWrapperMidFuncRunner.getNarrowFormulaName;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.bokesoft.distro.tech.yigosupport.extension.BaseStaticWrapperMidFuncRegistry;
import com.bokesoft.distro.tech.yigosupport.extension.BaseStaticWrapperMidFuncRegistryService;
import com.bokesoft.distro.tech.yigosupport.extension.BaseStaticWrapperMidFuncRegistryService.FunctionBuildOptions;
import com.bokesoft.yigo.parser.BaseFunImplCluster;

/**
 * 实现 {@link BaseStaticWrapperMidFuncRegistryService} 需要的静态 Java 方法映射为 Yigo
 * 中间层公式。
 */
@SuppressWarnings("deprecation")
public class BaseStaticWrapperMidFuncImplCluster extends BaseFunImplCluster{
	private String formulaPrefix;
	private Class<?>[] wrappers;
	private FunctionBuildOptions options;

	/**
	 * @deprecated 此方法仅保留供 {@link BaseStaticWrapperMidFuncRegistry}(已经 deprecated) 使用
	 * @param formulaPrefix
	 * @param wrappers
	 */
	public BaseStaticWrapperMidFuncImplCluster(String formulaPrefix, Class<?>[] wrappers){
		this(formulaPrefix, wrappers, null);
	}
	
	public BaseStaticWrapperMidFuncImplCluster(String formulaPrefix, Class<?>[] wrappers, FunctionBuildOptions options){
		this.formulaPrefix = formulaPrefix;
		this.wrappers = wrappers;
		
		if (null==options){
			options = FunctionBuildOptions.createDefault();
		}
		this.options = options;
	}
	
	@Override
	public Object[][] getImplTable() {
		Map<String, BaseStaticWrapperMidFuncRunner> formulaMap = new LinkedHashMap/*保证顺序*/<String, BaseStaticWrapperMidFuncRunner>();
		//所有公式类中的 public static 方法都作为公式, 公式名前面加上 <prefix> + 类名 前缀
		for (int i = 0; i < wrappers.length; i++) {
			@SuppressWarnings("rawtypes")
			Class formulaClass = wrappers[i];
			Method[] methods = formulaClass.getMethods();
			for (int j = 0; j < methods.length; j++) {
				Method m = methods[j];
				//组合成一个 <prefix>.XXXExp.YYYY 这样的公式名称
				int modifiers = m.getModifiers();
				if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers)){
					String methodName = m.getName();
					//xxx.Yyy.zzz() 模式的方法名称
					String fName = getDottedFormulaName(formulaPrefix, formulaClass, methodName, options.isWithClassName());
					if (! formulaMap.containsKey(fName)){
						formulaMap.put(fName, new BaseStaticWrapperMidFuncRunner(formulaPrefix, formulaClass, options, methodName));
					}
					//用"_"替换"." 的 formula name - xxx_Yyy_zzz()
					String uName = getUnderlineFormulaName(formulaPrefix, formulaClass, methodName, options.isWithClassName());
					if (! formulaMap.containsKey(uName)){
						formulaMap.put(uName, new BaseStaticWrapperMidFuncRunner(formulaPrefix, formulaClass, options, methodName));
					}
					//不包含 "." 的 formula name ( xxxYyyZzz() ), 比较符合 Yigo 的习惯
					String nName = getNarrowFormulaName(formulaPrefix, formulaClass, methodName, options.isWithClassName());
					if (! formulaMap.containsKey(nName)){
						formulaMap.put(nName, new BaseStaticWrapperMidFuncRunner(formulaPrefix, formulaClass, options, methodName));
					}
				}
			}
		}
		
		List<Object[]> formulaList = new ArrayList<Object[]>();
		for(Map.Entry<String, BaseStaticWrapperMidFuncRunner> en: formulaMap.entrySet()){
			formulaList.add(new Object[]{en.getKey(), en.getValue()});
		}
		
		return formulaList.toArray(new Object[][]{});
	}
}
