package com.bokesoft.distro.tech.yigosupport.extension.exttools.funs;

import java.util.Objects;

import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.CacheFactoryWrapUtil;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;

public class MaskExp {

    public static final String MASK_CACHE_KEY="Yee_MaskFun";
    private static final ICache<String> CACHE_SENSITIVE_FIELDS = CacheFactoryWrapUtil.getCache(MASK_CACHE_KEY);

    /**
     * 用于加载后事件 将字符串打上掩码
     * 如果数据字段被加密，需要先解密
     * @param context yigo上下文
     * @param table 需要掩码的数据库表名
     * @param field 需要掩码的数据库字段名
     * @param maskCharStr 掩码字符 eg： "*"
     * @param start 起始掩码位置
     * @param end 结束掩码位置
     */
    public static void FixedPos(DefaultContext context, String table, String field, String maskCharStr, Number start, Number end) throws Throwable {
        char maskChar = maskCharStr.charAt(0);
        Document document = context.getDocument();
        String oidFieldName = getOidFieldName(table, document);
        DataTable dataTable = document.get(table);

        int size = dataTable.size();
        if (size <= 0){
            return;
        }

        int fieldIdx = dataTable.getMetaData().findColumnIndexByKey(field, true);
        for (int i = 0; i < size; i++) {
            String unmaskedFiledValue = dataTable.getString(i, field);
            if (unmaskedFiledValue == null) {
                continue;
            }
            String key = calculateCacheKey(dataTable, i, oidFieldName, field);
            cacheSensitiveField(key, unmaskedFiledValue);
            String maskFiledValue = mask(unmaskedFiledValue, maskChar, start.intValue(), end.intValue());
            dataTable.setObject(i, fieldIdx, maskFiledValue, false);
        }

    }

    /**
     * 用于将修改了目标行，但是需要掩码的字段没有更改，
     * 此时将已经掩码的值替换为原值
     * @param context yigo上下文
     * @param table 掩码的表名
     * @param field 掩码的字段名
     */
    public static void Restore(DefaultContext context, String table, String field){
        Document document = context.getDocument();
        String oidFieldName = getOidFieldName(table, document);
        boolean isMainTable = isMainTable(document, table);
        DataTable dataTable = document.get(table);

        for (int i = 0; i < dataTable.size(); i++) {
            String originalValue = TypeConvertor.toString(dataTable.getOriginalObject(i, field));
            String newValue = dataTable.getString(i, field);
            // 主表Normal一定会修改 ;(主表为Normal状态时,也会被系统框架修改系统字段而产生修改sql顾需要定义为【行修改】状态)
            if (((isMainTable && isNormal(dataTable, i)) || isModified(dataTable, i)) && Objects.equals(originalValue, newValue)) {
                // 未改动 将缓存值放入
                String key = calculateCacheKey(dataTable, i, oidFieldName, field);
                dataTable.setString(i, field, findSensitiveField(key));
            }
        }

    }

    private static boolean isMainTable(Document document, String table) {
        String mainTableKey = document.getMetaDataObject().getMainTableKey();
        return table.equals(mainTableKey);
    }

    /**
     * 当前行是否修改
     * @param dataTable 数据行
     * @return 是否修改
     */
    private static boolean isModified(DataTable dataTable, int cloIndex){
        return dataTable.getState(cloIndex) == RowState.MODIFIED;
    }

    private static boolean isNormal(DataTable dataTable, int cloIndex){
        return dataTable.getState(cloIndex) == RowState.NORMAL;
    }


    private static void cacheSensitiveField(String key, String fieldValue){
        CACHE_SENSITIVE_FIELDS.put(key, fieldValue);
    }

    private static String findSensitiveField(String key){
        return CACHE_SENSITIVE_FIELDS.get(key);
    }



    private static String mask(String sourceStr, char maskChar, int start, int end){
        if (sourceStr == null) {
            return null;
        }

        if (start < 0 || end > sourceStr.length() || start > end) {
            throw new IllegalArgumentException("Invalid start or end position.");
        }

        StringBuilder maskedString = new StringBuilder(sourceStr);

        for (int i = start; i < end; i++) {
            maskedString.setCharAt(i, maskChar);
        }

        return maskedString.toString();
    }

    private static String calculateCacheKey(DataTable dataTable, int colIndex, String oidFieldName, String field) {
        String key = dataTable.getKey();
        Object oid = dataTable.getObject(colIndex, oidFieldName);
        return key +"/"+ oid +"/"+ field;
    }

    private static String getOidFieldName(String table, Document document) {
        MetaTable metaTable = document.getMetaDataObject().getMetaTable(table);
        return metaTable.getOIDColumn().getBindingDBColumnName();
    }

}
